/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#if defined( Uses_THintStatusLine ) && !defined( __THintStatusLine__ )
#define __THintStatusLine__

class TRect;
class TStatusDef;

class THintStatusLine : public TStatusLine
{
public:
  const char * (*HintFunction)(ushort);
  THintStatusLine(const TRect & r,TStatusDef & def,
                  const char * (*hintfunction)(ushort) = NULL) :
    TStatusLine(r,def),
    HintFunction(hintfunction) {}
  virtual const char * hint(ushort);
  static const char * const name;
  static TStreamable * build();
private:
  virtual const char * streamableName() const { return name; }
protected:
  THintStatusLine(StreamableInit);
};

inline const char * THintStatusLine::hint(ushort ctx)
{
  if (!HintFunction) return "";
  return HintFunction(ctx);
}

inline ipstream& operator >> ( ipstream& is, THintStatusLine& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, THintStatusLine*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, THintStatusLine& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, THintStatusLine* cl )
    { return os << (TStreamable *)cl; }

#endif

