/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TRect
#define Uses_TKeys
#define Uses_RawKeys
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TVEdConstant
#define Uses_TEditorApp
#define Uses_TDialog
#define Uses_TEditor
#define Uses_editCommands

#define Uses_THintStatusLine
#define Uses_ideCommands
#include <libide.h>

#define Uses_TSCollection
#define Uses_tvutilCommands
#include <libtvuti.h>

#define Uses_IDEConst
#include <rhide.h>
#include <ideapp.h>

#ifdef INTERNAL_DEBUGGER
#define Uses_tvgdbCommands
#include <libtvgdb.h>
#endif

#include <inf.h>

TStatusLine *IDE::initStatusLine( TRect r )
{
  r = TProgram::application->getExtent();
  r.a.y = r.b.y-1;
  TStatusLine *line;
  line = new THintStatusLine( r,
    *new TStatusDef( 0, 99 ) +
      *new TStatusItem( NULL, kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~F2~ Save"), kbF2, cmSave ) +
      *new TStatusItem( _("~F3~ Open"), kbF3, cmOpen ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom ) +
      *new TStatusItem( _("~F6~ Next"), kbF6, cmNext ) +
      *new TStatusItem( _("~Alt+F9~ Compile"), kbAltF9, cmCompile ) +
      *new TStatusItem( _("~F10~ Menu"), kbF10, cmMenu ) +
      *new TStatusItem( _("~Alt+X~ Quit"), kbAltX, cmQuit ) +
      *new TStatusItem( NULL, kbCtrlF5, cmResize )
    +*new TStatusDef( 100, 555) +
      *new TStatusItem( NULL, kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~F1~ Help"), kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbF10, cmMenu )
    +*new TStatusDef( hcProjectListBox, hcProjectListBox ) +
      *new TStatusItem( NULL, kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~Ins~ Add"), kbIns, cmAddProjectItem ) +
      *new TStatusItem( _("~Del~ Delete"), kbDel, cmDelProjectItem ) +
      *new TStatusItem( _("~^O~ Local"), RawkbCtrlO, cmLocalOptions ) +
      *new TStatusItem( _("~^I~ Includes"), RawkbCtrlI, cmShowIncludes ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom ) +
      *new TStatusItem( _("~Alt+F9~ Compile"), kbAltF9, cmCompile ) +
      *new TStatusItem( _("~Alt+X~ Quit"), kbAltX, cmQuit ) +
      *new TStatusItem( NULL, kbF10, cmMenu )
    +*new TStatusDef(  hcMsgListBox, hcMsgListBox ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~Enter~ Jump to source"), kbF1, cmHelp ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom ) +
      *new TStatusItem( _("~F6~ Next"), kbF6, cmNext ) +
      *new TStatusItem( _("~Alt+F9~ Compile"), kbAltF9, cmCompile ) +
      *new TStatusItem( _("~F10~ Menu"), kbF10, cmMenu ) +
      *new TStatusItem( _("~Alt+X~ Quit"), kbAltX, cmQuit )
    +*new TStatusDef( hcOptFlagList, hcPascalFlagList ) +
      *new TStatusItem( NULL, kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~Esc~ Cancel"), kbEsc, cmCancel ) +
      *new TStatusItem( _("~Space~ select"), RawkbSpace, cmEnter ) +
      *new TStatusItem( NULL, kbCtrlF5, cmResize )
    +*new TStatusDef( hcWindowList, hcWindowList ) +
      *new TStatusItem( NULL, kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~Enter~ Select"), kbEnter, cmSelectWindow ) +
      *new TStatusItem( _("~Del~ Close"), kbDel, cmDeleteWindow ) +
      *new TStatusItem( NULL, kbCtrlF5, cmResize )
    +*new TStatusDef( hcIDEFileEditor, hcIDEFileEditor ) +
      *new TStatusItem( NULL, kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( NULL, kbCtrlF1, cmSyntaxHelp ) +
      *new TStatusItem( _("~F2~ Save"), kbF2, cmSave ) +
      *new TStatusItem( _("~F3~ Open"), kbF3, cmOpen ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom ) +
      *new TStatusItem( _("~F6~ Next"), kbF6, cmNext ) +
      *new TStatusItem( _("~Alt+F9~ Compile"), kbAltF9, cmCompile ) +
      *new TStatusItem( _("~F10~ Menu"), kbF10, cmMenu ) +
      *new TStatusItem( _("~Alt+X~ Quit"), kbAltX, cmQuit ) +
      *new TStatusItem( NULL, RawkbCtrlJ, cmGotoLine )
    +*new TStatusDef( hcInfView, hcInfView ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~F1~ Help on InfoViewer"), kbF1, cmInfHelp ) +
      *new TStatusItem( _("~Alt+F1~ last help"), kbAltF1, cmInfBack ) +
      *new TStatusItem( _("~Alt+F10~ local menu"), kbAltF10, cmInfControl ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom) +
      *new TStatusItem( NULL, kbF10, cmMenu ) +
      *new TStatusItem( NULL, kbCtrlF5, cmResize )
#ifdef INTERNAL_DEBUGGER
    +*new TStatusDef(hcFunctionListBox,hcFunctionListBox) +
      *new TStatusItem( _("~F1~ Help"), kbF1, cmHelp ) +
      *new TStatusItem( _("~Enter~ Jump to source"), kbCtrlF5, cmResize )
    +*new TStatusDef(hcFunctionInputLine,hcFunctionInputLine) +
      *new TStatusItem(_("~Ctrl+F1~ Select from a list"), kbCtrlF1, cmSelectFunction)
    +*new TStatusDef( hcWatchListBox, hcWatchListBox ) +
      *new TStatusItem( _("~F1~ Help"), kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~Ins~ Add"), kbIns, cmAddWatchEntry ) +
      *new TStatusItem( _("~Del~ Delete"), kbDel, cmRemoveWatch ) +
      *new TStatusItem( _("~Enter~ Edit"), kbEnter, cmEditWatch ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom ) +
      *new TStatusItem( _("~Alt+X~ Quit"), kbAltX, cmQuit ) +
      *new TStatusItem( _("~F10~ Menu"), kbF10, cmMenu )
#endif
    +*new TStatusDef( 0, 0xFFFF ) +
      *new TStatusItem( _("~F1~ Help"), kbF1, cmHelp ) +
      *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
      *new TStatusItem( _("~F2~ Save"), kbF2, cmSave ) +
      *new TStatusItem( _("~F3~ Open"), kbF3, cmOpen ) +
      *new TStatusItem( _("~F5~ Zoom"), kbF5, cmZoom ) +
      *new TStatusItem( _("~F6~ Next"), kbF6, cmNext ) +
      *new TStatusItem( _("~Alt+F9~ Compile"), kbAltF9, cmCompile ) +
      *new TStatusItem( _("~F10~ Menu"), kbF10, cmMenu ) +
      *new TStatusItem( _("~Alt+X~ Quit"), kbAltX, cmQuit )
    ,IDEHint);
  return line;
}


