#! /bin/sh -e

# /* Linux i386 - gcc 2.7.2.1 (ELF shared library)
#  * a very simple make driver
#  * Copyright (C) 1996, 1997 Markus F.X.J. Oberhumer
#  */

cat config.h >/dev/null || exit 1

x=`grep -h "^VERSION=" configure`
test -n "$x" || exit 1
eval "$x"
MYLIB="liblzo.so.$VERSION"
rm -f $MYLIB liblzo.so

CC=gcc
x=`grep -h "^-" b/autoconf.opt b/gcc.opt b/linux/gcc_i386.opt b/gcc_lzo.opt`
CFLAGS="$x -fPIC"
x=`grep -h "^-" b/autoconf.opt`
ASFLAGS="$x -x assembler-with-cpp -Wall"

echo Compiling $MYLIB, please be patient...
echo $CC $CFLAGS -c src/*.c
     $CC $CFLAGS -c src/*.c
echo $CC $ASFLAGS -c src/i386/src/*.[sS]
     $CC $ASFLAGS -c src/i386/src/*.[sS]
rm -f $MYLIB
gcc -shared -o $MYLIB `cat b/linux/i386.rsp`
ln -s $MYLIB liblzo.so

echo Building the test programs...
x=`grep -h "^-" b/autoconf.opt b/gcc.opt b/linux/gcc_i386.opt`
CFLAGS="$x -DNO_ZLIB_H"
$CC -s $CFLAGS lzo_test.c $MYLIB -o lzo_test_shared
$CC -s $CFLAGS examples/precomp.c $MYLIB -o precomp_shared
$CC -s $CFLAGS examples/precomp2.c $MYLIB -o precomp2_shared
$CC -s $CFLAGS examples/simple.c $MYLIB -o simple_shared
$CC -s $CFLAGS -Isrc tests/align.c $MYLIB -o align_shared
$CC -s $CFLAGS -Isrc tests/chksum.c $MYLIB -o chksum_shared

echo Done.
