#define MAXFRAME 64

typedef struct {
    char *frame[MAXFRAME];
    int curfrm;
    int frames;

    char *bitmap;
    char *background;
    int x;
    int y;
    int xsize;
    int ysize;
    int xspeed;
    int yspeed;
} SPRITE;

void sdraw(SPRITE *s) {
    int y=s->y,
        x=s->x,
        yy, xx;

    /* Eli loopataan koko suorakulman kokoinen alue. bitmap- ja
       ja background -puskureissahan lasketaan sijainti seuraavasti:
       y * s->xsize + x. */
    for(yy=0; yy<s->ysize; yy++) { 
    for(xx=0; xx<s->xsize; xx++) {
        /* eli vrill 0 tm vertailu alla ei ole tosi, joten vrill
           0 merkittyj kohtia EI piirret! */
        if(s->bitmap[yy*s->xsize+xx]) {
            /* doublebuffer muuttuja osoittaa kaksoispuskuriin. Huomaa, ett
               ylkulma on y*320+x, mutta koska haluamme viel piirt useita
               rivej, lismme yy-looppimme y-arvoon, kutenn mys xx-looppi
               x-arvoon. Jos et ymmrtnyt niin poista vliaikaisesti kohdat
               ja net mit tapahtuu */
            s->background[yy*s->xsize+xx]=
                doublebuffer[ (y+yy) * 320 + (x+xx) ];

            /* sitten vain asetetaan bittikartasta oikea kohta ruudulle,
               alle peittyv osa on jo tallessa puskurin background vastaa-
               valla kohdalla. */
            doublebuffer[ (y+yy) * 320 + (x+xx) ]=
                s->bitmap[yy*s->xsize+xx];
        }
    }
    }
}

void shide(SPRITE *s) {
    int y=s->y,
        x=s->x,
        yy, xx;

    /* Eli loopataan koko suorakulman kokoinen alue. bitmap- ja
       ja background -puskureissahan lasketaan sijainti seuraavasti:
       y * s->xsize + x. */
    for(yy=0; yy<s->ysize; yy++) { 
    for(xx=0; xx<s->xsize; xx++) {
        /* eli vrill 0 tm vertailu alla ei ole tosi, joten vrill
           0 merkittyj kohtia EI piirret! */
        if(s->bitmap[yy*s->xsize+xx]) {
            doublebuffer[ (y+yy) * 320 + (x+xx) ]=
                s->background[yy*s->xsize+xx];
        }
    }
    }
}

void smove(SPRITE *s) {
    s->x+=s->xspeed;
    s->y+=s->yspeed;
}

void ssetlocation(SPRITE *s, int x, int y) {
    s->x=x;
    s->y=y;
}

void ssetspeed(SPRITE *s, int xspeed, int yspeed) {
    s->xspeed=xspeed;
    s->yspeed=yspeed;
}


void sanimate(SPRITE *s) {
    s->curfrm++;
    if(s->curfrm >= s->frames)
        s->curfrm=0;
    s->bitmap=s->frame[s->curfrm];
}

void sload(SPRITE *s, int x, int y, int xspeed, int yspeed, int xsize,
    int ysize, char *bitmapbuffer, int bufferx, int buffery, 
    int bufferxs, int frames) {
    int yy, xx, current;

    ssetlocation(s, x, y);
    ssetspeed(s, xspeed, yspeed);
    s->xsize=xsize;
    s->ysize=ysize;
    s->curfrm=0;
    s->frames=frames;

    for(current=0; current<frames; current++)
        s->frame[current]=(char *)malloc(xsize*ysize);
    s->background=(char *)malloc(xsize*ysize);
    s->bitmap=s->frame[s->curfrm];

    if(s->background==NULL || s->background==NULL) {
        printf("Ei tarpeeksi muistia sprite-puskureille!\n");
        exit(1);
    }
    
    /* Eli loopataan koko suorakulman kokoinen alue. bitmap-
       puskurissahan lasketaan sijainti seuraavasti:
       y * s->xsize + x. Uloimpana looppina on uutena framelooppi,
       joka on listty koska meidn pit ladata usea kuva. */
    for(current=0; current<frames; current++)
    for(yy=0; yy<ysize; yy++) { 
    for(xx=0; xx<xsize; xx++) {
        /* doublebuffer muuttuja osoittaa kaksoispuskuriin. Huomaa, ett
           ylkulma on y*320+x, mutta koska haluamme viel piirt useita
           rivej, lismme yy-looppimme y-arvoon, kutenn mys xx-looppi
           x-arvoon. Jos et ymmrtnyt niin poista vliaikaisesti kohdat
           ja net mit tapahtuu */
        s->frame[current][yy*xsize+xx]=
            bitmapbuffer[ (buffery+yy) * bufferxs + (bufferx+xx) +
                          (xsize+1)*current ];
    }
    }
}

int scollision(SPRITE *a, SPRITE *b) {
    /* Lasketaan spritejen ylkulmien vliset etisyydet. Huomaa, ett tss
       lasketaan mukaan nopeudet, eli palautusarvo 1 kertoo spritejen
       trmvn ENSI vuorolla. Nin ehditn pllekkin meneminen est
       ajoissa. */
    int xdistance= (a->x+a->xspeed) - (b->x+b->xspeed);
    int ydistance= (a->y+a->yspeed) - (b->y+b->yspeed);
    int xx, yy;
    /* Jos x- tai y-etisyys on suurempi kuin suuremman leveys eivt
       spritet voi mitenkn olla toistensa pll. */
    if(xdistance>a->xsize && xdistance>b->xsize) return 0;
    if(ydistance>a->ysize && ydistance>b->ysize) return 0;

    for(xx=0; xx< a->xsize; xx++)
    for(yy=0; yy< a->ysize; yy++)
        if(xx+xdistance < b->xsize && xx+xdistance>=0 &&
           yy+ydistance < b->ysize && yy+ydistance>=0)
        if(a->bitmap[ yy * a->xsize + xx ] &&
           b->bitmap[ (yy+ydistance) * b->xsize + (xx+xdistance) ])
            return 1;
    return 0;
}
