typedef struct {
    char red;
    char green;
    char blue;
} RGB;

void setcolor(int index, RGB *newdata) {
    outportb(0x3C8, index);    
    outportb(0x3C9, newdata->red);    
    outportb(0x3C9, newdata->green);
    outportb(0x3C9, newdata->blue);
}

void getcolor(int index, RGB *color) {
    outportb(0x3C7, index);
    color->red=inportb(0x3C9);
    color->green=inportb(0x3C9);
    color->blue=inportb(0x3C9);
}

void setpal(char *palette) {
    int c;
    
    outportb(0x3C8, 0);
    for(c=0; c<256*3; c++)
        outportb(0x3C9, palette[c]);
}

void getpal(char *palette) {
    int c;
    
    outportb(0x3C7, 0);
    for(c=0; c<256*3; c++)
        palette[c]=inportb(0x3C9);
}

void rotatepal(int startcolor, int endcolor, char *palette) {
   char r, g, b;
   int c;

   r=palette[startcolor*3+0]; /* tallennamme ensimmiset vrit ja siirrmme */
   g=palette[startcolor*3+1]; /* ne lopuksi loppuun. Tm paletti pyrii siten, */
   b=palette[startcolor*3+2]; /* ett viimeinen vri kulkeutuu kohti alkua */

   for(c=startcolor*3; c<endcolor*3; c++)
       palette[c]=palette[c+3];
                        /* muista, ett uusi vri on kolmen vlein,
                           sill vlisshn on aina kolme tavua, r,
                           g ja b, joita ei saa sekoittaa, muuten
                           saisimme aikaan vaikkapa sinisen paloauton!
                           (kiinnostava tavoite sinns) */

   palette[endcolor*3+0]=r;
   palette[endcolor*3+1]=g;
   palette[endcolor*3+2]=b;
}

void waitsync() {
    while( (inportb(0x3DA)&8) != 0);
    while( (inportb(0x3DA)&8) == 0);
}

void fadetoblack(char *palette) {
    char temppal[256*3];
    int c, color;

    memcpy(temppal, palette, 256*3);
    for(c=0; c<63; c++) { /* tarvitsemme maksimissaan 63 muutosta */
        for(color=0; color<256*3; color++)
            if(temppal[color]) temppal[color]--;
        waitsync();
        setpal(temppal);
    }
}

void fadetowhite(char *palette) {
    char temppal[256*3];
    int c, color;

    memcpy(temppal, palette, 256*3);
    for(c=0; c<63; c++) { /* tarvitsemme maksimissaan 63 muutosta */
        for(color=0; color<256*3; color++)
            if(temppal[color]<63) temppal[color]++;
        waitsync();
        setpal(temppal);
    }
}

void fadetopalette(char *palette, char *newpalette) {
    char temppal[256*3];
    int c, color;

    memcpy(temppal, palette, 256*3);
    for(c=0; c<63; c++) { /* tarvitsemme maksimissaan 63 muutosta */
        for(color=0; color<256*3; color++)
            if(temppal[color]>newpalette[color]) temppal[color]--;
            else if(temppal[color]<newpalette[color]) temppal[color]++;
        waitsync();
        setpal(temppal);
    }
}
