#include <go32.h>
#include <sys/movedata.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>

char *doublebuffer;

#include "palette.h"
#include "pcx.h"
#include "bitmap.h"

#define flip(c) _dosmemputl(c, 64000/4, 0xA0000)

int main() {
    char palette[768];
    BITMAP bitmap;

    doublebuffer=(char *)malloc(64000);
    if(doublebuffer==NULL) {
        printf("Ei tarpeeksi muistia kaksoipuskurin varaukseen!\n");
        return 1;
    }
    textmode(0x13);
    loadpcx("BITMAP.PCX", doublebuffer);
    loadpal("BITMAP.PCX", palette);
    setpal(palette);
    bload(&bitmap, 160, 100, 1, 1, 16, 16, doublebuffer, 1, 1, 320);
    loadpcx("BITBACK.PCX", doublebuffer);
    /* Lataus vasta kun bittikartta on otettu edellisest tiedostosta.
       Ei ladata palettia koska se on sama kuin edellisess PCX:ss. */

    while(!kbhit()) {
        bdraw(&bitmap);
        waitsync();
        flip(doublebuffer);
        bhide(&bitmap);
        bmove(&bitmap);
        if((bitmap.x+bitmap.xsize+bitmap.xspeed)>320 ||
           bitmap.x+bitmap.xspeed<0)
            bitmap.xspeed= -bitmap.xspeed;
        if((bitmap.y+bitmap.ysize+bitmap.yspeed)>200 ||
           bitmap.y+bitmap.yspeed<0)
            bitmap.yspeed= -bitmap.yspeed;
    }
    getch();
    fadetoblack(palette);
    textmode(0x3);

    return 0;
}
