/* Well here it is; how to access video ram at 0xa0000 without using
   a segment overide (ie using the current process's DS). Works well
   under MS Windows 3.1 in a full screen DOS box. Try running this app
   in the background (DOS settings 'Runs in Background' crossed).Then
   switch away from this app (CTRL-ESC) and run any other program.
   Windows will remap the video ram at 0xa0000 to a temporary system
   ram buffer while this app runs minimized; hence this app will
   run faster when minimized. The screen will be correctly restored 
   when we switch back to this app.
      This program works by removing the segment limit on DS and
   using 32-bit wrap around in the linear address space to access
   memory at linear address 0xa0000. In fact we now have access to
   all memory including DOS conventional memory. This circumvents
   all memory protection (except unmapped memory), so best to save
   the original DS for normal use, and use the new unlimited DS for
   the duration that video memory access is needed.

	Included is text-graphics mode switch hooks for the fixed
   gdb which cleanly restores the text mode screen when the debugger
   gets control, and cleanly restores the graphics screen when
   the inferior program is passed control from the debugger.
	On my Cirrus VLB card, you can put a break in the blit loop
   and press 'v' to continue the program. Then hold down the 'enter'
   key and watch the nice interlaced graphics and text screens! Quite
   a change from TD.
For djgpp V2.0;

   gcc -o t t.c

	Al-Junaid Walker 7/6/95.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gppconio.h>
#include <pc.h>
#include <dos.h>
#include <go32.h>
#include <dpmi.h>

/*#define LINEAR*/	/*use conventinal mem descriptor mapped into linear memory*/
	/*otherwise do it the recommended go32 way*/
/*#define SLOW_CURSOR*/	/*use slow BIOS calls to position cursor, otherwise write direct to BIOS area*/
	/*SLOW_CURSOR doesnt seem to work for some reason*/

#define BLIT_SIZE 32000U	/*# bytes to blit to screen each iteration*/
#define GR_BUF_SIZE	64000U	/*size of graphics buffer in VRAM */
#define GR_PAL_ENTRIES	256U	/*# VGA graphics RGB palette entries*/
#define TX_BUF_SIZE	4000U	/*size of text buffer in VRAM*/
#define TX_PAL_ENTRIES	16U	/*# VGA text RGB palette entries*/

typedef unsigned char uchar;

static union REGS regs;
static uchar *VRAM;
static unsigned ds_sel, cs_sel, ss_sel, fs_sel, gs_sel;

uchar *gr_buf;
int gr_mode=0;	/*flag saying what graphics mode, or 0 if in text mode*/
uchar gr_pal[3*GR_PAL_ENTRIES];
uchar tx_buf[TX_BUF_SIZE];
uchar tx_pal[3*TX_PAL_ENTRIES]={
         0, 0, 0,  0, 0,42,  0,42, 0,  0,42,42,
        42, 0, 0, 42, 0,42, 42,21, 0, 42,42,42,
        21,21,21, 21,21,63, 21,63,21, 21,63,63,
        63,21,21, 63,21,63, 63,63,21, 63,63,63
};	/*first 16 palette entries from default VGA palette that represent text character colors*/

unsigned tx_vram=0x80000000U;	/*linear address of text screen VRAM*/
unsigned short cursor_pos=0;	/*cursor position in text mode*/

void Sync(void)
{
    while (inportb(0x3da) & 8);
    while (!(inportb(0x3da) & 8));
}


void set_gr_pal(void)
{
    int c;
    outportb(0x3c8,0);
    for (c = 0; c < GR_PAL_ENTRIES*3; c++)
        outportb(0x3c9,gr_pal[c]);
}
void set_tx_pal(void)
{
    int c;
    outportb(0x3c8,0);
    for (c = 0; c < TX_PAL_ENTRIES*3; c++)
        outportb(0x3c9,tx_pal[c]);
}
void get_tx_pal(void)
{
    int c;
    outportb(0x3c7,0);
    for (c = 0; c < TX_PAL_ENTRIES*3; c++)
        tx_pal[c]=inportb(0x3c9);
}

void init_gr_buf(void)	/*initialize graphics buffer with an interesting pattern*/
{
	unsigned vram_off;
	for(vram_off=0; vram_off<GR_BUF_SIZE; vram_off++) gr_buf[vram_off]=vram_off;
}

void tx(void)
	/*return to a cleared text mode screen*/
{
	if(gr_mode != 0) {	/*switch from graphics mode back to text mode*/
		dosmemget(0xa0000, GR_BUF_SIZE, gr_buf);	/*save graphics VRAM*/
	    	regs.x.ax = 0x0003;	/*back to text mode*/
    		int86(0x10,&regs,&regs);
		set_tx_pal();	/*restore text palette*/
		dosmemput(tx_buf, TX_BUF_SIZE, tx_vram);	/*restore saved text VRAM*/
#ifdef SLOW_CURSOR
	    	regs.x.ax = 0x02;	/*set text cursor position*/
	    	regs.x.bx = 0x0;	/*use page 0*/
	    	regs.x.dx = cursor_pos;	/*saved cursor postion*/
    		int86(0x10,&regs,&regs);	/*restore saved cursor position*/
#else
		dosmemput(&cursor_pos, 2, 0x450);
#endif
		gr_mode=0;
	}
}

void gr(void)
	/*switch to GRaphics mode*/
{
	if(gr_mode == 0) {	/*switch from text mode back to graphics mode*/
		dosmemget(tx_vram, TX_BUF_SIZE, tx_buf);	/*save text VRAM*/		
#ifdef SLOW_CURSOR
	    	regs.x.ax = 0x03;	/*get text cursor position*/
	    	regs.x.bx = 0x0;	/*use page 0*/
    		int86(0x10,&regs,&regs);
	    	cursor_pos=regs.x.dx ;	/*save cursor postion*/
#else
		dosmemget(0x450, 2, &cursor_pos);
#endif
		regs.x.ax = 0x0013;	/*mode 13 graphics*/
		int86(0x10,&regs,&regs);
		set_gr_pal();	/*restore graphics palette*/
		dosmemput(gr_buf, GR_BUF_SIZE, 0xa0000);	/*restore saved graphics VRAM*/
		init_gr_buf();	/*rebuild to previous*/
		gr_mode=1;
	}
}

void barf(char *msg)	/*ERROR MESSAGE WHILE IN GRAPHICS MODE*/
{	
	tx();
	cprintf("\r\n%s\r\n", msg);
	exit(1);
}

void winge(char *msg)	/*ERROR MESSAGE WHILE IN TEXT MODE*/
{
	cprintf("\r\n%s\r\n", msg);
	exit(1);
}


static void print_esp(void)
	/*print 32-bit word at (%esp) = return address from this fn */
{
	unsigned l;
    __asm__(
        "movl   12(%%esp),%%ebx\n\t"
		:"=b" (l) : /*no input*/ :"ax", "bx", "cc"
    );
    	cprintf("\r\nret address=%08X\r\n", l);
    __asm__(
        "movl   %%esp,%%ebx\n\t"
		:"=b" (l) : /*no input*/ :"ax", "bx", "cc"
    );
    	cprintf("\r\nesp=%08X\r\n", l);
}

static unsigned get_limit(unsigned sel)
	/*get segment limit of the selector _sel */
{
	unsigned l;
    __asm__(
        "lsll 	%%eax,%%ebx\n\t"	/*get segment limit of %eax into %ebx*/
	"jz	1f\n\t"		/*lsl successful*/
	"movl	$0, %%ebx\n\t"	/*lsl unsuccessful => return bad limit of 0*/
    "1:\n\t"
		:"=b" (l) : "a" (sel) :"ax", "bx", "cc"
    );
    
    return l;
}

static void get_selectors(unsigned *code, unsigned *data, unsigned *stack, 
	unsigned *frame, unsigned *gate)
	/*get current program's selectors */
{
    __asm__(
        "movw 	%%cs, %%ax\n\t"	/*put %cs selector into %ax */
	"movzwl	%%ax, %%ebx\n\t"	/*and zero extend %ax into %ebx*/
        "movw 	%%ds, %%ax\n\t"
	"movzwl	%%ax, %%ecx\n\t"
        "movw 	%%ss, %%ax\n\t"
	"movzwl	%%ax, %%edx\n\t"
        "movw 	%%fs, %%ax\n\t"
	"movzwl	%%ax, %%esi\n\t"
        "movw 	%%ds, %%ax\n\t"
	"movzwl	%%ax, %%eax\n\t"
		:"=b" (*code), "=c" (*data), "=d" (*stack), 
                 "=S" (*frame), "=a" (*gate)
		: /*no input*/ 
		:"ax", "bx", "cx", "dx", "si", "cc"
    );
}

void RAM_TO_VRAM(unsigned char *dest, const unsigned char *src, int n)
		/*Write _n bytes (word aligned) to VRAM address _dest, from system RAM _src.*/
{
	__asm__("cld\n\t"
		"testw	$1,%%di\n\t"	/*_dest word unaligned?*/
		"je	1f\n\t"		/*even so word aligned*/
		"movsb\n\t"	/*odd, so move a byte to make _dest even and word aligned*/
		"dec	%%ecx\n\t"	/*update count*/
		"je	2f\n\t"		/*no more to do*/
	"1:\n\t"	/*_dest is now aligned*/
		"shrl	$1,%%ecx\n\t"	/*get a word count, carry=1 if a byte left over*/
		"rep	; movsw\n\t"	/*blit as many words as possible*/
		"adcl	%%ecx,%%ecx\n\t"	/*get the left over byte*/
		"rep	; movsb\n\t"	/*move the left over byte (if any)*/
	"2:\n\t"
		: /* no output */
		:"c" ((long) n),"D" (dest),"S" (src)
		: "cx","di","si","memory","cc");
}

static unsigned get_sel_base(unsigned sel)
{	/*figure out where selector is in physical memory*/
	regs.x.ax = 0x6;	/*get desrciptor linear base address*/
	regs.x.bx = sel;
	int86(0x31, &regs, &regs);
	if(regs.x.flags & 1) 
		cprintf(" Bad base ");
        return ((unsigned)(regs.x.cx)<<16) + (unsigned)(regs.x.dx);
}
 
int main(void)
{
	unsigned ticks, blits, vram_off;

	tx_vram=_go32_info_block.linear_address_of_primary_screen;
    	regs.x.ax = 0x0500;	/*select text page 0*/
	int86(0x10,&regs,&regs);

	if((gr_buf=(uchar *)malloc(GR_BUF_SIZE)) == NULL)
		winge("Cant alloc graphics buffer in main()");
	init_gr_buf();
	for(blits=0; blits<sizeof(gr_pal)/sizeof(gr_pal[0]); blits++)
		gr_pal[blits]=(194-blits)/3U & 63U;	/*256 BW RGB palette indices*/

	print_esp();
        get_selectors(&cs_sel, &ds_sel, &ss_sel, &fs_sel, &gs_sel);
	cprintf("\r\nValue/limit; cs=%08X/%08X ds=%08X/%08X \
ss=%08X/%08X fs=%08X/%08X gs=%08X/%08X\r\n", 
		cs_sel, get_limit(cs_sel), ds_sel, get_limit(ds_sel), 
		ss_sel, get_limit(ss_sel), fs_sel, get_limit(fs_sel), 
		gs_sel, get_limit(gs_sel) );
 
if(_go32_info_block.run_mode == _GO32_RUN_MODE_DPMI) {
	cprintf("\r\nUSING DPMI. DPMI VERSION=%X\r\n", 
		(unsigned)(_go32_info_block.run_mode_info));
	cprintf("Linear base; CS=%08X ", get_sel_base(cs_sel));
	cprintf("DS=%08X ", get_sel_base(ds_sel));
	cprintf("SS=%08X ", get_sel_base(ss_sel));
	cprintf("FS=%08X ", get_sel_base(fs_sel));
	cprintf("GS=%08X\r\n", get_sel_base(gs_sel));

#ifdef LINEAR
	VRAM=(unsigned char *)(   0xa0000  - ( ((unsigned)(regs.x.cx) <<16) + (unsigned)(regs.x.dx) )  );
	cprintf("\r\nRemapped Video RAM process virtual address=%08X\r\n", (unsigned)(VRAM));

	regs.x.ax = 0x8;	/*set descriptor range function*/
	regs.x.bx = ds_sel;
	regs.x.cx = -1;	/*MSB range*/
	regs.x.dx = -1;	/*LSB range*/
		/*Windows seems to allow the huge segment limit of -1(=0xFFFFFFFF).
		  This would obviously lead to memory protection violations with
		  other processes. Windows probably thinks that 0xFFFFFFFF +1 = 0
		  and silently allows this huge limit. Thank god for bugs! */
	int86(0x31, &regs, &regs);
    	cprintf("\r\nNew DS linear address limit=%08X\r\n", get_limit(ds_sel));
	if(regs.x.flags & 1)
		winge("Couldnt set descriptor range of ds_desc");
#endif
}


	blits=10000000;
	do {
	} while(--blits);	/*just spin a bit of time to test signals*/

	cprintf("\r\nYOU'LL SEE AN ODD STAIRCASE MOVING DOWN THE SCREEN. PRESS ANY KEY TO CONTINUE\r\n");
	getkey();	/*wait for keypress*/

	get_tx_pal();	/*get the existing text mode palette for restore - assume it never changes*/
	gr();
	set_gr_pal();	/*set the graphics palette*/

	blits=vram_off=0;
	ticks=clock();	/*start the timer*/
	while(/*!kbhit()*/ blits<2000) {
#ifdef LINEAR
		RAM_TO_VRAM(VRAM+vram_off, gr_buf, BLIT_SIZE);
#else
		dosmemput(gr_buf, BLIT_SIZE, 0xa0000+vram_off);
			/*djgpp V2 way of moving memory to VRAM in dpmi*/
#endif
		vram_off=(vram_off+4U) & 16383U;
		blits++;
	}
	ticks=100000U/CLOCKS_PER_SEC*(clock()-ticks)/100U;	/*how long did we spend blitting to screen in msec?*/
	if(ticks < 1U) ticks=1U;	/*duration too short or clock() broken*/
	tx();
	cprintf("\r\n%u blits took %ums. Blit rate=%uKBytes/s\r\n", blits,
		ticks, blits*BLIT_SIZE / ticks );
		


	return 0;
}











