;
;	Paintjet tables for printer.c, in here so that we can link them
;	as part of the printer.c overlay and not waste far space.
;
;	The tables were copied from Lee Crocker's PGIF program, with
;	the 8 undithered colors moved to the first 8 table slots.

;	required for compatibility if Turbo ASM
IFDEF ??version
MASM51
QUIRKS
ENDIF

.model medium, c

.code PRINTER_TEXT ; to combine with printer.c for TC++ overlays

;  This file contains various lookup tables used by PJGIF.  Patterns contains
;  unsigned values representing each of the 330 HP PaintJet colors.  Each color
;  at 90 DPI is composed of four dots in 8 colors.  Each hex digit of these
;  unsigned values represents one of the four dots.  Although the PaintJet will
;  produce these patterns automatically in 90 DPI mode, it is much faster to do
;  it in software with the PaintJet in 8-color 180 DPI mode.

	public pj_patterns
	public pj_reds
	public pj_greens
	public pj_blues

pj_patterns dw 7777h,0000h,1111h,2222h,3333h,4444h,5555h,6666h
	    dw	     0001h,0002h,0003h,0004h,0005h,0006h,0007h
	    dw 0110h,0120h,0130h,0140h,0150h,0160h,0170h,0220h
	    dw 0230h,0240h,0250h,0260h,0270h,0330h,0340h,0350h
	    dw 0360h,0370h,0440h,0450h,0460h,0470h,0550h,0560h
	    dw 0570h,0660h,0670h,0770h,0111h,0112h,0113h,0114h
	    dw 0115h,0116h,0117h,2012h,0123h,0124h,0125h,0126h
	    dw 0127h,3013h,0134h,0135h,0136h,0137h,4014h,0145h
	    dw 0146h,0147h,5015h,0156h,0157h,6016h,0167h,7017h
	    dw 0222h,0223h,0224h,0225h,0226h,0227h,3023h,0234h
	    dw 0235h,0236h,0237h,4024h,0245h,0246h,0247h,5025h
	    dw 0256h,0257h,6026h,0267h,7027h,0333h,0334h,0335h
	    dw 0336h,0337h,4034h,0345h,0346h,0347h,5035h,0356h
	    dw 0357h,6036h,0367h,7037h,0444h,0445h,0446h,0447h
	    dw 5045h,0456h,0457h,6046h,0467h,7047h,0555h,0556h
	    dw 0557h,6056h,0567h,7057h,0666h,0667h,7067h,0777h
	    dw	     1112h,1113h,1114h,1115h,1116h,1117h,2112h
	    dw 1123h,2114h,2115h,2116h,2117h,3113h,3114h,3115h
	    dw 3116h,3117h,4114h,4115h,4116h,4117h,5115h,5116h
	    dw 5117h,6116h,6117h,7117h,1222h,1223h,1224h,1225h
	    dw 1226h,1227h,3123h,1234h,1235h,1236h,1237h,4124h
	    dw 1245h,1246h,1247h,5125h,1256h,1257h,6126h,1267h
	    dw 7127h,1333h,1334h,1335h,1336h,1337h,4134h,1345h
	    dw 1346h,1347h,5135h,1356h,1357h,6136h,1367h,7137h
	    dw 1444h,1445h,1446h,1447h,5145h,1456h,1457h,6146h
	    dw 1467h,7147h,1555h,1556h,1557h,6156h,1567h,7157h
	    dw 1666h,1667h,7167h,1777h,      2223h,2224h,2225h
	    dw 2226h,2227h,3223h,3224h,3225h,3226h,3227h,4224h
	    dw 4225h,4226h,4227h,5225h,5226h,5227h,6226h,6227h
	    dw 7227h,2333h,2334h,2335h,2336h,2337h,4234h,2345h
	    dw 2346h,2347h,5235h,2356h,2357h,6236h,2367h,7237h
	    dw 2444h,2445h,2446h,2447h,5245h,2456h,2457h,6246h
	    dw 2467h,7247h,2555h,2556h,2557h,6256h,2567h,7257h
	    dw 2666h,2667h,7267h,2777h,      3334h,3335h,3336h
	    dw 3337h,4334h,4335h,4336h,4337h,5335h,5336h,5337h
	    dw 6336h,6337h,7337h,3444h,3445h,3446h,3447h,5345h
	    dw 3456h,3457h,6346h,3467h,7347h,3555h,3556h,3557h
	    dw 6356h,3567h,7357h,3666h,3667h,7367h,3777h
	    dw 4445h,4446h,4447h,5445h,5446h,5447h,6446h,6447h
	    dw 7447h,4555h,4556h,4557h,6456h,4567h,7457h,4666h
	    dw 4667h,7467h,4777h,      5556h,5557h,6556h,6557h
	    dw 7557h,5666h,5667h,7567h,5777h,	   6667h,7667h
	    dw 6777h

;  The 3 tables below contain the red, green, and blue values (on a scale of
;  0..255) of each of the 330 PaintJet colors.	These values are based on data
;  generously provided by HP customer service.

;		    11 <- changed black's value from this, seemed wrong
;		       135 <- changed red's value from this
;				    11 <- changed blue's value from this
pj_reds     db 229,  2,145,  7,227,  9,136,  5
	    db	    17, 10, 17, 10, 16, 10, 16, 29, 16, 32, 15, 30, 15, 31,  9
	    db	15, 10, 15,  9, 13, 37, 15, 32, 16, 36, 10, 15,  9, 13, 30, 15
	    db	31,  8, 13, 38, 62, 26, 68, 26, 63, 26, 68, 16, 35, 16, 33, 16
	    db	33, 77, 26, 69, 29, 77, 16, 31, 16, 31, 64, 27, 71, 16, 36, 81
	    db	 9, 15, 10, 15,  8, 13, 37, 15, 31, 15, 33, 10, 15,  9, 13, 29
	    db	15, 28,  8, 12, 28, 98, 28, 79, 32, 94, 16, 34, 17, 35, 73, 30
	    db	82, 17, 43,101, 11, 15, 10, 13, 29, 15, 27,  9, 13, 25, 65, 27
	    db	71, 16, 35, 88,  7, 12, 39,110,     54,146, 53,136, 58,144, 29
	    db	57, 28, 53, 29, 56,159, 54,144, 61,160, 27, 51, 28, 52,135, 55
	    db 144, 30, 60,159, 14, 23, 15, 22, 14, 21, 64, 30, 58, 32, 64, 15
	    db	22, 15, 21, 54, 31, 56, 14, 22, 64,185, 59,160, 69,185, 29, 57
	    db	31, 60,145, 63,162, 33, 71,186, 15, 22, 16, 21, 50, 30, 52, 15
	    db	21, 54,134, 58,145, 30, 60,161, 15, 22, 69,187,     13,  9, 14
	    db	 6, 11, 31, 14, 27, 12, 27, 10, 14,  9, 12, 24,  9, 23,  6,  9
	    db	22, 76, 23, 61, 25, 74, 15, 29, 14, 28, 55, 23, 62, 12, 30, 73
	    db	11, 15, 10, 12, 25, 14, 23,  8, 11, 20, 50, 22, 53, 13, 26, 61
	    db	 5,  8, 21, 71,     71,189, 87,227, 30, 63, 32, 69,164, 76,190
	    db	37, 89,227, 15, 22, 14, 20, 54, 31, 57, 14, 21, 63,147, 67,163
	    db	33, 72,191, 13, 24, 94,228,	15, 10, 13, 26, 14, 23, 10, 13
	    db	20, 50, 23, 50, 15, 26, 52,  8, 11, 23, 65,	60,147, 32, 67
	    db 166, 14, 24, 77,194,	 8, 32, 97

;		    11 <- changed black's value from this, seemed wrong
;			    65 <- changed green from this
pj_greens   db 224,  2, 20, 72,211, 10, 11, 55
	    db	    12, 15, 19, 11, 11, 14, 17, 14, 18, 22, 12, 13, 16, 19, 24
	    db	29, 16, 17, 23, 27, 41, 17, 22, 29, 39, 11, 10, 14, 14, 11, 14
	    db	17, 21, 25, 40, 16, 21, 28, 14, 16, 19, 25, 28, 37, 18, 20, 26
	    db	33, 48, 20, 26, 33, 46, 13, 12, 16, 18, 14, 18, 22, 24, 30, 42
	    db	40, 49, 25, 27, 39, 50, 69, 27, 33, 48, 66, 17, 17, 24, 27, 19
	    db	28, 35, 38, 48, 68,100, 32, 46, 65, 98, 18, 22, 29, 36, 27, 39
	    db	54, 49, 71,105, 11, 10, 14, 12, 10, 14, 13, 20, 20, 25, 11, 15
	    db	18, 22, 29, 49, 36, 46, 69,111,     23, 31, 16, 19, 22, 28, 30
	    db	37, 20, 22, 28, 34, 54, 22, 29, 36, 53, 14, 15, 17, 19, 17, 19
	    db	26, 25, 32, 46, 43, 50, 27, 28, 41, 49, 68, 29, 37, 51, 68, 19
	    db	19, 25, 28, 22, 30, 36, 40, 47, 66,104, 35, 51, 68,105, 20, 24
	    db	31, 37, 30, 38, 56, 50, 69,103, 13, 12, 15, 14, 13, 15, 16, 21
	    db	21, 26, 14, 16, 22, 23, 28, 44, 35, 42, 62,102,     78, 40, 44
	    db	65, 78, 98, 43, 53, 76, 99, 26, 27, 36, 40, 29, 43, 50, 63, 75
	    db	99,136, 49, 69, 98,142, 28, 32, 42, 51, 39, 52, 73, 77,103,145
	    db	17, 17, 21, 21, 18, 22, 24, 34, 37, 43, 19, 23, 30, 40, 48, 69
	    db	62, 76,101,147,     72,113,145,218, 33, 42, 52, 71, 61, 77,116
	    db 105,148,221, 18, 17, 21, 23, 21, 26, 30, 37, 43, 64, 30, 35, 48
	    db	50, 69,115, 77, 99,149,224,	10, 13, 11, 10, 12, 11, 17, 16
	    db	15,  9, 11, 12, 17, 17, 22, 26, 27, 36, 61,	14, 18, 21, 26
	    db	48, 34, 41, 68,115,	69, 99,149

;		    15 <- changed black's value from this, seemed wrong
;			    56 <- changed green from this
;					   163 <- changed cyan from this
pj_blues    db 216,  2, 34, 48, 33, 73, 64,168
	    db	    18, 19, 18, 20, 19, 22, 21, 22, 24, 22, 26, 24, 27, 24, 27
	    db	24, 29, 27, 31, 29, 22, 27, 25, 30, 28, 31, 29, 33, 33, 28, 32
	    db	32, 41, 40, 46, 28, 32, 28, 34, 30, 36, 31, 35, 32, 38, 34, 41
	    db	35, 27, 35, 31, 39, 34, 40, 37, 44, 40, 34, 42, 37, 49, 47, 45
	    db	40, 36, 43, 40, 47, 43, 33, 40, 36, 45, 41, 44, 41, 49, 46, 40
	    db	49, 45, 58, 56, 58, 30, 38, 34, 44, 40, 42, 39, 49, 46, 38, 49
	    db	46, 59, 62, 67, 49, 46, 55, 52, 44, 55, 52, 64, 64, 66, 43, 55
	    db	53, 66, 70, 78, 87, 91,101,115,     39, 34, 42, 37, 43, 36, 45
	    db	38, 47, 42, 49, 43, 34, 41, 36, 44, 38, 49, 45, 52, 46, 40, 47
	    db	42, 56, 51, 45, 49, 45, 52, 48, 56, 50, 40, 47, 44, 52, 47, 54
	    db	51, 59, 55, 47, 58, 50, 66, 60, 56, 34, 44, 38, 48, 42, 52, 47
	    db	56, 50, 42, 51, 46, 64, 59, 57, 60, 56, 64, 61, 52, 61, 57, 72
	    db	67, 64, 48, 58, 53, 69, 65, 65, 87, 83, 87, 94,     53, 59, 55
	    db	64, 60, 46, 53, 49, 59, 54, 60, 56, 65, 62, 53, 62, 58, 76, 71
	    db	68, 41, 50, 45, 56, 51, 58, 53, 63, 59, 49, 60, 56, 74, 71, 71
	    db	66, 63, 73, 70, 60, 69, 67, 84, 81, 79, 55, 67, 64, 84, 81, 83
	    db 104,104,106,116,     32, 40, 53, 48, 54, 50, 61, 57, 46, 59, 56
	    db	76, 75, 80, 64, 59, 70, 67, 57, 69, 65, 83, 81, 85, 54, 68, 66
	    db	86, 88, 96,110,114,125,137,	71, 81, 78, 68, 77, 76, 93, 92
	    db	90, 65, 77, 75, 92, 93, 96,117,119,126,138,	78, 79, 98,102
	    db 110,124,131,143,157,    173,185,200

	end

