unit Unit1;   { DEMO 2 for Delphi Zip by Eric W. Engler }

{ IMPORTANT:  You must have Optimization turned off in the
Delphi Project...Options, Compiler page, in order to get
DEMO 2 to work.  As of this time, I haven't determined if
this is my fault or Borland's fault.  In any event, it
doesn't hurt you much to have optimization off since most
of the work is being done in the C DLL, and it is highly
optimized.
- Eric Engler }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ZipMstr;

type
  TForm1 = class(TForm)
    ZipBut: TButton;
    UnzipBut: TButton;
    ExitBut: TButton;
    ZipMaster1: TZipMaster;
    DelBut: TButton;
    VersionBut: TButton;
    procedure ZipButClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ExitButClick(Sender: TObject);
    procedure ZipMaster1Message(Sender: TObject; ErrCode: Integer;
      Message: string);
    procedure UnzipButClick(Sender: TObject);
    procedure DelButClick(Sender: TObject);
    procedure VersionButClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   SetCurrentDir('C:\ZIP\DEMO2');
   Caption:='ZIP Demo 2 - ' + GetCurrentDir;
end;

procedure TForm1.ZipButClick(Sender: TObject);
begin
  with ZipMaster1 do
  begin
     ZipFileName:='TEST.ZIP';
     FSpecArgs.Add('TEST.DAT');
     Add;
     ShowMessage('Files added = ' + IntToStr(SuccessCnt));
  end;
end;

{ expand all files from the zipfile }
procedure TForm1.UnzipButClick(Sender: TObject);
begin
  with ZipMaster1 do
  begin
     ZipFileName:='TEST.ZIP';
     if Count = 0 then
     begin
        ShowMessage('Error - no files in the Zip file');
        Exit;
     end;
     { By not specifying filenames, we will extract them all. }
     { Of course, in this little demo there is only 1 file in the ZIP. }
     ExtrBaseDir:=GetCurrentDir;
     { if the file to be extracted already exists, overwrite it }
     ExtrOptions:=ExtrOptions+[Overwrite];
     Extract;
     ShowMessage('Files extracted = ' + IntToStr(SuccessCnt));
  end;
end;

procedure TForm1.DelButClick(Sender: TObject);
begin
  with ZipMaster1 do
  begin
     ZipFileName:='TEST.ZIP';
     FSpecArgs.Add('TEST.DAT');
     Delete;
     ShowMessage('Files deleted = ' + IntToStr(SuccessCnt));
  end;
end;

procedure TForm1.VersionButClick(Sender: TObject);
begin
   ShowMessage('ZIPDLL version: '
      + IntToStr(Integer(ZipMaster1.MajZipVers)) + '.'
      + IntToStr(Integer(ZipMaster1.MinZipVers)) + #13#10#13#10 +
      'UNZDLL version: '
      + IntToStr(Integer(ZipMaster1.MajUnzVers)) + '.'
      + IntToStr(Integer(ZipMaster1.MinUnzVers)));
end;

procedure TForm1.ExitButClick(Sender: TObject);
begin
   Close;
end;

{ This procedure displays messages received from the DLLs.  If you really
  want to minimize the amount of messages you show the user, you don't
  even need to assign this event handler.  However, I'd still recommend
  that you assign this to catch errors.  You can test the ErrCode
  before you display the message - if ErrCode is non-zero, make sure you
  display the message.  If it's 0, then you can ignore the message.
    Also, if ZipMaster1's "Verbose" property if true, you'll get more
  informational message callbacks here. By default, it's false to
  minimize user messages. }
procedure TForm1.ZipMaster1Message(Sender: TObject; ErrCode: Integer;
  Message: string);
begin
   { if ErrCode > 0 then }   { uncomment this line to show errors ONLY }
   ShowMessage(Message);
end;

end.
