/**************************************************************************/
/*                                                                        */
/* BIRTHDAY.CMD   Example program to demonstrate the use of WarpNote in   */
/*                connection with WarpNote Command. This program scans    */
/*                the file BIRTHDAY.TXT for coming anniversaries and if   */
/*                there are such events, the program creates a note to    */
/*                inform the user. This program could be run in your      */
/*                Startup folder. You may and you should customize this   */
/*                program for your own needs.                             */
/*                                                                        */
/* Created on November 8th, 1997, Uwe Schlenther, 70193 Stuttgart,Germany */
/**************************************************************************/

NoteNumber=100     /* This is the number of the note we will create. Make */
                   /* sure that you don't use this number for your own    */
                   /* needs and change it if necessary.                   */

Days=14            /* This is the number of days we will watch for coming */
                   /* events, counting from today.                        */

InFile="BIRTHDAY.TXT"   /* This is the file containing the birthday data. */

OutFile="NEWNOTE"

"del "OutFile

"wncomm wait"                               /* Wait for WarpNote startup. */
"wncomm delete "NoteNumber     /* Delete a previous instance of the note. */

call LINEOUT OutFile,"Coming Anniversaries",1
call LINEOUT OutFile,"===================="
call LINEOUT OutFile,""

call SetMonthDays

NumAnniversaries=0

Today=DATE("S")
parse var Today Year 5 Month 7 Day

do i=0 to Days
  call ScanBirthdayFile Day,Month,Year
  NumAnniversaries=NumAnniversaries+result

  Day=Day+1
  if Day>MonthDays.Month then do
    Day=1
    Month=Month+1
  end
  if (Month=2) & (Day=29) & (Year//4<>0) then do /* Simple algorithm for */
    Day=1                                        /* leap year. Should    */
    Month=Month+1                                /* suffice for this     */
  end                                            /* purpose.             */
  if Month>12 then do
    Month=1
    Year=Year+1
  end
end

LINEIN(OutFile,1,0)       /* Reset file pointer on anniversary data file. */

/* If anniversaries have been written to the OutFile, create a note.    */

if (NumAnniversaries>0) then do
  "wncomm getdesktopx"                  /* Get horizontal desktop size. */
  DesktopX=rc
  "wncomm getdesktopy"                    /* Get vertical desktop size. */
  DesktopY=rc
  "wncomm create "NoteNumber                        /* Create the note. */
  "wncomm setsizexy "NoteNumber DesktopX%2 DesktopY%4
  "wncomm center "NoteNumber
  "wncomm load "NoteNumber" newnote"
  "wncomm show "NoteNumber
end

exit

ScanBirthdayFile:
  arg Day,Month,Year

  Count=0

  LINEIN(InFile,1,0)      /* Reset file pointer on anniversary data file. */

  do while LINES(InFile)               /* Look through all lines of data. */
    Line=LINEIN(InFile)
    if (SUBSTR(Line,1,1)<>":") & (Line<>"") then do
      parse var Line ADay "," AMonth "," AYear "," AName   /* Parse line. */
      if (ADay=Day) & (AMonth=Month) then
      do
        Count=Count+1          /* Increase number of found anniversaries. */
        MName=MonthName(AMonth)
        Line=ADay MName": "AName
        if (AYear<>"") then do    /* Add age if yearappears in data file. */
          Age=Year-AYear
          Line=Line "("Age")"
        end
        call LINEOUT OutFile,Line
      end
    end
  end
return Count

MonthName:
  arg MonthNumber

  select
    when MonthNumber=1 then return "January"
    when MonthNumber=2 then return "February"
    when MonthNumber=3 then return "March"
    when MonthNumber=4 then return "April"
    when MonthNumber=5 then return "May"
    when MonthNumber=6 then return "June"
    when MonthNumber=7 then return "July"
    when MonthNumber=8 then return "August"
    when MonthNumber=9 then return "September"
    when MonthNumber=10 then return "October"
    when MonthNumber=11 then return "November"
    when MonthNumber=12 then return "December"
  end
return 0

SetMonthDays:
  MonthDays.1=31
  MonthDays.2=29
  MonthDays.3=31
  MonthDays.4=30
  MonthDays.5=31
  MonthDays.6=30
  MonthDays.7=31
  MonthDays.8=31
  MonthDays.9=30
  MonthDays.10=31
  MonthDays.11=30
  MonthDays.12=31
return 0
