/*
 REXX program to extract statistics from NFTP.FLS file     Version 0.6
 Freely distributable, but copyright by Tth Ferenc <etus@alarmix.net>
 Please mail any suggestinos and/or bug report to the author.

 To do (if I have time :)
 - option to count uploads/downloads separately
 - option to sort sites according to speed or down/upload size
 - option to list only specified time interval or sites

 Corrections

  0.5
    - corrected a bug, now the first site listed in nftp.fls will be listed
  0.6
    - corrected a small bug in the routine that handles temporary files
    - added progress indicator so the user won't worry that much :)
    - much cleaner source code with more comments


   Variables used for calculation
   ------------------------------
   files:  number of entries in NFTP log files
   month.: month of entry
   year.:  yaer of entry
   size.:  filesize of entry
   [more to-be added here if I have the time]
   
*/

Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Introduce ourselves :) */
Say
Say "NFTP logfile statistics calculator v0.6"
Say

/* Pull in the log file names */
Parse Arg inputfiles

/* Temporary filename */
tempfile = SysTempFileName('nftplog.???')

/* Output filename */
outputfile = "nftp.sta"

/* Delete output file */
"@del" outputfile ">nul 2>&1"

/* Initialize variables */
call SysCurState 'OFF'
ProgressCounter=1
process="|/-\"

/* Check wheter inputfiles were given or not on the command line */
If inputfiles="" Then
  Do
    Say "usage: stat.cmd NFTP_log_filename"
    Say "where NFTP_log_filename is a filemask describing NFTP log files"
    Exit
  End

/* get all log files into one big temporary file */
"@copy "inputfiles tempfile "1> nul 2>&1"

/* open our outputfile */
noecho = Lineout(outputfile, "Logfile created by NFTP logfile statistics calculator v0.6 on "||Date('L'))
noecho = Lineout(outputfile, "")
noecho = Lineout(outputfile, "Date      Megabyte     average speed (cps)")
noecho = Lineout(outputfile, "------------------------------------------")

/* Inform our user what is happening */
noecho = Charout(, "Gathering information from logfiles...")

/* Calculate the number of files and store their date/time, size etc. */
files=1
Do While Lines(tempfile) > 0
  Call PROGRESSINDICATOR(files 30)
  entry = Linein(tempfile)
    
  /* month, year and filesize */
  month.files = Substr(entry, 4, 2)
  year.files = Substr(entry, 7, 2)
  size.files = Substr(entry, 16, 9)

  /* down or upload */
  dl = Pos(" - ", entry) + 3
  ul = Pos(" + ", entry) + 3
  which = dl
  If which = 3 Then which = ul

/* Check if the entry is old style or new style.
   Old style log entries do not log the speed */
  If Pos("B/s) ", entry) = 0 Then
    Do
      speed.files = -1
      site.files = Substr(entry, which, Pos(":", entry, which) - which)
    End
  Else
    Do
      /* new style with speed */
      speed.files = Substr(entry, 26, 7)
      site.files = Substr(entry, which, Pos(":", entry, which) - which)
    End

/* If bps = 0 then let it be equal with filesize since in most cases
 it means that the transfer was done in 1 sec. But don't forget that
 there can be 0 long files */
  If speed.files = 0 Then speed.files = size.files
  If speed.files = 0 Then speed.files = 1
  site = site.files
  bytespersite.site=0
  bytespersite2.site=0
  offset=year.files*10000+month.files
  bytespermonth.offset=0
  bytespermonth2.offset=0
  timepersite.site=0
  timepermonth.offset=0
  files=files+1
End
noecho = Lineout(tempfile)
"@del "||tempfile||" 1> nul 2> nul"
files=files-1
time=0
total=0
total2=0
totaltime=0
say " "

noecho = Charout(, "Calculating statistics...")

/* summary */
Do counter=1 To files
/* Calculate the number of files and store their date/time, size etc. */
  Call PROGRESSINDICATOR(counter 40)
  site = site.counter
  sps = size.counter / speed.counter
  bytespersite.site=bytespersite.site + size.counter
  If speed.counter <> -1 Then bytespersite2.site=bytespersite2.site + size.counter
  If speed.counter <> -1 Then timepersite.site=timepersite.site+sps
  offset = year.counter * 10000 + month.counter
  bytespermonth.offset=bytespermonth.offset+size.counter
  If speed.counter <> -1 Then bytespermonth2.offset = bytespermonth2.offset + size.counter
  If speed.counter <> -1 Then timepermonth.offset = timepermonth.offset + sps
  If speed.counter = -1 Then total2=total2+size.counter
  Else
    Do
      total2 = total2 + size.counter
      total = total + size.counter
      totaltime = totaltime + sps
    End
End

kiirt=0
Do numsites=1 To files
  Call PROGRESSINDICATOR(numsites 70)
  offset=year.numsites*10000+month.numsites
  If numsites > 1 Then
    Do
      check = kiirt
      Do While (offset <> honap.check) & (check > 0)
        check = check - 1
      End
    End

  If (offset<>honap.check) Then Do
    If timepermonth.offset=0 Then timepermonth.offset=1
    speed=Format(bytespermonth2.offset/timepermonth.offset,16,0)
    If speed > 999999 Then speed=Right(Reverse(Insert(",", Insert(",", Reverse(Strip(speed)), 3), 7)),16)
    Else If speed > 999 Then speed=Right(Reverse(Insert(",", Reverse(Strip(speed)), 3)),16)
    byte=Format(bytespermonth.offset/1024/1024,9,2)
    If speed=0 Then speed=""
    noecho = Lineout(temp2, year.numsites"/"month.numsites||byte||speed)
    honap.kiirt=offset
    kiirt=kiirt+1
  End
End

noecho = Lineout(temp2)
"@type temp2 | sort > temp3"
Do While Lines(temp3) > 0
  line = Linein(temp3)
  noecho = Lineout(outputfile, Substr(line,4,2)||"/"||Substr(line,1,2)||Substr(line,6))
End
noecho = Lineout(temp3)
"@del temp2 1> nul 2> nul"
"@del temp3 1> nul 2> nul"

noecho = Lineout(outputfile, "")
noecho = Lineout(outputfile, "Site                                      Megabyte     average speed (cps)")
noecho = Lineout(outputfile, "--------------------------------------------------------------------------")
noecho = Lineout(outputfile, "")

Do numsites=1 To files
  Call PROGRESSINDICATOR(numsites 15)
  site=site.numsites
  check=0
  If numsites > 1 Then
    Do
      check = numsites -1
      Do While (site.check <> site) & (check > 0)
        check = check - 1
      End
    End

  If (site.check<>site) Then Do
    If timepersite.site=0 Then timepersite.site=1
    speed=Format(bytespersite2.site/timepersite.site,16,0)
    If speed > 999999 Then speed=Right(Reverse(Insert(",", Insert(",", Reverse(Strip(speed)), 3), 7)),16)
    Else If speed > 999 Then speed=Right(Reverse(Insert(",", Reverse(Strip(speed)), 3)),16)
    byte=Format(bytespersite.site/1024/1024,9,2)
    If speed=0 Then speed=""
    donotecho = Lineout(outputfile, Overlay(" ", site,38,0)||byte||"    "||speed)
  End
End
say " "
If totaltime>0 Then totalspeed=Format(total/totaltime,16,0)
Else totalspeed = ""
If totalspeed > 999999 Then totalspeed=Right(Reverse(Insert(",", Insert(",", Reverse(Strip(totalspeed)), 3), 7)),16)
Else If totalspeed > 999 Then totalspeed=Right(Reverse(Insert(",", Reverse(Strip(totalspeed)), 3)),16)
noecho = Lineout(outputfile, "--------------------------------------------------------------------------")
noecho = Lineout(outputfile, "Total            " Right(Format(total2/1024/1024,9,2), 31) Right(totalspeed, 19))
say "Done calculating statistics. See file 'nftp.sta'."
Exit

/* Show progress indicator */
PROGRESSINDICATOR:
Parse Arg Variable PerCounter
If Variable // PerCounter = 0 Then
  Do
    noecho = Charout(, SubStr(process,ProgressCounter,1))
    parse value SysCurPos() with row col
    rc = SysCurPos(row, col-1)
    ProgressCounter = ProgressCounter+1
    If (ProgressCounter = 5) Then ProgressCounter=1
  End
Return
