/* REXX */

/* Load RexxUtil extensions */
if RxFuncQuery("SysLoadFuncs") then do
    say "loading RexxUtil extensions..."
    call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    if result \= "0" then do
        say "error loading RexxUtil.dll"
        exit
    end
    call SysLoadFuncs
end

/* ask user about directories etc. */
Call SysCls
say
say "NFTP Version 1.11 installation"
say
say "This script will do the following:"
say "1) copy required files into the directory you specified;"
say "2) copy your preferences from existing NFTP.INI or put defaults there"
say "   if this is the first installation"
say "3) create objects on your desktop"
say

numlangs = 15
lang.1  = "English   "
lang.2  = "Russian   "
lang.3  = "Chinese   "
lang.4  = "Spanish   "
lang.5  = "Swedish   "
lang.6  = "Hungarian "
lang.7  = "German    "
lang.8  = "Danish    "
lang.9  = "Japanese  "
lang.10 = "Norwegian "
lang.11 = "Italian   "
lang.12 = "Brazilian "
lang.13 = "Dutch     "
lang.14 = "French    "
lang.15 = "Bulgarian "

choose_language:
    
say "Enter no. of language you wish to install:"
say
do i = 1 to numlangs by 3
    i1 = i + 1
    i2 = i + 2
    say right(i,2)")" lang.i "    " right(i1,2)")" lang.i1 "    " right(i2,2)")" lang.i2
end
say
say "Empty line entered will abort installation."
parse pull langno .
if langno = "" then exit
if (langno > numlangs) | (langno < 1) then do
    say "The number you entered is outside of range"
    say
    signal choose_language
end
language = lang.langno

say
say "Enter destination directory (where NFTP files will be installed)."
say "WARNING: this must be HPFS drive (to support long filenames)."
say "If you wish to install NFTP into the subtree (eg, ""d:\apps\tcpip\nftp"")"
say "you have to create upper directory first (""d:\apps\tcpip"" in the"
say "above example). Enter ""."" to install into the current directory."
say "Empty line entered will abort installation."
say
parse pull destpath .
if destpath = "" then exit

destpath = strip(destpath, "T", "\")
dlpath = strip(dlpath, "T", "\")

/* verify choices */
call SysCls
say "Installing NFTP into the directory :" destpath
say "NFTP language                      :" language
say
say "Press Ctrl-C to abort or any other key to continue"
say
'@pause >nul'
Call SysCls

/* creating target directories if necessary */
if destpath <> "." then
do
    call SysFileTree destpath, "srch", "D"
    if srch.0 = 0 then do
        rc = SysMkDir(destpath)
        if rc <> 0 then do
            say "Fatal error: cannot create directory" destpath
            exit
        end
    end
    call SysFileTree destpath"\nls", "srch", "D"
    if srch.0 = 0 then do
        rc = SysMkDir(destpath"\nls")
        if rc <> 0 then do
            say "Fatal error: cannot create directory" destpath"\nls"
            exit
        end
    end
end
    
/* copying NFTP files */
if destpath <> "." then
do
    '@copy * 'destpath' >nul'
    '@copy 'destpath'\*.nls 'destpath'\nls\ >nul'
    '@del 'destpath'\*.nls'
    say "Files were copied to" destpath
end

if destpath = "." then destpath = directory()
if dlpath = "." then dlpath = directory()
    
/* making sure we will not overwrite existing nftp.mrk */
if stream(destpath"\nftp.bmk", "C", "QUERY EXISTS") == "" then
   if stream(destpath"\nftp.mrk", "C", "QUERY EXISTS") <> "" then
      call bmkconv destpath"\nftp.mrk" destpath"\nftp.bmk"
   else
     '@copy nftp.bm 'destpath'\nftp.bmk >nul'

/* checking 'nftp.ini' presence */
newinifile = destpath"\nftp.ini"
if stream(destpath"\nftp.ini", "C", "QUERY EXISTS") <> "" then 
do
    say
    say destpath"\nftp.ini already exists."
    say "It will be renamed to nftp.bak and new nftp.ini will be"
    say "created; all your customizations are now transferred"
    say "automatically."
    '@pause'
    call SysFileDelete destpath"\nftp.bak"
    "@rename" destpath"\nftp.ini nftp.bak"
    call updini destpath"\nftp.bak" destpath"\nftp.ini" directory()"\nftp.i"
end
else
do
    /* creating new 'nftp.ini' and customizing it slightly */
    call SysFileDelete newinifile
    signal off notready
    say
    say "Enter default path for downloads (e.g., ""d:\tmp"")."
    say "This directory should reside on HPFS drive or you'll be unable"
    say "to download files which are not 8.3-compliant."
    say "You may skip it (current directory will be used for downloads)."
    parse pull dlpath .

    if (dlpath <> ".") & (dlpath <> "") then
    do
        call SysFileTree dlpath, "srch", "D"
        if srch.0 = 0 then do
            rc = SysMkDir(dlpath)
            if rc <> 0 then do
                say "Fatal error: cannot create directory" dlpath
                exit
            end
        end
    end

    do forever
       say
       say "Enter your e-mail address (to be used as a password for anonymous logins):"
       parse pull email .
       email = strip(email)
       if email <> "" then leave
    end

    do forever
        lin = linein("nftp.i")
        newlin = lin
        if substr(lin,1,20) = ';anonymous-password=' then
            newlin = 'anonymous-password="'email'"'
        if substr(lin,1,20) = ';log-transfers-name=' then
            newlin = ';log-transfers-name="'destpath'\nftp.fls"'
        if substr(lin,1,23) = ';default-download-path=' then
            newlin = 'default-download-path="'dlpath'"'
        if substr(lin,1,16) = ';bookmarks-file=' then
            newlin = ';bookmarks-file="'destpath'\nftp.bmk"'
        rc = lineout(newinifile, newlin)
        if lin = "" & left(stream("nftp.i"),5) <> "READY" then leave
    end
    call stream "nftp.i", "C", "CLOSE"
    call stream newinifile, "C", "CLOSE"
end

/* creating nftp.cmd */

cmdfile = destpath"\nftp.cmd"
call SysFileDelete cmdfile    
rc = lineout(cmdfile, "@set NFTP_LANG="strip(language))
rc = lineout(cmdfile, "@"destpath"\nftp.exe %1 %2 %3 %4 %5 %6")
call stream cmdfile, "C", "CLOSE"

'@pause'
Call SysCls

call makeobjs destpath

/* looks like we're done... */
say
say "Installation complete."
say
'@pause'
Exit
