/* REXX 

   bmkconv <old-bookmark-file> <new-bookmark-file>

   converts bookmark file from old format (.mrk) into new one (.bmk)

*/

parse arg oldlist newlist garbage

if (newlist = "" ) | (garbage <> "") then signal usage

/* Load RexxUtil extensions */
if RxFuncQuery("SysLoadFuncs") then do
    call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
    if result \= "0" then do
        say "error loading RexxUtil.dll"
        exit
    end
    call SysLoadFuncs
end

say
say "Converting" oldlist "into" newlist"..."
call SysFileDelete newlist
rc = lineout(newlist, "; generated by bmk-conv")
rc = lineout(newlist, "")
rc = lineout(newlist, "[General sites]")

signal off notready
countgen = 0
countos2 = 0

do forever
    
    bookmark = linein(oldlist)
    if bookmark = "" then leave
    
    /* parse old format */
    parse value bookmark with login site" : "initdir
    /*if (substr(initdir, 1, 1) <> "/") then initdir = "/"initdir*/
    if (initdir = "") | (site = "") then iterate
    /*say "|"login"|"site"|"initdir"|"*/

    /* attempt to guess description for some well-known sites */
    desc = ""
    tsite = translate(site)
    if (tsite = "HOBBES.NMSU.EDU") | (tsite = "FTP-OS2.NMSU.EDU") then ,
        desc = "Hobbes: the biggest place for OS/2 material on the Internet"
    if (tsite = "FTP.CDROM.COM") | (tsite = "FTP-OS2.CDROM.COM") then ,
        desc = "Walnut Creek CDROM archive"
    if (tsite = "FTP.LEO.ORG") then ,
        desc = "LEO - Link Everything Online, Germany"
    if (tsite = "SERVICE.BOULDER.IBM.COM") | (tsite = "FTP.SOFTWARE.IBM.COM") then ,
        desc = "IBM: primary ftp server for OS/2-related files"
    if (tsite = "FTP.SAI.MSU.SU") then ,
        desc = "SAI software archive, Moscow"

    /* create new format */
    newbookmark = site":"initdir" : "login"// : "desc
    rc = lineout(newlist, newbookmark)
    
    /* converted successfully */
    countgen = countgen + 1

    /* check for the end of file */
    if stream(oldlist) <> "READY" then leave
    
end
rc = lineout(newlist, "")

say countgen "entries were converted and placed into [General sites] folder"
/*say countos2 "entries were converted and placed into [OS/2-related sites] folder"*/

exit 0

usage:
    
    say
    say "Usage: bmkconv <old-bookmark-file> <new-bookmark-file>"
    say "Converts bookmark file from old format (.mrk) into new one (.bmk)."
    say "Both parameters are obligatory."

    exit 1
