/* */

 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
 call SysLoadFuncs

 rc=Say_Warning()
 rc=Handle_docs()
 rc=Handle_help()
 rc=Handle_script()
 rc=Handle_trans()
 rc=Save_files()
 Say 'Unzipping the distribution File'
 '@unzip  -qq -o distrib.zip' 
 If rc <> 0 Then rc=Say_error()
 rc=Is_hpfs()
 If rc = 1 Then '@unzip -qq -o hpfs.zip'
 If rc <> 0 Then rc=Say_error()
 Say 'Finished unzipping the distribution zip files, now cleaning up.'
 rc=Cleanup()
 rc=Restore_files()
 rc=Say_Info()
 rc=Run_setup() 
 rc=Create_Icon()
exit

Say_Warning: Procedure
 Call SysCls
 say 'This install procedure does the following.'
 say '[1] Deletes the help, script, docs, and translation sub-directories'
 say  '   if they exist.'
 say '[2] Unzips the distribution zip file, and help files'
 say '[3] Unzips extra help files if you are installing on HPFS'
 say '[4] Cleans up after itself'
 say '[5] Runs setup.exe to configure your irc session if necessary.'
 say ' '
 say 'If you wish to preserve files in some of these directories, then'
 say 'interrupt the install with Ctrl-break now.'
 say ' '
 say ' The files ircserv.txt, ircrc, and irc2.ini will be preserved'
 rc=SysSleep(15)
 say ' '
 say 'Proceeding...'
return 1

Handle_docs: Procedure
 curdir=directory()
 curdir=curdir'\docs\primer.txt'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\docs'
   '@delpath /y docs > nul'
 End 
return 1

Handle_help: Procedure
 curdir=directory()
 curdir=curdir'\help\cd'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\help'
   '@delpath /y help > nul'
 End 
return 1

Handle_script: Procedure
 curdir=directory()
 curdir=curdir'\script\channel'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\script'
   '@delpath /y script > nul'
 End 
return 1

Handle_trans: Procedure
 curdir=directory()
 curdir=curdir'\translation\ascii'
 fname=stream(curdir,'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say 'Deleting .\translation'
   '@delpath /y translation > nul'
 End 
return 1


Save_files: Procedure

 fname=stream("ircrc",'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say ' Copying your ircrc to ircrc_.old'
 '@copy ircrc  ircrc_.old '
 End 

 fname=stream("ircstart",'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say ' Copying your ircstart to ircstart.irc'
 '@copy ircstart  ircstart.irc '
 End 


 fname=stream("irc2.ini",'C','Q EXISTS')
 If fname<>'' Then 
 Do 
   Say ' Copying your irc2.ini to irc2_ini.old'
 '@copy irc2.ini irc2_ini.old '
 End 

 fname=stream("ircserv.txt",'C','Q EXISTS')
 If fname<>'' Then
  Do
   Say ' Copying your ircserv.txt to ircserv_.old'
   '@copy ircserv.txt ircserv_.old '
  End

return 1

Say_Error: Procedure
  Say ' '
  Say ' '
  Say 'An error occurred during unzipping the IRC/2 install files'
  Say 'The probable causes of this are insufficient disk space, '
  Say 'and corrupted or missing zip files.'
  Say 'Please check your disk space, and the zip file'
  rc=SysSleep(5)
  Exit
return 0

Is_HPFS: Procedure
 dname = systempfilename('junk.????')
 rc=sysmkdir(dname)
 If rc = 0 Then
  Do
   rc=sysrmdir(dname)
   return 1
  End
 Else
  return 0

Cleanup: Procedure
 del_file.1='distrib.zip'
 del_file.2='hpfs.zip'
 del_file.3='delpath.exe'
 del_file.4='unzip.exe'
 del_file.5='install.cmd'
 del_file.6='change.*'
 del_file.7='update.cmd'
 del_file.8='ircsetup.cmd'
 del_file.0=8
 
 do i=1 to del_file.0
   fname=stream(del_file.i,'C','Q EXISTS')
   if fname <>'' Then rc=SysFileDelete(del_file.i)
 End
return 1

Restore_files: Procedure
 Say 'Restoring any saved files'
 fname=stream("ircrc_.old",'C','Q EXISTS')
 say fname
 If fname <>'' Then 
 Do 
   Say ' Restoring ircrc '
  '@copy ircrc_.old ircrc '
  '@del ircrc_.old '
 End 

 fname=stream("irc2_ini.old",'C','Q EXISTS')
 If fname <>'' Then 
 Do 
   Say ' Restoring your irc2.ini'
 '@copy irc2_ini.old irc2.ini '
 '@del irc2_ini.old'
 End 

 fname=stream("ircserv_.old",'C','Q EXISTS')
 If fname <>'' Then
  Do
   Say ' Restoring your ircserv.txt'
   '@copy ircserv_.old ircserv.txt'
   '@del ircserv_.old '
  End

 fname=stream("ircstart.irc",'C','Q EXISTS')
 If fname <>'' Then
  Do
   Say ' Restoring your ircstart'
   '@copy ircstart.irc ircstart'
   '@del ircstart.irc '
  End

return 1

Say_Info: Procedure
 Call SysCls

 say 'IRC/2 has now been installed, and the install procedure will '
 say 'now configure it, assuming you have not configured it previously.'
 say 'The configure procedure will create an folder on your desktop with '
 say 'an object to start IRC/2 and an object to modify the setup program.'
 say 'You may use the IRC/2 icon or irc.cmd to start IRC/2'
 say ' '
 say 'If you wish to modify your IRC/2 configuration after the initial '
 say 'installation, please use the icon on your desktop or run setup.exe'
 say ' '
 say 'Setup.exe will now be automatically invoked if required'
 rc=SysSleep(15)
return 1


Run_setup: Procedure

 INI_VERSION = "0.51"
 VERSION_ID = "0.65K2"
 
 fname=stream("irc2.ini",'C','Q EXISTS')
 If fname = '' Then do
    rc=SysIni("irc2.ini",'IRC/2','VERSION', VERSION_ID)
   '@setup.exe'
 End
 Else Do
    rc=SysIni("irc2.ini",'IRC/2','ALL:','names')   
    do i = 1 to names.0
       val=SysIni("irc2.ini",'IRC/2',names.i)
       if right(val, 1) = '00'x then
          val=left(val, length(val) - 1)
       interpret names.i '= val'
    end
    No_need_to_run = 0

    if IRCSETUP_VERSION \= 'IRCSETUP_VERSION' then 
       '@del irc2.ini'

    if INIVERS = 'INIVERS' Then 
       No_need_to_run = 1
    else if INIVERS < INI_VERSION Then 
            No_need_to_run = 1

    if no_need_to_run = 1 Then 
       '@setup.exe'
    else
       rc=SysIni("irc2.ini",'IRC/2','VERSION', VERSION_ID)
 End

return 1

Create_Icon: Procedure

If SysSetObjectData("<IRC_FOLDER>"," ")=0 Then 
   Call irc2desk.Cmd

return rc;
