/*

  REXX Script to install Internet Adventurer - and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Installing..."

dir = directory() || '\'

dir2 = substr(dir, 1, 2) || '"' || substr(dir, 3, length(dir)-2)
say "Creating folder"
call SysCreateObject "WPFolder", "Internet" || d2c(10) || "Adventurer", "<WP_DESKTOP>", "OBJECTID=<INETADVFOLDER>", "replace"

say "Creating program objects"
call SysCreateObject "WPProgram", "Uninstall", "<INETADVFOLDER>", "EXENAME=CMD.EXE;PARAMETERS= /C" dir2 || 'UNINST.CMD"', "replace"
call SysCreateObject "WPProgram", "Restore Configuration", "<INETADVFOLDER>", "EXENAME=CMD.EXE;PARAMETERS= /C" dir2 || 'COPYINI.CMD INETADV.INI OS2"', "replace"
call SysCreateObject "WPProgram", "Backup Configuration", "<INETADVFOLDER>", "EXENAME=CMD.EXE;PARAMETERS= /C" dir2 || 'COPYINI.CMD OS2 INETADV.INI"', "replace"
call SysCreateObject "WPProgram", "Edit quicklist.txt", "<INETADVFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "QUICKLST.TXT;STARTUPDIR=" || dir, "replace"
call SysCreateObject "WPProgram", "Import quicklist" || d2c(10) || "from quicklist.txt", "<INETADVFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'QIMPORT.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Export quicklist" || d2c(10) || "to quicklist.txt", "<INETADVFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'QEXPORT.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Import quicklist" || d2c(10) || "from WebExplorer", "<INETADVFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=/C " || dir2 || 'IMPORT.CMD";STARTUPDIR=' || dir, "replace"
call SysCreateObject "WPProgram", "Internet Adventurer", "<INETADVFOLDER>", "EXENAME=" || dir || "INETADV.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "Get legal and" || d2c(10) || "Register", "<INETADVFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir2 || 'REGISTER.TXT"', "replace"
call SysCreateObject "WPProgram", "Readme First", "<INETADVFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir2 || 'README.TXT"', "replace"

say "Delete news database ? (must be done when installing over v0.25 or v0.26)"
parse upper pull answer .

if left(answer, 1) \= 'Y' then do
   say "Installation completed - not deleting news database"
   exit
end

say "Deleting news database"
'del art*'
'del newsgrp.*'

say "Installation completed"
