/*
------------------------
Test Quicklist routines
------------------------
*/

say "Trying to load/register Internet Adventurer REXX API"
if RxFuncQuery("IARX_Register") <> 0 then do
   rc = RxFuncAdd("IARX_Register","IA_UTILS","IARX_Register")
   if rc <> 0 then do
      say "-------------------------------------"
      say "Error loading Internet Adventurer API"
      say "-------------------------------------"
      exit(1)
   end
end

rc = IARX_Register();
if rc then do
   say "-------------------------------------"
   say "Error loading Internet Adventurer API"
   say "-------------------------------------"
   exit(1)
end

say "Opening database"
ptr = IARX_QOpenDatabase();
if length(ptr) > 0 then do
   say "-------------------------------------"
   say "Opening database gave this:" ptr
   say "-------------------------------------"
   exit(1)
end

say "Database opened"

signal on novalue name handlenovalue
signal on error   name handleerror
signal on syntax  name handleerror

rc = IARX_QMakeTree("t",0);
if rc <> 0 then do
   say "No items found"
end
else do
   say t.items "items found"
   do i = 1 to t.items by 1
      say "Title:" t.i.title
      if t.i.type = 1 then
         say "URL  :" t.i.url
   end
end

drop t.

say "Closing database"
rc = IARX_QCloseDatabase()

exit(0)


/*
-------------
Handle errors
-------------
Upon entry to this function, the contents of the variables are:
rc   - Error code
sigl - Line number, error occured in.

Now we just display the error code and text followed by the
source-line with the problem
*/

handleerror:

say "REXX Error" rc "in line" sigl ":" errortext(rc);
say "-----";
say "-----" sourceline(sigl);
say "-----";
rc = IARX_QCloseDatabase();
exit;

/*
------------------------------
Handle variables without value
------------------------------
*/
handlenovalue:

say "REXX Error, trying to reference variable with no value in line" sigl;
say "-----";
say "-----" sourceline(sigl);
say "-----";
rc = IARX_QCloseDatabase();
exit;
