/* ea.c
   Extended attributes.
*/

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include "MacFS/mountrec.h"
#include "MacFS/LibFuncs/macreadwriteres.h"
#include "ea.h"
#include "icon.h"

/* Maximum size of resource fork EA */
#define MAX_EA_RESOURCE            60000
#define ICON_BUF_SIZE              8192

static unsigned short build_resource_ea(MOUNT_RECORD *, CATALOG_RECORD *, 
					 char *, unsigned short);
static unsigned short resource_ea_len(CATALOG_RECORD *);

static unsigned short build_icon_ea(MOUNT_RECORD *, CATALOG_RECORD *,
				    char *, unsigned short);
static unsigned short icon_ea_len(MOUNT_RECORD *, CATALOG_RECORD *);

static char resource_ea_name[] = "HFS.RESOURCES";
static char icon_ea_name[] = ".ICON";

/* Builds list of all EAs for a file. */
unsigned short build_fealist(MOUNT_RECORD *mr, CATALOG_RECORD *cr,
			     char *buf, unsigned short bufsize)
{
  char *p=buf+sizeof(ULONG);
  PFEALIST pfealist=(PFEALIST)buf;
  PFEA pfea;
  unsigned short rc;
  
  if(bufsize < sizeof(ULONG))
    return ERROR_BUFFER_OVERFLOW;

  /* We set the cbList field in case we get an overflow later */
  pfealist->cbList = ea_size(mr, cr);

  /* The EA for the resource fork */
  if(resource_ea_len(cr)) {
    pfea=(PFEA)p;
    rc=build_resource_ea(mr, cr, p, buf+bufsize-p);
    if(rc!=NO_ERROR)
      return rc;
    p+=sizeof(FEA)+pfea->cbName+pfea->cbValue+1;
  }
  
  /* .ICON */
  if(icon_ea_len(mr, cr)) {
    pfea=(PFEA)p;
    rc=build_icon_ea(mr, cr, p, buf+bufsize-p);
    if(rc!=NO_ERROR)
      return rc;
    p+=sizeof(FEA)+pfea->cbName+pfea->cbValue+1;
  }

  pfealist->cbList = p-buf;
  return NO_ERROR;
}

/* Builds list of EAs specified in GEA list */
unsigned short build_fealist_from_gealist(MOUNT_RECORD *mr, CATALOG_RECORD *cr,
					  char *geabuf, char *feabuf,
					  unsigned short bufsize)
{
  PFEALIST pfealist=(PFEALIST)feabuf;
  PGEALIST pgealist=(PGEALIST)geabuf;
  char *p=feabuf+sizeof(ULONG), *q=geabuf+sizeof(ULONG);

  if(bufsize < sizeof(ULONG))
    return ERROR_BUFFER_OVERFLOW;

  pfealist->cbList = ea_size(mr, cr);

  while(q-geabuf < pgealist->cbList) {
    if(!strcmp(q+1, resource_ea_name)) {
      PFEA pfea=(PFEA)p;
      unsigned short rc = build_resource_ea(mr, cr, p, feabuf+bufsize-p);
      if(rc!=NO_ERROR)
	return rc;
      p+=sizeof(FEA)+pfea->cbName+pfea->cbValue+1;
    }
    else if(!strcmp(q+1, icon_ea_name)) {
      PFEA pfea=(PFEA)p;
      unsigned short rc = build_icon_ea(mr, cr, p, feabuf+bufsize-p);
      if(rc!=NO_ERROR)
	return rc;
      p+=sizeof(FEA)+pfea->cbName+pfea->cbValue+1;
    }
    q += *q+2;
  }
  pfealist->cbList = p-feabuf;
  return NO_ERROR;
}

/* Returns size of EAs for a file or directory */
unsigned ea_size(MOUNT_RECORD *mr, CATALOG_RECORD *cr)
{
  unsigned short size=0;

  /* Check for resource fork */
  if(resource_ea_len(cr))
    size+=sizeof(FEA)+strlen(resource_ea_name)+1+resource_ea_len(cr);
  if(icon_ea_len(mr, cr))
    size+=sizeof(FEA)+strlen(icon_ea_name)+1+icon_ea_len(mr, cr);

  size+=sizeof(ULONG); /* cbList */
  return size;
}

static unsigned short resource_ea_len(CATALOG_RECORD *cr)
{
  return 0;

  /*
  LONGWORD res_len=cr->U.cdrFilRec.filRLgLen;
  
  return (res_len>0 
	  && res_len<=MAX_EA_RESOURCE
	  && cr->cdrType == CDR_FILE) ? res_len+2*sizeof(USHORT) : 0;
  */
}

/* Creates the extended attribute for the resource fork EA. */
static unsigned short build_resource_ea(MOUNT_RECORD *mr,
					CATALOG_RECORD *cr,
					char *buf, unsigned short bufsize)
{
  char *p = buf+sizeof(FEA);
  PFEA pfea = (PFEA)buf;
  LONGWORD bytesread, res_len;

  pfea->fEA = 0;
  pfea->cbName = strlen(resource_ea_name);
  pfea->cbValue = 0;

  if(bufsize < sizeof(FEA)+strlen(resource_ea_name)+1)
    return ERROR_BUFFER_OVERFLOW;

  strcpy(p, resource_ea_name);
  p+=strlen(resource_ea_name)+1;
  
  if(!(res_len=resource_ea_len(cr)))
    return NO_ERROR;

  if(buf+bufsize-p < res_len)
    return ERROR_BUFFER_OVERFLOW;

  *(PUSHORT)p = EA_RESOURCE_FORK;
  p+=sizeof(USHORT);
  *(PUSHORT)p = res_len-4;
  p+=sizeof(USHORT);

  if(mread_res(mr, cr, 0, res_len-4, p, &bytesread))
    return NO_ERROR;

  pfea->cbValue = res_len;

  return NO_ERROR;
}

static unsigned short icon_ea_len(MOUNT_RECORD *mr, CATALOG_RECORD *cr)
{
  int s;

  if(cr->cdrType == CDR_FILE) {
    s=icon_file_size(mr, cr, RESID_CUSTOMICON);
    if(s)
      return 2*sizeof(USHORT)+s;
  }
  return 0;
}

/* Creates the .ICON EA. */
static unsigned short build_icon_ea(MOUNT_RECORD *mr,
				    CATALOG_RECORD *cr,
				    char *buf, unsigned short bufsize)
{
  char *p = buf+sizeof(FEA);
  PFEA pfea = (PFEA)buf;
  int icon_len;

  pfea->fEA = 0;
  pfea->cbName = strlen(icon_ea_name);
  pfea->cbValue = 0;

  if(bufsize < sizeof(FEA)+strlen(icon_ea_name)+1)
    return ERROR_BUFFER_OVERFLOW;

  strcpy(p, icon_ea_name);
  p+=strlen(icon_ea_name)+1;
  
  if(!(icon_len=icon_ea_len(mr, cr)))
    return NO_ERROR;

  if(buf+bufsize-p < icon_len)
    return ERROR_BUFFER_OVERFLOW;

  *(PUSHORT)p = EAT_ICON;
  p+=sizeof(USHORT);
  *(PUSHORT)p = icon_len-4;
  p+=sizeof(USHORT);

  build_icon_file(mr, cr, RESID_CUSTOMICON, p);
  pfea->cbValue = icon_len;

  return NO_ERROR;
}
