#include "../defs.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "local_btree.h"
#include "btree.h"
#include "../errors.h"
#include "../Volume/volbmap.h"


static int NewBTNode(MOUNT_RECORD *mnt,
		 BT_HEADER    *head,
		 BYTE  *buffer,
		 LONGWORD  *inserted_node,    
		 LONGWORD  flink,
		 LONGWORD  blink,
		 BYTE type,
		 BYTE level);

static  int  ExtendBTree(MOUNT_RECORD *mnt,
			 BT_HEADER    *head,
			 LONGWORD     min_nodes,
			 BYTE * buffer);




int     BT_PutRecord(MOUNT_RECORD *mnt,
		     BT_HEADER    *head,
		     BT_KEY        key,
		     BYTE*         p_rec,
		     int           insert_length)   {


  SEARCH_STACK_ELEM stack[BT_MAX_DEPTH+1];
  BYTE buff[BT_NODESIZE], buff_aux[BT_NODESIZE];
  BYTE  temp_rec[MAX_RECORD_LENGTH];
  
  BYTE * found_rec;
  BT_KEY found_key;
  int err;
  LONGWORD inserted_node;
  int free_space_l,free_space_r,desired_space; /* Must be signed */
  int Depth, tot_alloc, i, level;
  int nr_recs_l, nr_recs_r, to_insert;
  BYTE *p_offset_l, *p_offset_r;
  int  where_to_copy;
  int found_len;
  int propag_length;
  int move_len, grow_tree;
  int already_inserted;

			      /* First Lookup the key */
   err = BT_Search(mnt, head, key, &found_rec, &found_len, stack, 
		   found_key, buff);

   if(err && err != BT_FOUNDLESS && err != BT_NOTFOUND)
     return(err);
		     
   if(err == 0) {	      /* The record data must be substituted*/

			      /* The only way that a record can change it's 
                               * length is by changing the name or the type; 
                               * Here we are sure the name and the type are 
                               * the same
			       */
     if(insert_length != found_len)
       return(BT_BADRECORD);

     move_len = KeyLength(found_key);
     bcopy(p_rec, found_rec - move_len, insert_length);

					/* Now I must write the buffer */
     CHKERR(BT_WriteNode(mnt, head, stack[1].Node, buff));

     return(0);
   }
			      /* Now the stack will contain for each level 
                               * (1==leaf) the Node visited and the Record 
                               * followed in the search. The Record field 
                               * begins at 1 so we must substract 1. For the 
                               * level 1 the Record stores the last record 
                               * with the key less or equal than the searched 
                               * key. If Record is 0 the key was found less 
                               * than all the records in the node. */

  Depth = head->bth.bthDepth; /* The depth of the tree */
  
			      /* initialize in case we need to grow the tree*/
  stack[Depth+1].Node   = 0;

			      /* Throughout the function at the beginning of 
                               * buff will have the record to propagate at 
                               * higher levels because I changed the first 
                               * record in a node and in buff_aux will have 
                               * the record to be inserted*/

			      /* Copy the record to insert in buff_aux */
  bcopy(p_rec, & buff_aux[14], insert_length);

  propag_length = 0 ;	      /* No propag key at the beginning */

  inserted_node = 0;	      /* No last inserted node */

  
			      /* Now I must insert a record */

			      /* I will need to alloc several nodes so 
                               * verify before if they are avilable  */

  tot_alloc = 1 + 1;	      /* Probably I must alloc also a map node and a 
                               * new root node  so start with 2*/
  grow_tree = 1;	      /* See if it's probable that i will grow the 
			       * tree
			       */
  
  for(i=Depth;i>=1;i--) {
    tot_alloc += stack[i].Alloc;
    if(!stack[i].Alloc)
      grow_tree = 0;
  }

  if(tot_alloc > head->bth.bthFree)  {
			      /* I must allocate the nodes from global pool 
                               * and need to extend the BTree  */
    CHKERR(ExtendBTree(mnt , head, tot_alloc - head->bth.bthFree, buff))

  }

  if(Depth == BT_MAX_DEPTH && grow_tree)
    return(BT_TOOHIGH);
    
			      /* Now I proceed to insert starting from the 
                               * leaf level (1)
			       */
  for(level=1; level <= Depth + 1; level++)  {

    if(level == Depth + 1 && insert_length == 0)
			      /* The tree is done and nothing more to insert */
      break;


    if(level > 1) {	      /* Now I must change the format of the record 
                               * because there are index nodes from now one 
                               * and instead data I have pointers */

      if(propag_length)	      /* Expand the propag key if it exists*/
	propag_length = (*head->KeyExpand)(& buff[14], stack[level-1].Node );

      if(insert_length)	      /* Expand the insert key if it exists*/
	insert_length = (*head->KeyExpand)(& buff_aux[14], inserted_node );
       
    }

			      /* Save the propagated record in temp because I 
                               * need to read something in buff*/
    if(propag_length)
      bcopy(& buff[14], temp_rec, propag_length);

    if(stack[level].Node == 0)  { /* Add a new root */

			      /* Allocate a node, read it in buff, set the 
                               * node descriptor; the number of records in 
                               * node is set to 0
                               */
      CHKERR(NewBTNode(mnt, head, buff, & stack[level].Node,0, 
		       0,level == 1 ? NODE_LEAF : NODE_INDEX, level));

      head->bth.bthRoot = stack[level].Node;

			      /* If the root node is not a leaf then it will 
                               * contain from the beginning the propagated 
                               * record and the inserted record */
      if(level > 1)  {
	PutWord(1 , & buff[ND_NRECS]);
			      /* Set the backpointer to the new free space */
	PutWord(14+propag_length, & buff[btnOffsetRec(1)]);
			      /* The record will be inserted before 1 */
	stack[level].Record = 1;
      } else {
			      /* Else insert it first in buffer because we 
                               * don't propagate nothing */
	stack[level].Record = 0;
      }

    } else {
			      /* Refresh the buff */
      CHKERR(BT_ReadNode(mnt, head, stack[level].Node, buff));
    }


			      /* Propagate the lower record */
    if(propag_length) {
      where_to_copy = GetWord( & buff[btnOffsetRec( stack[level].Record - 1)]);
      bcopy(temp_rec, & buff[where_to_copy], propag_length);
			      /* Don't need to work with the backpointers 
                               * because I propagate exactly in the place of 
                               * an old index record  */
    }

    if(insert_length == 0)  {  /* Nothing to insert so save the node and go 
                                * one level up  */
      CHKERR(BT_WriteNode(mnt, head, stack[level].Node, buff));
      continue;
    }

			      /* Save the record to be inserted in temp_rec 
                               * because I need to read something in 
                               * buff_aux  */
    bcopy( & buff_aux[14], temp_rec, insert_length);

			      /* Get the parameters of the node where to 
                               * insert  */
    nr_recs_l  = GetWord(& buff[ND_NRECS]); 
    p_offset_l = & buff[btnOffsetRec(nr_recs_l)];
    free_space_l = btnOffsetRec(nr_recs_l) - GetWord(p_offset_l);

    to_insert = stack[level].Record; /* The record before which to insert*/

    free_space_l -= (insert_length + 2); /* 2 is for the backpointer */

    inserted_node = 0;	      /* Maybe I don't need to allocate a node */
    already_inserted = 0;

    if(free_space_l < 0) {
			      /* Allocate a new node , read it in buff_aux 
                               * and initialize it's descriptor; set NRecs 
                               * to 0  */
       CHKERR(NewBTNode(mnt, head, buff_aux, & inserted_node, 
			GetLongWord(& buff[ND_FLINK]), 
			stack[level].Node,
			level == 1 ? NODE_LEAF : NODE_INDEX, level));
 

			      /* Decide how many records need to move from 
                               * left ro right  */
       free_space_r = BT_NODESIZE - 14 - 2;
			      /* I will try to divide the final free space 
                               * among the two records  */
       desired_space = (free_space_l + free_space_r) / 2;

			      /* Begin from the end of left */
       for(nr_recs_r = 0; free_space_l < desired_space; nr_recs_r++) {
	 
	 if(nr_recs_l - nr_recs_r == to_insert) {
	   free_space_l += insert_length + 2;
           free_space_r -= insert_length + 2;
	 }
	 else {
	   int old;
	   old = GetWord(p_offset_l);
	   p_offset_l += 2;
           move_len = old - GetWord(p_offset_l) + 2;
	   free_space_l += move_len;
           free_space_r -= move_len; 
      	 }
       }

			      /* I tried to prove mathematically that here I 
                               * will have the following conditions:  */
			      /* - free_space_l >= 0 */
			      /* - free_space_r >= 0 */
			      /*  It's true if  */
			      /*  3*rec_length < BT_NODESIZE-16*/
       if(free_space_l < 0 || free_space_r < 0 || nr_recs_r > nr_recs_l)
	 return(BT_BUG1);

			      /* Now move */
       p_offset_r = & buff_aux[btnOffsetRec(nr_recs_r)];
       where_to_copy = btnOffsetRec(nr_recs_r) - free_space_r;
 
       PutWord(where_to_copy, p_offset_r); /* Write backpointer to free space*/
       p_offset_r += 2;

       p_offset_l = & buff[btnOffsetRec(nr_recs_l)];

			      /* Move the records to buff_aux */

       for(i = 0; i < nr_recs_r; i++) {
			      /* I need to test for already_inserted because 
                               * otherwise I will loop  */
	 if(nr_recs_l == to_insert  && !already_inserted) { 
			      /* Move the inserted record */
	   where_to_copy -= insert_length;
	   bcopy(temp_rec, & buff_aux[where_to_copy], insert_length);
	   already_inserted = 1;
	 }
	 else {
	   int old;
	   old = GetWord(p_offset_l);
	   p_offset_l += 2;
           move_len = old - GetWord(p_offset_l);
	   where_to_copy -= move_len;
	   bcopy(& buff[GetWord(p_offset_l)], 
		 & buff_aux[where_to_copy],
		 move_len);
	   nr_recs_l --;      /* Decrease the number of records */
      	 }

	 PutWord(where_to_copy, p_offset_r); /* Write backpointer */
	 p_offset_r += 2;
       }

			      /* Adjust NRECS in right node */
       PutWord(nr_recs_r, & buff_aux[ND_NRECS]);
       
       PutLongWord( inserted_node, & buff[ND_FLINK]);
			      /* I'm done with the right node */
       
			      /* Save the node */
       CHKERR(BT_WriteNode(mnt,head,inserted_node,buff_aux)); 
       
     }
    

			      /* I still have to shift in left */
    if( ! already_inserted) {
      nr_recs_l ++;
			      /* Pointer to the new free space */
      p_offset_l = & buff[btnOffsetRec(nr_recs_l)];

			      /* Adjust the backpointers */
      for(i = nr_recs_l; i > to_insert; i--)  {
	PutWord( GetWord(p_offset_l + 2) + insert_length, p_offset_l);
	p_offset_l += 2;
      }
			      /* Now p_offset_l points to the offset of 
                               * to_insert. Shift to make place for new 
                               * record  */

      where_to_copy = GetWord(p_offset_l);
			      /* Get the pointer to the NEW free space */
      p_offset_l = & buff[btnOffsetRec(nr_recs_l)];

      bcopy(& buff[where_to_copy], 
	    & buff[where_to_copy + insert_length],
			      /* Substract insert_length to find the old free 
                               * space   */
	    GetWord(p_offset_l) - where_to_copy - insert_length);

			      /* Copy the new record */
      bcopy( temp_rec, & buff[where_to_copy], insert_length);
			      /* Put the backpointer */

    }


    PutWord(nr_recs_l, & buff[ND_NRECS]);

			      /* Save the left node */
    CHKERR(BT_WriteNode(mnt, head, stack[level].Node, buff));

			      /* Now prepare the new propag_length and 
                               * insert_length  */

    propag_length = GetWord(& buff[btnOffsetRec(1)]) - 14;
    if(inserted_node == 0)
      insert_length = 0;
    else
      insert_length = GetWord(& buff_aux[btnOffsetRec(1)]) - 14;

			      /* Go one level back */
  }  /* for each level in tree */

			      /* Change the depth of the tree */
  if(stack[Depth+1].Node != 0)
    head->bth.bthDepth = Depth + 1;

  head->bth.bthNRecs++;
  return 0;
}
	 




static int NewBTNode(MOUNT_RECORD *mnt,
		 BT_HEADER    *head,
		 BYTE  *buff,
		 LONGWORD  *inserted_node,    
		 LONGWORD  flink,
		 LONGWORD  blink,
		 BYTE type,
		 BYTE level)    {
  int err;

  CHKERR(BT_BitMapAllocNode(mnt, head, inserted_node, buff));

			      /* Before reading the node I must set the 
                               * BLink of the following node  */
  if(flink != 0)   {
			      /* Read in the node */
    CHKERR(BT_ReadNode(mnt, head, flink, buff));
    
    PutLongWord(*inserted_node, & buff[ND_BLINK]);
			      /* Write the node  */

    CHKERR(BT_WriteNode(mnt, head, flink, buff));
  }

			      /* Read in the allocated node */
  CHKERR(BT_ReadNode(mnt, head, *inserted_node, buff));

			      /* Initialize the Node Descriptor */
			      /* for the new node*/
  PutLongWord(flink, & buff[ND_FLINK]);
  PutLongWord(blink, & buff[ND_BLINK]);
  PutByte( level, & buff[ND_HEIGHT]);
  PutByte( type, & buff[ND_TYPE]);
  PutWord( 0, & buff[ND_NRECS]); 
  PutWord( 0 , & buff[ND_NRECS+2]);	/* Zero Resv2 */

  PutWord(14, & buff[btnOffsetRec(0)]); /* Backpointer */

					/* Adjust the first and the last leaves */
  if(level == 1) {
    if(flink == 0)
      head->bth.bthLNode = *inserted_node;
    if(blink == 0)
      head->bth.bthFNode = *inserted_node;
  } 

  return 0;
}

			      /* Extends the BTree with at least min_nodes */
static  int  ExtendBTree(MOUNT_RECORD *mnt,
			 BT_HEADER    *head,
			 LONGWORD     min_nodes,
			 BYTE * buffer)   {


  int err;
  EXTENT_DESCRIPTOR ext_desc, *vib_ext_rec;
  LONGWORD chunk;
  EXTENT_RECORD     ext_rec;
  LONGWORD found_id,min_chunk;
  LONGWORD *p_file_len;
  WORD first_block, found_block;
  int found_df, nodes, i;
  
			      /* By now we can extend only the Catalog tree; 
                               * for this I must figure out which BTree I am 
                               * */
  if(head->BTfileid != CATALOG_FILE_ID) 
    return(BT_UNIMPLEMENTED);

			      /* Look in the volume info for the size of the 
                               * chunk to allocate */
  chunk = head->ClpSiz;
  min_chunk = min_nodes * BT_NODESIZE;
  
			      /* More than that if I need */
  if(chunk < min_chunk)
    chunk = min_chunk;

			      /* Convert the chunk to allocation blocks */
  chunk = chunk / mnt->vib.AlBlkSiz;

			      /* Ask for the chunk */
  CHKERR(alloccontiguousspace(mnt, chunk, &ext_desc));

			      /* If I don't get it all see if big enough */
  chunk = ext_desc.length * mnt->vib.AlBlkSiz;
  
  if(chunk < min_chunk)  {
			      /* Give back the space and exit*/
    freecontiguousspace(mnt, &ext_desc);
    return(BT_NOTALLOC);
  }
  
  
			   
			      /* Compute the number of nodes */
  nodes = chunk / BT_NODESIZE;

  
			      /* Extend the extents tree for this tree */
  vib_ext_rec  = head->BTfileid == CATALOG_FILE_ID ?
    mnt->vib.CTExtRec : mnt->vib.XTExtRec;
  p_file_len = head->BTfileid == CATALOG_FILE_ID ?
    &mnt->vib.CTFlSize : &mnt->vib.XTFlSize;

			      /* Get the logical block number for this new 
                               * extent  */
  first_block =  *p_file_len / mnt->vib.AlBlkSiz;
  
			      /* The size of the BTree file */
  *p_file_len += chunk;
			      /* First look if all 3 slots in the vib are 
                               * full  */
  for(i=0;i<3;i++)
    if( vib_ext_rec[i].length == 0)
      break;

			      /* If something free put there */
  if(i<3)   {

    bcopy(&ext_desc, & vib_ext_rec[i], sizeof(EXTENT_DESCRIPTOR));

			      /* Adjust the caches because the first three 
                               * extents are always residents in the cache */
    bcopy(vib_ext_rec, & head->cache[0].ext, sizeof(EXTENT_RECORD));
 
    head->cache[0].length += ext_desc.length;

  } else {		      /* I need to adjust the extent record in the 
                               * extents tree */

			      /* Search for the last extent record for this 
                               * file  */
    err = GetExtentRecord(mnt, head->BTfileid,1,
			   first_block - 1, ext_rec,
			   &found_id,
			   &found_df,
			   &found_block);
    
    if(err && err != BT_FOUNDLESS && err != BT_NOTFOUND)
      return err;

			      /* If it was not found (this is the fourth 
                               * extent for the file) or if the found extent 
                               * record is full */
    for(i=0;i<3;i++)
      if(ext_rec[i].length == 0)
	break;

    if(err == BT_NOTFOUND || i == 3)  {
			      /* Fill with zero the ext_rec */
      bzero(ext_rec, sizeof(EXTENT_RECORD));
			      /* Copy at the beginning the ext_desc */
      bcopy(&ext_desc, ext_rec, sizeof(EXTENT_DESCRIPTOR));


    } else {
			      /* Patch the found extent record */
      bcopy(& ext_desc, & ext_rec[i], sizeof(EXTENT_DESCRIPTOR));

      first_block = found_block;
    }

			      /* And write it back */
    CHKERR(PutExtentRecord(mnt, head->BTfileid, 1, first_block, ext_rec));


			      /* Look in the cache if we have this entry */
    for(i=0;  i < head->cache_size; i++)  {
      if(first_block == head->cache[i].block) {
			      /* Copy there the new extent */
	bcopy(ext_rec, head->cache[i].ext, sizeof(EXTENT_RECORD));
			      /* Adjust the length */
	head->cache[i].length += nodes;

	break;
      }
    }
  }			      /* End with adjusting the Btree extents file */
  

			      /* Number of free nodes. Do it before 
                               * BitMapExtend  */
  head->bth.bthFree += nodes;
  
  CHKERR(BT_BitMapExtend(mnt, head, nodes, buffer));

  			      /* Adjust the number of nodes in the tree. do 
                               * it after BitMapExtend because it assumes 
                               * that nr_nodes is the old one  */
  head->bth.bthNNodes += nodes;

  return 0;

}






