#include "../defs.h"
#include "../errors.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "../btree/btree.h"
#include "../LibFuncs/catalog.h"
#include "../DevSupport/readwrite.h"
#include "../Volume/volbmap.h"
#include "../Times/mac_time.h"
#include "macreadwrite.h"
#include "macreadwrite_local.h"
#include <stdio.h>
#include <stdlib.h>

#define NODEBUG


#ifdef USER
int macseek(MFILE *mfile, SIGNEDLONGWORD offset, int whence) 
{
  lockcatrec(mfile->cr);
  switch (whence) {
  case SEEKFROMBEGINING:
    mfile->offset=(unsigned)offset;
    break;
  case SEEKFROMEND:
    mfile->offset=mfile->cr->U.cdrFilRec.filLgLen-(unsigned)offset;
    break;
  case SEEKFROMCURPOS:
    mfile->offset=(unsigned)((signed)mfile->offset+offset);
    break;
  default:
    unlockcatrec(mfile->cr);
    return BADWHENCE;
  }
  unlockcatrec(mfile->cr);
  return 0;
}
#endif

int generateedlist(MOUNT_RECORD *mr,
		   CATALOG_RECORD *cr,
		   LONGWORD sb,
		   LONGWORD sl,
		   ED **edlist)
{
  WORD i, allocblockstart, allocblocklen, cured;
  int founddf; 
  EXTENT_RECORD er;
  ED *el, *tmp;
  int rc;
  LONGWORD foundid;
  WORD fb;
  LONGWORD osl;

  

  if ((cr->U.cdrFilRec.filPyLen==0)
      ||(sb>(cr->U.cdrFilRec.filPyLen/mr->vib.AlBlkSiz)))
    return 0;

  cured=0;

  if ((el=(ED*)malloc(sizeof(ED)*EDALLOCUNITS))==NULL)
    return GENEDLISTOUTOFMEM;

  osl=sl; /* Used to check against rollover */

/* First check the ExtRec in the Catalog Structure */

  memcpy(er,cr->U.cdrFilRec.filExtRec,sizeof(EXTENT_RECORD));

  fb=0;

  do {
    i=0;

    
/* Check out Extent Descriptor */

    while (sl!=0 && i<3) {

/* See if this block contains part of what we're interested in... */

      if ((fb+er[i].length-1)>=sb) {

/* If so, add an extent descriptor to the edlist */

	allocblockstart=er[i].first+(sb-fb);
	allocblocklen=er[i].first+(er[i].length-allocblockstart);
	if (allocblocklen>sl) 
	  allocblocklen=sl;

	if (!(cured%EDALLOCUNITS)&&(cured!=0)) {
	  if ((tmp=(ED *)realloc(el, (cured+EDALLOCUNITS)*sizeof(ED)))==NULL) {
	    free(el);
	    return GENEDLISTOUTOFMEM;
	  } else {
	    el=tmp;
	  }
	}

	el[cured].start=allocblockstart;
	el[cured].length=allocblocklen;
	++cured;

#ifdef DEBUG
	printf("knited %d(%d) from ed %d\n", allocblockstart, allocblocklen, i);
#endif


/* Update found block and search block to reflect the next ed */

	fb=fb+er[i].length;
	sb=sb+allocblocklen;
	sl-=allocblocklen;
#ifdef DEBUG
	printf("fb=%d, sb=%d, sl=%d\n", fb, sb, sl);
#endif

/* if search length (sl) wrapped around, something very strange happened... */
	
	if (sl>osl) {
#ifdef DEBUG
	  printf("FAILURE: sl negative sl=%d\n", sl);
#endif
	  free(el);
	  return GENEDLISTINTERNALERR;
	}

      } else {

/* If not on current extend descripter, increment fb and go to the next on */
#ifdef DEBUG
	printf("Not on ed %d\n", i);
#endif
	fb=fb+er[i].length;
      }
      ++i;
    }

/* if we ran of end of er but still have some sl left, get a new er */

    
    if (sl!=0) {
#ifdef DEBUG
      printf("Requesting Another Extent Record sb=%ld\n", (long)sb);
#endif
      rc=GetExtentRecord(mr, 
			 cr->U.cdrFilRec.filFlNum,
			 1,
			 sb,
			 er,
			 &foundid,
			 &founddf,
			 &fb);
      if ((foundid!=cr->U.cdrFilRec.filFlNum)||(!founddf)) {
	free(el);
#ifdef DEBUG
	printf("Bad Return from GetExtentRecord - expect fid=%d, got"
	       " %d, expected df=%d, got df=%d\n", cr->U.cdrFilRec.filFlNum,
	       foundid, 1, founddf);
#endif
	return GENEDLISTBLOCKNOTFOUND;
      }
#ifdef DEBUG
      printf("Valid Extent Record!\n");
#endif

    }
  } while (sl!=0);
   
  *edlist=el;

  return cured;
}
		       

int getcompleteedlist(MOUNT_RECORD *mr,
		      CATALOG_RECORD *cr,
		      EXTENT_DESCRIPTOR **edlist)
{
  int numeds;

#ifdef USER
  lockcatrec(cr);
#endif

  numeds=generateedlist(mr, 
			cr, 
			0, 
			cr->U.cdrFilRec.filPyLen/mr->vib.AlBlkSiz, 
			(ED **) edlist);
#ifdef USER
  unlockcatrec(cr);
#endif

  return numeds;

}
  
			  
int macreadblocks(MOUNT_RECORD *mr,
		  CATALOG_RECORD *cr,
		  LONGWORD start,
		  LONGWORD numblocks,
		  BYTE *buf,
		  LONGWORD *blocksactuallyread)
{
  ED *edlist;
  WORD startblock, length;
  LONGWORD startsect, numsects, nextbufoffset, blocksread;
  int numeds, cured;

  blocksread=0;

  if ((numeds=generateedlist(mr,
			 cr,
			 start,
			 numblocks,
			 &edlist))<0) {
    return numeds;
  }

  nextbufoffset=0;

  cured=0;

  while (cured<numeds) {
    startblock=edlist[cured].start;
    length=edlist[cured].length;


#ifdef DEBUG
    printf("Looking at start=%d, len=%d\n", startblock, length);
#endif

    startsect=mr->vib.AlBlSt+(mr->vib.AlBlkSiz/mr->sr.sectsize)*startblock;


/*    startsect=(mr->vib.VBMSt+mr->vib.NmAlBlks/8/mr->sr.sectsize)+

 That's the starting sector of the allocation area of the disk 
	     startblock*(mr->vib.AlBlkSiz/mr->sr.sectsize)+1;
 That's the sector desired 
*/

    numsects=length*(mr->vib.AlBlkSiz/mr->sr.sectsize);

    if (readsects(mr,startsect,numsects,
		  (char *) &(buf[nextbufoffset]))!=numsects) {
      free(edlist);
      return CANTREADALLOCBLOCK;
    }

    nextbufoffset+=numsects*mr->sr.sectsize;

    blocksread+=length;

    if (blocksread>numblocks) {
      free(edlist);
      return MACREADOUTOFBOUNDS;
    }

    ++cured;
  }

  free(edlist);

  *blocksactuallyread=blocksread;

  return 0;
}

   



int mread(MOUNT_RECORD *mr,
	  CATALOG_RECORD *cr, 
	  LONGWORD start, 
	  LONGWORD numbytes,
	  BYTE *buf,
	  LONGWORD *bytesactuallyread)
{
  LONGWORD startblock, endblock, numblocks, partialblock, partlen, actual;
  LONGWORD byteshandled;
  int rc;
  BYTE *localbuf, *bufptr;


  if (start+1>(cr->U.cdrFilRec.filLgLen)) {
    *bytesactuallyread=0;
    return 0;
  }

  if ((start+numbytes-1)>(cr->U.cdrFilRec.filLgLen-1))
    numbytes=cr->U.cdrFilRec.filLgLen-start;

  if ((localbuf=(BYTE *)malloc(mr->vib.AlBlkSiz))==NULL)
    return MACWRITEOUTOFMEM;

  byteshandled=0;

  startblock=start/mr->vib.AlBlkSiz;

  endblock=(start+numbytes-1)/mr->vib.AlBlkSiz;

  numblocks=endblock-startblock+1;

  partialblock=start%mr->vib.AlBlkSiz;

  bufptr=buf;


/* Is the first block a partial block? */

#ifdef DEBUG
  printf("Read Begins First Block: partialblock=%lu\n", (unsigned long)partialblock);
#endif

  if (partialblock) {
    if ((rc=macreadblocks(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }

    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTREAD;
    }

    partlen=mr->vib.AlBlkSiz-partialblock;

    if (partlen>numbytes)
      partlen=numbytes;


    memcpy(bufptr,&(localbuf[partialblock]),partlen);

    ++startblock; --numblocks;
    byteshandled+=partlen;
    bufptr+=partlen;
  }

  if (numblocks==0) {
    *bytesactuallyread=byteshandled;
    free(localbuf);
    return 0;
  }

/* If any middle blocks, handle them */

#ifdef DEBUG
  printf("Middle blocks: numblocks=%lu\n", (unsigned long)numblocks);
#endif

  if (numblocks>1) {
    if ((rc=macreadblocks(mr, cr, startblock, numblocks-1, bufptr, &actual))){
      free(localbuf);
      return rc;
    }
    if (actual!=(numblocks-1)) {
      free(localbuf);
      return MACREADCANTREAD;
    }
    
    startblock+=actual;
    byteshandled+=mr->vib.AlBlkSiz*actual;
    numblocks-=actual;
    bufptr+=mr->vib.AlBlkSiz*actual;
  }

  partialblock=(numbytes-byteshandled);

/* If last block is a partial block handle it specially */

#ifdef DEBUG
  printf("Last Block: partialblock=%lu\n", (unsigned long)partialblock);
#endif

  if (!partialblock) {
    if ((rc=macreadblocks(mr,cr,startblock,1,bufptr,&actual))) {
      free(localbuf);
      return rc;
    }
    
    if (actual!=1) {
      free(localbuf);
      return MACREADCANTREAD;
    }

    byteshandled+=mr->vib.AlBlkSiz;

  } else {
    if ((rc=macreadblocks(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }
    if (actual!=1) {
      free(localbuf);
      return MACREADCANTREAD;
    }
    
    memcpy(bufptr, localbuf, partialblock);
    
    byteshandled+=partialblock;
  }

  free(localbuf);

  *bytesactuallyread=byteshandled;

#ifdef DEBUG
  printf("End of Read: byteshandled=%lu, numbytes=%lu\n", 
	 (unsigned long)byteshandled, (unsigned long)numbytes);
#endif

  return 0;
		

}

#ifdef USER
int macread(MFILE *mfile,
	    LONGWORD numbytes,
	    BYTE *buf,
	    LONGWORD *bytesactuallyread)
{
  int rc;

  if (!isreadable(mfile) || mfile->valid!=VALIDVAL)
    return FILEISNOTREADABLE;

  lockcatrec(mfile->cr);

  if (mfile->cr->status) {
    unlockcatrec(mfile->cr);
    return FILEISGONE;
  }

  rc=mread(mfile->mr,
	   mfile->cr,
	   mfile->offset,
	   numbytes,
	   buf,
	   bytesactuallyread);

  unlockcatrec(mfile->cr);
  
  if (rc) 
    return rc;

  mfile->offset+=*bytesactuallyread;

  return 0;

}

#endif


int macwriteblocks(MOUNT_RECORD *mr,
		   CATALOG_RECORD *cr,
		   LONGWORD start,
		   LONGWORD numblocks,
		   BYTE *buf,
		   LONGWORD *blocksactuallywritten)
{
  ED *edlist;
  WORD startblock, length;
  LONGWORD startsect, numsects, nextbufoffset, blockswritten;
  int numeds, cured;

  blockswritten=0;

  if ((numeds=generateedlist(mr,
			     cr,
			     start,
			     numblocks,
			     &edlist))<0) {
    return numeds;
  }

  nextbufoffset=0;

  cured=0;

  while (cured<numeds) {
    startblock=edlist[cured].start;
    length=edlist[cured].length;


#ifdef DEBUG
    printf("Looking at start=%d, len=%d\n", startblock, length);
#endif

    startsect=mr->vib.AlBlSt+(mr->vib.AlBlkSiz/mr->sr.sectsize)*startblock;

/*
    startsect=(mr->vib.VBMSt+mr->vib.NmAlBlks/8/mr->sr.sectsize)+
 That's the starting sector of the allocation area of the disk 
	     startblock*(mr->vib.AlBlkSiz/mr->sr.sectsize)+1;
 That's the sector desired 
*/

    numsects=length*(mr->vib.AlBlkSiz/mr->sr.sectsize);

    if (writesects(mr,(SECTNUMTYPE)startsect,numsects,
		   (char *) &(buf[nextbufoffset]))!=numsects) {
      free(edlist);
      return CANTREADALLOCBLOCK;
    }

    nextbufoffset+=numsects*mr->sr.sectsize;

    blockswritten+=length;

    if (blockswritten>numblocks) {
      free(edlist);
      return MACREADOUTOFBOUNDS;
    }

    ++cured;
  }

  free(edlist);

  *blocksactuallywritten=blockswritten;

  return 0;
}

    
  
int mwrite(MOUNT_RECORD *mr,
	   CATALOG_RECORD *cr,
	   LONGWORD start,
	   LONGWORD numbytes,
	   BYTE *buf,
	   LONGWORD *bytesactuallywritten)
{
  LONGWORD startblock, endblock, numblocks, partialblock, partlen, actual;
  LONGWORD byteshandled;
  int rc;
  BYTE *localbuf, *bufptr;

  if (start+numbytes > cr->U.cdrFilRec.filPyLen )
    if ((rc=mgrowfile(mr, 
		      cr, 
		      (WORD) (  
		      (start+numbytes-1l)/mr->vib.AlBlkSiz +
                      ((start+numbytes-1l)%mr->vib.AlBlkSiz ? 1l: 0l) 
			      )  )))
      return rc;

  if ((localbuf=(BYTE *)malloc(mr->vib.AlBlkSiz))==NULL)
    return MACWRITEOUTOFMEM;

  byteshandled=0;

  startblock=start/mr->vib.AlBlkSiz;

  endblock=(start+numbytes-1)/mr->vib.AlBlkSiz;

/*
  endblock=((start+numbytes-1)/mr->vib.AlBlkSiz - 1) +
           ((start+numbytes-1)%mr->vib.AlBlkSiz ? 1: 0);
*/
  numblocks=endblock-startblock+1;

  partialblock=start%mr->vib.AlBlkSiz;

  bufptr=buf;


/* Is the first block a partial block? */

#ifdef DEBUG
  printf("Write Begins First Block: partialblock=%lu\n", (unsigned long)partialblock);
#endif

  if (partialblock) {
    if ((rc=macreadblocks(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }

    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTREAD;
    }

    partlen=mr->vib.AlBlkSiz-partialblock;

    if (partlen>numbytes)
      partlen=numbytes;


    memcpy(&(localbuf[partialblock]),bufptr,partlen);

    if ((rc=macwriteblocks(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }

    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTWRITE;
    }

    ++startblock; --numblocks;
    byteshandled+=partlen;
    bufptr+=partlen;
  }

  if ((start+byteshandled)>cr->U.cdrFilRec.filLgLen)
    cr->U.cdrFilRec.filLgLen=start+byteshandled;


  if (numblocks==0) {
    *bytesactuallywritten=byteshandled;
    free(localbuf);
    cr->U.cdrFilRec.filMdDat=now();
    return 0;
  }

/* If any middle blocks, handle them */

#ifdef DEBUG
  printf("Middle blocks: numblocks=%lu\n", (unsigned long)numblocks);
#endif

  if (numblocks>1) {
    if ((rc=macwriteblocks(mr, cr, startblock, numblocks-1, bufptr, &actual))){
      free(localbuf);
      return rc;
    }
    if (actual!=(numblocks-1)) {
      free(localbuf);
      return MACWRITECANTWRITE;
    }
    
    startblock+=actual;
    byteshandled+=mr->vib.AlBlkSiz*actual;
    numblocks-=actual;
    bufptr+=mr->vib.AlBlkSiz*actual;
  }

  if ((start+byteshandled)>cr->U.cdrFilRec.filLgLen)
    cr->U.cdrFilRec.filLgLen=start+byteshandled;


  partialblock=(numbytes-byteshandled);

/* If last block is a partial block handle it specially */

#ifdef DEBUG
  printf("Last Block: partialblock=%lu\n", (unsigned long)partialblock);
#endif

  if (!partialblock) {
    if ((rc=macwriteblocks(mr,cr,startblock,1,bufptr,&actual))) {
      free(localbuf);
      return rc;
    }
    
    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTWRITE;
    }
    
    byteshandled+=mr->vib.AlBlkSiz;
  } else {
    if ((rc=macreadblocks(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }
    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTREAD;
    }
    
    memcpy(localbuf, bufptr, partialblock);
    
    if ((rc=macwriteblocks(mr, cr, startblock, 1, localbuf, &actual))) {
      free(localbuf);
      return rc;
    }
    if (actual!=1) {
      free(localbuf);
      return MACWRITECANTWRITE;
    }
    
    byteshandled+=partialblock;
  }
  
  if ((start+byteshandled)>cr->U.cdrFilRec.filLgLen)
    cr->U.cdrFilRec.filLgLen=start+byteshandled;


  free(localbuf);

  *bytesactuallywritten=byteshandled;

#ifdef DEBUG
  printf("End of Write: byteshandled=%lu, numbytes=%lu\n", 
	 (unsigned long)byteshandled, (unsigned long)numbytes);
#endif
  
  cr->U.cdrFilRec.filMdDat=now();

  return 0;
		
}		

		
#ifdef USER
   
int macwrite(MFILE *mfile,
	     LONGWORD numbytes,
	     BYTE *buf,
	     LONGWORD *bytesactuallywritten)
{
  int rc;

  if (!iswriteable(mfile) || mfile->valid!=VALIDVAL)
    return FILEISNOTWRITABLE;

  lockcatrec(mfile->cr);

  if (mfile->cr->status) {
    unlockcatrec(mfile->cr);
    return FILEISGONE;
  }

  rc=mwrite(mfile->mr,
	    mfile->cr,
	    mfile->offset,
	    numbytes,
	    buf,
	    bytesactuallywritten);

  unlockcatrec(mfile->cr);

  if (rc)
    return rc;

  mfile->offset+=*bytesactuallywritten;

  return 0;

}

#endif



    
    


int mgrowfile(MOUNT_RECORD *mr,
	      CATALOG_RECORD *cr,
	      WORD newnumblocks)
{
  int rc;
  WORD numblocks, blocksize, lastlogblock, blocksfound, nextblockstart,
       erblockstart, foundlogblock, firstlbofnewspace;
  LONGWORD foundid, bf;
  EXTENT_DESCRIPTOR *edlist;
  EXTENT_RECORD er;
  int numeds, cured, fail, modifiedcr, i, founddf;
  CATALOG_RECORD oldcr;

  blocksize=mr->vib.AlBlkSiz;
  numblocks=cr->U.cdrFilRec.filPyLen/blocksize;
  firstlbofnewspace=numblocks;

  if (newnumblocks<=numblocks)
    return MGROWDOESNTTRUNC;


  lastlogblock=numblocks-1;

/* Allocate the number of Blocks Needed */

  if ((numeds=allocspaceonbmap(mr,
			       newnumblocks-numblocks,
			       &edlist,
			       &bf))<0)
    return numeds;

  blocksfound=(WORD)bf;

  if ((blocksfound!=(newnumblocks-numblocks))) {
    freespaceonbmap(mr,edlist, numeds);
    free(edlist);
    return MGROWNOTENOUGHSPACE;
  }


  memcpy(&oldcr,cr, sizeof(CATALOG_RECORD));

/* Check on the catalog extent record */ 

  cured=0;
  nextblockstart=0;
  fail=0;
  modifiedcr=0;

  for (i=0;i<3 && cured<numeds;i++) {
    if ((cr->U.cdrFilRec.filExtRec[i].first+
	cr->U.cdrFilRec.filExtRec[i].length)==edlist[cured].first) {
      cr->U.cdrFilRec.filExtRec[i].length+=edlist[cured].length;
      ++cured;
      modifiedcr=1;
    } else {
      if (cr->U.cdrFilRec.filExtRec[i].length==0) {
	cr->U.cdrFilRec.filExtRec[i].first=edlist[cured].first;
	cr->U.cdrFilRec.filExtRec[i].length=edlist[cured].length;
	++cured;
	modifiedcr=1;
      }
    }
    nextblockstart+=cr->U.cdrFilRec.filExtRec[i].length;
  }

  

/* if we modified the cr and still have more to do, we just allocate
   extent records and fill them until we're done.

   Also, if we didn't modify the CR, but it contains all the blocks 
   for the current length of the file, we do the same
*/
  if ((modifiedcr && cured<numeds) ||
      (!modifiedcr && cured<numeds && nextblockstart==firstlbofnewspace)) {
    while (cured<numeds) {
      erblockstart=nextblockstart;
      for (i=0;i<3;i++) {
	if (cured<numeds) {
	  er[i].first=edlist[cured].first;
	  er[i].length=edlist[cured].length;
	  ++cured;
	  nextblockstart+=er[i].length;
	} else {
	  er[i].first=er[i].length=0;
	}
      }
      if ((rc=PutExtentRecord(mr,
			      cr->U.cdrFilRec.filFlNum,
			      1,
			      erblockstart,
			      er))) {
	freespace(mr,cr->U.cdrFilRec.filFlNum,edlist,numeds,
		  firstlbofnewspace, 1);
	free(edlist);
	memcpy(cr,&oldcr,sizeof(CATALOG_RECORD));
	return rc;
      }
    }
  }

/* If we didn't modify the CR, then we need to request the er which has
   the last logical block of the file on it.
*/

  if (!modifiedcr && cured<numeds) {
    rc=GetExtentRecord(mr,
		       cr->U.cdrFilRec.filFlNum,
		       1,
		       lastlogblock,
		       er,
		       &foundid,
		       &founddf,
		       &foundlogblock);

    if (rc && rc!=BT_FOUNDLESS && rc!=BT_NOTFOUND) {
      freespace(mr,cr->U.cdrFilRec.filFlNum,edlist,numeds,
		firstlbofnewspace, 1);
      free(edlist);
      return rc;
    }

    if (rc==BT_NOTFOUND) {
      for (i=0;i<3;i++)
	er[i].first=er[i].length=0;
      foundlogblock=lastlogblock+1;
    } else {
      if (foundid!=cr->U.cdrFilRec.filFlNum || !founddf) {
	freespace(mr,cr->U.cdrFilRec.filFlNum,edlist,numeds,
		  firstlbofnewspace, 1);
	free(edlist);
	return rc;
      }
    }

/* Now fill any empty EDs on this ER */

    nextblockstart=foundlogblock;
    
    for (i=0; i<3; i++) {
      if ((er[i].length!=0) && (cured<numeds) && 
	  ((er[i].first+er[i].length)==edlist[cured].first)) {
	er[i].length+=edlist[cured].length;
	++cured;
      } else {
	if ((er[i].length==0)&&(cured<numeds)) {
	  er[i].first=edlist[cured].first;
	  er[i].length=edlist[cured].length;
	  ++cured;
	}
      }
      nextblockstart+=er[i].length;
    }

    if ((rc=PutExtentRecord(mr,
			    cr->U.cdrFilRec.filFlNum,
			    1,
			    foundlogblock,
			    er))) {
      freespace(mr,cr->U.cdrFilRec.filFlNum,edlist,numeds,
		firstlbofnewspace, 1);
      free(edlist);
      return MGROWCANTWRITELASTER;
    }

/* Now if there are any EDs left, just start writing new ERs */

    while (cured<numeds) {
      erblockstart=nextblockstart;
      for (i=0;i<3;i++) {
	if (cured<numeds) {
	  er[i].first=edlist[cured].first;
	  er[i].length=edlist[cured].length;
	  ++cured;
	  nextblockstart+=er[i].length;
	} else {
	  er[i].first=er[i].length=0;
	}
      }
      if ((rc=PutExtentRecord(mr,
			      cr->U.cdrFilRec.filFlNum,
			      1,
			      erblockstart,
			      er))) {
	freespace(mr,cr->U.cdrFilRec.filFlNum,edlist,numeds,
		  firstlbofnewspace, 1);
	free(edlist);
	return rc;
      }
    }
  }

  if ((nextblockstart)!=newnumblocks) {
    freespace(mr,cr->U.cdrFilRec.filFlNum,edlist,numeds,
	      firstlbofnewspace, 1);
    free(edlist);
    memcpy(cr,&oldcr,sizeof(CATALOG_RECORD));
    return MGROWGREWTOWRONGSIZE;
  }

  cr->U.cdrFilRec.filPyLen=nextblockstart*mr->vib.AlBlkSiz;
  
  free(edlist);

  return 0;
  
}

    
int mtruncatefile(MOUNT_RECORD *mr,
		  CATALOG_RECORD *cr,
		  LONGWORD newsize)
{
  int rc, numeds;
  EXTENT_DESCRIPTOR *edlist;

  if (newsize!=0) 
    return TRUNCTONONZEROSIZE;

  if (cr->cdrType!=CDR_FILE)
    return CANONLYTRUNCFILES;

  if ((numeds=getcompleteedlist(mr, cr, &edlist))<0)
    return numeds;

  if (numeds>0) {
    if ((rc=freespace(mr,
		      cr->U.cdrFilRec.filFlNum,
		      edlist,
		      numeds,
		      0,
		      0))) {
      free(edlist);
      return rc;
    }
  }

  cr->U.cdrFilRec.filLgLen=0;
  cr->U.cdrFilRec.filPyLen=0;
  cr->U.cdrFilRec.filMdDat=now();

  return 0;
}





