/* apifunc.c
   The API functions thread.
*/

#define INCL_BASE
#define INCL_DOSSEMAPHORES
#define INCL_DOSNMPIPES
#define INCL_NOPMAPI
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "hfsapi.h"
#include "mountstatus.h"
#include "fsd.h"
#include "../r0r3shar.h"
#include "apifunc.h"
#include "fsctl.h"

#include "macfs/DevSupport/readwrite.h"

/* The name of the control pipe */
char control_pipe_name[] = "\\PIPE\\HFS_CONTROLPIPE";

void api_thread(void *arg)
{
  HPIPE PipeHandle;
  ULONG ulBytes;
  CHAR message[256];
  APIRET rc;
 
#ifdef DEBUG
  printf("API server thread running\n");
#endif

  /* Create the control pipe */
  rc = DosCreateNPipe(control_pipe_name, &PipeHandle, NP_ACCESS_DUPLEX,
		      NP_WAIT | NP_TYPE_MESSAGE | NP_READMODE_MESSAGE | 
		      0x01, 
		      sizeof(message), sizeof(message), 0L);
  if (rc != NO_ERROR) {
#ifdef DEBUG
    printf("Cannot create control pipe!\n");
#endif
    _endthread();
  }

  for(;;) {
    /* Wait for an incoming connection */
    rc = DosConnectNPipe(PipeHandle);
    if (rc != NO_ERROR) {
      printf("DosConnectNPipe returned error %lu\n",rc);
      _endthread();
    }
 
#ifdef DEBUG
    printf("Control pipe connected\n");
#endif
    rc = DosRead(PipeHandle, message, sizeof(message), &ulBytes);
    if (rc != NO_ERROR) {
#ifdef DEBUG
      printf("Control pipe: DosRead error: return code = %lu\n", rc);
#endif
      _endthread();
    }
 
    switch(*(unsigned short *)message) {
    case API_SYNC: {
      /* Sync command */

      PAPI_CMD_SYNC msg = (PAPI_CMD_SYNC)message;
      unsigned short res;
      ULONG parm_len;
      union {
	unsigned short hVPB;
	unsigned short drive;
      } param;

      /* Check if it's an HFS drive */
      param.drive = msg->drive;
      rc=do_FSCtl(NULL, 0, NULL, &param, sizeof(param), &parm_len,
		  FSCTL_FUNC_GET_HVPB_FROM_DRV);
#ifdef DEBUG
      printf("FSCTL_FUNC_GET_HVPB_FROM_DRV returned rc = %lu, hVPB = %hu\n", rc, param.hVPB);
#endif
      if(rc==NO_ERROR) {
	VOLPARMSTRUC vp;
	ULONG data_len, parm_len;

	/* Get the volume parameters */
	rc=do_FSCtl(&vp, sizeof(vp), &data_len, 
		    &param.hVPB, sizeof(unsigned short), &parm_len,
		    FSCTL_FUNC_GETVOLPARM);
	if(rc==NO_ERROR) {
          if(syncmountrecord(vp.vpfsd.mr))
            res=API_RES_UNKNOWN_ERROR;
          else
            res=API_RES_NO_ERROR;
	  
	  /* Save the volume parameters */
	  rc=do_FSCtl(&vp, sizeof(vp), &data_len,
		      &param.hVPB, sizeof(unsigned short), &parm_len,
		      FSCTL_FUNC_SETVOLPARM);
	  if(rc!=NO_ERROR) {
#ifdef DEBUG
	    printf("API thread: FSCTL_FUNC_SETVOLPARM failed, rc = %lu\n", rc);
#endif
	    res=API_RES_UNKNOWN_ERROR;
	  }
	}
	else {
#ifdef DEBUG
	  printf("API thread: FSCTL_FUNC_GETVOLPARM failed, rc = %lu\n", rc);
#endif
	  res=API_RES_UNKNOWN_ERROR;
	}
      }
      else
	res=API_RES_NOT_HFS;
      DosWrite(PipeHandle, &res, sizeof(res), &ulBytes);
      break;
    }

    default:
#ifdef DEBUG
      printf("Control pipe received unknown command!\n");
#endif
      _endthread();
    }

    /* Wait until the client has read all the data */
    DosResetBuffer(PipeHandle);

    /* Disconnect pipe */
    DosDisConnectNPipe(PipeHandle);
  }
}
