int alloccontiguousspace(MOUNT_RECORD *mr,
			 LONGWORD numblocks,
			 EXTENT_DESCRIPTOR *ed);
/* Tries to find numblocks contiguous allocation units and fills an
   EXTENT_DESCRIPTOR with the best match.  A nonzero return is an
   error, and it is advisable to check the length field of the
   extent descriptor to be sure you got all you wanted.  If there
   is insufficient contiguous space to meet your request, the function
   will give back the largest contiguous space it could find.
*/

int freecontiguousspace(MOUNT_RECORD *mr,
			EXTENT_DESCRIPTOR *ed);
/* Frees the blocks described by ed.  nonzero return on failure. 
*/

int allocspaceonbmap(MOUNT_RECORD *mr, 
	       LONGWORD numblocks, 
	       EXTENT_DESCRIPTOR **edlist,
	       LONGWORD *numblocksactuallyfound);
/* Tries to allocate numblocks of space, building an extent descriptor
   list.  A less than zero return indicates an error.  A positive return
   is the number of extent descriptors on edlist.  If not enough space
   could be found, allocspace will allocate as much as possible and 
   return that amount in numblocksactuallyfound.
*/



int freespace(MOUNT_RECORD *mr,
	      LONGWORD fid,
	      EXTENT_DESCRIPTOR *edlist,
	      int numeds,
	      WORD startblock,
	      int failrecoverymode);


int freespaceonbmap(MOUNT_RECORD *mr, 
		    EXTENT_DESCRIPTOR *edlist, 
		    int numeds);
/* Tries to deallocate the extents described by edlist.  Nonzero return
   indicates an error (shouldn't happen.)  A nonzero return is the 
   fail code of the *first* call to freecontiguousspace that fails.
*/


int readvolbmap(MOUNT_RECORD *mr);
/* Brings volume bitmap into memory
*/

int writevolbmap(MOUNT_RECORD *mr);
/* Flushes volume bitmap to disk
*/

int checkvbmap(MOUNT_RECORD *mr);
/* returns nonzero if free space on VBM disagrees with VIB.
*/


int printvolbmap(MOUNT_RECORD *mr);

  




