//
// $Header: D:/ext2-os2/minifsd/ext2/RCS/super.c,v 1.1 1996/05/27 23:51:00 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifdef OS2
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>
#include <os2/types.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <string.h>
#include <linux/sched.h>
#include <linux/locks.h>
#include <os2/log.h>
#endif

#ifdef OS2
#define NORET_TYPE
#define KERN_CRIT
#define KERN_WARNING
extern char scratch_buffer[];
#endif

NORET_TYPE void ext2_panic (struct super_block * sb, const char * function,
                            const char * fmt, ...)
{
        char *buf = scratch_buffer;

        va_list args;

        va_start (args, fmt);
        vsprintf (buf, fmt, args);
        va_end (args);

        ext2_os2_panic(0, "ext2fs panic (on drive %c:): %s: %s\n",
               sb->s_unit + 'A', function, buf);
}

void ext2_error (struct super_block * sb, const char * function,
                 const char * fmt, ...)
{
        char buf[1024];
        va_list args;

        va_start (args, fmt);
        vsprintf (buf, fmt, args);
        va_end (args);

	ext2_os2_panic(0, "ext2-os2 detected a file system error on drive %c: %s: %s\n",
                       sb->s_unit + 'A', function, buf);

}

void ext2_warning (struct super_block * sb, const char * function,
                   const char * fmt, ...)
{
        char buf[1024];
        va_list args;

        va_start (args, fmt);
        vsprintf (buf, fmt, args);
        va_end (args);

        printk (KERN_WARNING "EXT2-fs warning (on drive %c:): %s: %s\n",
                sb->s_unit + 'A', function, buf);

}


