//
// $Header: D:/ext2-os2/microfsd/RCS/microfsd.h,v 1.2 1996/05/27 23:34:58 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __microfsd_h
#define __microfsd_h

/*
 * Data structure to be passed to OS2LDR
 */
struct FileTable {
    unsigned short ft_cfiles;
    unsigned short ft_ldrseg;
    unsigned long  ft_ldrlen;
    unsigned short ft_museg;
    unsigned long  ft_mulen;
    unsigned short ft_mfsseg;
    unsigned long  ft_mfslen;
    unsigned short ft_ripseg;
    unsigned long  ft_riplen;
    unsigned short (*ft_muOpen)(char far *pName, unsigned long far *pulFileSize);
    unsigned short seg1;
    unsigned long  (*ft_muRead)(long loffseek, char far *pBuf, unsigned long cbBuf);
    unsigned short seg2;
    void           (*ft_muClose)(void);
    unsigned short seg3;
    void           (*ft_muTerminate)(void);
    unsigned short seg4;
};

extern void _pascal video_output(char *msg, unsigned short msglen);
extern void _pascal video_crlf(void);

int sprintf(char * buf, const char *fmt, ...);

/*
 * Standard micro-fsd entry points
 */
unsigned short mu_Open(char far *pName, unsigned long far *pulFileSize);
unsigned short stub_mu_Open(char far *pName, unsigned long far *pulFileSize);
unsigned long mu_Read(long loffseek, char far *pBuf, unsigned long cbBuf);
unsigned long stub_mu_Read(long loffseek, char far *pBuf, unsigned long cbBuf);
void mu_Close(void);
void stub_mu_Close(void);
void mu_Terminate(void);
void stub_mu_Terminate(void);

/*
 * Current microfsd segment register
 */
extern unsigned short current_seg;

extern char scratch_buffer[];

extern void microfsd_panic(const char *format, ...);

/*
 * pathutil.c
 */
char *DecoupePath(char *path, char *component);

/*
 * inode.c
 */
struct buffer_head *ext2_getblk(struct inode * inode, blk_t block, blk_t create, int *err);
struct buffer_head *ext2_bread(struct inode * inode, blk_t block, blk_t create, int *err);

/*
 * file.c
 */
struct file *open_by_name(char *pName);
void vfs_close(struct file *f);
int VFS_read(struct file *file, char far *buf, loff_t len, unsigned long far*pLen);

/*
 * ll_rwblk.c
 */
void ll_rw_block(int rw, int nr, struct buffer_head **bh);

void buffer_init(int blocksize);

/*
 * From vsprintf.c
 */
unsigned long simple_strtoul(const char *cp,char **endp,unsigned int base);
extern int printk(const char *fmt, ...);

/*
 * From entry.asm
 */
extern int _pascal bios_read_hd(
                        unsigned short dev, 
                        unsigned short head,
                        unsigned short cyl,
                        unsigned short sect,
                        unsigned short nbsect,
                        unsigned long buffer
                       );


extern dev_t bios_device;
extern struct buffer_head *free_buffers;

#endif /* __microfsd_h */
