/* Installation Script for BioGraph */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

/* Abfrage, in welchem Pfad wir sind */
CALL SysFileTree 'BIO*.*', datei, 'FO'
IF datei.0 < 3 THEN
DO
   SAY "BioGraph wurde noch nicht entpackt."
   SAY "Bitte alle Dateien entpacken und nochmals probieren."
   SAY " "
   SAY "You haven't unpacked BioGraph yet."
   SAY "Please unpack all filesand try again."
   EXIT
END

/* Den Pfad und die Platte extrahieren */
pfad = FILESPEC("path",datei.1)
disk = FILESPEC("drive",datei.1)
path = OVERLAY(pfad,disk,3)

SAY "Installation of BioGraph for OS/2  (c) 1995 Uwe Schlenther Software"
SAY "==================================================================="
SAY " "

/* Ansonsten Daten erfragen */
Abfrage:
SAY "Welches Verzeichnis soll verwendet werden ?"
SAY "Which directory shall be used ?"

SAY "(z.B. C:\BIOGRAPH)  "
PARSE PULL pfad
IF pfad = "" THEN pfad="C:\BIOGRAPH"
SAY " "
SAY "BioGraph wird im Verzeichnis " pfad " installiert."
SAY "BioGraph will be installed in " pfad
SAY " "
SAY "Geben sie <return> fr weiter ein, <K> fr Korrektur oder <A> fr Abbruch !"
SAY "Press <return> to continue, <K> for corrections or <A> to cancel !"
PULL antwort

/* Auswerten */
IF antwort = "A" THEN SIGNAL Abbruch
IF antwort = "K" THEN SIGNAL Abfrage

SAY "Thanks...."

weiter:
/* Jetzt ggf. das Verzeichnis erzeugen */
rc = SysMkDir(pfad)

/* und die dort ntigen Dateien hinverschieben */
INTERPRET "'COPY BIO*.* 'pfad'\*.*'"
INTERPRET "'COPY *.DLL 'pfad'\*.*'"

/* Anlegen des Ordners auf der WPS */
SAY " "
SAY "Soll ein Programmobjekt fr BioGraph erstellt werden ?"
SAY "Shall we create a program object on your desktop ?"
SAY " "
SAY "Geben sie <J> oder <N> ein !"
SAY "Please enter <J> for Yes or <N> for No !"
PULL antwort

/* Auswerten */
IF antwort = "N" THEN SIGNAL Ende
SAY " "
SAY "WPS-Objekte werden erzeugt..."
SAY "WPS-Objects are being created..."

/* Den Ordner anlegen */
klasse='WPFolder'
titel='BioGraph'
ort='<WP_DESKTOP>'
param='OBJECTID=<BIO_ORDNER>;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='BioGraph'
ort='<BIO_ORDNER>'
param='PROGTYPE=PM;EXENAME='pfad'\BIO.EXE;ICONFILE='pfad'\BIO.ICO;STARTUPDIR='pfad';'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Hilfeobjekt anlegen */
klasse='WPProgram'
titel='Hilfe zu BioGraph'
ort='<BIO_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='pfad';PARAMETERS='pfad'\BIO_GER.INF;'
mode='fail'
Location = "<WP_TEMPS>"
Title = "Hilfedatei"
rc = SysCreateObject(klasse,titel,ort,param,mode)

klasse='WPProgram'
titel='BioGraph Help'
ort='<BIO_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='pfad';PARAMETERS='pfad'\BIO_ENG.INF;'
mode='fail'
Location="<WP_TEMPS>"
Title="HelpFile"
rc=SysCreateObject(klasse,titel,ort,param,mode)

/* Ende-Meldung */
Ende:
SAY " "
SAY "BioGraph ist jetzt installiert !"
SAY "BioGraph installation successful !"
EXIT

/* Standard-Fehlerhandler */
Fehler:
SAY " "
SAY "Es ist ein Fehler aufgetreten. Bitte versuchen Sie's nochmal !"
SAY "An error has occured. Please try again !"
EXIT

/* Abbruch des scripts */
Abbruch:
SAY " "
SAY "Abbruch..."
SAY "User break..."
EXIT

