/*
 *      MAKEAND.CMD - V1.0 C.Langanke 1996
 *
 *      execute MAKEAND /? to get online help in your language.
 */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 Redirection  = '> NUL 2>&1';
 CrLf         = D2C(13)''D2C(10);
 '@ECHO OFF'

 /* OS/2 errorcodes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 /* load rexxutil extensions */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* determine message file */
 MessageFile = GetCalldir()'\makeand.msg';
 IF (\FileExist(MessageFile)) THEN
 DO
    SAY;
    SAY Title;
    SAY;
    SAY CmdName': error : Messagefile 'MessageFile' not found.';
    SAY 'Program aborted.';
 END;
 ELSE
    SIGNAL ON HALT NAME HALT_NLS

 /* default values */
 Title    = GetNlsString('Title')''CrLf''GetNlsString('Program');
 ErrorTag = GetNlsString('ErrTag', CmdName);
 Debug    = FALSE;

 IF (Debug) THEN Redirection = '';

 /* display title */
 SAY;
 SAY Title;
 SAY;

 /* show help */
 ARG Parm .
 IF ((Parm = '') | (POS('?', Parm) > 0)) THEN
 DO
    SAY GetNlsString('Help1');
    SAY GetNlsString('Help2');
    SAY GetNlsString('Help3');
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* get command line parms */
 SourceName       = ''
 UseTimeFrame     = -1;
 DefaultTimeFrame = 150;
 DllSeekOffset    = X2D(19B) + 2;
 Framerate.Min     = 100;
 Framerate.Max     = 2000;

 PARSE ARG Parms
 rc = ParseCommandLineParms(, Parms);
 DO i = 1 TO Parm.0;
    IF (Parm.i = '') THEN ITERATE;
    ThisParm = Parm.i;
    PARSE VAR ThisParm ThisTag':'ThisValue;

    SELECT
       WHEN (POS(TRANSLATE(ThisTag), '/TIMEFRAME') = 1) THEN
       DO
          IF (DATATYPE(ThisValue) \= 'NUM') THEN
          DO
             SAY ErrorTag GetNlsString('ErrTimeframe1');
             EXIT(ERROR.INVALID_PARAMETER);
          END;
          IF ((ThisValue < Framerate.Min) | (ThisValue > Framerate.Max)) THEN
          DO
             SAY ErrorTag GetNlsString('ErrTimeframe2', Framerate.Min, Framerate.Max);
             EXIT(ERROR.INVALID_PARAMETER);
          END;

          UseTimeframe = ThisValue;
       END;

       OTHERWISE
       DO
          IF (SourceName = '') THEN
             SourceName  = ThisParm;
          ELSE
          DO
             SAY ErrorTag GetNlsString('ErrParm', ThisParm);
             EXIT(ERROR.INVALID_PARAMETER);
          END;
       END;

    END; /* SELECT */
 END; /* DO */

 DirName = GetDirName(SourceName);
 IF (DirName \= '') THEN
 DO
    SourceName = DirName;
    fIsDirectory = TRUE;
 END;
 ELSE
 DO
    rc = SysFileTree(SourceName, 'File.', 'F');
    IF ((rc \= 0) | (File.0 \= 1)) THEN
    DO
       SAY ErrorTag GetNlsString('ErrSource', SourceName);
       EXIT(ERROR.FILE_NOT_FOUND);
    END;
    fIsDirectory = FALSE;
 END;

 /* get res file name, transform it to 8.3 notation */
 FileName = FILESPEC('N', SourceName);
 FilePath = FILESPEC('D', SourceName)''FILESPEC('P', SourceName);

 ExtPos = POS('.', FileName);
 IF (ExtPos > 0) THEN
    FileName = LEFT(FileName, ExtPos - 1);

 IF (LENGTH(FileName) > 8) THEN
    FileName = LEFT(FileName, 8);

 BaseFileName = FileName;
 IF (fIsDirectory) THEN
 DO
    BaseName   = FileName;
    ScriptName = BaseName'.anm';
 END;
 ELSE
    BaseName  = FilePath''FileName;
 RcFile  = BaseName'.rc';
 ResFile = BaseName'.res';
 DllFile = BaseName'.and';

 TemplateFile = GetCallDir()'\template.dll';

 /* check wether object file is present */
 IF (\FileExist(TemplateFile)) THEN
 DO
    SAY ErrorTag GetNlsString('ErrObj', TemplateFile);
    EXIT(ERROR.FILE_NOT_FOUND);
 END;

 DO WHILE (1)

    IF (fIsDirectory) THEN
    DO
       /* timeframe given ? */
       IF (UseTimeFrame = -1) THEN
          UseTimeFrame = DefaultTimeFrame;

       /* check directory */
       rc = ReadSourceDirectory( SourceName, ScriptName, UseTimeFrame);
    END;
    ELSE
       /* read script */
       rc = ReadSourceFile( SourceName, UseTimeFrame);

    IF (rc \= ERROR.NO_ERROR) THEN LEAVE;

    /* write resource file */
    rc = WriteRcFile( RcFile);
    IF (rc \= ERROR.NO_ERROR) THEN LEAVE;

    /* creating  dll file */
    SAY GetNlsString('CreateDll');
    'copy' TemplateFile DllFile Redirection
    IF (rc \= ERROR.NO_ERROR) THEN LEAVE;
    rc = PatchDll( DllFile, 'TEMPLATE', TRANSLATE(FileName));

    /* creating res */
    SAY GetNlsString('CreateRes');
    'rc -r' RcFile  Redirection
    IF (rc \= ERROR.NO_ERROR) THEN LEAVE;

    /* writing resources to dll */
    SAY GetNlsString('WriteRes');
    'rc' BaseName DllFile Redirection

    /* set icon */
    rc1 = SysSetIcon(DllFile, Pointer.First);

    /* clean up */
    IF (\Debug) THEN
    DO
       rc1 = SysFileDelete( RcFile);
       rc1 = SysFileDelete( ResFile);
    END;

    /* we're done */
    LEAVE;
 END;

 /* display error */
 IF (rc \= ERROR.NO_ERROR) THEN
 DO
    SAY;
    SAY ErrorTag 'rc='rc;
 END;

 EXIT(rc);

/* ------------------------------------------------------------------------- */

HALT_NLS:
 SAY GetNlsString('Halt');
 EXIT(ERROR.GEN_FAILURE);

HALT:
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 /* Default: OS2 directory -> determines boot drive */
 IF (DirName = '') THEN DirName = '\OS2';

 /* Default: PATH  */
 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 /* get value */
 PathValue = VALUE(EnvVarName,,env);

 /* search entry */
 DirName = ':'DirName';';
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE
 PARSE ARG MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 Message = SysGetMessage(MsgId, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ------------------------------------------------------------------------- */
ParseCommandLineParms: PROCEDURE EXPOSE Parm.
 PARSE ARG Delimiter,Parms

 /* Vorgabewerte */
 ParmCount = 0;
 DROP(Parm.);
 Parm.  = '';
 Parm.0 = 0;

 /* verify parameters */
 Parms = STRIP(Parms);
 IF (Parms = '') THEN
    RETURN(Parm.0);

 Delimter = TRANSLATE(STRIP(Delimiter));

 /* convert tabs */
 Parms = TRANSLATE(Parms, D2C(32), D2C(9));

 /* split the parms */
 DO WHILE (Parms \= '')
    /* handle quotes */
    QuotesPos = POS('"', WORD(Parms, 1));
    IF (QuotesPos > 0) THEN
    DO

       ThisParmEnd = POS('"', Parms, QuotesPos + 1);
       IF (ThisParmEnd = 0) THEN
          ThisParmEnd = LENGTH(Parms) + 1;

       say QuotesPos
       say ThisParmEnd

       IF (QuotesPos > 1) THEN
          ThisParm = LEFT(Parms, QuotesPos - 1);
       ELSE
          ThisParm = '';
       ThisParm = ThisParm''SUBSTR(Parms, QuotesPos + 1, ThisParmEnd - QuotesPos - 1);
       NextParmPos = ThisParmEnd + 1;

       IF (NextParmPos > LENGTH(Parms)) THEN
          NextParmPos = 0;

    END;
    ELSE
    /* no quotes here */
    DO
       /* is it the delimiter parameter ? */
       IF (POS(Delimiter, Parms) = 1) THEN
       DO
          ThisParm = Parms;
          NextParmPos = 0;
       END;
       ELSE
       DO
          ThisParm = STRIP(WORD(Parms, 1));
          NextParmPos = LENGTH(ThisParm) + 1;
       END;
    END;

    /* store this parm  */
    i      = Parm.0 + 1;
    Parm.i = ThisParm;
    Parm.0 = i;

    IF (NextParmPos > 0) THEN
    DO
       Parms = SUBSTR(Parms, NextParmPos);
       Parms = STRIP(Parms);
    END;
    ELSE
       Parms = '';
 END;

 RETURN(Parm.0);

/* -------------------------------------------------------------------------- */
GetDirName: PROCEDURE
 PARSE ARG Name

 /* save environment */
 CurrentDrive = FILESPEC('D', DIRECTORY());
 CurrentDir   = DIRECTORY(FILESPEC('D', Name));

 /* try directory */
 DirFound  = DIRECTORY(Name);

 /* reset environment */
 rc = DIRECTORY(CurrentDir);
 rc = DIRECTORY(CurrentDrive);

 RETURN(DirFound);

/* ========================================================================= */
ReadSourceFile: PROCEDURE EXPOSE CmdName env ERROR. TRUE FALSE Pointer. FrameRate. MessageFile
PARSE ARG File, UseTimeFrame

 /* default values */
 Result      = ERROR.NO_ERROR;
 CommentChar = ';';
 SectionOpen = FALSE;
 SectionSkip = FALSE;
 ErrorTag    = GetNlsString('ErrTag');
 ErrorCount  = 0;

 BootDrive   = GetInstDrive();

 Section.0   = 10;
 Section.1   = 'ARROW:';
 Section.2   = 'TEXT:';
 Section.3   = 'WAIT:';
 Section.4   = 'MOVE:';
 Section.5   = '';
 Section.6   = 'NWSE:';
 Section.7   = 'NESW:';
 Section.8   = 'WE:';
 Section.9   = 'NS:';
 Section.10  = 'ILLEGAL:';
 Section.End = 'END:';

 Drop(Pointer.);
 Pointer.     = '';
 Pointer.0    = 10;
 Pointer.1.0  = 0;
 Pointer.2.0  = 0;
 Pointer.3.0  = 0;
 Pointer.4.0  = 0;
 Pointer.5.0  = 0;
 Pointer.6.0  = 0;
 Pointer.7.0  = 0;
 Pointer.8.0  = 0;
 Pointer.9.0  = 0;
 Pointer.10.0 = 0;
 Pointer.First = '';

 PointerCount  = 0;

 LineCount = 1;

 SAY GetNlsString('ReadScript', File);

 /* check header of script file */
 ThisLine = STRIP(LINEIN( File));
 IF (ThisLine \= 'Animation_Script') THEN
 DO
    SAY;
    SAY GetNlsString('ErrTag', CmdName) GetNlsString('ErrFile', File);
    Result = ERROR.INVALID_FORMAT;
 END;


 DO WHILE ((LINES(File) > 0) & (Result = ERROR.NO_ERROR))

    /* read a line */
    ThisLine = STRIP(LINEIN( File));
    ThisLine = TRANSLATE(ThisLine, D2C(32), D2C(9));
    LineCount = LineCount + 1

    /* ignore comments */
    CommentPos = POS(CommentChar, Thisline);
    IF (CommentPos > 0) THEN
       ThisLine = STRIP(LEFT(ThisLine, CommentPos - 1));

    /* skip empty lines */
    IF (ThisLine = '') THEN ITERATE;

    IF (\SectionOpen) THEN
    DO
       /* get section name */
       SectionName = TRANSLATE(WORD(ThisLine, 1));

       /* search for section */
       DO s = 1 TO Section.0
          IF (Section.s = SectionName) THEN
          DO
             ThisSection = s;
             SectionOpen = TRUE;
             LEAVE;
          END;
       END;

       IF (\SectionOpen) THEN
       DO
          /* invalid section keyword */
          SAY GetNlsString('ErrKeyword', LineCount, ErrorTag, SectionName);
          Result = ERROR.INVALID_FORMAT;
          ErrorCount  = ErrorCount + 1;
          ITERATE;
       END;
    END;
    ELSE
    DO
       /* check for section end */
       EndOfSection = TRANSLATE(WORD(ThisLine, 1));
       IF (Section.End = EndOfSection) THEN
       DO
          SectionOpen = FALSE;
          SectionSkip = FALSE;
          ITERATE;
       END;

       /* skip section ? */
       IF (SectionSkip) THEN 
       DO
          ITERATE;
       END;

       /* add pointer to list */
       SELECT
          WHEN (((WORDS(Thisline) < 2) & (Pointer.ThisSection.0 > 0)) | (WORDS(Thisline) > 2))THEN
          DO
             SAY File''GetNlsString('ErrFormat', LineCount, ErrorTag);
             Pointer.ThisSection.0 = 0;
             SectionSkip = TRUE;
             ErrorCount  = ErrorCount + 1;
             ITERATE;
          END;

          OTHERWISE
          DO
             PARSE VAR ThisLine ThisPointer TimeFrame

             /* translate ?: to boot drive */
             IF (LEFT(ThisPointer, 2) = '?:') THEN
                ThisPointer = BootDrive''SUBSTR(ThisPointer, 3);

             /* verify definition */
             IF (\FileExist(ThisPointer)) THEN
             DO
                SAY File''GetNlsString('ErrPtrNotFound', LineCount, ErrorTag, ThisPointer);
                Pointer.ThisSection.0 = 0;
                SectionSkip = TRUE;
                ErrorCount  = ErrorCount + 1;
                ITERATE;
             END;

             /* save name of first pointer */
             IF (Pointer.First = '') THEN
                Pointer.First = STRIP(ThisPointer);


             /* is it static pointer ? */
             IF ((Pointer.ThisSection.StaticPtr = '') & (TimeFrame = '')) THEN
             DO
                Pointer.ThisSection.StaticPtr = STRIP(ThisPointer);
                PointerCount = PointerCount + 1;
                ITERATE;
             END;

             IF ((TimeFrame = '') | (\DATATYPE(TimeFrame,'NUM'))) THEN
             DO
                SAY File''GetNlsString('ErrNotNum', LineCount, ErrorTag);
                Pointer.ThisSection.0 = 0;
                SectionSkip = TRUE;
                ErrorCount  = ErrorCount + 1;
                ITERATE;
             END;

             IF ((TimeFrame < Framerate.Min) | (TimeFrame > Framerate.Max)) THEN
             DO
                SAY File''GetNlsString('ErrTimeframe3', LineCount, ErrorTag, Framerate.Min, Framerate.Max);
                Pointer.ThisSection.0 = 0;
                SectionSkip = TRUE;
                ErrorCount  = ErrorCount + 1;
                ITERATE;
             END;


             /* ovveride timeframe ? */
             IF (UseTimeFrame \= -1) THEN
                TimeFrame = UseTimeFrame;

             /* store pointer and duration */
             p                           = Pointer.ThisSection.0 + 1;
             Pointer.ThisSection.p.Ptr   = STRIP(ThisPointer);
             Pointer.ThisSection.p.Dur   = STRIP(TimeFrame);
             Pointer.ThisSection.0       = p;
             PointerCount = PointerCount + 1;

          END; /* OTHERWISE */

       END; /* SELECT */

    END; /* ELSE */

 END; /* DO WHILE (LINES(File) > 0) */

 /* close file */
 rc = LINEOUT(File);

 IF ((Result = ERROR.NO_ERROR) & (PointerCount = 0)) THEN
 DO
    SAY;
    SAY GetNlsString('ErrTag', CmdName) GetNlsString('NoPtrs', File);
    Result = ERROR.FILE_NOT_FOUND;
 END;

 IF (ErrorCount > 0) THEN
 DO
    Result = ERROR.INVALID_DATA;
    EXIT(Result);
 END;

 RETURN(Result);

/* ========================================================================= */
ReadSourceDirectory: PROCEDURE EXPOSE CmdName env CrLf ERROR. TRUE FALSE Pointer. MessageFile
PARSE ARG Directory, ScriptFile, UseTimeFrame

 Result       = ERROR.NO_ERROR;
 CommentChar  = ';';
 GroupOpen    = FALSE;
 AbsolutePath = FALSE;

 Group.0   = 10;
 Group.1   = 'ARROW';
 Group.2   = 'TEXT';
 Group.3   = 'WAIT';
 Group.4   = 'MOVE';
 Group.5   = '';
 Group.6   = 'SIZENWSE';
 Group.7   = 'SIZENESW';
 Group.8   = 'SIZEWE';
 Group.9   = 'SIZENS';
 Group.10  = 'ILLEGAL';

 Section.0   = 10;
 Section.1   = 'ARROW:';
 Section.2   = 'TEXT:';
 Section.3   = 'WAIT:';
 Section.4   = 'MOVE:';
 Section.5   = '';
 Section.6   = 'NWSE:';
 Section.7   = 'NESW:';
 Section.8   = 'WE:';
 Section.9   = 'NS:';
 Section.10  = 'ILLEGAL:';
 Section.End = 'END:';

 Drop(Pointer.);
 Pointer.     = '';
 Pointer.0    = 10;
 Pointer.1.0  = 0;
 Pointer.2.0  = 0;
 Pointer.3.0  = 0;
 Pointer.4.0  = 0;
 Pointer.5.0  = 0;
 Pointer.6.0  = 0;
 Pointer.7.0  = 0;
 Pointer.8.0  = 0;
 Pointer.9.0  = 0;
 Pointer.10.0 = 0;
 Pointer.First = '';
 PointerCount  = 0;

 /* determine if relative path given */
 IF (LEFT(directory, 1) = '.') THEN
    AbsolutePath = TRUE;

 /* delete old script file */
 rc = SysFileDelete( ScriptFile);

 /* write header to scriptfile */
 LineHeader = CommentChar''COPIES(D2C(32), 7);
 FileHeader = LineHeader''GetNlsString('Program')''CrLf''CrLf''GetNlsString('Title');
 LinePos    = POS(CrLf, FileHeader);
 DO WHILE (LinePos > 0)
    FileHeader = INSERT( LineHeader, FileHeader, LinePos + 1);
    LinePos    = POS(CrLf, FileHeader, LinePos + LENGTH(LineHeader) + 2);
 END;
 rc = LINEOUT(ScriptFile, 'Animation_Script')
 rc = LINEOUT(ScriptFile, CommentChar);
 rc = LINEOUT(ScriptFile, LineHeader''GetNlsString('GeneratedBy', DATE(), TIME()));
 rc = LINEOUT(ScriptFile, CommentChar);
 rc = LINEOUT(ScriptFile, FileHeader);
 rc = LINEOUT(ScriptFile, CommentChar);
 rc = LINEOUT(ScriptFile, '');

 SAY GetNlsString('ReadDir', Directory);
 DO g = 1 TO Group.0

    SectionStarted = FALSE;

    /* get static ptr file name */
    FileName = Directory'\'Group.g'.PTR';
    IF (FileExist(FileName)) THEN
    DO
       IF (AbsolutePath) THEN
          FileName = STREAM(FileName, 'C', 'QUERY EXISTS');
       Pointer.g.StaticPtr = FileName;
       PointerCount = PointerCount + 1;

       /* save name of first pointer */
       IF (Pointer.First = '') THEN
          Pointer.First = FileName;

       /* write ptr to ScriptFile */
       SectionStarted = TRUE;
       rc = LINEOUT(ScriptFile, Section.g);
       rc = LINEOUT(ScriptFile,  STRIP(FileName));
    END;

    DO i = 0 TO 127

       /* get file name */
       FileName = Directory'\'Group.g''RIGHT(i, 3, '0')'.PTR';
       IF (\FileExist(FileName)) THEN LEAVE;

       IF (AbsolutePath) THEN
          FileName = STREAM(FileName, 'C', 'QUERY EXISTS');

       /* save name of first pointer */
       IF (Pointer.First = '') THEN
          Pointer.First = FileName;

       /* store pointer and duration */
       p                 = Pointer.g.0 + 1;
       Pointer.g.p.Ptr   = STRIP(FileName);
       Pointer.g.p.Dur   = STRIP(UseTimeFrame);
       Pointer.g.0       = p;
       PointerCount = PointerCount + 1;

       /* start scriptfile section */
       IF ((\SectionStarted) & (i = 0) & (g \= 5)) THEN
          rc = LINEOUT(ScriptFile, Section.g);

       /* write ptr to ScriptFile */
       rc = LINEOUT(ScriptFile,  STRIP(FileName)   STRIP(UseTimeFrame));

    END; /*  DO i = 0 TO 127 */

    /* end scriptfile section */
    IF (((i > 1) | (Pointer.g.StaticPtr \= '')) & (g \= 5)) THEN
       rc = LINEOUT(ScriptFile, Section.End);

 END; /* DO g = 1 TO Group.0 */

 /* close Scriptfile */
 rc = STREAM(ScriptFile, 'C', 'CLOSE');

 IF (PointerCount = 0) THEN
 DO
    SAY;
    SAY GetNlsString('ErrTag', CmdName) GetNlsString('NoPtrs', Directory);
    Result = ERROR.FILE_NOT_FOUND;
 END;

 RETURN(Result);

/* ========================================================================= */
WriteRcFile: PROCEDURE EXPOSE CmdName ERROR. TRUE FALSE Pointer. MessageFile
ARG File

 Result = ERROR.NO_ERROR;

 SAY GetNlsString('WriteRc');
 DO WHILE (1)

    /* delete old file */
    IF (FileExist(File)) THEN
    DO
       rc = SysFileDelete( File);
       IF (rc \= 0) THEN
       DO
          Result = ERROR.ACCESS_DENIED;
          LEAVE;
       END;
    END;

 /* write pointer definitions to res file */
 PointerCount = 0;
 DO p = 1 TO Pointer.0

    IF (Pointer.p.StaticPtr \= '') THEN
    DO
       rc = LINEOUT(File, 'ICON' (p * 100) Pointer.p.StaticPtr);
       PointerCount = PointerCount + 1;
    END;

    DO i = 1 TO Pointer.p.0
       rc = LINEOUT(File, 'ICON' (p * 100) + i Pointer.p.i.Ptr);
       PointerCount = PointerCount + 1;
    END;
 END;

 IF (PointerCount = 0) THEN
 DO
    SAY;
    SAY GetNlsString('ErrTag', CmdName) GetNlsString('NoPtrs');
    RETURN(ERROR.FILE_NOT_FOUND);
 END;

 /* write timeouts to res file */
 rc = LINEOUT(File, 'STRINGTABLE');
 rc = LINEOUT(File, 'BEGIN');
 ThisId = 0;
 DO p = 1 TO Pointer.0

    rc = WriteStringTableEntry( File, ThisId, '"'Pointer.p.0'"');
    ThisId = ThisId + 1;

    DO i = 1 TO Pointer.p.0
       rc = WriteStringTableEntry( File, ThisId, '"'Pointer.p.i.Dur'"');
       ThisId = ThisId + 1;
    END;
 END;

 rc = LINEOUT(File, 'END');

 /* close file */
 rc = LINEOUT(File);

 RETURN(Result);

/* ========================================================================= */
WriteStringTableEntry: PROCEDURE
PARSE ARG File, Id, Value

 IF ((Id \= 0) & (Id // 16 = 0)) THEN
 DO
 rc = LINEOUT(File, 'END');
 rc = LINEOUT(File, 'STRINGTABLE');
 rc = LINEOUT(File, 'BEGIN');
 END;

 rc = LINEOUT(File, Id  Value);

 RETURN('');

/* ========================================================================= */
GetNlsString: PROCEDURE EXPOSE ERROR. MessageFile
 PARSE ARG MessageId, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9;

 /* default values */
 Message     = '*** Message' Id 'not found. ***';

 /* default values */
 MessageFileIdText = 'WPAMPTR_MESSAGEFILE';

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId MessageLanguage MessageFileKeys MessageListcount
 IF ((MessageFileIdText \= MessageFileId) | (LENGTH(MessageFileKeys) \= 2))THEN
 DO
    SAY 'Invalid message file' MessageFile;
    EXIT(ERROR.INVALID_DATA);
 END;

 /* load Messagelist*/
 MessageList = '';
 DO i = 1 TO MessageListcount
    MessageList = MessageList LoadMsgString(i, MessageFile)
 END;

 /* handle special id YesNoKeys */
 IF (MessageId = 'YESNOKEYS') THEN
    RETURN(MessageFileKeys);

 /* read message ids */
 MessagePos   = WORDPOS(TRANSLATE(MessageId), TRANSLATE(MessageList));
 IF (MessagePos > 0) THEN
 DO
    ThisMessage = LoadMsgString(MessagePos + MessageListcount, MessageFile, Parm1, Parm2, Parm3, Parm4, Parm5, Parm6, Parm7, Parm8, Parm9);
    IF (ThisMessage \= '') THEN
       Message = ThisMessage;
 END;

 RETURN(Message);


/* ========================================================================= */
PatchDll: PROCEDURE EXPOSE ERROR. TRUE FALSE MessageFile
 PARSE ARG File, OldName, NewName

 /* defaults */
 BufLen     = 256;
 fNameFound = FALSE;
 FilePos    = 1;

 /* search old name in dll */
 DO WHILE (CHARS(File) > 0)
    Buffer = CHARIN(File, FilePos, BufLen);
    NamePos = POS(OldName, Buffer);
    IF (NamePos > 0) THEN
    DO
       fNameFound = TRUE;
       FilePos = FilePos + NamePos;
       LEAVE;
    END;
    ELSE
       FilePos = FilePos + BufLen;
 END;

 IF (fNameFound) THEN
 DO
    /* seek to position */
    rc = STREAM(File, 'c', 'seek' FilePos - 2);
    rc = CHAROUT(File, D2C(LENGTH(NewName)));
    rc = CHAROUT(File, NewName''COPIES(D2C(0), 8 - LENGTH(NEWNAME)));
 END;

 /* close file */
 rc = LINEOUT(File);


 RETURN(0);

