@echo off
rem  Ŀ 
rem   ARCHIVE TESTING 
rem   
IF "%1"=="" GOTO ENDE
IF "%2"=="" GOTO ENDE
IF "%3"=="" GOTO ENDE
IF NOT EXIST %2 GOTO ENDE
IF EXIST crcfail.%3 DEL crcfail.%3 >NUL

rem *** ARCHIVE BRANCH ********************************************************

IF "%1" == "ZIP" GOTO ZIP
IF "%1" == "ARC" GOTO ARC
IF "%1" == "ARJ" GOTO ARJ
IF "%1" == "LHARC" GOTO LZH
IF "%1" == "PAK" GOTO PAK
IF "%1" == "RAR" GOTO RAR
IF "%1" == "TD0" GOTO TD0
IF "%1" == "GIF" GOTO GIF
GOTO ENDE

rem *** PROCEED ARCHIVE TESTING **********************************************

:ZIP
pkunzip -t %2 >NUL
if errorlevel 51 goto ARC_ERROR
if errorlevel 50 goto DISK_FULL
if errorlevel 11 goto NO_FILES
if errorlevel 10 goto BAD_COMMAND
if errorlevel 9 goto NO_FILES
if errorlevel 8 goto NO_MEMORY
if errorlevel 3 goto ARC_ERROR
if errorlevel 2 goto ARC_ERROR
rem *** level 1 is for warnings, have to assume CRC warning ***
if errorlevel 1 goto CRC_ERROR
GOTO ENDE

:ARC
pkunpak -t %2 >NUL
if errorlevel 1 goto ARC_ERROR
GOTO ENDE

:PAK
pak t %2 >NUL
if errorlevel 1 goto ARC_ERROR
GOTO ENDE
 
:ARJ
arj t /y %2 >NUL
if errorlevel 9 goto INVALID
if errorlevel 8 goto NO_MEMORY
if errorlevel 7 goto BAD_COMMAND
if errorlevel 6 goto ARC_ERROR
if errorlevel 5 goto DISK_FULL
if errorlevel 4 goto FAIL_VERIFY
if errorlevel 3 goto CRC_ERROR
if errorlevel 2 goto ARC_ERROR
if errorlevel 1 goto ARC_ERROR
GOTO ENDE

:LZH
lha t /m /n2 %2 >NUL
if errorlevel == 2 goto ARC_ERROR
if errorlevel == 1 goto CRC_ERROR
GOTO ENDE

:RAR
rar t -y %2 >NUL
if errorlevel == 255 goto PROG_ERROR
if errorlevel == 8 goto NO_MEMORY
if errorlevel == 7 goto BAD_COMMAND
if errorlevel == 6 goto PROG_ERROR
if errorlevel == 5 goto DISK_FULL
if errorlevel == 4 goto LOCKED
if errorlevel == 3 goto CRC_ERROR
if errorlevel == 2 goto ARC_ERROR
if errorlevel == 1 goto WARNING
goto ENDE

:TD0
tdcheck %2 >NUL
if errorlevel 1 goto ARC_ERROR
GOTO ENDE

:GIF
giftest %2 %4
if errorlevel == 255 goto PROG_ERROR
if errorlevel == 60 goto ENDE
if errorlevel == 25 goto DUPE_CRC
if errorlevel == 20 goto MIN_REZ
if errorlevel == 10 goto GIF_LITED
if errorlevel == 5 goto BAD_COMMAND
if errorlevel == 1 goto GIF_FAIL
GOTO ENDE

rem *** ARCHIVE ERRORS *******************************************************

:CRC_ERROR
ECHO CRC ERRORS IN %1! %4 >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

:ARC_ERROR
ECHO ERROR IN %1! %4 >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

:INVALID
ECHO INVALID %1! %4 >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

:NO_FILES
rem  Partial Archive?
ECHO NO FILES IN %1! %4 >CRCFAIL.%3
ECHO 2 >>CRCFAIL.%3
GOTO ENDE

rem *** GIF ERRORS ***********************************************************

:GIF_FAIL
ECHO INVALID HEADER OR PARTIAL GIF! >CRCFAIL.%3
ECHO 2 >>CRCFAIL.%3
GOTO ENDE

:MIN_REZ
ECHO FAILED MINIMUM RESOLUTION! >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

:DUPE_CRC
ECHO DUPLICATE CRC FOUND! >CRCFAIL.%3
ECHO 1 >>CRCFAIL.%3
GOTO ENDE

:GIF_LITED
REM Tells GIF-LITE not to bother
ECHO PASSED (GIF-LITE'd) >CRCFAIL.%3
ECHO -1 >>CRCFAIL.%3
GOTO ENDE

rem *** WARNINGS *************************************************************

:NO_MEMORY
ECHO WARNING - INSUFFICIENT MEMORY!!! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:FAIL_VERIFY
ECHO WARNING - FAILED VERIFICATION! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:WARNING
ECHO WARNING - NON FATAL ERROR(S)! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:LOCKED
ECHO WARNING - ARCHIVE LOCKED! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:BAD_COMMAND
ECHO WARNING - ILLEGAL COMMAND!!! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:DISK_FULL
ECHO WARNING - DISK FULL!!! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

:PROG_ERROR
ECHO WARNING - PROGRAM ERROR!!! >CRCFAIL.%3
ECHO 0 >>CRCFAIL.%3
GOTO ENDE

rem *** END OF BATCH *********************************************************
:ENDE
