/*==========================================================================
module:      weapon.hpp
programmer:  Shane Garrett
Language:    Watcom C++

Copyright 1995 Holistic Design

=========================================================================-*/
#define  SPEC_TEMP_MASK                0xF
#define  SPEC_TEMP_SHIFT               8

#define  FLAK_STYLE							0x00000010	// Coded
#define  THIRD_MIN_RANGE					0x00000020	// Coded
#define  ONE_PER_DETACHMENT				0x00000040	// Coded
#define  CAN_TARGET_ANY_LOCATION			0x00000080	// Coded

#define  PLUS_ONE_MELEE_BONUS				0x00000100	// Coded
#define  PLUS_DIE_MELEE_BONUS				0x00000200	// Coded
#define  MELEE_DAMAGE_BONUS				0x00000400	// Coded
#define  MELEE_CRIT_BONUS					0x00000800	// Coded

#define  OPTIONAL_AMMO						0x00001000
#define  OPTIONAL_AMMO_LISTING			0x00002000
#define  OBSERVATION_HIT_BONUS			0x00004000
#define  MORALE_BONUS						0x00008000

#define	SPECIAL_WEAPON 					0x40000000  // Coded
#define	TEMPLATE_WEAPON					0x80000000  // Coded
#define  BARRAGE_WEAPON                0x20000000  // Coded
#define	FW_IGNORES_COVER_MOD				0x08000000	// Coded
#define	FW_TURN_TO_RELOAD					0x04000000	// Coded

// Weapon Location specifiers needed for all weapons which can be mounted
#define	TITAN_GENERAL_AREA				0x00010000
#define	TITAN_RIGHT_ARM_AREA				0x00020000
#define	TITAN_LEFT_ARM_AREA				0x00040000
#define  TITAN_BOTH_ARM_AREA				0x00060000
#define	TITAN_RIGHT_CARAP_AREA			0x00080000
#define  TITAN_LEFT_CARAP_AREA			0x00100000
#define  TITAN_BOTH_CARAP_AREA			0x00180000
#define	TITAN_HEAD_AREA					0x00200000
#define	TITAN_BELLY_AREA					0x00400000
#define	TITAN_AREA_ALL						0x007F0000

// this is a special area because the harpoon missle can be attached to
// both the launcher and a titan carapace area
#define	LAUNCHER_AREA						0x00080000
#define	GENERAL_AREA						0x00010000

//Special and Template weapon types
#define  TEMPLATE_TYPE_PULSA           0
#define  TEMPLATE_TYPE_BARRAGE_MISSLE  1
#define  TEMPLATE_TYPE_WARP            2
#define  TEMPLATE_TYPE_FLAMER          3
#define  TEMPLATE_TYPE_VORTEX          4
#define  TEMPLATE_TYPE_SNAPPER         5
#define  TEMPLATE_TYPE_KUSTOM_ROKKITS  6

#define  SPECIAL_TYPE_LIFTA           11
#define  SPECIAL_TYPE_WIERDBOY        12
#define  SPECIAL_TYPE_KUST_KANNON     13

#define	BARR	                        -2
#define	TEMP	                        -3
#define	SPEC_SAVE	                  -20


// Weapn IDs
#define WPID_AUTOCAN_25              1001
#define WPID_AXES                    1002
#define WPID_BARRAGE_MSL             1003
#define WPID_BATTCAN_25              1004
#define WPID_BATTCAN_35              1005
#define WPID_BOLT_TANK               1006
#define WPID_BOLT_SHORT              1007
#define WPID_BOLT_BIKE               1008
#define WPID_BOLT                    1009
#define WPID_BOLT_HVY                1010
#define WPID_BUBBLE_CHUKKA           1011
#define WPID_BUZZ_SAW_GUN            1012
#define WPID_CHAIN_FIST              1014
#define WPID_CLUSTER_BUSTER          1015
#define WPID_DDAY_CAN                1016
#define WPID_DEATHSTRIKE_CAN         1017
#define WPID_DE_LUXE_KUST_KAN        1018
#define WPID_DEST_ROKKIT             1019
#define WPID_DETH_KAN                1020
#define WPID_EARTH_SHAKER            1021
#define WPID_FIRE_THROWER            1022
#define WPID_GATLING_BLAS            1023
#define WPID_GATLING_CAN             1024
#define WPID_GUTBUS                  1025
#define WPID_GUTBUS_BALL             1026
#define WPID_GUTBUS_CHAIN            1027
#define WPID_GUTBUS_EXPL             1028
#define WPID_HUNTING_LANCE           1029
#define WPID_HVY_WEAPONS             1030
#define WPID_INFERNO_GUN             1031
#define WPID_KRUSHER_GUN             1032
#define WPID_KUST_KAN                1034
#define WPID_LASCAN                  1035
#define WPID_LAS_BLAS                1036
#define WPID_LAS_BURNER              1037
#define WPID_LASGUN                  1038
#define WPID_LIFTA_DROPPA            1039
#define WPID_MAGNUM                  1040
#define WPID_MELTA_CAN               1041
#define WPID_MULTI_LAS               1042
#define WPID_MULTI_LAUN              1043
#define WPID_MULTI_MELTA             1044
#define WPID_MUL_ROCKET_LAUN         1045
#define WPID_OBSERV_TURR             1046
#define WPID_PISTOL_SWORD            1047
#define WPID_PLAS_BLASGUN            1048
#define WPID_PLAS_CAN                1049
#define WPID_PLAS_DEST               1050
#define WPID_POWER_FIST              1051
#define WPID_PULSA_ROKKIT            1052
#define WPID_QUAKE_CAN               1053
#define WPID_RIPPER_FIST             1054
#define WPID_ORK_ROCKETS				 1055
#define WPID_ROCKETS_100             1056
#define WPID_ROCKETS_25              1057
#define WPID_SCORCHER                1058
#define WPID_SCORCH_TURR             1059
#define WPID_SHOTGUNS                1060
#define WPID_SIEGE_MORTAR            1061
#define WPID_SLASHA_ATT_GUN          1062
#define WPID_SNAPPER                 1063
#define WPID_SUP_LIFTA_DROP          1064
#define WPID_THUDD_GUN               1065
#define WPID_THUNDERER               1066
#define WPID_TURBO_LAS_DEST          1067
#define WPID_VOLC_CAN                1068
#define WPID_VORTEX_MISS             1069
#define WPID_VULC_MEG_BOLT           1070
#define WPID_WARP_MISS               1071
#define WPID_WARP_MSL                1072
#define WPID_WEIRDBOY_TOWER          1073
#define WPID_ROCKETS_MARAUDER		  	 1074
#define WPID_BATTCAN_HEAD            1075
#define WPID_GORK_HEAD               1076
#define WPID_MORK_HEAD               1077
#define WPID_BATTCAN_TURR            1078
#define WPID_DEMOLISHER					 1079
#define WPID_QUAD_FLAKGUN				 1080

#define	WPID_SELECT				       -1
#define	WPID_NOTHING				    -2
#define	WPID_CHOOSE				       -1

#define WID_SOUND_TYPE_GNPDR_INF        0
#define WID_SOUND_TYPE_BOLTER           1
#define WID_SOUND_TYPE_AUTO_CANNON      2
#define WID_SOUND_TYPE_BATTLE_CANNON    3
#define WID_SOUND_TYPE_KUSTOM_KANNON    4
#define WID_SOUND_TYPE_GATLING          5
#define WID_SOUND_TYPE_LASER_INF        6
#define WID_SOUND_TYPE_LASER_CANNON     7
#define WID_SOUND_TYPE_MULTI_LASER      8
#define WID_SOUND_TYPE_LARGE_LASER      9
#define WID_SOUND_TYPE_GATLING_LASER   10
#define WID_SOUND_TYPE_BARRAGE         11
#define WID_SOUND_TYPE_HVY_BARRAGE     12
#define WID_SOUND_TYPE_HELLSTORM       13
#define WID_SOUND_TYPE_FLAMER          14
#define WID_SOUND_TYPE_ROCKET_BARRAGE  15
#define WID_SOUND_TYPE_SMALL_PLASMA    16
#define WID_SOUND_TYPE_MEDIUM_PLASMA   17
#define WID_SOUND_TYPE_LARGE_PLASMA    18
#define WID_SOUND_TYPE_WEIRDBOY        19
#define WID_SOUND_TYPE_MULTI_MELTA     20
#define WID_SOUND_TYPE_ELECTRICAL      21
#define WID_SOUND_TYPE_SINGLE_ROCKET   22
#define WID_SOUND_TYPE_UNKNOWN         23


// Page number of weapon visible effects

#define WID_EFFECT_TYPE_NONE				   0
#define WID_EFFECT_TYPE_MORE_EXPL1	      999
#define WID_EFFECT_TYPE_HEXFLAME 	      998
#define WID_EFFECT_TYPE_SMOKE	            997
#define WID_EFFECT_TYPE_EXPL	            996
#define WID_EFFECT_TYPE_MORE_EXPL2	      995
#define WID_EFFECT_TYPE_BGLASER		      994
#define WID_EFFECT_TYPE_FIREEXPL	         993
#define WID_EFFECT_TYPE_SMLASER           992
#define WID_EFFECT_TYPE_???	            991
#define WID_EFFECT_TYPE_BUBBLE            3107
#define WID_EFFECT_TYPE_PULSA             3123
#define WID_EFFECT_TYPE_LIFTABEAM         899
#define WID_EFFECT_TYPE_TOWERBOLT         895
#define WID_EFFECT_TYPE_TITANWARPMSL      3581  
#define WID_EFFECT_TYPE_TITANVORTEXMSL    3580
#define WID_EFFECT_TYPE_TITANBARRAGEMSL   3579
#define WID_EFFECT_TYPE_DEATHMISSLE       1105
#define WID_EFFECT_TYPE_KUSTROKKITS       3127
