#############################################################################
#                                  FIRE                                     #
#                                                                           #
# This robot demonstrates the use of a bearing. CldBearings is set when     #
# a robot hits another object. A collision bearing contains the relative    #
# heading to the object that hits this robot (values -180 to 179 ). Remeber,#
# cldbearing says nothing about the direction an object that hits this      #
# robot was traveling, it only specifies where on this robot's body it      # 
# hit.                                                                      #
#                                                                           #
# Note: This robot also contains a very usefull section that determines     #
#       the smallest number of degrees needed to reach a desired angle,     #
#       and another that converts a bearing to an absolute heading.         #
#                                                                           #
#############################################################################


Init
{
	Name( "Fire" )

	RegCore( Search )
	RegCldRobot( RobotHit, 1 )
	RegDtcCookie( FoundCookie, 2 )
	RegCldMissile( MissileHit, 3 )
	RegDtcRobot( FoundRobot, 4 )

	LockGun( TRUE )
	dist = 50
}

Search
{
	Scan( )
	RadarRight( 5 )
}  

FoundRobot
{
	if( ScanDist < 50 AND energy > 50 )
		Fire( 7 )
	else
		Fire( 1 )
	endif
	
	Scan( )
}        

MissileHit
{
	# Turn perpendicular to the object that nailed us
	if( cldbearing < 0 )
		BodyRight( cldbearing + 90 )
	else
		BodyRight( cldbearing - 90 )
	endif
	
	# Run Away, Run Away
	Ahead( dist )
	
	# Change the direction we run
	dist = -dist
	
	# Clear out any detections that may have been lost during move
	Scan( )
}

RobotHit
{
	Stop( )

	# This converts cldbearing to an absolute heading from 0 to 359
	bearing = cldbearing
	Gosub( BearingToHeading )

	# Determine the smallest number of degrees to the robot that hit us
	destAngle = heading
	Gosub( MinDegreesRight )

	# Turn gun and radar towards the robot
	GunRight( rightDegrees )

	# Check if the robot that hit us is still there.
	# Note that if a robot is found, the robot detection event handler
	# 'FoundRobot' will not be called until 'RobotHit' returns. This is
	# because 'RobotHit' has a higher priority than 'FoundRobot'. After
	# we call Scan() return so that 'FoundRobot' can handle the robot 
	# detection event. This works because the the 'cldrobot' variable is
	# automatically reset at the end of this section ending the cldrobot
	# event.

	Scan()
}

FoundCookie
{
	SyncAll( )
	Ahead( scandist + 5 )
}

# Very usefull subroutine. Changes a bearing value into an absolute
# heading. Before called, this section expects 'bearing' to be filled
# with the number that requires conversion. When complete, 'heading' 
# will contain the converted value.

BearingToHeading
{
	# Do a little error checking

	if( bearing > 179 OR bearing < -180 )
		Print( "BearingToHeading: bad bearing of" )
		Print( bearing )
		return
	endif

	# BearingToHeading works with BODYAIM. This could be made 
	# another user variable to make BearingToHeading more versitile.

	heading = bodyAim + bearing

	if( heading < 0 )
		heading = heading + 360
	elseif( heading > 359 )
		heading = heading - 360
	endif
}


# Very usefull subroutine. Determines the minimum number of degrees 
# needed to reach 'destAngle'. Before called, this section expects
# 'destAngle' to be filled with the desired angle. When complete, 
# 'rightDegrees' will contain the smallest number of degrees needed
# to reach destAngle turning RIGHT. If 'destAngle' can be reached 
# fastest by turning LEFT, 'rightDegrees' will be negative!

MinDegreesRight
{
	# Do a little error checking

	if( destAngle > 359 OR destAngle < 0 )
		Print( "MinDegreesRight: bad destAngle of" )
		Print( destAngle )
		rightDegrees = 0
		return
	endif


	# MinDegreesRight works with GUNAIM. This could be made 
	# another user variable to make MinDegreesRight more versitile.

	temp_right = destAngle - gunaim
	
	if( temp_right < 0 )
		temp_right = temp_right + 360
	endif
	
	temp_left = -temp_right + 360
	
	if( temp_right <= temp_left )
		rightDegrees = temp_right
	else
		rightDegrees = -temp_left
	endif
}

