#############################################################################
#                               SMART CORNER                                #
#                                                                           #
# This robot demonstrates the ability to learn over a match. This robot     # 
# changes its behavior from one game to the next depending upon how it did  #
# in the previous game. An even smarter robot might modify its behavior by  #
# tracking all of the games it has played in during a match. There are many #
# other statistical functions available that this robot does not even use!  #
#                                                                           #
#############################################################################


Init
{
	Name( "Smart Corner" )
    
	# Figure out how many robots are in the game!
	GetOthers( )
	others = result
    
	# Set detection section to "Travel Mode"
	RegDtcRobot( TrvFoundRobot, 1 )
	RegCore( MyCore )
	RegAScan( AutoScan, 3 )

	
	Gosub( GoCorner )

	# Don't want to shot cookies on our way to the
	# corner so register the detection handler here
	RegDtcCookie( FoundCookie, 2 )
}

MyCore
{
	Scan()
	GunLeft( guninc )
}  

GoCorner
{
	LockAll( ON )

	# Go to the corner determined by our stored value.
	# Will always be upper left for first game of match.
	# Hitting a wall will stop the robot, but causes no damage

	BodyRight( corner )
	Ahead( 400 )
	BodyLeft( 90 )
	Ahead( 400 )

	# Change robot detection section to "Corner Mode"
	RegDtcRobot( CrnFoundRobot, 1 )

	LockAll( OFF )
	LockGun( ON )
	GunLeft( 90 )
	
	# Calculate the "ends" of the robot's radar sweep

	gun_start = gunaim
	
	if( gunaim == 0 )
		gun_end = 270
	else
		gun_end = gunaim - 90
	endif
		
	# Registering event may seem a bit over-kill. This could be
	# done with if statements in MyCore, but this is more interesting!
	# Notice that having two events with the same priority produces 
	# unknow results only when it is possible for both events to occur
	# at the same time.
	
	RegCustom( GunAtStart, 3, gunaim == gun_start )
	RegCustom( GunAtEnd, 3, gunaim == gun_end )
	
}

GunAtStart
{
	# Event is called when we hit gun_start.
	# scan() now so we check along the gun_start angle.

	Scan()
	
	# Since we used == in our events above, the guninc value
	# must causes us to hit gun_start and gun_end exactly!

	guninc = 3

	# If we don't change our gunaim, this event will never end!

	GunLeft( 3 )
}

GunAtEnd
{
	Scan()
	guninc = -3
	GunRight( 3 )
}

AutoScan
{
	Scan( )
}

# This section is used while sitting in a corner
# If another robot is detected fire until we don't see it.

CrnFoundRobot
{
	Gosub( Fire )
	Scan( )
}

# This section is used while traveling to a corner
# If another robot is detected, stop, fire until gone,
# then finish moving to the wall

TrvFoundRobot
{
	# Calling stop may times does not over-write continue info.
	stop( )
	Gosub( Fire )
	Scan( )
	
	if( dtcrobot == 0 )
		# Since the command moves us all the way to the wall,
		# we will not be able to detect another robot. Check
		# out the blocking() command for a better solution.
		Continue( )
	endif
}

FoundCookie
{
	Fire( 1 )
}

Fire
{
	if( scandist > 200 OR energy < 15 )
		Fire( 1 )
	elseif( scandist > 100 )
		Fire( 3 )
	elseif( scandist > 50 )
		Fire( 5 )
	else( )
		Fire( 7 )
	endif
}

Dead
{
	GetOthers( )
	
	# Lets see how we did. This allows the robot to adapt
	# to its enemies. If we were not in the top 75 percent,
	# switch to another corner. The first if() is needed to prevent
	# division by zero when we are the only player in a game.

	if( others )
		if( (others - result) / others < 0.75 )
			corner = corner + 90
			if( corner == 270 )
				corner = -90
			endif
		endif
	endif
	
	Store( corner )
}
