#define MAX_NUM_FUELCENS	50

#define SEGMENT_IS_NOTHING			0
#define SEGMENT_IS_FUELCEN			1
#define SEGMENT_IS_REPAIRCEN		2
#define SEGMENT_IS_CONTROLCEN		3
#define SEGMENT_IS_ROBOTMAKER		4
#define MAX_CENTER_TYPES			5

typedef struct control_center_triggers {
	short		num_links;
	short 	seg[MAX_WALLS_PER_LINK];
	short		side[MAX_WALLS_PER_LINK];
} control_center_triggers;

// An array of pointers to segments with fuel centers.
typedef struct FuelCenter {
	int			Type;
	int			segnum;
	byte			Flag;
	byte			Enabled;
	byte			Lives;			//	Number of times this can be enabled.
	byte			dum1;
	fix 			Capacity;
	fix			MaxCapacity;
	fix			Timer;
	fix			Disable_time;		//	Time until center disabled.
	vms_vector	Center;
} FuelCenter;

// The max number of robot centers per mine.
#define MAX_ROBOT_CENTERS  20	

typedef struct matcen_info {
	int			robot_flags;		// Up to 32 different robots
	fix			hit_points;			// How hard it is to destroy this particular matcen
	fix			interval;			// Interval between materialogrifizations
	short			segnum;				// Segment this is attached to.
	short			fuelcen_num;		// Index in fuelcen array.
} matcen_info;
