#include "types.h"
#include "vecmat.h"
#include "segment.h"
#include "gameseg.h"
#include "aistruct.h"
#include "gr.h"
#include "piggy.h"

/*
 *		CONSTANTS
 */

#define MAX_OBJECTS			350		//increased on 01/24/95 for multiplayer. --MK;  total number of objects in world

//Object types
#define OBJ_NONE		255	//unused object
#define OBJ_WALL		0		//A wall... not really an object, but used for collisions
#define OBJ_FIREBALL	1		//a fireball, part of an explosion
#define OBJ_ROBOT		2		//an evil enemy
#define OBJ_HOSTAGE	3		//a hostage you need to rescue
#define OBJ_PLAYER	4		//the player on the console
#define OBJ_WEAPON	5		//a laser, missile, etc
#define OBJ_CAMERA	6		//a camera to slew around with
#define OBJ_POWERUP	7		//a powerup you can pick up
#define OBJ_DEBRIS	8		//a piece of robot
#define OBJ_CNTRLCEN	9		//the control center
#define OBJ_FLARE		10		//a flare
#define OBJ_CLUTTER	11		//misc objects
#define OBJ_GHOST		12		//what the player turns into when dead
#define OBJ_LIGHT		13		//a light source, & not much else
#define OBJ_COOP		14		//a cooperative player object.
#define MAX_OBJECT_TYPES	15

//Result types
#define RESULT_NOTHING	0		//Ignore this collision
#define RESULT_CHECK		1		//Check for this collision

//Control types - what tells this object what do do
#define CT_NONE			0	//doesn't move (or change movement)
#define CT_AI				1	//driven by AI
#define CT_EXPLOSION		2	//explosion sequencer
#define CT_FLYING			4	//the player is flying
#define CT_SLEW			5	//slewing
#define CT_FLYTHROUGH	6	//the flythrough system
#define CT_WEAPON			9		//laser, etc.
#define CT_REPAIRCEN		10	//under the control of the repair center
#define CT_MORPH			11	//this object is being morphed
#define CT_DEBRIS			12	//this is a piece of debris
#define CT_POWERUP		13	//animating powerup blob
#define CT_LIGHT			14	//doesn't actually do anything
#define CT_REMOTE			15 //controlled by another net player
#define CT_CNTRLCEN		16	//the control center/main reactor 

//Movement types
#define MT_NONE			0	//doesn't move
#define MT_PHYSICS		1	//moves by physics
#define MT_SPINNING		3	//this object doesn't move, just sits and spins

//Render types
#define RT_NONE			0	//does not render
#define RT_POLYOBJ		1	//a polygon model
#define RT_FIREBALL		2	//a fireball
#define RT_LASER			3	//a laser
#define RT_HOSTAGE		4	//a hostage
#define RT_POWERUP		5	//a powerup
#define RT_MORPH			6	//a robot being morphed
#define RT_WEAPON_VCLIP	7	//a weapon that renders as a vclip

//misc object flags
#define OF_EXPLODING			1		//this object is exploding
#define OF_SHOULD_BE_DEAD	2		//this object should be dead, so next time we can, we should delete this object.
#define OF_DESTROYED			4		//this has been killed, and is showing the dead version
#define OF_SILENT				8		//this makes no sound when it hits a wall.  Added by MK for weapons, if you extend it to other types, do it completely!
#define OF_ATTACHED			16		//this object is a fireball attached to another object
#define OF_HARMLESS			32		//this object does no damage.  Added to make quad lasers do 1.5 damage as normal lasers.

//Different Weapon ID types...
#define WEAPON_ID_LASER			0
#define WEAPON_ID_MISSLE		1
#define WEAPON_ID_CANNONBALL	2

//Object Initial shields...
#define OBJECT_INITIAL_SHIELDS F1_0/2

//physics flags
#define PF_TURNROLL		0x01		// roll when turning
#define PF_LEVELLING		0x02		// level object with closest side
#define PF_BOUNCE			0x04		// bounce (not slide) when hit will
#define PF_WIGGLE			0x08		// wiggle while flying
#define PF_STICK			0x10		// object sticks (stops moving) when hits wall
#define PF_PERSISTENT	0x20		// object keeps going even after it hits another object (eg, fusion cannon)
#define PF_USES_THRUST	0x40		// this object uses its thrust

#define	IMMORTAL_TIME	0x3fffffff	//	Time assigned to immortal objects, about 32768 seconds, or about 9 hours.

extern char	Object_type_names[MAX_OBJECT_TYPES][9];

//	List of objects rendered last frame in order.  Created at render time, used by homing missiles in laser.c
#define	MAX_RENDERED_OBJECTS	50
extern short Ordered_rendered_object_list[MAX_RENDERED_OBJECTS];
extern int Num_rendered_objects;

/*
 *		STRUCTURES
 */

//	A compressed form for sending crucial data about via slow devices, such as modems and buggies.
typedef struct shortpos {
	byte	bytemat[9];
	short	xo,yo,zo;
	short	segment;
	short velx, vely, velz;
} shortpos;

//	This is specific to the shortpos extraction routines in gameseg.c.
#define	RELPOS_PRECISION	10
#define	MATRIX_PRECISION	9
#define	MATRIX_MAX			0x7f		//	This is based on MATRIX_PRECISION, 9 => 0x7f

//information for physics sim for an object
typedef struct physics_info {
	vms_vector	velocity;		//velocity vector of this object
	vms_vector	thrust;			//constant force applied to this object
	fix			mass;				//the mass of this object
	fix			drag;				//how fast this slows down
	fix			brakes;			//how much brakes applied
	vms_vector	rotvel;			//rotational velecity (angles)
	vms_vector	rotthrust;		//rotational acceleration
	fixang		turnroll;		//rotation caused by turn banking
	ushort		flags;			//misc physics flags
} physics_info;

//stuctures for different kinds of simulation

typedef struct laser_info {
	short			parent_type;	 	// The type of the parent of this object
	short			parent_num; 		// The object's parent's number
	int			parent_signature;	// The object's parent's signature...
	fix			creation_time;		//	Absolute time of creation.
	short			last_hitobj;		//	For persistent weapons (survive object collision), object it most recently hit.
	short			track_goal;			//	Object this object is tracking.
	fix			multiplier;			//	Power if this is a fusion bolt (or other super weapon to be added).
} laser_info;

typedef struct explosion_info {
	fix			spawn_time;			// when lifeleft is < this, spawn another
	fix			delete_time;		// when to delete object
	short			delete_objnum;		// and what object to delete
	short			attach_parent;		// explosion is attached to this object
	short			prev_attach;		// previous explosion in attach list
	short			next_attach;		// next explosion in attach list
} explosion_info;

typedef struct light_info {
	fix			intensity;		//how bright the light is
} light_info;

typedef struct powerup_info {
	int			count;			//how many/much we pick up (vulcan cannon only?)
} powerup_info;

typedef struct vclip_info {
	int			vclip_num;
	fix			frametime;
	byte			framenum;
} vclip_info;

//structures for different kinds of rendering

typedef struct polyobj_info {
	int			model_num;						//which polygon model
	vms_angvec	anim_angles[MAX_SUBMODELS];	//angles for each subobject
	int			subobj_flags;					//specify which subobjs to draw
	int			tmap_override;					//if this is not -1, map all face to this
	byte			alt_textures;					//if not -1, use these textures instead
} polyobj_info;

typedef struct object {
	int			signature;		// Every object ever has a unique signature...
	ubyte			type;				// what type of object this is... robot, weapon, hostage, powerup, fireball
	ubyte			id;				// which form of object...which powerup, robot, etc.
	short			next,prev;		// id of next and previous connected object in Objects, -1 = no connection
	ubyte			control_type;  // how this object is controlled
	ubyte			movement_type; // how this object moves
	ubyte			render_type;	//	how this object renders
	ubyte			flags;			// misc flags
	short			segnum;			// segment number containing object
	short			attached_obj;	// number of attached fireball object
	vms_vector  pos;				// absolute x,y,z coordinate of center of object
	vms_matrix  orient;			// orientation of object in world
	fix			size;				// 3d size of object - for collision detection
	fix			shields; 		// Starts at maximum, when <0, object dies..
	vms_vector  last_pos;		// where object was last frame
	byte			contains_type;	//	Type of object this object contains (eg, spider contains powerup)
	byte			contains_id;	//	ID of object this object contains (eg, id = blue type = key)
	byte			contains_count;// number of objects of type:id this object contains
	byte			matcen_creator;//	Materialization center that created this object, high bit set if matcen-created
	fix			lifeleft;		// how long until goes away, or 7fff if immortal
	

	//movement info, determined by MOVEMENT_TYPE
	union {
		physics_info phys_info;			//a physics object
		vms_vector	 spin_rate;			//for spinning objects
	} mtype;

	//control info, determined by CONTROL_TYPE
	union {								
		laser_info 		laser_info;
		explosion_info	expl_info;		//NOTE: debris uses this also
		ai_static		ai_info;
		light_info		light_info;		//why put this here?  Didn't know what else to do with it.
		powerup_info	powerup_info;
	} ctype;

	//render info, determined by RENDER_TYPE
	union {
		polyobj_info pobj_info;			//polygon model
		vclip_info	 vclip_info;		//vclip
	} rtype;

} object;

typedef struct obj_position {
	vms_vector  pos;				// absolute x,y,z coordinate of center of object
	vms_matrix  orient;			// orientation of object in world
	short			segnum;			// segment number containing object
} obj_position;	

