//	Constants indicating currently moving forward or backward through path.
//	Note that you can add aip->direction to aip_path_index to get next segment on path.
#define	AI_DIR_FORWARD		1
#define	AI_DIR_BACKWARD	(-AI_DIR_FORWARD)

//	Behaviors
#define	AIB_STILL						0x80
#define	AIB_NORMAL						0x81
#define	AIB_HIDE							0x82
#define	AIB_RUN_FROM					0x83
#define	AIB_FOLLOW_PATH				0x84
#define	AIB_STATION						0x85

#define	MIN_BEHAVIOR	0x80
#define	MAX_BEHAVIOR	0x85

//	Constants defining meaning of flags in ai_state
#define	MAX_AI_FLAGS	11					//	This MUST cause word (4 bytes) alignment in ai_static, allowing for one byte mode

//	This is the stuff that is permanent for an AI object and is therefore saved to disk.
typedef struct ai_static {
	ubyte			behavior;					// 
	byte			flags[MAX_AI_FLAGS];		// various flags, meaning defined by constants
	short			hide_segment;				//	Segment to go to for hiding.
	short			hide_index;					//	Index in Path_seg_points
	short			path_length;				//	Length of hide path.
	short			cur_path_index;			//	Current index in path.

	short			follow_path_start_seg;	//	Start segment for robot which follows path.
	short			follow_path_end_seg;		//	End segment for robot which follows path.

	int			danger_laser_signature;
	short			danger_laser_num;

} ai_static;
