; This procedure will be called every time civ.exe checkes the improvement
; of a map field. It tests if the field positions are contained in the
; improvement list. If they are found then it simulates an improvement,
; if there normally would be none and vice versa.
; Besides it fetches the 'masterword' by which civ.exe normally calculates
; whether a field is improved or not and writes it to the variable masterw
; of the main Turbo Pascal program civ_map2.pas. It uses that above the
; position where you have build in the int F2h call civ.exe calculates the
; normal improvement state of a field. 21h bytes above the new int F2h
; call you can find the pointer to that 'masterw'.

data       segment word public
           extrn counter : word, x : word, y : word, masterw : word
data ends          

code       segment word public
           assume cs:code, ds : data
           public civint2;

civint2     proc far
            cmp ax, cx           ; these commands has been overwritten
            je l0                ; in civ.exe while inserting the int F2 call
            sub ax, ax
            jmp l1
l0:         mov ax, 0001h
l1:         push di              ; start of the real procedure
            mov di, sp
            push bx
            push cx
            push si
            push ds
            push es
            mov si, ss:[di+4]    ; fetch segment address of int F2h call
            mov es, si           ;    from stack
            mov si, ss:[di+2]    ; fetch offset address of int F2h call
            sub si, 21h          ; jump 21h bytes back in civ.exe code
            mov bx, es:[si]      ; get pointer on 'masterword'
            mov si, ds           ; ds register of civ.exe -> es
            mov es, si
            mov si, data         ; get data segment of variable masterw
            mov ds, si
            mov cx, es:[bx]      ; get 'masterword'
            mov masterw, cx      ; write it to variable masterw
            mov si, 0fffeh       ; si : pointer in coordinate lists
            mov cx, counter      ; loop counter cx starts at list length
                                 ;     'counter'
l2:         add si, 02h
            dec cx
            jl l3                ; loop finished ?
            mov bx, x[si]        ; get element of list of x positions
            cmp bx, ss:[bp+8]    ; compare with x position of map field
            jne l2
            mov bx, y[si]        ; the same with y position
            cmp bx, ss:[bp+0ah]
            jne l2               ; found ?
            xor ax, 0001h        ; if yes: change ax (ax=0: not improve,
l3:         pop es               ;                    ax=1: improve)
            pop ds
            pop si
            pop cx
            pop bx
            mov sp, di
            pop di
            iret                 ; that's all
civint2     endp

code        ends
            end
