#include <stdio.h>
#include "common.h"

int	x, y;		/* sizes according to original .dat file */
int	tx, ty;		/* sizes according to .hex file */
int	auxload = 0;	/* true if tx/ty set */
int	size;		/* original map total size */

int	player[6];	/* active players */

main(argc, argv)
int	argc;
char	**argv;
{
 if (argc != 3)
 {
  fprintf(stderr,"Usage: %s file.dat (old) file.dat (new) \n",argv[0]);
  exit(1);
 }

 data_load();
 dsc2map(argv[1],argv[2]);
}

byte	string2byte();
byte	color2byte();

int	dsc2map(orig,evol)
char	*orig, *evol;
{
 size = file_load(orig);
 /* try to load file into memory buffer */

 if (size <= 0)
 {
  fprintf(stderr,"dsc2map(): failed to load %s map.\n",orig);
  exit(1);
 }

 x = databuffer[0x266];
 y = databuffer[0x268];
 /* get original x/y sizes */

 t2m(IN_TERR_FILE);	/* write into auxl */
 o2m(IN_OBJE_FILE);	/* write into auxl */
 v2m(IN_UNIT_FILE); 	/* write into auxl */
 s2m(IN_SHOP_FILE); 	/* write into auxl */
 p2m(IN_PROD_FILE); 	/* write into data */

 fprintf(stdout,".hex file[s] parsed\n");
 fprintf(stdout,".txt file[s] parsed\n");

 wake_up();

 file_save(evol);

 if ((tx != x) || (ty != y))
  fprintf(stdout,"dsc2map(): warning - %s has new row/col size.\n",evol);

 return (0);
}

int	wake_up()
{
 int	loop;
 byte	list = 0;

 for (loop=0; loop<6; loop++)
 {
  if (player[loop] == 1)
  {
   list = list | color2byte(loop);
   fprintf(stdout," player #%d up\n",loop);
  }
 }
 databuffer[0x123] = list;
 /* store value */
}

int	v2m(v)
char	*v;
{
 int	cd, offset, p, fx, fy;
 byte	b0, b1;
 FILE	*fv, *fopen();
 int	co, ly;
 char	unit[3];

 unit[2] = '\0';

 fv = fopen(v,"r");
 /* open vehicle file */

 if (fv == NULL)
 {
  fprintf(stderr,"v2m(): unable to open %s vehicle file\n",v);
  exit(1);
 }

 fgets(textline1,LINSIZE,fv);
 /* read 1st line */

 fscanf(fv,"%s %d %s %d\n",textline1,&fy,textline2,&fx);
 /* read rows/cols sizes */

 if (auxload == 0)
 {
  tx = fx;
  ty = fy;
  auxload = 1;
 }
 else
 {
  if ((fx != tx) || (fy != ty))
  {
   fprintf(stderr,"v2m(): mismatch between .hex files\n");
   fprintf(stderr,"v2m(): x %d y %d (data) x %d y %d (file)\n",tx,ty,fx,fy);
   fclose(fv);
   exit(1);
  }
 }
 /* x/y test between previous sizes */

 cd = tx*ty*4;
 /* offset to vehicle segment */

 fgets(textline1,LINSIZE,fv);
 /* read 3rd line */

 for (ly=0; ly<ty; ly++)
 {
  fgets(textline1,LINSIZE,fv);
  fgets(textline2,LINSIZE,fv);
  /* read two lines */

  offset = tx*2*ly;
  /* set offset */

  for (p=0; p<tx; p++)
  {
   if (p % 2)
   {
    unit[0] = textline2[3+p*3];
    unit[1] = textline2[4+p*3];
    co = textline2[5+p*3]-'0';
   }
   else
   {
    unit[0] = textline1[3+p*3];
    unit[1] = textline1[4+p*3];
    co = textline1[5+p*3]-'0';
   }
   /* the unit */

   if (unit[0] != ' ')
   {
    b0 = string2byte(unit);
    b1 = 255;
    if (b0 == 255)
     fprintf(stderr,"v2m(): unit '%s' at row %d col %d unknown\n",unit,ly,p);
    else
     b1 = color2byte(co);
    auxlbuffer[cd+offset+p*2]   = b0;
    auxlbuffer[cd+offset+p*2+1] = b1;

    if ((co<6) && (co>=0))
     player[co] = 1;
    /* wake up this player */
   }
   else
   {
    auxlbuffer[cd+offset+p*2]   = 255;
    auxlbuffer[cd+offset+p*2+1] = 255;
   }
  }
 }
 fclose(fv);
}

byte	color2byte(color)
int	color;
{
 byte	b1;

 switch(color)
 {
  case 0:
   b1 = 1;
   break;

  case 1:
   b1 = 2;
   break;

  case 2:
   b1 = 4;
   break;

  case 3:
   b1 = 8;
   break;
 
  case 4:
   b1 = 16;
   break;

  case 5:
   b1 = 32;
   break;

  default:
   b1 = 64;
   break;
 }

 return (b1);
}

int	string2object(s,b0,b1)
char	*s;
byte	*b0, *b1;
{
 int	loop, reply = 0;

 for (loop=0; loop<OBJEs; loop++)
 {
  if ((s[0] == obje_idx[loop][0]) &&
      (s[1] == obje_idx[loop][1]) &&
      (s[2] == obje_idx[loop][2]))
  {
   reply = 1;
   *b0 = obje_cde[loop][0];
   *b1 = obje_cde[loop][1];
   break;
  }
 }
 return (reply);
}

int	string2terrain(s,b0,b1)
char	*s;
byte	*b0, *b1;
{
 int	loop, reply = 0;

 for (loop=0; loop<TERRs; loop++)
 {
  if ((s[0] == terr_idx[loop][0]) &&
      (s[1] == terr_idx[loop][1]) &&
      (s[2] == terr_idx[loop][2]))
  {
   reply = 1;
   *b0 = terr_cde[loop][0];
   *b1 = terr_cde[loop][1];
   break;
  }
 }
 return (reply);
}

byte	string2byte(s)
char	*s;
{
 int	loop, scan, reply = 255;

 for (loop=0; loop<UNITs; loop++)
 {
  if ((s[0] == unit_idx[loop][0]) &&
      (s[1] == unit_idx[loop][1]))
  {
   reply = loop;
   break;
  }
 }
 return (reply);
}

int	file_save(name)
char	*name;
{
 int	displacement;
 int	shops;

 FILE	*fo, *fopen();

 fo = fopen(name,"wb");
 /* open map file */

 if (fo == NULL)
 {
  fprintf(stderr,"file_save(): unable to open %s map file\n",name);
  exit(1);
 }

 databuffer[0x266] = tx;
 databuffer[0x268] = ty;
 /* set new x/y sizes */

 shops = auxlbuffer[4+tx*ty*6] + auxlbuffer[5+tx*ty*6]*256;
 /* how many shops */

 fwrite(databuffer,0x26A,1,fo);
 /* write block #1 (MSSN/MISS) */

 fwrite(auxlbuffer,tx*ty*6+shops*0x50+6,1,fo);
 /* write block #2 (ACTN/SHOP) */

 shops = databuffer[0x26a+4+tx*ty*6] + databuffer[0x26a+5+tx*ty*6]*256;
 /* how many shops */

 displacement = 0x26a+x*y*6+6+shops*0x50;
 /* this must be skipped */

 fwrite(&(databuffer[displacement]),(size-displacement),1,fo);
 /* write block #3 (MAP0/DF00) */

 fprintf(stdout,".dat file[s] ready!\n");

 fclose(fo);
 /* close file */

 return (0);
}

int	file_load(name)
char*	name;
{
 FILE	*tmp, *fopen();

 tmp = fopen(name,"rb");
 if (tmp == NULL)
 {
  fprintf(stderr,"fileload(): unable to open %s map.\n",name);
  exit(1);
 }

 fread(databuffer,BUFSIZE,1,tmp);
 /* read whole file into memory */

 size = ftell(tmp);
 /* file size */

 fclose(tmp);

 fprintf(stdout,".dat file[s] loaded\n"); 
 return(size);
}

int	t2m(v)
char	*v;
{
 int	cd, offset, p, fx, fy;
 byte	b0, b1;
 FILE	*fv, *fopen();
 int	ly, co;
 char	type[4];

 type[3] = '\0';

 fv = fopen(v,"r");
 /* open terrain file */

 if (fv == NULL)
 {
  fprintf(stderr,"t2m(): unable to open %s terrain file\n",v);
  exit(1);
 }

 fgets(textline1,LINSIZE,fv);
 /* read 1st line */

 fscanf(fv,"%s %d %s %d\n",textline1,&fy,textline2,&fx);
 /* read rows/cols sizes */

 if (auxload == 0)
 {
  tx = fx;
  ty = fy;
  auxload = 1;
 }
 else
 {
  if ((fx != tx) || (fy != ty))
  {
   fprintf(stderr,"t2m(): mismatch between .hex files\n");
   fprintf(stderr,"t2m(): x %d y %d (data) x %d y %d (file)\n",tx,ty,fx,fy);
   fclose(fv);
   exit(1);
  }
 }
 /* x/y test between previous sizes */

 cd = 0x0;
 /* offset to terrain segment ( into auxl buffer ) */

 fgets(textline1,LINSIZE,fv);
 /* read 3rd line */

 for (ly=0; ly<ty; ly++)
 {
  fgets(textline1,LINSIZE,fv);
  fgets(textline2,LINSIZE,fv);
  /* read two lines */

  offset = tx*2*ly;
  /* set offset */

  for (p=0; p<tx; p++)
  {
   if (p % 2)
   {
    type[0] = textline2[3+p*3];
    type[1] = textline2[4+p*3];
    type[2] = textline2[5+p*3];
   }
   else
   {
    type[0] = textline1[3+p*3];
    type[1] = textline1[4+p*3];
    type[2] = textline1[5+p*3];
   }
   /* the type */

   if (type[0] != ' ')
   {
    co = string2terrain(type,&b0,&b1);
    if (co == 0)
     fprintf(stderr,"t2m(): terrain '%s' at row %d col %d unknown\n",type,ly,p);
    else
    {
     auxlbuffer[cd+offset+p*2]   = b0;
     auxlbuffer[cd+offset+p*2+1] = b1;
    }
   }
   /* '  ' means the old value */
  }
 }
 fclose(fv);
}

int	o2m(v)
char	*v;
{
 int	cd, offset, fx, fy, p;
 byte	b0, b1;
 FILE	*fv, *fopen();
 int	ly, co;
 char	type[4];

 type[3] = '\0';

 fv = fopen(v,"r");
 /* open object file */

 if (fv == NULL)
 {
  fprintf(stderr,"o2m(): unable to open %s object file\n",v);
  exit(1);
 }

 fgets(textline1,LINSIZE,fv);
 /* read 1st line */

 fscanf(fv,"%s %d %s %d\n",textline1,&fy,textline2,&fx);
 /* read rows/cols sizes */

 if (auxload == 0)
 {
  tx = fx;
  ty = fy;
  auxload = 1;
 }
 else
 {
  if ((fx != tx) || (fy != ty))
  {
   fprintf(stderr,"o2m(): mismatch between .hex files\n");
   fprintf(stderr,"o2m(): x %d y %d (data) x %d y %d (file)\n",tx,ty,fx,fy);
   fclose(fv);
   exit(1);
  }
 }
 /* x/y test between previous sizes */

 cd = tx*ty*2;
 /* offset to object segment */

 fgets(textline1,LINSIZE,fv);
 /* read 3rd line */

 for (ly=0; ly<ty; ly++)
 {
  fgets(textline1,LINSIZE,fv);
  fgets(textline2,LINSIZE,fv);
  /* read two lines */

  offset = tx*2*ly;
  /* set offset */

  for (p=0; p<tx; p++)
  {
   if (p % 2)
   {
    type[0] = textline2[3+p*3];
    type[1] = textline2[4+p*3];
    type[2] = textline2[5+p*3];
   }
   else
   {
    type[0] = textline1[3+p*3];
    type[1] = textline1[4+p*3];
    type[2] = textline1[5+p*3];
   }
   /* the type */

   if (type[0] != ' ')
   {
    co = string2object(type,&b0,&b1);
    if (co == 0)
     fprintf(stderr,"o2m(): object '%s' at row %d col %d unknown\n",type,ly,p);
    else
    {
     auxlbuffer[cd+offset+p*2]   = b0;
     auxlbuffer[cd+offset+p*2+1] = b1;
    }
   }
   else
   {
    auxlbuffer[cd+offset+p*2]   = 255;
    auxlbuffer[cd+offset+p*2+1] = 255;
   }
  }
 }
 fclose(fv);
}

int	p2m(v)
char	*v;
{
 FILE	*fv, *fopen();
 int	loop;
 word	value;

 fv = fopen(v,"r");
 /* open production file */

 if (fv == NULL)
 {
  fprintf(stderr,"p2m(): unable to open %s production file\n",v);
  exit(1);
 }

 fgets(textline1,LINSIZE,fv);
 /* read 1st line */

 for (loop=0; loop<UNITs; loop++)
 {
  fscanf(fv,"%s %d\n",textline1,&value);
  /* retrieve value & string */

  if ((value != 0) && (value != 1) && (value != 2) && (value != 3))
  {
   fprintf(stderr,"p2m(): wrong index %d for unit %s\n",value,textline1);
   exit(1);
  }
 
  databuffer[0x1b2+loop*2] = value;
  /* store data */
 }

 fclose(fv);
 return (0);
}

int	s2m(v)
char	*v;
{
 FILE	*fv, *fopen();
 int	loop, shops, offset, block;
 int	cleaner;
 int	type, row, col;
 char	ctag;
 int	cd_u, cd_o;
 int	cargo, test, unit, j_count, s_count;
 byte	lo, hi;
 word	data;

 fv = fopen(v,"r");
 /* open shop file */

 if (fv == NULL)
 {
  fprintf(stderr,"s2m(): unable to open %s shop file\n",v);
  exit(1);
 }

 cd_o = tx*ty*2;
 /* offset to object segment */

 cd_u = tx*ty*4;
 /* offset to unit segment */

 auxlbuffer[tx*ty*6] = 'S';
 auxlbuffer[tx*ty*6+1] = 'H';
 auxlbuffer[tx*ty*6+2] = 'O';
 auxlbuffer[tx*ty*6+3] = 'P';

 fgets(textline1,LINSIZE,fv);
 /* read 1st line */

 fscanf(fv,"%s %d\n",textline1,&shops);
 /* retrieve value & string */

 auxlbuffer[4+tx*ty*6] = shops % 256; 
 auxlbuffer[5+tx*ty*6] = shops / 256; 
 /* store value in buffer */

 offset = 6+tx*ty*6;
 /* offset to 1st shop */

 for (loop=0; loop<shops; loop++)
 {
  block = offset + loop*0x50;
  /* current offset */

  for (cleaner=0; cleaner < 0x50; cleaner++)
   auxlbuffer[block+cleaner] = 0x00;
  /* clean shop area */

  fscanf(fv,"%s %d\n",textline1,&type);
  /* get shop type (1 or 2) */

  if (strcmp(textline1,"***type") != 0)
  { 
   fprintf(stderr,"s2m(): in shop %d ",loop);
   fprintf(stderr,"expected keyword '***type' found '%s'.\n",textline1);
   exit(1);
  }

  if ((type != 1) && (type != 2))
  { 
   fprintf(stderr,"sm2(): in shop %d ",loop);
   fprintf(stderr,"shop type 1 or 2 found %d.\n",type);
   exit(1);
  }

  auxlbuffer[block] = type;
  /* write type */

  switch(type)
  {
   case 0x01:
    fscanf(fv,"%s %d %d\n",textline1,&row,&col);
    /* get row/col */

    if (strcmp(textline1,"row/col") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'row/col' found '%s'.\n",textline1);
     exit(1);
    }

    if ((row<0) || (row >=ty))
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"row %d outside range [0,(%d-1)]\n",row,ty);
     exit(1);
    }

    if ((col<0) || (col >=tx))
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"col %d outside range [0,(%d-1)]\n",col,tx);
     exit(1);
    }

    data = row*0x40+col;
    auxlbuffer[block+2] = data % 256;
    auxlbuffer[block+3] = data / 256;
    auxlbuffer[block+10] = data % 256;
    auxlbuffer[block+11] = data / 256;
    /* store it */

    fscanf(fv,"%s %c %s\n",textline1,&ctag,textline2);

    if (strcmp(textline1,"object") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'object' found '%s'.\n",textline1);
     exit(1);
    }

    test = 0;
    /* no special test required */

    switch(ctag)
    {
     case 'H':
      auxlbuffer[block+4] = 0x01;
      if (strcmp(textline2,"???") != 0) 
      {
       lo = auxlbuffer[cd_o+tx*row*2+col*2];
       hi = auxlbuffer[cd_o+tx*row*2+col*2+1];
       if (strcmp(textline2,obje_idx[bytes2object(lo,hi)]) != 0)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' obje.hex is different.\n",textline2);
        exit(1);
       }
      }
      break;

     case 'P': 
      auxlbuffer[block+4] = 0x02; 
      if (strcmp(textline2,"???") != 0) 
      {
       lo = auxlbuffer[cd_o+tx*row*2+col*2];
       hi = auxlbuffer[cd_o+tx*row*2+col*2+1];
       if (strcmp(textline2,obje_idx[bytes2object(lo,hi)]) != 0)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' obje.hex is different.\n",textline2);
        exit(1);
       }
      }
      break;

     case 'C': 
      auxlbuffer[block+4] = 0x04; 
      if (strcmp(textline2,"???") != 0) 
      {
       lo = auxlbuffer[cd_o+tx*row*2+col*2];
       hi = auxlbuffer[cd_o+tx*row*2+col*2+1];
       if (strcmp(textline2,obje_idx[bytes2object(lo,hi)]) != 0)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' obje.hex is different.\n",textline2);
        exit(1);
       }
      }
      break;

     case 'T': 
      auxlbuffer[block+4] = 0x08; 
      if (strcmp(textline2,"???") != 0) 
      {
       lo = auxlbuffer[cd_o+tx*row*2+col*2];
       hi = auxlbuffer[cd_o+tx*row*2+col*2+1];
       if (strcmp(textline2,obje_idx[bytes2object(lo,hi)]) != 0)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' obje.hex is different.\n",textline2);
        exit(1);
       }
      }
      break;

     case 'B': 
      auxlbuffer[block+4] = 0x10; 
      if (strcmp(textline2,"???") != 0) 
      {
       lo = auxlbuffer[cd_o+tx*row*2+col*2];
       hi = auxlbuffer[cd_o+tx*row*2+col*2+1];
       if (strcmp(textline2,obje_idx[bytes2object(lo,hi)]) != 0)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' obje.hex is different.\n",textline2);
        exit(1);
       }
      }
      break;

     case 'U': 
      auxlbuffer[block+4] = 0x20; 
      if (strcmp(textline2,"???") != 0) 
      {
       lo = auxlbuffer[cd_u+tx*row*2+col*2];
       hi = auxlbuffer[cd_u+tx*row*2+col*2+1];
       if (lo == 0xff)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' unit.hex is enpty.\n",textline2);
        exit(1);
       }
       if (strcmp(textline2,unit_idx[lo]) != 0)
       { 
        fprintf(stderr,"sm2(): in shop %d ",loop);
        fprintf(stderr,"shop has '%s' unit.hex is different.\n",textline2);
        exit(1);
       }
      }
      test = 1;
      unit = lo;
      /* required cargo test */
      break;

     default:
      fprintf(stderr,"s2m(): in shop %d ",loop);
      fprintf(stderr,"unknown object type '%c'\n",ctag);
      exit(1);
      break;
    }

    fscanf(fv,"%s %c\n",textline1,&ctag);

    if (strcmp(textline1,"struct") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'struct' found '%s'.\n",textline1);
     exit(1);
    }

    switch (ctag)
    { 
     case 'U':
      auxlbuffer[block+0x32] = 0x80;
      break;

     case 'H':
      auxlbuffer[block+0x33] = 0x01;
      break;

     case 'A':
      auxlbuffer[block+0x33] = 0x02;
      break;

     case 'S':
      auxlbuffer[block+0x33] = 0x04;
      break;

     case 'F':
      auxlbuffer[block+0x33] = 0x08;
      break;

     case 'C':
      auxlbuffer[block+0x33] = 0x10;
      break;

     case 'B':
      auxlbuffer[block+0x33] = 0x20;
      break;

     case 'T':
      auxlbuffer[block+0x33] = 0x40;
      break;

     case '?':
      auxlbuffer[block+0x33] = 0x80;
      break;

     default:
      fprintf(stderr,"sm2(): in shop %d ",loop);
      fprintf(stderr,"unknown struct type '%c'\n",ctag);
      exit(1);
      break;
    }

    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"id") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'id' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+8] = type % 256;
    auxlbuffer[block+9] = type / 256;

    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"=energy") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword '=energy' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+12] = type % 256;
    auxlbuffer[block+13] = type / 256;

    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"=raw_mt") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword '=raw_mt' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+14] = type % 256;
    auxlbuffer[block+15] = type / 256;

    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"+energy") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword '+energy' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+16] = (byte)type;

    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"+raw_mt") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword '+raw_mt' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+17] = (byte)type;

    s_count = 0;
    /* slot count */

    cargo = 0;
    /* cargo count */

    for (cleaner=0; cleaner < 32; cleaner++)
     auxlbuffer[block+18+cleaner] = 0xff;

    while (1)
    { 
     fscanf(fv,"%s",textline1);

     if (strcmp(textline1,"<") == 0)
      break;

     if (strcmp(textline1,"slot") != 0)
     { 
      fprintf(stderr,"sm2(): in shop %d ",loop);
      fprintf(stderr,"expected keyword 'slot' found '%s'.\n",textline1);
      exit(1);
     }

     fscanf(fv,"%s\n",textline1);

     type = string2byte(textline1);
     
     if (type == 0xff)
     { 
      fprintf(stderr,"sm2(): in shop %d ",loop);
      fprintf(stderr,"unknown unit found '%s'.\n",textline1);
      exit(1);
     }
     auxlbuffer[block+18+s_count*2] = (byte)type;

     cargo = cargo + unit_siz[type];
     s_count++;

     if (s_count == 16)
      break;
    }
   
    if (test) 
    { 
     if (cargo > unit_cap[unit])
     { 
      fprintf(stdout,"sm2(): warning - shop %d overloaded ",loop);
      fprintf(stdout,"max %d eff %d.\n",unit_cap[unit],cargo);
     }
    }
  
    j_count = 0;
    /* prod count */

    while (1)
    { 
     fscanf(fv,"%s",textline1);

     if (strcmp(textline1,"<") == 0)
      break;

     if (strcmp(textline1,"prod") != 0)
     { 
      fprintf(stderr,"sm2(): in shop %d ",loop);
      fprintf(stderr,"expected keyword 'prod' found '%s'.\n",textline1);
      exit(1);
     }

     fscanf(fv,"%s\n",textline1);

     type = string2byte(textline1);
     
     if (type == 0xff)
     { 
      fprintf(stderr,"sm2(): in shop %d ",loop);
      fprintf(stderr,"unknown unit found '%s'.\n",textline1);
      exit(1);
     }
     auxlbuffer[block+52+j_count*2] = (byte)type;
   
     j_count++;

     if (j_count == 4)
      break;
    }
      
    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"score") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'score' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+0x3e] = type % 256;
    auxlbuffer[block+0x3f] = type / 256;

    fscanf(fv,"%s %d\n",textline1,&type);
    if (strcmp(textline1,"owner") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'owner' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+0x40] = (byte)color2byte(type);

    if ((type<6) && (type>=0))
     player[type] = 1;
    /* wake up this player */

    for (cleaner=0; cleaner<s_count; cleaner++)
     auxlbuffer[block+19+cleaner*2] = 0x00;

    break;

   case 0x02:
    fscanf(fv,"%s %d %d\n",textline1,&row,&col);
    /* get row/col */

    if (strcmp(textline1,"row/col") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'row/col' found '%s'.\n",textline1);
     exit(1);
    }

    if ((row<0) || (row >=ty))
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"row %d outside range [0,(%d-1)]\n",row,ty);
     exit(1);
    }

    if ((col<0) || (col >=tx))
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"col %d outside range [0,(%d-1)]\n",col,tx);
     exit(1);
    }

    data = row*0x40+col;
    auxlbuffer[block+2] = data % 256;
    auxlbuffer[block+3] = data / 256;
    auxlbuffer[block+10] = data % 256;
    auxlbuffer[block+11] = data / 256;
    /* store it */

    fscanf(fv,"%s %d\n",textline1,&data);
    if (strcmp(textline1,"w0x48") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'w0x48' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+0x48] = data % 256;
    auxlbuffer[block+0x49] = data / 256;

    fscanf(fv,"%s %d\n",textline1,&data);
    if (strcmp(textline1,"w0x4a") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'w0x4a' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+0x4a] = data % 256;
    auxlbuffer[block+0x4b] = data / 256;

    fscanf(fv,"%s %d\n",textline1,&data);
    if (strcmp(textline1,"w0x4c") != 0)
    { 
     fprintf(stderr,"sm2(): in shop %d ",loop);
     fprintf(stderr,"expected keyword 'w0x4c' found '%s'.\n",textline1);
     exit(1);
    }
    auxlbuffer[block+0x4c] = data % 256;
    auxlbuffer[block+0x4d] = data / 256;
    break;
  }
 }
 /* parsed all shops */

 fclose(fv);
 return (0);
}

int	bytes2object(b0,b1)
int	b0, b1;
{
 int	d = -1, loop;

 for (loop=0; loop<OBJEs; loop++)
 {
  if ((b0 == obje_cde[loop][0]) && (b1 == obje_cde[loop][1]))
  {
   d = loop;
   break;
  }
 }

 return (d);
}
