/**************************************************************************/
/*                             OFset   Utility                            */
/*                                                                        */
/*                                 M\Cooper                               */
/*                        3425 Chestnut Ridge Rd.                         */
/*                        Grantsville, MD 21536-9801                      */
/*                        --------------------------                      */
/*                        E-mail: thegrendel@aol.com                      */
/*                                                                        */
/*                $2.00 to register the entire WORDY package              */
/*                                                                        */
/**************************************************************************/

#include <conio.h>
#include "srch.h"

#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 8
#define CR "\n"
#define MAXLEN 30
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define WD 8

#define BUFFERSIZE 8192

char ad[] =
"OFset utility by M\\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536";

typedef enum { FALSE, TRUE } Boolean;

void getword( char *lset, char *filename, int l_number );
void center( char *strng );
Boolean wordtest( char *letterset, char *word, int number_of_letters_sel );


void main( int argc, char **argv )
{

   char letterset [ MAXLEN ],
        filename [ MAXLEN ],
        ans [WD];
        int number;

	 if( argc == NOARGS )
	    {
	    clrscr();
	    printf( "Enter a LETTERSET to select from ... " );
	    gets( letterset );
     strcpy( filename, "word.lst" );
     printf( "\nHow many letters to select from %s? ", letterset );
     gets( ans );
     number = atoi( ans );
	    }
	 else
     if( argc == NOARGS + 1 )
	       {
        strcpy( letterset, *( argv + 1 ) );
        strcpy( filename, "word.lst" );
        clrscr();
        printf( "\nHow many letters to select from %s? ", letterset );
        gets( ans );
        number = atoi( ans );
        }
   else
      if( argc == NOARGS + 2 )
        {
        strcpy( letterset, *( argv + 1 ) );
        number = atoi( *( argv + 2 ) );
        strcpy( filename, "word.lst" );
        }

   else
     {
     strcpy( letterset, *( argv + 1 ) );
     number = atoi( *( argv + 2 ) );
     strcpy( filename,  *( argv + 3 ) );
     }

	 getword( letterset, filename, number );
}



Boolean wordtest( char *letterset, char *word, int lnumber )
{
   int hits = 0;

      while( *letterset )
         {
         if( strchr( word, *letterset ) )
            hits++;

         letterset++;
         }
      
      if( hits >= lnumber )
         return( TRUE );
      else
         return( FALSE );
}

/*************************************************************/
void getword( char *letter_set, char *filename, int number )
{

	char	l_set [ MAXLEN ],
		word [ MAXLEN ],
		tempstr [ LINE_LEN + 1 ],
		targetfile [ MAXLEN ],
		bar [ LINE_LEN + 1 ],
   wd [ WD ],
		double_bar [ LINE_LEN + 1 ],
  file_suffix[] = ".ofs";

	FILE *fptr,
		*tfile;
	int fnamelen;
	long wcount = 0L;

	   memset( bar, '-', LINE_LEN );
	   *( bar + LINE_LEN ) = NULL;
	   memset( double_bar, '=', LINE_LEN );
	   *( double_bar + LINE_LEN ) = NULL;

      strcpy( l_set, letter_set);

	   /*************opening credits*****************************/
	   clrscr();
	   printf( double_bar );
	   strcpy( tempstr, ad );
	   center ( tempstr );
	   printf( tempstr );
	   printf( CR );
	   printf( double_bar );
	   printf( CR );
	   /*********************************************************/
	   /*   Create name of file to store derived words in       */
	   /*********************************************************/
	   fnamelen = strlen( l_set );
	   if( fnamelen  > FILENAME_MAXLEN )
		  fnamelen = FILENAME_MAXLEN;
	   strncpy( targetfile, l_set, fnamelen );
	   *( targetfile + fnamelen ) = NULL;
	   //NULL-terminate string, so strcat works, ha, ha.
	   strcat( targetfile, file_suffix );
	  /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open Wordfile!" );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 1 );

	   if( !( tfile = fopen( targetfile, "wt" ) ) )
		 {
		 printf( "\7\7\7Cannot open file to save words in!" );
		 exit ( FILE_OPENING_ERROR + 2 );
		 }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_OPENING_ERROR + 3 );

	   /**************'Wait' Message************/
	   printf( CR CR );
	   printf( "WORKING...\n\n" );
	   printf( "This will take from 10 seconds or less [fast 486 machine]\n" );
	   printf( "to 5 minutes or more [slow 8088 with old hard drive].\n\n" );
	   printf( "Now searching 99,000+ word file \nand writing file of valid words containing at least %d letters of -%s-.\n\n", 
            number, letter_set );
	   /*****************************************/





	   sprintf( tempstr, "Words selected with at least %d letters from: %s.\n",
            number, strupr( l_set ) );
	   center( tempstr );
	   fprintf( tfile, double_bar );
      fprintf( tfile, CR );
	   fprintf( tfile, tempstr );
	   fprintf( tfile, double_bar );
	   fprintf( tfile, CR );


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )

			if( wordtest( letter_set, word, number ) )
			   {
			   fprintf( tfile, "%s", word );
			   wcount++;
			   }
		  /*******************************************/

      if( wcount == 1 )
          strcpy( wd, "word" );
      else 
          strcpy( wd, "words" );

		  fprintf( tfile, bar );
      fprintf( tfile, CR );
		  sprintf( tempstr, "%ld %s can be constructed using at least %d letters from %s.",
				 wcount, wd, number, l_set );
		  center( tempstr );		      
		  fprintf( tfile, tempstr );
		  fprintf( tfile, "\n\n" );

		  center( ad );
		  fprintf( tfile, ad );

		  fcloseall();

		  sprintf( tempstr,
				 "The file %s has %ld %s containing at least %d letters of %s\7.\n\n",
				 targetfile, wcount, wd, number, l_set );
		  center( tempstr );
		  printf( CR CR );
		  printf( tempstr );

}



void center( char *str )
{
   int padding;
   char st [ LINE_LEN + INCREMENT ];

	 padding = LINE_LEN / 2 - strlen( str ) / 2;
	 memset( st, SPACE, padding );
	 *( st + padding ) = NULL;  //Terminate string
	 strcat( st, str );
	 strcpy( str, st );

	 return;
}
