PROGRAM STRYKER;
USES DOS, CRT, UTILS, Graph, VGAPal60;
  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=Star  Stryker=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
  {                              Yang Liu                               }
  {                    A Text Based adventure Game                      }
  {  NOTICE: This game requires ANSI.SYS or another ANSI drivers to     }
  {          execute, or the screens will look messy. Look for ANSI     }
  {          drivers on your local Bulletin Board,  or ask a friend     }
  {          for them.                                                  }
  {                                                                     }
  {  DISCLAMER:  I do not take any responsibility for any system        }
  {              malfunction from  this game,  though I strongly        }
  {              doubt that that will happen.                           }
  {                                                                     }
  {  SHAREWARE:  This version is SHAREWARE, It must be registered       }
  {              within 15 days or you will face legal charges.         }
  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
  {                       PROCEDURES DICTIONARY                         }
  {                                                                     }
  {  *.SCR                                                              }
  {            Different Screens of this Game                           }
  {                                                                     }
  {  UNIT UTILS                                                         }
  {    LineClear       : Clears a line with a certain length            }
  {    ShowDirection   : Shows the user what direction he can go        }
  {    ClearMessage    : Clears the message box                         }
  {    ClearLocation   : Clears the location box                        }
  {    ClearOption     : Clears the options box                         }
  {    Noway           : Tell the user that he/she can't go there       }
  {                                                                     }
  {  PROGRAM STRYKER.PAS                                                }
  {    InitializeGraphics                                               }
  {                    : Ready the game to display graphics             }
  {    Initialize      : Initializes the Game. Gives value to some of   }
  {                      the variables                                  }
  {    Hitpoint        : Calculate the Hitpoints of the USER            }
  {    EndingScreen    : Display Unregistered Shareware notice          }
  {    DisplayStatus   : Displays the user's status                     }
  {    DisplayStartup  : Displays The startup                           }
  {    DrawPCX         : Loads and views PCX Files                      }
  {    QuestionUser    : Asks the user questions                        }
  {    DisplayStory    : Displays the story to the user                 }
  {    DisplayMenu     : Displays the game's menu                       }
  {    CheckInventory  : Checks the user's inventory and marks the      }
  {                      appropriate box with a                        }
  {    Options         : Lets the user load/save game                   }
  {    InitializeRoom  : Initializes the Room                           }
  {    MazeDesc        : Initializes the description of the maze        }
  {    Die             : Tells the user that he/she died and display    }
  {    TrapsNTreasures : Used in the maze, can either give user credits }
  {                      or deduct hitpoints.                           }
  {    BeatGame        : Tells the user that he/she won the game        }
  {    TrappedRoom     : Tell user that the room he/she is in is trapped}
  {                                                                     }
  {    Rooms;                                                           }
  {    Shop            : A shop where the user can buy things           }
  {       TheShop      : Actual Place where you buy things              }
  {    Start           : Where the user starts out                      }
  {    Room1 - Room18  : Level One rooms                                }
  {    PM1 - PM48      : Level Two Thru Level Three rooms               }
  {    Lab             : Lab where Shadow's Computer is located         }
  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
  {                           Functions Index                           }
  {                                                                     }
  {    DetectVGA       : Detects the VGA                                }
  {    FileExists      : Sees if a file exists or not (Used Save/Load)  }
  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}


TYPE
   ScreenType = ARRAY [0..3999] OF Byte;
   String10   = String [10];
   Objects    = (FlashLight, LaserPistol, Parachute, Shovel, Canteen,
   RGem, GGem, BGem, LaserDisc, CompKey);
   GotEm      = ARRAY [FlashLight..Compkey] OF Boolean;
   String12   = String [12];
   Rooms      = (START, R1, R2, R3, R4, R5, R6, R7, R8, R9, R10, R11, R12,
   R13, R14, R15, R16, R17, R18, M1, M2, M3, M4, M5, M6, M7,
   M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19,
   M20, M21, M22, M23, M24, M25, M26, M27, M28, M29, M30, M31,
   M32, M33, M34, M35, M36, M37, M38, M39, M40, M41, M42, M43,
   M44, M45, M46, M47, M48, LAB, SHOP);
   Actions    = (ShieldOn, DigBox, DigRgem, DigGgem, DigBgem, DiskWithInfo,
   ComputerBlewUp, UserDied, WaterInCanteen, FoundPotions,
   VirusOnDisk, North, South, East, West, GameDone, Done,
   WaterSplashed, Quit, ComputerUse);
   DoneThat   = ARRAY [ShieldOn..ComputerUse] OF Boolean;
   
VAR
  {Miscellaneous Section of Variables}
   Screen            : ScreenType ABSOLUTE $B800: 0000;
   ItemCheck         : GotEm;
   Location          : Rooms;
   DoneAction        : DoneThat;
   AutoDetectPointer : Pointer;
   BPointer          : Pointer;
   GraphDriver, Mode : Integer;
   ErrorCode         : Integer;
   X, Y              : Integer;
   Size              : Word;
   Cheat             : Boolean;
   
  {String    Section of Variables}
   Name,
   Race      : String [12];
   Filename  : String12;
   DEATH1,
   DEATH2,
   DEATH3,
   DEATH4    : String [69];
   CH : Char;
   
  {Integer Section of Variables}
   Gender,
   Male,
   Female,
   THP,
   CHP,
   Wounds,
   Potions,
   Credits           : Integer;
   
  {-=-=-=-=-=-DetectVGA256-=-=-=-=-=-}
  {$F+}
FUNCTION DetectVGA256 : Integer;
VAR
   DetectedDriver : Integer;
   SuggestedMode  : Integer;
BEGIN
   DetectGraph (DetectedDriver, SuggestedMode);
   IF (DetectedDriver = VGA) OR (DetectedDriver = MCGA) THEN
      DetectVGA256 := 0
   ELSE
      DetectVGA256 := grError;
END;
  {$F-}

  {-=-=-=-=-=-FileExists-=-=-=-=-=-}
  FUNCTION FileExists (FileName: String)
                                : Boolean;
  { Returns True if file exists; otherwise,
  it returns False. Closes the file if
  it exists. }
VAR
   f: File;
BEGIN
  {$I-}
   Assign (f, FileName);
   Reset (f);
   Close (f);
  {$I+}
   FileExists := (IORESULT = 0) AND
   (FileName <> '');
END;    { FileExists }

  {-=-=-=-=-=-Initialize Graphics-=-=-=-=-=-}
PROCEDURE InitializeGraphics;
BEGIN
   ClrScr;
   DirectVideo := FALSE;
   AutoDetectPointer := @DetectVGA256;
   GraphDriver := INSTALLUSERDRIVER ('VGA256', AutoDetectPointer);
BEGIN
   AutoDetectPointer := @DetectVGA256;
   GraphDriver := INSTALLUSERDRIVER ('VGA256', AutoDetectPointer);
END;
    GraphDriver := Detect;
    InitGraph (GraphDriver, Mode, 'VGA256');
  Size := IMAGESIZE (0, 0, 199, 7);
  GetMem (BPointer, Size);
END;

  {-=-=-=-=-=-Initialize Game-=-=-=-=-=-}
PROCEDURE Initialize;
VAR
   ItemCounter   : Objects;
   ActionCounter : Actions;
BEGIN
   Gender                := 3;
   Male                  := 1;
   Female                := 2;
   Potions               := 5;
   Credits               := 100;
   Location              := START;
   FOR ItemCounter := FlashLight TO CompKey DO
      ItemCheck [ItemCounter]  := FALSE;
   FOR Actioncounter := ShieldOn TO ComputerUse DO
      DoneAction [ActionCounter] := FALSE;
   DoneAction [ShieldOn]        := TRUE;
END; (* Initialize *)

  {-=-=-=-=-=-Hitpoint-=-=-=-=-=-}
PROCEDURE Hitpoints;
BEGIN
   Randomize;
   THP   := (RANDOM (10) ) + 20;
   IF PARAMSTR (1) = '/Cheat' THEN Cheat := TRUE;
   CHP   := THP;
   
END; (* HitPoints *)

  {-=-=-=-=-=-Ending Screen-=-=-=-=-=-}
  {$I REGISTER.SCR}
PROCEDURE EndingScreen;
BEGIN
   ClrScr;
   TextBackground (Black);
   TextColor (White);
   Move (REGISTER, SCREEN, 4000);
   GotoXY (1, 25);
   Halt;
END; (* EndingScreen *)

  {-=-=-=-=-=-Display User Info-=-=-=-=-=-}
PROCEDURE DisplayStatus;
BEGIN
   GotoXY (33, 11); Write (Name);
   GotoXY (33, 12); Write (Race);
   GotoXY (33, 13); IF Gender = Female THEN Write ('Female')
   ELSE Write ('Male');
   GotoXY (33, 14); Write ('           ');
   GotoXY (33, 14); Write (CHP, '/', THP);
END; (* DisplayStatus *)

  {-=-=-=-=-=-Display The Introduction-=-=-=-=-=-}
  {$I intro.scr} ;
PROCEDURE DisplayStartup;
BEGIN
   Move (Intro, Screen, 4000);
END; (* DisplayStartup *)

  {-=-=-=-=-=-DrawPCX-=-=-=-=-=-}
PROCEDURE DrawPCX (filename : String12);
BEGIN
   InitializeGraphics;
   Size := IMAGESIZE (0, 0, 199, 7);
   GetMem (BPointer, Size);
   SetpalBlack;
   Read256PCX (filename);
   FadeinPalblack (50);
   SavePal;
   Proceed := READKEY;
   FadeOutPalBlack (99);
END;

  {-=-=-=-=-=-Ask User for Information-=-=-=-=-=-}
PROCEDURE QuestionUser;
BEGIN
   TextBackground (White);
   TextColor      (Yellow);
   REPEAT
      LineClear (14, 17, 55);
      GotoXY        (14, 17);
      Write         ('Enter your name: ');
      ReadLn        (Name);
   UNTIL Name <> ('');
   REPEAT
      LineClear (14, 17, 55);
      GotoXY (14, 17);
      Write         ('Enter your type of race, ', Name, ': ');
      ReadLn        (Race);
   UNTIL Race <> ('');
   REPEAT
      LineClear (14, 17, 55);
      GotoXY (14, 17);
      Write      ('Are you a (M)ale or (F)emale: ');
      CH := READKEY;
      CASE UPCASE (CH) OF
         'M'  : Gender := Male;
         'F'  : Gender := Female;
      END; (* Case *)
   UNTIL Gender <= 2
END; (* QuestionUser *)

  {-=-=-=-=-=-Display Story Introduction-=-=-=-=-=-}
  {$I story.scr}
PROCEDURE DisplayStory;
BEGIN
   Move (Story, Screen, 4000);
   CH := READKEY;
END; (* DisplayStory *)

  {-=-=-=-=-=-Display Menu-=-=-=-=-=-}
  {$I menu.scr}
PROCEDURE DisplayMenu;
BEGIN
   Move (Menu, Screen, 4000);
   DisplayStatus;
END; (* DisplayMenu *)

  {-=-=-=-=-=-Check Inventory-=-=-=-=-=-}
PROCEDURE CheckInventory;
BEGIN
   TextColor (Blue);
  {Check for FlashLight}
   GotoXY (20, 12);
   IF ItemCheck [Flashlight]    = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Laserpistol}
   GotoXY (20, 13);
   IF ItemCheck [LaserPistol]   = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Parachute}
   GotoXY (20, 14);
   IF ItemCheck [Parachute]     = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Shovel}
   GotoXY (20, 15);
   IF ItemCheck [Shovel]        = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Canteen}
   GotoXY (20, 16);
   IF ItemCheck [Canteen]       = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Red Gem}
   GotoXY (20, 17);
   IF ItemCheck [RGem]          = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Green Gem}
   GotoXY (20, 18);
   IF ItemCheck [GGem]          = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Blue Gem}
   GotoXY (20, 19);
   IF ItemCheck [BGem]          = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Laser Disc}
   GotoXY (20, 20);
   IF ItemCheck [LaserDisc]     = TRUE THEN WriteLn ('')
   ELSE Write (' ');
  {Check for Computer Key}
   GotoXY (20, 21);
   IF ItemCheck [CompKey]       = TRUE THEN WriteLn ('')
   ELSE Write (' ');
   GotoXY (18, 22); WriteLn ('   ');
   GotoXY (18, 23); WriteLn ('   ');
   GotoXY (18, 22); WriteLn (POTIONS);
   GotoXY (18, 23); WriteLn (CREDITS);
END; (* CheckInventory *)

  {-=-=-=-=-=-Option Menu-=-=-=-=-=-}
PROCEDURE Options;
  {$I options.scr}
VAR
   ItemCounter : Objects;
   ActionCounter : Actions;
   DontProceed, Load, Save, Finished, NBRFormat : Boolean;
   SavedDesc : String [62];
   Junk      : String [62];
   UserLoc : Integer;
   UserObj : Integer;
   UserAct : Integer;
   SavedFile, Saved1, Saved2, Saved3, Saved4 : Text;
BEGIN
   Load := FALSE;
   Save := FALSE;
   DontProceed := FALSE;
   UserLoc := 0;
   Move (OPTIONS, SCREEN, 4000);
   
  {Slot One}
   IF FileExists ('Saved1.sav') THEN
   BEGIN
      Assign (Saved1, 'Saved1.sav');
      Reset (Saved1);
      ReadLn (Saved1, SavedDesc);
      GotoXY (9, 10); Write (SavedDesc);
      Close (Saved1);
   END
   ELSE
   BEGIN
      GotoXY (9, 10); Write ('This Slot is not used');
   END;
   
  {Slot Two}
   IF FileExists ('Saved2.sav') THEN
   BEGIN
      Assign (Saved2, 'Saved2.sav');
      Reset (Saved2);
      ReadLn (Saved2, SavedDesc);
      GotoXY (9, 14); Write (SavedDesc);
      Close (Saved2);
   END
   ELSE
   BEGIN
      GotoXY (9, 14); Write ('This Slot is not used');
   END;
   
  {Slot Three}
   IF FileExists ('Saved3.sav') THEN
   BEGIN
      Assign (Saved3, 'Saved3.sav');
      Reset (Saved3);
      ReadLn (Saved3, SavedDesc);
      GotoXY (9, 18); Write (SavedDesc);
      Close (Saved3);
   END
   ELSE
   BEGIN
      GotoXY (9, 18); Write ('This Slot is not used');
   END;
   
  {Slot Four}
   IF FileExists ('Saved4.sav') THEN
   BEGIN
      Assign (Saved4, 'Saved4.sav');
      Reset (Saved4);
      ReadLn (Saved4, SavedDesc);
      GotoXY (9, 22); Write (SavedDesc);
      Close (Saved4);
   END
   ELSE
   BEGIN
      GotoXY (9, 22); Write ('This Slot is not used');
   END;
   
   REPEAT
  {Ask User To Load or Save}
      REPEAT
         CH := ' ';
         GotoXY (43, 5); CH := READKEY;
         CH := UPCASE (CH);
         CASE CH OF
            'L'  : Load := TRUE;
            'S'  : Save := TRUE;
            CHR (27) : Finished := TRUE
         END; (* Case *)
      UNTIL (CH = 'L') OR (CH = 'S') OR (CH = CHR (27) );
  {Load Procedure}
      IF LOAD = TRUE THEN
      BEGIN
         Initialize;
         REPEAT
            CH := ' ';
            GotoXY (43, 5); CH := READKEY;
            CASE CH OF
               '1'  : IF FileExists ('Saved1.sav') THEN Assign (SavedFile, 'Saved1.sav') ELSE DontProceed := TRUE;
               '2'  : IF FileExists ('Saved2.sav') THEN Assign (SavedFile, 'Saved2.sav') ELSE DontProceed := TRUE;
               '3'  : IF FileExists ('Saved3.sav') THEN Assign (SavedFile, 'Saved3.sav') ELSE DontProceed := TRUE;
               '4'  : IF FileExists ('Saved4.sav') THEN Assign (SavedFile, 'Saved4.sav') ELSE DontProceed := TRUE;
            END; (* Case *)
         UNTIL DontProceed = FALSE;
         Reset (SavedFile);
         ReadLn (SavedFile, Junk);
         ReadLn (SavedFile, Name);
         ReadLn (SavedFile, Race);
         ReadLn (SavedFile, Gender);
         ReadLn (SavedFile, CHP);
         ReadLn (SavedFile, THP);
         ReadLn (SavedFile, Potions);
         ReadLn (SavedFile, Credits);
         ReadLn (SavedFile, UserLoc);
         CASE UserLoc OF
            1      :   Location := START;
            2      :   Location := SHOP;
            3      :   Location := R1;
            4      :   Location := R2;
            5      :   Location := R3;
            6      :   Location := R4;
            7      :   Location := R5;
            8      :   Location := R6;
            9      :   Location := R7;
            10     :   Location := R8;
            11     :   Location := R9;
            12     :   Location := R10;
            13     :   Location := R11;
            14     :   Location := R12;
            15     :   Location := R13;
            16     :   Location := R14;
            17     :   Location := R15;
            18     :   Location := R16;
            19     :   Location := R17;
            20     :   Location := R18;
            21     :   Location := M1;
            22     :   Location := M2;
            23     :   Location := M3;
            24     :   Location := M4;
            25     :   Location := M5;
            26     :   Location := M6;
            27     :   Location := M7;
            28     :   Location := M8;
            29     :   Location := M9;
            30     :   Location := M10;
            31     :   Location := M11;
            32     :   Location := M12;
            33     :   Location := M13;
            34     :   Location := M14;
            35     :   Location := M15;
            36     :   Location := M16;
            37     :   Location := M17;
            38     :   Location := M18;
            39     :   Location := M19;
            40     :   Location := M20;
            41     :   Location := M21;
            42     :   Location := M22;
            43     :   Location := M23;
            44     :   Location := M24;
            45     :   Location := M25;
            46     :   Location := M26;
            47     :   Location := M27;
            48     :   Location := M28;
            49     :   Location := M29;
            50     :   Location := M30;
            51     :   Location := M31;
            52     :   Location := M32;
            53     :   Location := M33;
            54     :   Location := M34;
            55     :   Location := M35;
            56     :   Location := M36;
            57     :   Location := M37;
            58     :   Location := M38;
            59     :   Location := M39;
            60     :   Location := M40;
            61     :   Location := M41;
            62     :   Location := M42;
            63     :   Location := M43;
            64     :   Location := M44;
            65     :   Location := M45;
            66     :   Location := M46;
            67     :   Location := M47;
            68     :   Location := M48;
            69     :   Location := LAB;
         END; (* CASE *)
         FOR Counter := 1 TO 10 DO
      BEGIN
         ReadLn (SavedFile, UserObj);
         CASE USEROBJ OF
            1   :  ItemCheck [FlashLight] := TRUE;
            2   :  ItemCheck [LaserPistol] := TRUE;
            3   :  ItemCheck [Parachute]  := TRUE;
            4   :  ItemCheck [Shovel]     := TRUE;
            5   :  ItemCheck [Canteen]    := TRUE;
            6   :  ItemCheck [RGem]       := TRUE;
            7   :  ItemCheck [GGem]       := TRUE;
            8   :  ItemCheck [BGem]       := TRUE;
            9   :  ItemCheck [LaserDisc]  := TRUE;
            10  :  ItemCheck [CompKey]    := TRUE;
         END; (* Case *)
      END;
      FOR Counter := 1 TO 20 DO
      BEGIN
         ReadLn (SavedFile, USERACT);
         CASE USERACT OF
            1  :   DoneAction [ShieldOn]        := TRUE;
            2  :   DoneAction [DigBox]          := TRUE;
            3  :   DoneAction [DigRgem]         := TRUE;
            4  :   DoneAction [DigGgem]         := TRUE;
            5  :   DoneAction [DigBgem]         := TRUE;
            6  :   DoneAction [DiskWithInfo]    := TRUE;
            7  :   DoneAction [ComputerBlewUp]  := TRUE;
            8  :   DoneAction [UserDied]        := TRUE;
            9  :   DoneAction [WaterInCanteen]  := TRUE;
            10 :   DoneAction [FoundPotions]    := TRUE;
            11 :   DoneAction [VirusOnDisk]     := TRUE;
            12 :   DoneAction [North]           := TRUE;
            13 :   DoneAction [South]           := TRUE;
            14 :   DoneAction [East]            := TRUE;
            15 :   DoneAction [West]            := TRUE;
            16 :   DoneAction [GameDone]        := TRUE;
            17 :   DoneAction [Done]            := TRUE;
            18 :   DoneAction [WaterSplashed]   := TRUE;
            19 :   DoneAction [Quit]            := TRUE;
            20 :   DoneAction [ComputerUse]     := TRUE;
         END; (* CASE *)
         Finished := TRUE;
      END; (* ForLoop *)
      Close (SavedFile);
      END; (* ENDIF *)
  {Save Procedure}
      IF SAVE = TRUE THEN
      BEGIN
         CH := ' ';
         GotoXY (43, 5); CH := READKEY;
         CH := UPCASE (CH);
         REPEAT
            CASE CH OF
               '1'  : 
                      BEGIN
                         Assign (SavedFile, 'Saved1.sav');
                         LineClear (9, 10, 62); GotoXY (9, 10);
                         ReadLn (SavedDesc);
                      END;
               '2'  : 
                      BEGIN
                         Assign (SavedFile, 'Saved2.sav');
                         LineClear (9, 14, 62); GotoXY (9, 14);
                         ReadLn (SavedDesc);
                      END;
               '3'  : 
                      BEGIN
                         Assign (SavedFile, 'Saved3.sav');
                         LineClear (9, 18, 62); GotoXY (9, 18);
                         ReadLn (SavedDesc);
                      END;
               '4'  : 
                      BEGIN
                         Assign (SavedFile, 'Saved4.sav');
                         LineClear (9, 22, 62); GotoXY (9, 22);
                         Readln (SavedDesc);
                      END;
            END; (* Case *)
         UNTIL (CH = '1') OR (CH = '2') OR (CH = '3') OR (CH = '4');            
         Rewrite (SavedFile);
         WriteLn (SavedFile, SavedDesc);
         WriteLn (SavedFile, Name);
         WriteLn (SavedFile, Race);
         WriteLn (SavedFile, Gender);
         WriteLn (SavedFile, CHP);
         WriteLn (Savedfile, THP);
         WriteLn (SavedFile, Potions);
         WriteLn (SavedFile, Credits);
         CASE LOCATION OF
            START  :  USERLOC := 1;
            SHOP   :  USERLOC := 2;
            R1     :  USERLOC := 3;
            R2     :  USERLOC := 4;
            R3     :  USERLOC := 5;
            R4     :  USERLOC := 6;
            R5     :  USERLOC := 7;
            R6     :  USERLOC := 8;
            R7     :  USERLOC := 9;
            R8     :  USERLOC := 10;
            R9     :  USERLOC := 11;
            R10    :  USERLOC := 12;
            R11    :  USERLOC := 13;
            R12    :  USERLOC := 14;
            R13    :  USERLOC := 15;
            R14    :  USERLOC := 16;
            R15    :  USERLOC := 17;
            R16    :  USERLOC := 18;
            R17    :  USERLOC := 19;
            R18    :  USERLOC := 20;
            M1     :  USERLOC := 21;
            M2     :  USERLOC := 22;
            M3     :  USERLOC := 23;
            M4     :  USERLOC := 24;
            M5     :  USERLOC := 25;
            M6     :  USERLOC := 26;
            M7     :  USERLOC := 27;
            M8     :  USERLOC := 28;
            M9     :  USERLOC := 29;
            M10    :  USERLOC := 30;
            M11    :  USERLOC := 31;
            M12    :  USERLOC := 32;
            M13    :  USERLOC := 33;
            M14    :  USERLOC := 34;
            M15    :  USERLOC := 35;
            M16    :  USERLOC := 36;
            M17    :  USERLOC := 37;
            M18    :  USERLOC := 38;
            M19    :  USERLOC := 39;
            M20    :  USERLOC := 40;
            M21    :  USERLOC := 41;
            M22    :  USERLOC := 42;
            M23    :  USERLOC := 43;
            M24    :  USERLOC := 44;
            M25    :  USERLOC := 45;
            M26    :  USERLOC := 46;
            M27    :  USERLOC := 47;
            M28    :  USERLOC := 48;
            M29    :  USERLOC := 49;
            M30    :  USERLOC := 50;
            M31    :  USERLOC := 51;
            M32    :  USERLOC := 52;
            M33    :  USERLOC := 53;
            M34    :  USERLOC := 54;
            M35    :  USERLOC := 55;
            M36    :  USERLOC := 56;
            M37    :  USERLOC := 57;
            M38    :  USERLOC := 58;
            M39    :  USERLOC := 59;
            M40    :  USERLOC := 60;
            M41    :  USERLOC := 61;
            M42    :  USERLOC := 62;
            M43    :  USERLOC := 63;
            M44    :  USERLOC := 64;
            M45    :  USERLOC := 65;
            M46    :  USERLOC := 66;
            M47    :  USERLOC := 67;
            M48    :  USERLOC := 68;
            LAB    :  USERLOC := 69;
         END; (* Case *)
         WriteLn (SavedFile, UserLoc);
         Counter := 0;
         FOR ItemCounter := FLASHLIGHT TO COMPKEY DO
         BEGIN
            Counter := Counter + 1;
            IF ItemCheck [ItemCounter] = TRUE THEN WriteLn (SavedFile, Counter)
            ELSE WriteLn (SavedFile, '0');
         END;
         
         Counter := 0;
         FOR ActionCounter := ShieldOn TO ComputerUse DO
         BEGIN
            Counter := Counter + 1;
            IF DoneAction [ActionCounter] = TRUE THEN WriteLn (SavedFile, Counter)
            ELSE WriteLn (SavedFile, '0');
         END;
         Finished := TRUE;
         Close (SavedFile);
      END;
   UNTIL Finished = TRUE;
   ClrScr;
   DisplayMenu;
   CheckInventory;
END;
      
  {-=-=-=-=-=-Initialize Room-=-=-=-=-=-}
PROCEDURE InitializeRoom;
VAR
   RegainedHits : Integer;
BEGIN
   TextColor (LightGreen);
   CheckInventory;
   DisplayStatus;
   GotoXY (52, 21); Write ('<ESC> Quit Game');
   GotoXY (52, 22); Write ('<TAB> System menu');
   IF (Potions > 0) AND (CHP < THP) THEN
   BEGIN
      GotoXY (52, 19); Write ('U)se a Potion');
   END;
   CH := ' ';
   GotoXY (51, 23);
   CH := READKEY;
   CH := UPCASE (CH);
   IF CH = CHR (27) THEN EndingScreen;
   IF CH = CHR (9) THEN Options;
   IF (CH = 'U') AND (POTIONS > 0) AND (CHP < THP) THEN
   BEGIN
      Randomize;
      RegainedHits := RANDOM (15) + 1;
      IF RegainedHits + CHP > THP THEN RegainedHits := THP - CHP;
      CHP := CHP + RegainedHits;
      Potions := Potions - 1;
      ClearMessage;
      GotoXY (50, 5); Write ('You regained ', RegainedHits, ' Hitpoints');
   END;
   IF (CH = '+') AND (Cheat = TRUE) THEN
   BEGIN
      CHP := CHP + 5;
      IF CHP > THP THEN THP := CHP;
      DisplayStatus;
   END;
   IF (CH = '-') AND (Cheat = TRUE) THEN
   BEGIN
      CHP := CHP - 5;
      IF CHP < 0 THEN
      BEGIN
         Death1 := ('Ah, so you have found the internal cheat in this');
         Death2 := ('game, too bad you killed yourself with it. Maybe');
         Death3 := ('next time you would actually have a chance to beat');
         Death4 := ('this game. Well Good luck on your next adventure');
         DoneAction [GameDone] := TRUE;
         DoneAction [UserDied] := TRUE;
      END;
   END;
END; (* InitializeRoom *)
      
  {-=-=-=-=-=-Maze Description-=-=-=-=-=-}
PROCEDURE MazeDesc;
BEGIN
   ClearLocation;
   GotoXY (6, 3); Write ('You are in a dark cave');
   GotoXY (6, 4); Write ('It is impossible to tell');
   GotoXY (6, 5); Write ('where you are.');
END; (* MazeDesc *)

  {-=-=-=-=-=-Died-=-=-=-=-=-}
  {$I DEATH.SCR}
   PROCEDURE Died (Death1, Death2, Death3, Death4 : String69);
   BEGIN
      TextColor (Black);
      Move (DEATH, SCREEN, 4000);
      GotoXY (27, 8); Write (Name, ',');
      GotoXY (27, 9); IF Gender = Female THEN Write ('She was a good')
      ELSE Write ('He was a good');
      GotoXY (27, 10); Write (Race);
      GotoXY (6, 20); Write (Death1);
      GotoXY (6, 21); Write (Death2);
      GotoXY (6, 22); Write (Death3);
      GotoXY (6, 23); Write (Death4);
      CH := READKEY
   END; (* Died *)

  {-=-=-=-=-=-Traps & Treasures-=-=-=-=-=-}
PROCEDURE Traps;
VAR
   RandomNumber : Integer;
BEGIN
   Randomize;
   RandomNumber := (RANDOM (10) + 1);
   IF RandomNumber < 3 THEN
   BEGIN
      CHP := CHP - RandomNumber;
      ClearMessage;
      GotoXY (50, 4); Write ('You got hit by a trap.');
      GotoXY (50, 5); Write ('You lose ', RandomNumber, ' Hitpoints');
   END; (* EndIf *)
   IF CHP <= 0 THEN
   BEGIN
      DoneAction [UserDied] := TRUE;
      Death1 := ('You have activated a trap, But this time you don''t');
      Death2 := ('survive from it. Your vision slowly blurs and darkens.');
      Death3 := ('These Caves will be your grave. You will never see the');
      Death4 := ('sun again.');
      DoneAction [GameDone] := TRUE;
   END; (* EndIf *)
   IF RandomNumber > 7 THEN
   BEGIN
      Credits := Credits + (RandomNumber - 4);
      ClearMessage;
      GotoXY (50, 4); Write ('You found ', (RandomNumber - 4), ' credits!');
   END; (* EndIf *)
END; (* Traps *)

  {-=-=-=-=-=-BeatGame-=-=-=-=-=-}
  {$I finish.scr}
PROCEDURE BeatGame;
BEGIN
   DrawPCX ('Launch.dat');
   DrawPCX ('Planet.dat');
   DrawPCX ('Shadow.dat');
   IF GENDER = FEMALE THEN DrawPCX ('Sinclair.dat')
   ELSE DrawPCX ('Talia.dat');
   CloseGraph;
   Endingscreen;
END; (* BeatGame *)

  {-=-=-=-=-=-Trapped Room-=-=-=-=-=-}
PROCEDURE TrappedRoom;
BEGIN
   DoneAction [UserDied] := TRUE;
   DEATH1 := ('A Gate crashes down behind you. you are stuck here.');
   DEATH2 := ('Few months later, you die of starvation, A year later');
   DEATH3 := ('Shadow takes over the world, and all that is left of');
   DEATH4 := ('you is a skeleton');
   DoneAction [GAMEDONE] := TRUE
END; (* TrappedRoom *)

  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-Rooms-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
  {-=-=-=-=-=-Start-=-=-=-=-=-}
PROCEDURE PSTART;
  BEGIN
     ShowDirection (TRUE, FALSE, FALSE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at the entrance to the the');
     GotoXY (6, 4); Write ('Capital of Tholia on the planet');
     GotoXY (6, 5); Write ('Nimbus ]I[. Track down Shadow, Find');
     GotoXY (6, 6); Write ('his computer And destroy it. Then');
     GotoXY (6, 7); Write ('go back to headquarters.');
     IF (DoneAction [ComputerBlewup] = TRUE) AND (DoneAction [DiskwithInfo] = TRUE) THEN
     BEGIN
        GotoXY (27, 19); Write ('R)eturn to Ship');
     END;
     InitializeRoom;
     CASE CH OF
        'N'  : LOCATION := R13;
        'S'  : NOWAY;
        'E'  : NOWAY;
        'W'  : NOWAY;
        'R'  : IF (DoneAction [ComputerBlewup] = TRUE) AND (DoneAction [DiskwithInfo] = TRUE) THEN
           DoneAction [GAMEDONE] := TRUE
     END; (* Case *)
  END; (* Pstart *)

  {-=-=-=-=-=-The Shop-=-=-=-=-=-}
PROCEDURE PSHOP;
  {$I SHOP.SCR}
  PROCEDURE TheShop;
     BEGIN
        REPEAT
           Move (Shop, Screen, 4000);
           GotoXY (59, 22); WriteLn (Credits);
           GotoXY (47, 22); CH := READKEY;
           CASE CH OF
              '0'  : DoneAction [Done] := TRUE;
              '1'  : 
                     BEGIN
                        IF (ItemCheck [Flashlight] = FALSE) AND (credits >= 15) THEN
                        BEGIN
                           ItemCheck [Flashlight] := TRUE;
                           Credits := Credits - 15;
                        END; (* FlashLight *)
                     END; (* Case Statement *)
              
              '2'  : 
                     BEGIN
                        IF (Itemcheck [LaserPistol] = FALSE) AND (Credits >= 175) THEN
                        BEGIN
                           ItemCheck [LaserPistol] := TRUE;
                           Credits := Credits - 175;
                        END; (* LaserPistol *)
                     END; (* Case Statement *)
              
              '3'  : 
                     BEGIN
                        IF (ItemCheck [Shovel] = FALSE) AND (Credits >= 15) THEN
                        BEGIN
                           ItemCheck [Shovel] := TRUE;
                           Credits := Credits - 15;
                        END; (* Shovel *)
                     END; (* Case Statement *)
              
              '4'  : 
                     BEGIN
                        IF (ItemCheck [Parachute] = FALSE) AND (Credits >= 25) THEN
                        BEGIN
                           ItemCheck [Parachute] := TRUE;
                           Credits := Credits - 25
                        END; (* Parachute *)
                     END; (* Case Statement *)
              
              '5'  : 
                     BEGIN
                        IF (ItemCheck [LaserDisc] = FALSE) AND (Credits >= 20) THEN
                        BEGIN
                           ItemCheck [LaserDisc] := TRUE;
                           Credits := Credits - 20
                        END; (* LaserDisc *)
                     END; (* Case Statement *)
              
              '6'  : 
                     BEGIN
                        IF Credits >= 50 THEN
                        BEGIN
                           Potions := Potions + 5;
                           Credits := Credits - 50
                        END; (* Potions *)
                     END; (* Case Statement *)
              
              '7'  : 
                     BEGIN
                        IF Credits >= 50 THEN
                        BEGIN
                           THP := THP + 5;
                           CHP := CHP + 5;
                           CREDITS := CREDITS - 50
                        END; (* Life Pods *)
                     END; (* Case Statement *)
              
           END; (* Case *)
           
        UNTIL DoneAction [DONE] = TRUE;
        DisplayMenu;
        DoneAction [Done] := FALSE;
     END; (* TheShop *)

  BEGIN
     ShowDirection (FALSE, TRUE, TRUE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at the Shop');
     GotoXY (6, 4); Write ('You will need to stock up on some');
     GotoXY (6, 5); Write ('items in order to defeat Shadow');
     GotoXY (28, 19);
     Write ('G)o in the shop');
     InitializeRoom;
     CASE CH OF
        'N'  : noway;
        'S'  : Location := R4;
        'E'  : Location := R1;
        'W'  : Noway;
        'G'  : TheShop;
     END; (* Case *)
     ClearOptions;
  END; (* Pshop *)

  {-=-=-=-=-=-Room One-=-=-=-=-=-}
PROCEDURE Room1;
  BEGIN
     ShowDirection (FALSE, TRUE, FALSE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at a dark alley.');
     IF ItemCheck [Canteen] = FALSE THEN
     BEGIN
        GotoXY  (6, 4); Write ('You see an old canteen here');
        GotoXY (28, 19); Write ('P)ick up canteen');
     END; (* Canteen *)
     InitializeRoom;
     CASE CH OF
        'N'  : NOWAY;
        'S'  : LOCATION := R5;
        'E'  : NOWAY;
        'W'  : LOCATION := SHOP;
        'P'  : IF ItemCheck [Canteen] = FALSE THEN
        BEGIN
           ItemCheck [Canteen] := TRUE;
           GotoXY (50, 4); Write ('You picked up the Canteen');
        END; (* EndIf *)
     END; (* Case *)
     ClearOptions;
  END; (* Room1 *)

  {-=-=-=-=-=-Room Two-=-=-=-=-=-}
PROCEDURE Room2;
  BEGIN
     ShowDirection (FALSE, TRUE, TRUE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are in a park. You see');
     GotoXY (6, 4); Write ('a lot of trees. You stop to get');
     GotoXY (6, 5); Write ('a breath of fresh air. The Hospital');
     GotoXY (6, 6); Write ('is to the SouthEast.');
     GotoXY (6, 7); Write ('');
     InitializeRoom;
     CASE CH OF
        'N'  : NOWAY;
        'S'  : LOCATION := R7;
        'E'  : LOCATION := R3;
        'W'  : NOWAY;
     END; (* Case *)
  END; (* Room2 *)

  {-=-=-=-=-=-Room Three-=-=-=-=-=-}
PROCEDURE Room3;
  BEGIN
     ShowDirection (FALSE, TRUE, TRUE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are standing by a statue');
     GotoXY (6, 4); Write ('of Yang Liu, Aka Spectrum.');
     GotoXY (6, 5); Write ('by staring at this statue, You');
     GotoXY (6, 6); Write ('wish that you could of met him.');
     GotoXY (6, 7); Write ('You sigh wistfully.');
     
     InitializeRoom;
     CASE CH OF
        'N'  : NOWAY;
        'S'  : LOCATION := R8;
        'E'  : LOCATION := R4;
        'W'  : LOCATION := R2;
     END; (* Case *)
  END; (* Room3 *)

  {-=-=-=-=-=-Room Four-=-=-=-=-=-}
PROCEDURE Room4;
  BEGIN
     ShowDirection (TRUE, TRUE, FALSE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You rest your bones on a bench.');
     GotoXY (6, 4); Write ('The Shop is to the north.');
     GotoXY (6, 5); Write ('The Hospital is to the SouthEast');
     InitializeRoom;
     CASE CH OF
        'N'  : Location := Shop;
        'S'  : Location := R9;
        'E'  : Noway;
        'W'  : Location := R3;
     END; (* Case *)
  END; (* Room4 *)

  {-=-=-=-=-=-Room Five-=-=-=-=-=-}
PROCEDURE Room5;
  BEGIN
     ShowDirection (TRUE, TRUE, TRUE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You see a warehouse to south');
     GotoXY (6, 4); Write ('As you walk, your feet slips into');
     GotoXY (6, 5) ; Write ('a small hole. You curse as you fall');
     GotoXY (28, 19);
     IF DoneAction [FoundPotions] = FALSE THEN WriteLn ('I)nvestigate Hole');
     InitializeRoom;
     CASE CH OF
        'N'  : Location := R1;
        'S'  : Location := R10;
        'E'  : Location := R6;
        'W'  : NOWAY;
        'I'  : IF DoneAction [FoundPotions] = FALSE THEN
        BEGIN
           ClearMessage;
           GotoXY (50, 4); Write ('You found some potions');
           Potions := Potions + 3;
           DoneAction [FoundPotions] := TRUE
        END; (* EndIf *)
     END; (* Case *)
     ClearOptions;
  END; (* Room5 *)

  {-=-=-=-=-=-Room Six-=-=-=-=-=-}
PROCEDURE Room6;
  BEGIN
     ShowDirection (FALSE, TRUE, FALSE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at the beach.');
     GotoXY (28, 19);
     IF (ItemCheck [Canteen] = TRUE) AND (DoneAction [WaterInCanteen] = FALSE) THEN
        Write ('F)ill Canteen with Water');
     InitializeRoom;
     CASE CH OF
        'N'  : Noway;
        'S'  : Location := R11;
        'E'  : Noway;
        'W'  : Location := R5;
        'F'  : IF (ItemCheck [Canteen] ) = TRUE AND (DoneAction [WaterInCanteen] = FALSE) THEN
        BEGIN
           ClearMessage;
           GotoXY (50, 4); Write ('You fill the canteen');
           GotoXY (50, 5); Write ('to the brim with salt');
           GotoXY (50, 6); Write ('water.');
           DoneAction [WaterInCanteen] := TRUE
        END; (* EndIf *)
     END; (* Case *)
     ClearOptions;
  END; (* Room6 *)

  {-=-=-=-=-=-Room Seven-=-=-=-=-=-}
PROCEDURE Room7;
  BEGIN
     ShowDirection (TRUE, TRUE, FALSE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at the business section');
     GotoXY (6, 4); Write ('of Nimbus ]I[. If it weren''t for');
     GotoXY (6, 5); Write ('that darn fence, you could go east');
     GotoXY (6, 6); Write ('to the hospital.');
     
     initializeRoom;
     CASE CH OF
        'N'  : location := r2;
        'S'  : location := r12;
        'E'  : noway;
        'W'  : noway;
     END; (* Case *)
  END; (* Room8 *)

  {-=-=-=-=-=-Room Eight-=-=-=-=-=-}
PROCEDURE Room8;
  BEGIN
     ShowDirection (TRUE, FALSE, TRUE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at a Hospital. You can cure');
     GotoXY (6, 4); Write ('most of your wounds here');
     IF CHP < THP THEN
     BEGIN
        GotoXY (28, 19); WriteLn ('H)eal all your wounds');
     END; (* EndIf *)
     InitializeRoom;
     CASE CH OF
        'N'  : LOCATION := R3;
        'S'  : LOCATION := R13;
        'E'  : LOCATION := R9;
        'W'  : LOCATION := R7;
        'H'  : IF CHP < THP THEN
        BEGIN
           ClearMessage;
           Wounds := THP - CHP;
           IF Wounds > Credits THEN Wounds := Credits;
           CHP := CHP + Wounds;
           Credits := Credits - WOUNDS;
           IF CHP = THP THEN
           BEGIN
              GotoXY (50, 4);
              WriteLn ('You were Completely Healed');
           END
           ELSE
           BEGIN
              GotoXY (50, 4);
              WriteLn ('You regained ', Wounds, ' hitpoints');
           END; (* EndIf *)
           IF CREDITS = 0 THEN
           BEGIN
              GotoXY (50, 5);
              WriteLn ('You are out of cash');
           END; (* EndIf *)
        END; (* EndIf *)
     END; (* Case *)
  END; (* Room8 *)

  {-=-=-=-=-=-Room Nine-=-=-=-=-=-}
PROCEDURE Room9;
  BEGIN
     ShowDirection (TRUE, TRUE, TRUE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You sit under the shade of an');
     GotoXY (6, 4); Write ('Oak Tree and try to get some rest.');
     GotoXY (6, 5); Write ('The hospital is to the west, but');
     GotoXY (6, 6); Write ('there is a fence there blocking');
     GotoXY (6, 7); Write ('the way.');
     
     initializeRoom;
     CASE CH OF
        'N'  : Location := R4;
        'S'  : Location := R14;
        'E'  : Location := R10;
        'W'  : Noway;
     END; (* Case *)
  END; (* Room9 *)

  {-=-=-=-=-=-Room Ten-=-=-=-=-=-}
PROCEDURE Room10;
  BEGIN
     ShowDirection (TRUE, TRUE, FALSE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are near a Crystal Station.');
     GotoXY (6, 4); Write ('You see people dropping by to refuel');
     GotoXY (6, 5); Write ('They''re vehicles.');
     
     InitializeRoom;
     CASE CH OF
        'N'  : Location := R5;
        'S'  : Location := R15;
        'E'  : NOWAY;
        'W'  : Location := R9;
     END; (* Case *)
  END; (* Room10 *)

  {-=-=-=-=-=-Room Eleven-=-=-=-=-=-}
PROCEDURE Room11;
  BEGIN
     ShowDirection (TRUE, TRUE, FALSE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You see a river that flows');
     GotoXY (6, 4); Write ('to the east. The Ocean is');
     GotoXY (6, 5); Write ('to the north.');
     InitializeRoom;
     CASE CH OF
        'N'  : Location := R6;
        'S'  : Location := R16;
        'E'  : Noway;
        'W'  : Noway;
     END; (* Case *)
  END; (* Room11 *)

  {-=-=-=-=-=-Room Twelve-=-=-=-=-=-}
PROCEDURE Room12;
  BEGIN
     ShowDirection (TRUE, FALSE, TRUE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You look up to see an apartment');
     GotoXY (6, 4); Write ('Complex. This must be where everyone');
     GotoXY (6, 5); Write ('lives. The Hospital is to the NorthEast');
     
     InitializeRoom;
     CASE CH OF
        'N'  : LOCATION := R7;
        'S'  : NOWAY;
        'E'  : LOCATION := R13;
        'W'  : NOWAY;
     END; (* Case *)
  END; (* Room12 *)

  {-=-=-=-=-=-Room Thirteen->>>>>>>>>}
PROCEDURE Room13;
  BEGIN
     ShowDirection (FALSE, TRUE, TRUE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You notice that the hospital is');
     GotoXY (6, 4); Write ('to the north. Then you look back');
     GotoXY (6, 5); Write ('south at your ship and wonder if');
     GotoXY (6, 6); Write ('you ever will kill Shadow.');
     
     InitializeRoom;
     CASE CH OF
        'N'  : NOWAY;
        'S'  : LOCATION := START;
        'E'  : LOCATION := R14;
        'W'  : LOCATION := R12;
     END; (* Case *)
  END; (* Room13 *)

  {-=-=-=-=-=-Room Fourteen-=-=-=-=-=-}
PROCEDURE Room14;
  BEGIN
     ShowDirection (TRUE, FALSE, TRUE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You see a cluster of Candy Stores');
     GotoXY (6, 4); Write ('You wanted to buy some candy, but as');
     GotoXY (6, 5); Write ('you look in your wallet, you decide');
     GotoXY (6, 6); Write ('against it');
     
     InitializeRoom;
     CASE CH OF
        'N'  : LOCATION := R9;
        'S'  : NOWAY;
        'E'  : LOCATION := R15;
        'W'  : LOCATION := R13;
     END (* Case *)
  END; (* Room14 *)

  {-=-=-=-=-=-Room Fifteen-=-=-=-=-=-}
PROCEDURE Room15;
  BEGIN
     ShowDirection (TRUE, TRUE, FALSE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are in a field with a lot of');
     GotoXY (6, 4); Write ('beautiful flowers, Nimbus ]I[ is');
     GotoXY (6, 5); Write ('truely a great place to visit, if your');
     GotoXY (6, 6); Write ('not on a Top-Secret mission. You see an');
     GotoXY (6, 7); Write ('abandoned warehouse to the south');
     
     InitializeRoom;
     CASE CH OF
        'N'  : Location := R10;
        'S'  : Location := R18;
        'E'  : Noway;
        'W'  : Location := R14;
     END; (* Case *)
  END; (* Room15 *)

  {-=-=-=-=-=-Room Sixteen-=-=-=-=-=-}
PROCEDURE Room16;
  BEGIN
     ShowDirection (TRUE, FALSE, TRUE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are at a beautiful waterfall');
     GotoXY (6, 4); Write ('You watch as the crystal clear');
     GotoXY (6, 5); Write ('water cascade down in a small lake');
     InitializeRoom;
     CASE CH OF
        'N'  : Location := R11;
        'S'  : Noway;
        'E'  : Location := R17;
        'W'  : Noway;
     END; (* Case *)
  END; (* Room16 *)

  {-=-=-=-=-=-Room Seventeen-=-=-=-=-=-}
PROCEDURE Room17;
  BEGIN
     ShowDirection (FALSE, FALSE, TRUE, TRUE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are behind the waterfall');
     GotoXY (6, 4); Write ('You see a cave that looks like');
     GotoXY (6, 5); Write ('someone yawning. Do you dare Enter?');
     InitializeRoom;
     CASE CH OF
        'N'  : noway;
        'S'  : noway;
        'E'  : Location := M4;
        'W'  : location := R16;
     END; (* Case *)
  END; (* Room17 *)

  {-=-=-=-=-=-Room Eighteen-=-=-=-=-=-}
PROCEDURE Room18;
  BEGIN
     ShowDirection (TRUE, FALSE, FALSE, FALSE);
     ClearLocation;
     GotoXY (6, 3); Write ('You are in an abandoned computer');
     GotoXY (6, 4); Write ('warehouse. You see a lot of used');
     GotoXY (6, 5); Write ('computers here. You wonder why these');
     GotoXY (6, 6); Write ('computers are abandoned here.');
     IF (ItemCheck [LaserDisc] ) = TRUE AND (DoneAction [VirusOnDisk] = FALSE) THEN
     BEGIN;
        GotoXY (28, 19); Write ('C)opy virus onto CD');
     END; (* EndIf *)
     InitializeRoom;
     CASE CH OF
        'N'  : location := r15;
        'S'  : noway;
        'E'  : noway;
        'W'  : noway;
        'C'  : IF (DoneAction [VirusOnDisk] = FALSE) AND (ItemCheck [LaserDisc] = TRUE) THEN
        BEGIN
           DoneAction [VirusOnDisk] := TRUE;
           GotoXY (50, 4); Write ('You transfered the virus.');
           GotoXY (50, 5); Write ('All you have to do now is');
           GotoXY (50, 6); Write ('to find Shadow''s computer');
        END; (* EndIf *)
     END; (* Case *)
     ClearOptions
  END; (* Room18 *)

  {-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=The Maze=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
  {-=-=-=-=-=-Maze One-=-=-=-=-=-}
PROCEDURE PM1;
BEGIN
   TrappedRoom;
END; (* PM1 *)

  {-=-=-=-=-=-Maze Two-=-=-=-=-=-}
PROCEDURE PM2;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, FALSE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : Location := M10;
      'E' : Location := M3;
      'W' : NOWAY;
   END; (* Case *)
END; (* PM2 *)

  {-=-=-=-=-=-Maze Three-=-=-=-=-=-}
PROCEDURE PM3;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, TRUE, FALSE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : Location := M11;
      'E' : NOWAY;
      'W' : Location := M2;
   END; (* Case *)
END; (* PM3 *)

  {-=-=-=-=-=-Maze Four-=-=-=-=-=-}
PROCEDURE PM4;
BEGIN
   ClearLocation;
   GotoXY (6, 3); Write ('You finally made it out of the water');
   GotoXY (6, 4); Write ('and slowly make your way towards the');
   GotoXY (6, 5); Write ('cave');
   ShowDirection (FALSE, FALSE, TRUE, TRUE);
   InitializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : NOWAY;
      'E' : LOCATION := M5;
      'W' : LOCATION := R17;
   END; (* Case *)
   ClearDirection;
END; (* PM4 *)

  {-=-=-=-=-=-Maze Five-=-=-=-=-=-}
PROCEDURE PM5;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : Location := M13;
      'E' : Location := M6;
      'W' : Location := M4;
   END; (* Case *)
END; (* PM5 *)

  {-=-=-=-=-=-Maze Six-=-=-=-=-=-}
PROCEDURE PM6;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, FALSE, TRUE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M1;
      'S' : Location := M13;
      'E' : Location := M7;
      'W' : Location := M5;
   END; (* Case *)
END; (* PM6 *)

  {-=-=-=-=-=-Maze Seven-=-=-=-=-=-}
PROCEDURE PM7;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M8;
      'W' : Location := M6;
   END; (* Case *)
END; (* PM7 *)

  {-=-=-=-=-=-Maze Eight-=-=-=-=-=-}
PROCEDURE PM8;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : Location := M15;
      'E' : Location := M9;
      'W' : Location := M7;
   END; (* Case *)
END; (* PM8 *)

  {-=-=-=-=-=-Maze Nine-=-=-=-=-=-}
PROCEDURE PM9;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M16;
      'E' : Location := M10;
      'W' : Location := M8;
   END; (* Case *)
END; (* PM9 *)

  {-=-=-=-=-=-Maze Ten-=-=-=-=-=-}
PROCEDURE PM10;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, FALSE, FALSE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M2;
      'S' : Noway;
      'E' : Noway;
      'W' : Location := M9;
   END; (* Case *)
END; (* PM10 *)

  {-=-=-=-=-=-Maze Eleven-=-=-=-=-=-}
PROCEDURE PM11;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, TRUE, FALSE, FALSE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M3;
      'S' : Location := M17;
      'E' : NOWAY;
      'W' : NOWAY;
   END; (* Case *)
END; (* PM11 *)

  {-=-=-=-=-=-Maze Twelve-=-=-=-=-=-}
PROCEDURE PM12;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, FALSE);
   TRAPS;
   GotoXY (28, 19); Write ('G)o Down');
   InitializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : NOWAY;
      'E' : LOCATION := M13;
      'W' : NOWAY;
      'G' : LOCATION := M34;
   END; (* Case *)
   ClearOptions;
END; (* PM12 *)

  {-=-=-=-=-=-Maze Thirteen-=-=-=-=-=-}
PROCEDURE PM13;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, TRUE, FALSE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M5;
      'S' : Location := M18;
      'E' : NOWAY;
      'W' : Location := M12;
   END; (* Case *)
END; (* PM13 *)

  {-=-=-=-=-=-Maze Fourteen-=-=-=-=-=-}
PROCEDURE PM14;
BEGIN
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, FALSE, FALSE, TRUE);
   ClearLocation;
   GotoXY (6, 3); Write ('The lab is to the West.');
   GotoXY (6, 4);
   IF DoneAction [ShieldOn] = TRUE THEN
   BEGIN
      Write ('Access to lab is blocked by a shield');
   END; (* EndIf *)
   IF DoneAction [WaterInCanteen] = TRUE THEN
   BEGIN
      GotoXY (28, 19); Write ('D)ump water onto Shield');
   END;
   IF (ItemCheck [LaserPistol] = TRUE) AND (DoneAction [SHIELDON] = TRUE) AND (Doneaction [WaterSplashed] = TRUE) THEN
   BEGIN
      GotoXY (28, 20); Write ('B)last shield with Laser Pistol');
   END; (* EndIf *)
   IF ItemCheck [COMPKEY] = TRUE THEN
   BEGIN
      GotoXY (28, 21); Write ('U)se Key/Password');
   END; (* EndIf *)
   GotoXY (28, 22); Write ('G)o Down');
   InitializeRoom;
   CASE CH OF
      'N' : NOway;
      'S' : NOWAY;
      'E' : NOWAY;
      'W' : IF DoneAction [Shieldon] = TRUE THEN NOWAY
      ELSE Location := Lab;
      'D' : IF DoneAction [WaterInCanteen] = TRUE THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('You splash the salt water');
         GotoXY (50, 5); Write ('onto the shield, The');
         GotoXY (50, 6); Write ('Shield is now weakened.');
         Doneaction [WaterSplashed] := TRUE
      END;
      'B' : IF (DoneAction [Shieldon] = TRUE) AND (ItemCheck [LaserPistol] = TRUE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('You blast the shield with');
         GotoXY (50, 5); Write ('the gun, it instantly shuts');
         GotoXY (50, 6); Write ('off.');
         DoneAction [SHIELDON] := FALSE;
      END; (* EndIf *)
      'U' : IF ItemCheck [COMPKEY] = TRUE THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('You unlock the panel with');
         GotoXY (50, 5); Write ('the key, and enter the');
         GotoXY (50, 6); Write ('Username/Password.');
         DoneAction [ShieldON] := FALSE;
      END; (* EndIf *)
      'G' : Location := M37;
   END; (* Case *)
   ClearOptions;
END; (* PM14 *)
  {-=-=-=-=-=-Maze Fifteen-=-=-=-=-=-}
PROCEDURE PM15;
BEGIN
   MAZEDESC;
   GotoXY (6, 6); Write ('You noticed something different');
   GotoXY (6, 7); Write ('about the ground');
   GotoXY (28, 19);
   IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigRgem] = FALSE) THEN Write ('D)ig in the ground');
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, FALSE, FALSE, FALSE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M8;
      'S' : NOWAY;
      'E' : NOWAY;
      'W' : NOWAY;
      'D' : IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigRgem] = FALSE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('After many hours digging');
         GotoXY (50, 5); Write ('you unearth a red gem.');
         ItemCheck [RGem] := TRUE;
         DoneAction [DigRGem] := TRUE;
      END; (* EndIf *)
   END; (* Case *)
   ClearOptions;
   CheckInventory;
END; (* PM15 *)

  {-=-=-=-=-=-Maze Sixteen-=-=-=-=-=-}
PROCEDURE PM16;
BEGIN
   MAZEDESC;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, TRUE, FALSE, FALSE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M9;
      'S' : Location := M22;
      'E' : Noway;
      'W' : Noway;
   END; (* Case *)
END; (* PM16 *)

  {-=-=-=-=-=-Maze Seventeen-=-=-=-=-=-}
PROCEDURE PM17;
BEGIN
   MAZEDESC;
   GotoXY (6, 6); Write ('You noticed something different');
   GotoXY (6, 7); Write ('about the ground');
   GotoXY (28, 19);
   IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigGgem] = FALSE) THEN Write ('D)ig in the ground');
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, FALSE, FALSE, FALSE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M11;
      'S' : Noway;
      'E' : Noway;
      'W' : Noway;
      'D' : IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigGgem] = FALSE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('After many hours digging');
         GotoXY (50, 5); Write ('you unearth a Green Gem.');
         ItemCheck [GGem] := TRUE;
         DoneAction [DigGGem] := TRUE;
      END; (* EndIf *)
   END; (* Case *)
   ClearOptions;
   CheckInventory;
END; (* PM17 *)

  {-=-=-=-=-=-Maze Eighteen-=-=-=-=-=-}
PROCEDURE PM18;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (TRUE, FALSE, TRUE, FALSE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M13;
      'S' : Noway;
      'E' : Location := M19;
      'W' : Noway
   END; (* Case *)
END; (* PM18 *)

  {-=-=-=-=-=-Maze Nineteen-=-=-=-=-=-}
PROCEDURE PM19;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M20;
      'W' : Location := M18;
   END; (* Case *)
END; (* PM19 *)

  {-=-=-=-=-=-Maze Twenty-=-=-=-=-=-}
PROCEDURE PM20;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M21;
      'W' : Location := M19;
   END; (* Case *)
END; (* PM20 *)

  {-=-=-=-=-=-Maze TwentyOne-=-=-=-=-=-}
PROCEDURE PM21;
BEGIN
   TrappedRoom;
END; (* PM21 *)

  {-=-=-=-=-=-Maze TwentyTwo-=-=-=-=-=-}
PROCEDURE PM22;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN SHowdirection (TRUE, FALSE, TRUE, FALSE);
   TRAPS;
   initializeRoom;
   CASE CH OF
      'N' : Location := M16;
      'S' : Noway;
      'E' : Location := M23;
      'W' : Noway;
   END; (* Case *)
END; (* PM22 *)

  {-=-=-=-=-=-Maze TwentyThree-=-=-=-=-=-}
PROCEDURE PM23;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN SHowdirection (FALSE, FALSE, TRUE, TRUE);
   TRAPS;
   initializeRoom;
   CASE CH OF
      'N' : NOWAY;
      'S' : NOWAY;
      'E' : Location := M24;
      'W' : Location := M22;
   END; (* Case *)
END; (* PM23 *)

  {-=-=-=-=-=-Maze TwentyFour-=-=-=-=-=-}
PROCEDURE PM24;
BEGIN
   TrappedRoom;
END; (* PM24 *)

  {-=-=-=-=-=-Maze TwentyFive-=-=-=-=-=-}
PROCEDURE PM25;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN Showdirection (FALSE, TRUE, TRUE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M30;
      'E' : Location := M26;
      'W' : Noway;
   END; (* Case *)
END; (* PM25 *)

  {-=-=-=-=-Maze TwentySix-=-=-=-=-=-}
PROCEDURE PM26;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (FALSE, TRUE, FALSE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M31;
      'E' : Noway;
      'W' : Location := M25;
   END; (* Case *)
END; (* PM26 *)

  {-=-=-=-=-=-Maze TwentySeven-=-=-=-=-=-}
PROCEDURE PM27;
BEGIN
   TrappedRoom;
END; (* PM27 *)

  {-=-=-=-=-=-Maze TwentyEight-=-=-=-=-=-}
PROCEDURE PM28;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M36;
      'E' : Location := M29;
      'W' : Noway;
   END; (* Case *)
END; (* PM28 *)

  {-=-=-=-=-=-Maze TwentyNine-=-=-=-=-=-}
PROCEDURE PM29;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M30;
      'W' : Location := M28;
   END; (* Case *)
END; (* PM29 *)

  {-=-=-=-=-=-Maze Thirty-=-=-=-=-=-}
PROCEDURE PM30;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (TRUE, FALSE, FALSE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M25;
      'S' : Noway;
      'E' : Noway;
      'W' : Location := M29;
   END; (* Case *)
END; (* PM30 *)

  {-=-=-=-=-=-Maze Thirty One-=-=-=-=-=-}
PROCEDURE PM31;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (TRUE, TRUE, TRUE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M26;
      'S' : Location := M39;
      'E' : Location := M32;
      'W' : Noway;
   END; (* Case *)
END; (* PM31 *)

  {-=-=-=-=-=-Maze Thirty Two-=-=-=-=-=-}
PROCEDURE PM32;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN showdirection (TRUE, FALSE, TRUE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M27;
      'S' : Noway;
      'E' : Location := M33;
      'W' : Location := M31;
   END; (* Case *)
END; (* PM32 *)

  {-=-=-=-=-=-Maze Thirty Three-=-=-=-=-=-}
PROCEDURE PM33;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN showdirection (FALSE, TRUE, FALSE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M41;
      'E' : Noway;
      'W' : Location := M32;
   END; (* Case *)
END; (* PM33 *)

  {-=-=-=-=-=-Maze Thirty Four-=-=-=-=-=-}
PROCEDURE PM34;
BEGIN
   MAZEDESC;
   GotoXY (6, 6); Write ('You noticed something different');
   GotoXY (6, 7); Write ('about the ground');
   GotoXY (28, 19);
   IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigBgem] = FALSE) THEN Write ('D)ig in the ground');
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, FALSE);
   GotoXY (28, 20); WriteLn ('G)o Up');
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M35;
      'W' : Noway;
      'D' : IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigBgem] = FALSE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('After many hours digging');
         GotoXY (50, 5); Write ('you unearth a Blue Gem.');
         ItemCheck [BGem] := TRUE;
         DoneAction [DigBGem] := TRUE;
      END; (* EndIf *)
      'G' : Location := M12;
   END; (* Case *)
   ClearOptions;
   CheckInventory;
END; (* PM34 *)

  {-=-=-=-=-=-Thirty Five-=-=-=-=-=-}
PROCEDURE PM35;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (FALSE, FALSE, TRUE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M36;
      'W' : Location := M34;
   END; (* Case *)
END; (* PM35 *)

  {-=-=-=-=-=-Thirty Six-=-=-=-=-=-}
PROCEDURE PM36;
BEGIN
   Mazedesc;
   IF itemcheck [Flashlight] = TRUE THEN SHowDirection (TRUE, TRUE, FALSE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M28;
      'S' : Location := M42;
      'E' : Noway;
      'W' : Location := M35;
   END; (* Case *)
END; (* PM36 *)

  {-=-=-=-=-=-Thirty Seven-=-=-=-=-=-}
PROCEDURE PM37;
BEGIN
   MazeDesc;
   IF Itemcheck [FlashLight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, FALSE);
   Traps;
   GotoXY (28, 19); Write ('G)o up');
   initializeroom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M43;
      'E' : Location := M38;
      'W' : Noway;
      'G' : Location := M14;
   END; (* Case *)
   ClearOptions;
END; (* PM37 *)

  {-=-=-=-=-=-Thirty Eight-=-=-=-=-=-}
PROCEDURE PM38;
BEGIN
   MAZEDESC;
   GotoXY (6, 6); Write ('You noticed something different');
   GotoXY (6, 7); Write ('about the ground');
   GotoXY (28, 19);
   IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigBox] = FALSE) THEN Write ('D)ig in the ground');
   IF ItemCheck [Flashlight] = TRUE THEN ShowDirection (FALSE, TRUE, FALSE, TRUE);
   TRAPS;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Noway;
      'W' : Location := m37;
      'D' : IF (ItemCheck [Shovel] = TRUE) AND (DoneAction [DigBox] = FALSE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('After many hours digging');
         GotoXY (50, 5); Write ('you unearth a small box.');
         IF (ItemCheck [Rgem] = TRUE) AND (ItemCheck [Ggem] = TRUE) AND (ITEMCHECK [Bgem] = TRUE) THEN
         BEGIN
            ItemCheck [RGem] := FALSE;
            ItemCheck [GGem] := FALSE;
            ItemCheck [BGem] := FALSE;
            ItemCheck [CompKey] := TRUE;
            GotoXY (50, 6); Write ('You open the box with the');
            GotoXY (50, 7); Write ('gems. Inside you find a');
            CH := READKEY;
            ClearMessage;
            GotoXY (50, 4); Write ('note that Reads:');
            GotoXY (50, 5); Write ('USENAME:Jo M.');
            GotoXY (50, 6); Write ('PWRD:123$JAB');
            GotoXY (50, 7); Write ('You also find a Key');
            DoneAction [DigBox] := TRUE;
         END
         ELSE
         BEGIN
            GotoXY (50, 6); Write ('You can''t unlock it');
         END; (* EndIf *)
      END; (* EndIf *)
   END; (* Case *)
   ClearOptions;
   CheckInventory;
END; (* PM38 *)

  {-=-=-=-=-=-Maze Thirty Nine-=-=-=-=-=-}
PROCEDURE PM39;
BEGIN
   TrappedRoom;
END; (* PM39 *)

  {-=-=-=-=-=-Maze Forty-=-=-=-=-=-}
PROCEDURE PM40;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN ShowDirection (FALSE, TRUE, TRUE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location  := M46;
      'E' : Location := M41;
      'W' : Noway;
   END; (* Case *)
END; (* PM40 *)

  {-=-=-=-=-=-Maze Forty One-=-=-=-=-=-}
PROCEDURE PM41;
BEGIN
   MazeDesc;
   IF Itemcheck [Flashlight] = TRUE THEN SHowdirection (TRUE, FALSE, FALSE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M33;
      'S' : Noway;
      'E' : NOway;
      'W' : Location := M40;
   END; (* Case *)
END; (* PM41 *)

  {-=-=-=-=-=-Maze Forty Two-=-=-=-=-=-}
PROCEDURE PM42;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN showdirection (TRUE, FALSE, FALSE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M36;
      'S' : Noway;
      'E' : Noway;
      'W' : Noway;
   END; (* Case *)
END; (* PM42 *)

  {-=-=-=-=-=-Maze Forty Three-=-=-=-=-=-}
PROCEDURE PM43;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN showdirection (TRUE, FALSE, TRUE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M37;
      'S' : Noway;
      'E' : Location := m44;
      'W' : Noway;
   END; (* Case *)
END; (* PM43 *)

  {-=-=-=-=-=-Maze Forty Four-=-=-=-=-=-}
PROCEDURE PM44;
BEGIN
   MazeDesc;
   IF ItemCheck [Flashlight] = TRUE THEN showdirection (FALSE, TRUE, TRUE, TRUE);
   traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Location := M47;
      'E' : Location := M45;
      'W' : Location := M43;
   END; (* Case *)
END; (* PM44 *)

  {-=-=-=-=-=-Maze Forty Five-=-=-=-=-=-}
PROCEDURE PM45;
BEGIN
   MazeDesc;
   IF ItemCheck [FlashLight] = TRUE THEN showdirection (FALSE, FALSE, TRUE, TRUE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Noway;
      'S' : Noway;
      'E' : Location := M46;
      'W' : Location := M44;
   END; (* Case *)
END; (* PM45 *)

  {-=-=-=-=-=-Maze Forty Six-=-=-=-=-=-}
PROCEDURE PM46;
BEGIN
   MazeDesc;
   IF Itemcheck [flashlight] = TRUE THEN Showdirection (TRUE, FALSE, FALSE, TRUE);
   Traps;
   InitializeROom;
   CASE CH OF
      'N' : Location := M40;
      'S' : noway;
      'E' : Noway;
      'W' : Location := m45;
   END; (* Case *)
END; (* PM46 *)

  {-=-=-=-=-=-Maze Forty Seven-=-=-=-=-=-}
PROCEDURE PM47;
BEGIN
   Mazedesc;
   IF ItemCheck [FlashLight] = TRUE THEN showdirection (TRUE, FALSE, TRUE, FALSE);
   Traps;
   InitializeRoom;
   CASE CH OF
      'N' : Location := M44;
      'S' : Noway;
      'E' : Location := M48;
      'W' : Noway;
   END; (* Case *)
END; (* PM47 *)

  {-=-=-=-=-=-Maze Forty Eight-=-=-=-=-=-}
PROCEDURE PM48;
BEGIN
   TrappedRoom;
END; (* PM47 *)

  {-=-=-=-=-=-The Lab-=-=-=-=-=-}
PROCEDURE PLAB;
BEGIN
   SHOWDIRECTION (FALSE, FALSE, TRUE, FALSE);
   ClearLocation;
   GotoXY (6, 3); Write ('You are at the computer lab');
   GotoXY (6, 4); Write ('Quick! Destroy the computer!');
   ClearOptions;
   IF ItemCheck [LaserDisc] = TRUE THEN
   BEGIN
      GotoXY (28, 19); Write ('C)opy the info onto CD');
   END;
   IF DoneAction [VirusOnDisk] = TRUE THEN
   BEGIN
      GotoXY (28, 20); Write ('U)pload Virus to Computer');
   END;
   InitializeRoom;
   CASE CH OF
      'N' : NOway;
      'S' : Noway;
      'E' : Location := M14;
      'W' : Noway;
      'C' : IF (DoneAction [DiskWithInfo] = FALSE) AND (DoneAction [ComputerBlewUp] = FALSE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('File successfully Copied');
      END; (* EndIf *)
      'U' : IF (DoneAction [VIRUSONDISK] = TRUE) AND (DoneAction [COMPUTERBLEWUP] = FALSE) THEN
      BEGIN
         ClearMessage;
         GotoXY (50, 4); Write ('The Computer Blew up');
         GotoXY (50, 5); Write ('Now get back to your ship');
         DoneAction [ComputerBlewup] := TRUE;
      END; (* EndIf *)
   END; (* Case *)
   ClearOptions;
END; (* PLab *)

  {-=-=-=-=-=-=-=-=--=-=-=-=-=-Main Program-=-=-=-=-=-=-=-=-=-=-=-=-=-}
BEGIN
   Initialize;
   Hitpoints;
   DisplayStartup;
   QuestionUser;
   DrawPcx ('space.dat');
   CloseGraph;
   DisplayStory;
   DisplayMenu;
   CheckInventory;
   REPEAT
      CASE LOCATION OF
         START  :   PSTART;
         SHOP   :   PSHOP;
         R1     :   Room1;
         R2     :   Room2;
         R3     :   Room3;
         R4     :   Room4; 
         R5     :   Room5;
         R6     :   Room6;
         R7     :   Room7;
         R8     :   Room8;
         R9     :   Room9;
         R10    :   Room10;
         R11    :   Room11;
         R12    :   Room12;
         R13    :   Room13;
         R14    :   Room14;
         R15    :   Room15;
         R16    :   Room16;
         R17    :   Room17;
         R18    :   Room18;
         M1     :   PM1;
         M2     :   PM2;
         M3     :   PM3;
         M4     :   PM4;
         M5     :   PM5;
         M6     :   PM6;
         M7     :   PM7;
         M8     :   PM8;
         M9     :   PM9;
         M10    :   PM10;
         M11    :   PM11;
         M12    :   PM12;
         M13    :   PM13;
         M14    :   PM14;
         M15    :   PM15;
         M16    :   PM16;
         M17    :   PM17;
         M18    :   PM18;
         M19    :   PM19;
         M20    :   PM20;
         M21    :   PM21;
         M22    :   PM22;
         M23    :   PM23;
         M24    :   PM24;
         M25    :   PM25;
         M26    :   PM26;
         M27    :   PM27;
         M28    :   PM28;
         M29    :   PM29;
         M30    :   PM30;
         M31    :   PM31;
         M32    :   PM32;
         M33    :   PM33;
         M34    :   PM34;
         M35    :   PM35;
         M36    :   PM36;
         M37    :   PM37;
         M38    :   PM38;
         M39    :   PM39;
         M40    :   PM40;
         M41    :   PM41;
         M42    :   PM42;
         M43    :   PM43;
         M44    :   PM44;
         M45    :   PM45;
         M46    :   PM46;
         M47    :   PM47;
         M48    :   PM48;
         LAB    :   PLAB;
      END; (* Case *)
   UNTIL DoneAction [GameDone] = TRUE;
   IF DoneAction [USERDIED] = TRUE THEN
   BEGIN
      Died (Death1, Death2, Death3, Death4);
      EndingScreen;
   END;
   BeatGame
END.