C
C  STATEMENT FUNCTIONS
C
C
C  TOTING(OBJ)  = TRUE IF THE OBJ IS BEING CARRIED
C  HERE(OBJ)    = TRUE IF THE OBJ IS AT "LOC" (OR IS BEING CARRIED)
C  AT(OBJ)      = TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT
C  LIQ(DUMMY)   = OBJECT NUMBER OF LIQUID IN BOTTLE
C  LIQLOC(LOC)  = OBJECT NUMBER OF LIQUID (IF ANY) AT LOC
C  BITSET(L,N)  = TRUE IF COND(L) HAS BET N SET (BIT 0 IS UNITS BIT)
C  FORCED (LOC) = TRUE IF LOC MOVES WITHOUT ASKING FOR INPUT (COND=2)
C  DARK(DUMMY)  = TRUE IF LOCATION "LOC" IS DARK
C  PCT(N)       = TRUE N% OF THE TIME (N INTEGER FROM 0 TO 100)
C
C  WZDARK SAYS WHETHER THE LOC HE'S LEAVING WAS DARK
C  LMWARN SAYS WHETHER HE'S BEEN WARNED ABOUT LAMP GOING DIM
C  CLOSNG SAYS WHETHER IT'S CLOSING TIME YET
C  PANIC SAYS WHETHER HE'S FOUND OUT HE'S TRAPPED IN THE CAVE
C  CLOSED SAYS WHETHER WE'RE ALL THE WAY CLOSED
C  GAVEUP SAYS WHETHER HE EXITED VIA "QUIT"
C  SCORNG INDICATES TO THE SCORE ROUTINE WHETHER WE'RE DOING A "SCORE" COMMAND
C  DEMO IS TRUE IF THIS IS A PRIME-TIME DEMONSTRATION GAME
C  YEA IS RANDOM YES/NO REPLY


      TOTING(OBJ)=PLACE(OBJ).EQ.-1
      HERE(OBJ)=PLACE(OBJ).EQ.LOC.OR.TOTING(OBJ)
      AT(OBJ)=PLACE(OBJ).EQ.LOC.OR.FIXED(OBJ).EQ.LOC
      LIQ2(PBOTL)=(1-PBOTL)*WATER+(PBOTL/2)*(WATER+OIL)
      LIQ(DUMMY)=LIQ2(MAX0(PROP(BOTTLE),-1-PROP(BOTTLE)))
      LIQLOC(LOC)=LIQ2((MOD(COND(LOC)/2*2,8)-5)*MOD(COND(LOC)/4,2)+1)
      BITSET(L,N)=(COND(L).AND.SHIFT(1,N)).NE.0
      FORCED(LOC)=COND(LOC).EQ.2
      DARK(DUMMY)=MOD(COND(LOC),2).EQ.0.AND.(PROP(LAMP).EQ.0.OR.
     1            .NOT.HERE(LAMP))
      PCT(N)=RAN(100).LT.N
C
