@echo off

Rem /  Batch File Installer for
Rem /      Modern Bride
Rem /      version 1.04
Rem /  (c) 1993 Virgin Games
Rem /  MJS11.23

cls
if exist bride104.exe goto NOERR
goto ERR3

:NOERR
if %1x==x goto TryDefault
if exist %1\WEDMAIN.EXE goto DO_IT
goto ERR

:TryDefault
if exist c:\bride\wedmain.exe goto CONTINUE
goto usage

:CONTINUE
echo Detected default install directory. 
echo.
set BRIDEPTH=C:\BRIDE
if %BRIDEPTH%==C:\BRIDE goto DO_IT2
goto ERR2

:DO_IT
set BRIDEPTH=%1
if %BRIDEPTH%==%1 goto DO_IT2 
goto ERR2

:DO_IT2
echo One moment please...
echo.
for %%A in (WEDMAIN.EXE WEDMAIN.HLP) do del %BRIDEPTH%\%%A
for %%A in (ETIQUETT.HLP CHECKS.PX CHECKS.DB) do del %BRIDEPTH%\%%A
for %%A in (TIPS.HLP README.WRI) do del %T7GPTH%\%%A
echo Loading update information...
copy \BRIDE104.EXE %BRIDEPTH% > NUL
echo Updating old files... 
echo.
%BRIDEPTH%\BRIDE104.EXE %BRIDEPTH% 
del %BRIDEPTH%\BRIDE104.EXE
pause
if exist %BRIDEPTH%\BRIDE104.TXT goto SUCCESS
goto ERROR

:ERR3
echo.
echo             BRIDE104.EXE file not found  
echo.
echo           Please ensure that the install is run from the 
echo           floppy disk drive.
echo.
echo           For example, you should be typing:
echo           A:
echo           INSTALL
echo.
echo.
goto ERROR

:ERR2
echo.
echo             Not enough environment space   
echo                  to finish installation of update.
echo.
echo            Please increase the environment space before 
echo            running the install. 
echo.
echo            For example, add: 
echo            SHELL=C:\DOS\COMMAND.COM C:\DOS\ /p /e:256
echo            to you CONFIG.SYS file.
echo.
echo            Do NOT run the install from Windows.
echo.
echo.
goto ERROR

:ERR
echo. 
echo      *** Could not find Modern Bride files in: 
echo          %1 
echo          please check path.

:USAGE
echo. 
echo      To update your installation of Modern Bride, type "INSTALL"
echo      followed by a space and the name of the directory where the
echo      Modern Bride files were originally installed.
echo. 
echo      For example, if the update files are located on a disk in
echo      drive A:, and Modern Bride was originally installed to D:\BRIDE, 
echo      the commands would look like this:
echo. 
echo      A:
echo      INSTALL D:\BRIDE
echo. 
goto end

:ERROR
echo            Failed attempt to update Modern Bride 
echo.
echo                  For assistance, please contact 
echo                  Virgin Games Technical Support
echo                         (714) 833-1999
goto end

:SUCCESS
cls
echo       Updated "Modern Bride" to version 1.04 
echo.
echo      Do NOT re-install Modern Bride from the original disks or else
echo      the updated files will be overwritten.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.
echo.

:END
set BRIDEPTH=
echo. 

