/****************************************************************************
                  F1GP2 playtime logger v1.1a ENGLISH VERSION
                                     by
                                Petri Tuominen

Disclaimer:        - you use this program on your own risk
                   - if you modify this sourcefile and want to publish it
                     please ask a permission from me via e-mail
                   - this program is freeware

About the source:  - this program isn't tested very well, so if you
                     find a bug tell me about it
****************************************************************************/

#include <dos.h>                                // for gettext()
#include <iostream.h>                           // for cout()
#include <fstream.h>                            // for file I/O
#include <stdlib.h>                             // for atoi()

int getnextnum(char string[],int &stringptr);   // get next number from string
long getloggedtime();                           // get logged time from file
void putloggedtime(long time);                  // put logged time to file
void printtotal(long time);                     // prints the total time to screen
//***************************************************************************
void main() {

// test if the 'You played...'-text is there
        if (peekb(0xb800,0)!='Y' && peekb(0xb800,1)!='o' && peekb(0xb800,2)!='u') {
           cout<<"--- GP2 Playtime logger v1.1a (C) Petri Tuominen 1996 -------------------------\n";
           cout<<"Nothing to log! See README.TXT for info!\n";
           long time=getloggedtime();
           printtotal(time);
           exit(0);
        }

        char string[30];
        int stringptr=0;
                            
// copy from b800h to string[]
        int a=28*2;
        char data;
        do {
           data=peekb(0xb800,a);
           string[stringptr]=data;
           a=a+2;
           stringptr++;
        } while (data!='.' && stringptr<30);

        stringptr=0;
        
        cout<<"--- GP2 Playtime logger v1.1a (C) Petri Tuominen 1996 -------------------------\n";

// transform hours&minutes&seconds to seconds
        long hours=0;
        long minutes=0;
        long seconds=0;
        do {
           long num=getnextnum(string,stringptr);
           if (num==0)
              break;
           if (string[stringptr+1]=='h')
              hours=hours+num;
           if (string[stringptr+1]=='m')
              minutes=minutes+num;
           if (string[stringptr+1]=='s')
              seconds=seconds+num;
        }while (1);
        long total=hours*3600+minutes*60+seconds;                  

// update timetable 
        seconds=getloggedtime();
        total=total+seconds;
        putloggedtime(total);
        cout<<"Timetable updated!\n";

        printtotal(total);
}

//***************************************************************************
int getnextnum(char string[],int &stringptr) {
        int number=0;
        do {
              if (string[stringptr]>='0' && string[stringptr]<='9') {
                 number=atoi(&string[stringptr]);
                 break;
              }
           stringptr++;
        } while (stringptr<30);

// skip the grabbed number by moving the stringptr
        while (stringptr<30) {                  
           if (string[stringptr]==' ')
              return number;
           stringptr++;
        }
        return number;
}
//***************************************************************************
long getloggedtime() {
        ifstream fread("gp2time.log");
        long seconds=0;
        fread >> seconds;
        fread.close();
        return seconds;
}
//***************************************************************************
void putloggedtime(long time) {
        ofstream fwrite("gp2time.log");
        fwrite << time;
        fwrite.close();
}
//***************************************************************************
void printtotal(long time) {
        long days=time/86400;
        time=time-86400*days;
        long hours=time/3600;
        time=time-3600*hours;
        long minutes=time/60;
        time=time-60*minutes;
        
        cout<<"Total playtime with GP2 is ";
        if (days>0)
           cout<<days<<" days, ";
        if (hours>0)
           cout<<hours<<" hours, ";
        cout<<minutes<<" minutes and "<<time<<" seconds.\n";
        cout<<"-------------------------------------------------------------------------------";
}
//***************************************************************************

