diff -ur --new-file d:\quakestu\qcc\send\v101qc/bot.h backup5/bot.h
--- d:\quakestu\qcc\send\v101qc/bot.h	Thu Jan  1 00:00:00 1970
+++ backup5/bot.h	Tue Sep 10 09:17:32 1996
@@ -0,0 +1,52 @@
+/*
+==============================================================================
+
+TM BOT HEADER FILE
+
+==============================================================================
+*/
+/*
+// Global Constants
+
+float   BOT_TOGGLE				= 100;		// impulse constant
+float	BOT_AUTO_TOGGLE			= 101;		// impulse constant
+float	BOT_MOVE_FIRE			= 102;		// impulse constant
+float 	BOT_LEFT_FIRE_TOGGLE	= 103;		// impulse constant
+float	BOT_RIGHT_TELEPORT		= 104;		// impulse constant
+float	STAND					= 0;		// move_flag constant
+float	WALK					= 1;		// move_flag constant
+float	RUN						= 2;		// move_flag constant
+*/
+// Bot Prototypes - called by player
+
+void () Bot_Precache;		// Precache information for the bot
+//void () BotActivate;            // Activate bot
+//void () BotDeActivate;          // DeActivate bot
+//void () BotToggle;                      // Toggle bot on and off
+//void () BotAutoToggle;          // Toggle automatic/manual control of bot
+//void () BotMoveToggle;          // Toggle movement (walk, run, stand) in man mode
+//void () BotTurnRight;           // Turn bot to the right by 22.5 degrees in man mode
+//void () BotTurnLeft;            // Turn bot to the left by 22.5 degrees in man mode
+//void () BotFireToggle;          // Toggle bot's auto-firing in auto mode
+//void () BotFire;                        // Have bot fire at its current target in auto mode
+//void () BotTeleportHome;        // Have bot teleport back to its owner
+
+// Botai Prototypes - called by bot (mostly modified versions of existing code)
+
+float	()								BotFindTarget;
+void	()								BotFoundTarget;
+void	()								BotHuntTarget;
+void	()								bot_ai_stand;
+void	(float dist)					bot_ai_walk;
+void	(float dist)					bot_ai_run;
+void    ()                                                              bot_die;
+void    ()                                                              bot_ai_turn;
+void	()								bot_fire;
+void	(void () thinkst)				BotCheckRefire;		// Replaces SUB_CheckRefire
+void	()								BotSelfDeActivate;
+
+// Bot_ext Prototypes - called by triggers.qc
+
+void	()		bot_counter_use;
+void	()		bot_trigger_onlyregistered_touch;
+
diff -ur --new-file d:\quakestu\qcc\send\v101qc/bot.qc backup5/bot.qc
--- d:\quakestu\qcc\send\v101qc/bot.qc	Thu Jan  1 00:00:00 1970
+++ backup5/bot.qc	Wed Sep 11 06:58:40 1996
@@ -0,0 +1,373 @@
+/*
+==============================================================================
+
+BOT
+
+==============================================================================
+*/
+
+// Prototypes
+entity ()       SelectSpawnPoint; // bens
+void () BotStartDMB;
+void () BotStartDMC;
+void () BotStartDMD;
+
+void	()		Bot_Precache;
+void (vector org) spawn_tfog;
+void(vector org, entity death_owner) spawn_tdeath;
+
+float   modelindex_eyes, modelindex_bot;
+
+//=============================================================
+// Bot_Precache - called by Worldspawn
+//=============================================================
+void () Bot_Precache =
+{
+        precache_model ("progs/s_explod.spr");
+        precache_model ("progs/player.mdl");
+        precache_model ("progs/h_player.mdl");
+	precache_model2 ("progs/laser.mdl");
+        precache_model ("progs/null.spr");
+	precache_sound2 ("enforcer/death1.wav");
+	precache_sound2 ("enforcer/enfire.wav");
+	precache_sound2 ("enforcer/enfstop.wav");
+	precache_sound2 ("enforcer/idle1.wav");
+	precache_sound2 ("enforcer/pain1.wav");
+	precache_sound2 ("enforcer/pain2.wav");
+	precache_sound2 ("enforcer/sight1.wav");
+	precache_sound2 ("enforcer/sight2.wav");
+	precache_sound2 ("enforcer/sight3.wav");
+	precache_sound2 ("enforcer/sight4.wav");
+};
+
+void () BotStartDM =
+{
+// sounds and models precached in the world.qc file
+
+	local entity	newbot;
+        local entity    spot;
+        if (world.model == "maps/start.bsp")
+                return;
+	newbot = spawn();
+        newbot.solid = SOLID_SLIDEBOX;
+        newbot.movetype = MOVETYPE_STEP;
+        newbot.angles = self.angles;
+        newbot.classname = "bot";
+        newbot.netname = "Botinater";
+        newbot.owner=newbot;
+        self.bot_flag = TRUE;
+	newbot.health = 100;
+        newbot.max_health = 100;
+//        newbot.takedamage = DAMAGE_YES;
+        newbot.takedamage = DAMAGE_NO;
+        newbot.goalentity = self;
+        newbot.movetarget = self;
+	newbot.pausetime = time + 2;
+        newbot.items = (IT_SHOTGUN + IT_AXE);
+        newbot.weapon = (IT_SHOTGUN);
+        newbot.ammo_shells = 25;
+	newbot.ideal_yaw = newbot.angles * '0 1 0';
+	newbot.yaw_speed = 30;
+        newbot.view_ofs = '0 0 22';
+	newbot.th_stand = bot_stand1;
+	newbot.th_walk = bot_walk1;
+        newbot.th_stuff = bot_stuff1;
+        newbot.th_dodge = bot_dodge1;
+	newbot.th_run = bot_run1;
+        newbot.th_pain = SUB_Null;
+//        newbot.th_pain = bot_pain;
+	newbot.th_die = bot_die;
+	newbot.th_missile = bot_atk1;
+	self.super_damage_finished = 0;
+	self.radsuit_finished = 0;
+        self.invisible_finished = 0;
+	self.invincible_finished = 0;
+	self.effects = 0;
+	self.invincible_time = 0;	
+	self.deadflag = DEAD_NO;
+        setmodel (newbot, "progs/player.mdl");
+        setsize (newbot, VEC_HULL_MIN, VEC_HULL_MAX);
+//        setsize (newbot, '-16 -16 -24', '16 16 40');
+        spot = SelectSpawnPoint ();
+        newbot.origin = spot.origin + '0 0 2';
+        newbot.angles = spot.angles;
+        newbot.fixangle = TRUE;             
+//        bot_client();
+        spawn_tfog (newbot.origin);
+        spawn_tdeath(newbot.origin, newbot);
+
+	newbot.nextthink = time + 0.1;
+        newbot.think = BotBegin;
+        if (skill >= 1)
+                BotStartDMB();
+
+
+};
+void () BotStartDMB =
+{
+// sounds and models precached in the world.qc file
+
+	local entity	newbot;
+        local entity    spot;
+        if (world.model == "maps/start.bsp")
+                return;
+	newbot = spawn();
+        newbot.solid = SOLID_SLIDEBOX;
+        newbot.movetype = MOVETYPE_STEP;
+        newbot.angles = self.angles;
+        newbot.classname = "bot";
+        newbot.netname = "Bot-to-the-Bone";
+        newbot.owner=newbot;
+        self.bot_flag = TRUE;
+	newbot.health = 100;
+        newbot.max_health = 100;
+        newbot.takedamage = DAMAGE_YES;
+        newbot.goalentity = self;
+        newbot.movetarget = self;
+	newbot.pausetime = time + 2;
+        newbot.items = (IT_SHOTGUN + IT_AXE);
+        newbot.weapon = (IT_SHOTGUN);
+        newbot.ammo_shells = 25;
+	newbot.ideal_yaw = newbot.angles * '0 1 0';
+	newbot.yaw_speed = 30;
+	newbot.view_ofs = '0 0 25';
+	newbot.th_stand = bot_stand1;
+	newbot.th_walk = bot_walk1;
+        newbot.th_stuff = bot_stuff1;
+        newbot.th_dodge = bot_dodge1;
+	newbot.th_run = bot_run1;
+//        newbot.th_pain = bot_pain;
+        newbot.th_pain = SUB_Null;
+
+	newbot.th_die = bot_die;
+	newbot.th_missile = bot_atk1;
+        setmodel (newbot, "progs/player.mdl");
+        setsize (newbot, VEC_HULL_MIN, VEC_HULL_MAX);
+//        setsize (newbot, '-16 -16 -24', '16 16 40');
+        spot = SelectSpawnPoint ();
+        newbot.origin = spot.origin + '0 0 1';
+        newbot.angles = spot.angles;
+        newbot.fixangle = TRUE;             
+//        bot_client();
+	spawn_tfog (newbot.origin);
+        spawn_tdeath(newbot.origin, newbot);
+	newbot.nextthink = time + 0.1;
+	newbot.think = newbot.th_stand;
+        if (skill >= 2)
+                BotStartDMC();
+
+
+};
+void () BotStartDMC =
+{
+// sounds and models precached in the world.qc file
+
+	local entity	newbot;
+        local entity    spot;
+        if (world.model == "maps/start.bsp")
+                return;
+	newbot = spawn();
+        newbot.solid = SOLID_SLIDEBOX;
+        newbot.movetype = MOVETYPE_STEP;
+        newbot.angles = self.angles;
+        newbot.classname = "bot";
+        newbot.netname = "Botcules";
+        newbot.owner=newbot;
+        self.bot_flag = TRUE;
+	newbot.health = 100;
+        newbot.max_health = 100;
+        newbot.takedamage = DAMAGE_YES;
+        newbot.goalentity = self;
+        newbot.movetarget = self;
+	newbot.pausetime = time + 2;
+        newbot.items = (IT_SHOTGUN + IT_AXE);
+        newbot.weapon = (IT_SHOTGUN);
+        newbot.ammo_shells = 25;
+	newbot.ideal_yaw = newbot.angles * '0 1 0';
+	newbot.yaw_speed = 30;
+	newbot.view_ofs = '0 0 25';
+	newbot.th_stand = bot_stand1;
+	newbot.th_walk = bot_walk1;
+        newbot.th_stuff = bot_stuff1;
+        newbot.th_dodge = bot_dodge1;
+	newbot.th_run = bot_run1;
+//        newbot.th_pain = bot_pain;
+        newbot.th_pain = SUB_Null;
+	newbot.th_die = bot_die;
+	newbot.th_missile = bot_atk1;
+        setmodel (newbot, "progs/player.mdl");
+        setsize (newbot, VEC_HULL_MIN, VEC_HULL_MAX);
+//        setsize (newbot, '-16 -16 -24', '16 16 40');
+        spot = SelectSpawnPoint ();
+        newbot.origin = spot.origin + '0 0 1';
+        newbot.angles = spot.angles;
+        newbot.fixangle = TRUE;             
+//        bot_client();
+	spawn_tfog (newbot.origin);
+        spawn_tdeath(newbot.origin, newbot);
+	newbot.nextthink = time + 0.1;
+	newbot.think = newbot.th_stand;
+        if (skill >= 3)
+                BotStartDMD();
+};
+void () BotStartDMD =
+{
+// sounds and models precached in the world.qc file
+
+	local entity	newbot;
+        local entity    spot;
+        if (world.model == "maps/start.bsp")
+                return;
+	newbot = spawn();
+        newbot.solid = SOLID_SLIDEBOX;
+        newbot.movetype = MOVETYPE_STEP;
+        newbot.angles = self.angles;
+        newbot.classname = "bot";
+        newbot.netname = "DeathBOT";
+        newbot.owner=newbot;
+        self.bot_flag = TRUE;
+	newbot.health = 100;
+        newbot.max_health = 100;
+        newbot.takedamage = DAMAGE_YES;
+        newbot.goalentity = self;
+        newbot.movetarget = self;
+	newbot.pausetime = time + 2;
+        newbot.items = (IT_SHOTGUN + IT_AXE);
+        newbot.weapon = (IT_SHOTGUN);
+        newbot.ammo_shells = 25;
+	newbot.ideal_yaw = newbot.angles * '0 1 0';
+	newbot.yaw_speed = 30;
+	newbot.view_ofs = '0 0 25';
+	newbot.th_stand = bot_stand1;
+	newbot.th_walk = bot_walk1;
+        newbot.th_stuff = bot_stuff1;
+        newbot.th_dodge = bot_dodge1;
+	newbot.th_run = bot_run1;
+//        newbot.th_pain = bot_pain;
+        newbot.th_pain = SUB_Null;
+	newbot.th_die = bot_die;
+	newbot.th_missile = bot_atk1;
+        setmodel (newbot, "progs/player.mdl");
+        setsize (newbot, VEC_HULL_MIN, VEC_HULL_MAX);
+//        setsize (newbot, '-16 -16 -24', '16 16 40');
+        
+        spot = SelectSpawnPoint ();
+        newbot.origin = spot.origin + '0 0 1';
+        newbot.angles = spot.angles;
+        newbot.fixangle = TRUE;             
+//        bot_client();
+	spawn_tfog (newbot.origin);
+        spawn_tdeath(newbot.origin, newbot);
+	newbot.nextthink = time + 0.1;
+	newbot.think = newbot.th_stand;
+};                 
+
+void (float frgs,entity tmp,string tmpb) BotReStartDM =
+{
+// sounds and models precached in the world.qc file
+
+	local entity	newbot;
+        local entity    spot;
+	newbot = spawn();
+        newbot.solid = SOLID_SLIDEBOX;
+        newbot.movetype = MOVETYPE_STEP;
+        newbot.angles = self.angles;
+        newbot.classname = "bot";
+        newbot.netname = tmpb;
+        newbot.owner=newbot;
+	newbot.health = 100;
+        newbot.max_health = 100;
+        newbot.takedamage = DAMAGE_YES;
+        newbot.goalentity = tmp;
+        newbot.movetarget = tmp;
+	newbot.pausetime = time + 2;
+        newbot.items = (IT_SHOTGUN + IT_AXE);
+        newbot.weapon = (IT_SHOTGUN);
+        newbot.ammo_shells = 25;
+	newbot.ideal_yaw = newbot.angles * '0 1 0';
+	newbot.yaw_speed = 30;
+	newbot.view_ofs = '0 0 25';
+        newbot.enemy = tmp;
+        newbot.frags = frgs;
+	newbot.th_stand = bot_stand1;
+	newbot.th_walk = bot_walk1;
+	newbot.th_run = bot_run1;
+        newbot.th_stuff = bot_stuff1;
+        newbot.th_dodge = bot_dodge1;
+//        newbot.th_pain = bot_pain;
+        newbot.th_pain = SUB_Null;
+	newbot.th_die = bot_die;
+	newbot.th_missile = bot_atk1;
+        setmodel (newbot, "progs/player.mdl");
+        setsize (newbot, VEC_HULL_MIN, VEC_HULL_MAX);
+//        setsize (newbot, '-16 -16 -24', '16 16 40');
+        
+        spot = SelectSpawnPoint ();
+        newbot.origin = spot.origin + '0 0 1';
+        newbot.angles = spot.angles;
+        newbot.fixangle = TRUE;             
+//        bot_client();
+	spawn_tfog (newbot.origin);
+        spawn_tdeath(newbot.origin, newbot);
+	newbot.nextthink = time + 0.1;
+        newbot.think = newbot.th_run;
+};
+
+void () BotAdd =
+{
+// sounds and models precached in the world.qc file
+
+	local entity	newbot;
+        local entity    spot;
+	newbot = spawn();
+        newbot.solid = SOLID_SLIDEBOX;
+        newbot.movetype = MOVETYPE_STEP;
+        newbot.angles = self.angles;
+        newbot.classname = "bot";
+        newbot.netname = "KillBOT";
+        newbot.owner=newbot;
+        self.bot_flag = TRUE;
+	newbot.health = 100;
+        newbot.max_health = 100;
+        newbot.takedamage = DAMAGE_YES;
+        newbot.goalentity = self;
+        newbot.movetarget = self;
+        newbot.pausetime = time + 2;
+        newbot.items = (IT_SHOTGUN + IT_AXE);
+        newbot.weapon = (IT_SHOTGUN);
+        newbot.ammo_shells = 25;
+	newbot.ideal_yaw = newbot.angles * '0 1 0';
+	newbot.yaw_speed = 30;
+        newbot.view_ofs = '0 0 22';
+	newbot.th_stand = bot_stand1;
+	newbot.th_walk = bot_walk1;
+        newbot.th_stuff = bot_stuff1;
+        newbot.th_dodge = bot_dodge1;
+	newbot.th_run = bot_run1;
+//        newbot.th_pain = bot_pain;
+        newbot.th_pain = SUB_Null;
+
+	newbot.th_die = bot_die;
+	newbot.th_missile = bot_atk1;
+        self.super_damage_finished = 0;
+	self.radsuit_finished = 0;
+        self.invisible_finished = 0;
+	self.invincible_finished = 0;
+	self.effects = 0;
+	self.invincible_time = 0;	
+	self.deadflag = DEAD_NO;
+
+        setmodel (newbot, "progs/player.mdl");
+        setsize (newbot, VEC_HULL_MIN, VEC_HULL_MAX);
+//        setsize (newbot, '-16 -16 -24', '16 16 40');
+        
+        spot = SelectSpawnPoint ();
+        newbot.origin = spot.origin + '0 0 1';
+        newbot.angles = spot.angles;
+        newbot.fixangle = TRUE;             
+//        bot_client();
+	spawn_tfog (newbot.origin);
+        spawn_tdeath(newbot.origin, newbot);
+	newbot.nextthink = time + 0.1;
+	newbot.think = newbot.th_stand;
+};
diff -ur --new-file d:\quakestu\qcc\send\v101qc/bot_ext.qc backup5/bot_ext.qc
--- d:\quakestu\qcc\send\v101qc/bot_ext.qc	Thu Jan  1 00:00:00 1970
+++ backup5/bot_ext.qc	Fri Aug 30 21:21:56 1996
@@ -0,0 +1,50 @@
+/*
+==============================================================================
+
+BOT EXTENSIONS
+
+==============================================================================
+*/
+
+// Prototypes
+
+void	()		bot_counter_use;
+void	()		bot_trigger_onlyregistered_touch;
+
+
+void() bot_counter_use =
+{
+	local string junk;
+
+	self.count = self.count - 1;
+	if (self.count < 0)
+		return;
+	
+	self.enemy = activator;
+	multi_trigger ();
+};
+
+
+void() bot_trigger_onlyregistered_touch =
+{
+	if (self.attack_finished > time)
+		return;
+
+	self.attack_finished = time + 2;
+	if (cvar("registered"))
+	{
+		self.message = "";
+		SUB_UseTargets ();
+		remove (self);
+	}
+	else
+	{
+		if (self.message != "")
+		{
+			sprint (other.owner, "Incoming message from bot:\n");
+			centerprint (other.owner, self.message);
+			sound (other.owner, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
+		}
+	}
+};
+
diff -ur --new-file d:\quakestu\qcc\send\v101qc/botai.qc backup5/botai.qc
--- d:\quakestu\qcc\send\v101qc/botai.qc	Thu Jan  1 00:00:00 1970
+++ backup5/botai.qc	Wed Sep 11 07:16:06 1996
@@ -0,0 +1,2346 @@
+
+/*
+==============================================================================
+
+BOT AI
+
+==============================================================================
+*/
+
+// Prototypes
+float() crandom;
+void () bot_checkrange;
+void(vector org, vector vel) SpawnMeatSpray;
+void(entity attacker, float damage)     bot_pain;
+void(vector org, vector vel, float damage) SpawnBlood;
+void() bot_FireAxe;
+void() QAxe_Attack;
+void() Axe_Attack;
+void() bot_FireLightning;
+void(float shotcount, vector dir, vector spread) FireBullets;
+void () bot_upabit;
+float() check_dodge;
+void () bot_start_dodge;
+void () bot_run_mdodge;
+void () bot_end_dodge;
+void () bot_start_circle;
+void () bot_end_circle;
+void () bot_enemy_image;
+void () bot_remove_enemy_image;
+void () bot_ai_face;
+float(entity targ, entity targ2) infrontr;
+void() bot_firebullets;
+void () BotFoundRocket;
+void () BotStartDM;
+void (float frgs,entity tmp,string tmpb) BotReStartDM;
+void () bot_run_dodge;
+float	()								BotFindTarget;
+void () bot_run_circle;
+void	()								bot_ai_stand;
+void	()								bot_die;
+void	()								BotFoundTarget;
+void    ()                                                              BotHuntTarget;
+void	(float dist)					bot_ai_walk;
+void	()								bot_ai_turn;
+void	(float dist)					bot_ai_run;
+void	(void () thinkst)				BotCheckRefire;
+void	()								BotSelfDeActivate;
+void    ()                                              bot_attack;
+void    ()                                              bot_shoot;
+void	()								bot_fire;
+void    ()                                              bot_nail;
+void    ()                                              bot_nail2;
+void    ()                                              enforcer_fire;
+void    (vector offset)                                 benforcer_fire;
+void    (vector org, vector dir)                        launch_spike;
+void    ()                                              spike_touch;
+void ()                                                 superspike_touch;
+void (entity oldself) Bot_PostThink;
+void (entity oldself) Bot_PreThink;
+//void () bot_remove_controller;
+void () bot_think;
+void () Bot_PostThinkb;
+void () Bot_PreThinkb;
+void () bot_thinkb;
+void() BotCheckPowerupsb;
+float   modelindex_eyes, modelindex_bot;
+void () BotFoundItem;
+float () BotFindItem;
+void () BOTFireGrenade;
+void () BOTGrenadeTouch;
+void () BOTGrenadeExplode;
+void () s_explode1;
+void    (float dist)                                    bot_ai_stuff;
+void    ()                                              BotFoundStuff;
+void    ()                                              BotHuntStuff;
+float    ()                                              BotFindStuff;
+
+//void () set_ai_think;
+ 
+$cd /raid/quake/id1/models/player_4
+$origin 0 -6 24
+$base base		
+$skin skin
+
+//
+// running
+//
+$frame axrun1 axrun2 axrun3 axrun4 axrun5 axrun6
+
+$frame rockrun1 rockrun2 rockrun3 rockrun4 rockrun5 rockrun6
+
+//
+// standing
+//
+$frame stand1 stand2 stand3 stand4 stand5
+
+$frame axstnd1 axstnd2 axstnd3 axstnd4 axstnd5 axstnd6
+$frame axstnd7 axstnd8 axstnd9 axstnd10 axstnd11 axstnd12
+
+
+//
+// pain
+//
+$frame axpain1 axpain2 axpain3 axpain4 axpain5 axpain6
+
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+
+
+//
+// death
+//
+
+$frame axdeth1 axdeth2 axdeth3 axdeth4 axdeth5 axdeth6
+$frame axdeth7 axdeth8 axdeth9
+
+$frame deatha1 deatha2 deatha3 deatha4 deatha5 deatha6 deatha7 deatha8
+$frame deatha9 deatha10 deatha11
+
+$frame deathb1 deathb2 deathb3 deathb4 deathb5 deathb6 deathb7 deathb8
+$frame deathb9
+
+$frame deathc1 deathc2 deathc3 deathc4 deathc5 deathc6 deathc7 deathc8
+$frame deathc9 deathc10 deathc11 deathc12 deathc13 deathc14 deathc15
+
+$frame deathd1 deathd2 deathd3 deathd4 deathd5 deathd6 deathd7
+$frame deathd8 deathd9
+
+$frame deathe1 deathe2 deathe3 deathe4 deathe5 deathe6 deathe7
+$frame deathe8 deathe9
+
+//
+// attacks
+//
+$frame nailatt1 nailatt2
+
+$frame light1 light2
+
+$frame rockatt1 rockatt2 rockatt3 rockatt4 rockatt5 rockatt6
+
+$frame shotatt1 shotatt2 shotatt3 shotatt4 shotatt5 shotatt6
+
+$frame axatt1 axatt2 axatt3 axatt4 axatt5 axatt6
+
+$frame axattb1 axattb2 axattb3 axattb4 axattb5 axattb6
+
+$frame axattc1 axattc2 axattc3 axattc4 axattc5 axattc6
+
+$frame axattd1 axattd2 axattd3 axattd4 axattd5 axattd6
+
+
+void()	bot_stand1	=[	$stand1,	bot_stand2	] {bot_ai_stand();};
+void()	bot_stand2	=[	$stand2,	bot_stand3	] {bot_ai_stand();};
+void()	bot_stand3	=[	$stand3,	bot_stand4	] {bot_ai_stand();};
+void()	bot_stand4	=[	$stand4,	bot_stand5	] {bot_ai_stand();};
+void()  bot_stand5      =[      $stand5,        bot_stand1      ] {bot_ai_stand();};
+
+void()  bot_standa1      =[      $axstnd1,        bot_standa2      ] {bot_ai_stand();};
+void()  bot_standa2      =[      $axstnd2,        bot_standa3      ] {bot_ai_stand();};
+void()  bot_standa3      =[      $axstnd3,        bot_standa4      ] {bot_ai_stand();};
+void()  bot_standa4      =[      $axstnd4,        bot_standa5      ] {bot_ai_stand();};
+void()  bot_standa5      =[      $axstnd5,        bot_standa6      ] {bot_ai_stand();};
+void()  bot_standa6      =[      $axstnd6,        bot_standa7      ] {bot_ai_stand();};
+void()  bot_standa7      =[      $axstnd7,        bot_standa8      ] {bot_ai_stand();};
+void()  bot_standa8      =[      $axstnd8,        bot_standa9      ] {bot_ai_stand();};
+void()  bot_standa9      =[      $axstnd9,        bot_standa10      ] {bot_ai_stand();};
+void()  bot_standa10      =[      $axstnd10,        bot_standa11      ] {bot_ai_stand();};
+void()  bot_standa11     =[      $axstnd11,        bot_standa12      ] {bot_ai_stand();};
+void()  bot_standa12      =[      $axstnd12,        bot_standa1      ] {bot_ai_stand();};
+
+void()  bot_walk1       =[      $rockrun1 ,        bot_walk2       ]
+{
+        bot_ai_walk(6);
+};
+void()  bot_walk2       =[      $rockrun1 ,        bot_walk3       ] {bot_ai_walk(10);};
+void()  bot_walk3       =[      $rockrun2 ,        bot_walk4       ] {bot_ai_walk(10);};
+void()  bot_walk4       =[      $rockrun2 ,        bot_walk5       ] {bot_ai_walk(8);};
+void()  bot_walk5       =[      $rockrun3 ,        bot_walk6       ] {bot_ai_walk(4);};
+void()  bot_walk6       =[      $rockrun3 ,        bot_walk7       ] {bot_ai_walk(6);bot_upabit();};
+void()  bot_walk7       =[      $rockrun4 ,        bot_walk8       ] {bot_ai_walk(10);};
+void()  bot_walk8       =[      $rockrun4 ,        bot_walk9       ] {bot_ai_walk(10);};
+void()  bot_walk9       =[      $rockrun5 ,        bot_walk10       ] {bot_ai_walk(8);};
+void()  bot_walk10       =[      $rockrun5 ,        bot_walk11       ] {bot_ai_walk(4);};
+void()  bot_walk11       =[      $rockrun6 ,        bot_walk12       ] {bot_ai_walk(6);};
+void()  bot_walk12       =[      $rockrun6 ,        bot_walk1       ] {bot_ai_walk(8);bot_upabit();};
+
+void()  bot_walka1       =[      $axrun1 ,        bot_walk2       ]
+{
+        bot_ai_walk(6);
+};
+void()  bot_walka2       =[      $axrun1 ,        bot_walka3       ] {bot_ai_walk(10);};
+void()  bot_walka3       =[      $axrun2 ,        bot_walka4       ] {bot_ai_walk(10);};
+void()  bot_walka4       =[      $axrun2 ,        bot_walka5       ] {bot_ai_walk(8);};
+void()  bot_walka5       =[      $axrun3 ,        bot_walka6       ] {bot_ai_walk(4);};
+void()  bot_walka6       =[      $axrun3 ,        bot_walka7       ] {bot_ai_walk(6);bot_upabit();};
+void()  bot_walka7       =[      $axrun4 ,        bot_walka8       ] {bot_ai_walk(10);};
+void()  bot_walka8       =[      $axrun4 ,        bot_walka9       ] {bot_ai_walk(10);};
+void()  bot_walka9       =[      $axrun5 ,        bot_walka10       ] {bot_ai_walk(8);};
+void()  bot_walka10       =[      $axrun5 ,        bot_walka11       ] {bot_ai_walk(4);};
+void()  bot_walka11       =[      $axrun6 ,        bot_walka12       ] {bot_ai_walk(6);};
+void()  bot_walka12       =[      $axrun6 ,        bot_walka1       ] {bot_ai_walk(8);bot_upabit();};
+
+void()  bot_run1        =[      $rockrun1  ,        bot_run2        ]
+{
+        bot_ai_run(30);//18
+};
+void()  bot_run2        =[      $rockrun2  ,        bot_run3        ] {bot_ai_run(30);};//14
+void()  bot_run3        =[      $rockrun3  ,        bot_run4        ] {bot_ai_run(30);bot_upabit();};//7
+void()  bot_run4        =[      $rockrun4  ,        bot_run5        ] {bot_ai_run(30);};//12
+void()  bot_run5        =[      $rockrun5  ,        bot_run6        ] {bot_ai_run(30);};//14
+void()  bot_run6        =[      $rockrun6  ,        bot_run1        ] {bot_ai_run(30);bot_upabit();};//14
+
+void()  bot_runa1        =[      $axrun1  ,        bot_runa2        ]
+{
+        bot_ai_run(30);//18
+};
+void()  bot_runa2        =[      $axrun2  ,        bot_runa3        ] {bot_ai_run(30);};//14
+void()  bot_runa3        =[      $axrun3  ,        bot_runa4        ] {bot_ai_run(30);bot_upabit();};//7
+void()  bot_runa4        =[      $axrun4  ,        bot_runa5        ] {bot_ai_run(30);};//12
+void()  bot_runa5        =[      $axrun5  ,        bot_runa6        ] {bot_ai_run(30);};//14
+void()  bot_runa6        =[      $axrun6  ,        bot_runa1        ] {bot_ai_run(30);bot_upabit();};//14
+
+void()  bot_dodge1        =[      $shotatt1,       bot_dodge2        ] {bot_ai_face();bot_checkrange();bot_start_dodge();bot_run_dodge();};
+void()  bot_dodge2        =[      $shotatt2,       bot_dodge3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodge3        =[      $shotatt3,       bot_dodge4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge4        =[      $shotatt4,       bot_dodge5        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge5        =[      $shotatt5,       bot_dodge6        ] {bot_ai_face();bot_run_dodge();};
+
+void()  bot_dodge6        =[      $rockrun1  ,        bot_dodge7        ]
+{bot_ai_face();
+        bot_run_dodge();
+};
+void()  bot_dodge7        =[      $rockrun2  ,        bot_dodge8        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge8        =[      $rockrun3  ,        bot_dodge9        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge9        =[      $rockrun4  ,        bot_dodge10       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge10       =[      $rockrun5  ,        bot_dodge11       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge11       =[      $shotatt1,       bot_dodge12        ] {bot_ai_face();bot_checkrange();bot_run_dodge();};
+void()  bot_dodge12       =[      $shotatt2,       bot_dodge13        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodge13       =[      $shotatt3,       bot_dodge14       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge14       =[      $shotatt4,       bot_dodge15        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge15        =[      $shotatt5,       bot_dodge16        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge16        =[      $shotatt6,       bot_dodge17        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge17        =[      $rockrun3  ,        bot_dodge18        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge18        =[      $rockrun4  ,        bot_dodge19        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge19        =[      $rockrun5  ,        bot_dodge20        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodge20       =[      $rockrun6  ,        bot_run1        ] {bot_ai_face();bot_run_dodge();bot_end_dodge();};
+
+void()  bot_dodgen1        =[      $nailatt2,       bot_dodgen2        ] {bot_ai_face();bot_checkrange();bot_start_dodge();bot_run_dodge();};
+void()  bot_dodgen2        =[      $nailatt1,       bot_dodgen3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen3        =[      $nailatt2,       bot_dodgen4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen4        =[      $nailatt1,       bot_dodgen5        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen5        =[      $nailatt2,       bot_dodgen6        ] {bot_ai_face();bot_run_dodge();};
+
+void()  bot_dodgen6        =[      $nailatt1  ,        bot_dodgen7        ]
+{bot_ai_face();
+bot_attack();
+        bot_run_dodge();
+};
+void()  bot_dodgen7        =[      $nailatt2  ,        bot_dodgen8        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen8        =[      $nailatt1  ,        bot_dodgen9        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen9        =[      $nailatt2 ,        bot_dodgen10       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen10       =[      $nailatt1  ,        bot_dodgen11       ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen11       =[      $nailatt2,       bot_dodgen12        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen12       =[      $nailatt1,       bot_dodgen13        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen13       =[      $nailatt2,       bot_dodgen14       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen14       =[      $nailatt1,       bot_dodgen15        ] {bot_ai_face();bot_checkrange();bot_attack();bot_run_dodge();};
+void()  bot_dodgen15        =[      $nailatt2,       bot_dodgen16        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen16        =[      $nailatt1,       bot_dodgen17        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen17        =[      $nailatt2  ,        bot_dodgen18        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen18        =[      $nailatt1  ,        bot_dodgen19        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgen19        =[      $nailatt2  ,        bot_dodgen20        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgen20       =[      $nailatt1  ,        bot_run1        ] {bot_ai_face();bot_attack();bot_run_dodge();bot_end_dodge();};
+
+void()  bot_dodgesn1        =[      $nailatt2,       bot_dodgesn2        ] {bot_ai_face();bot_start_dodge();bot_run_dodge();};
+void()  bot_dodgesn2        =[      $nailatt1,       bot_dodgesn3        ] {bot_ai_face();bot_checkrange();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn3        =[      $nailatt1,       bot_dodgesn4        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn4        =[      $nailatt2,       bot_dodgesn5        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgesn5        =[      $nailatt1,       bot_dodgesn6        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+
+void()  bot_dodgesn6        =[      $nailatt1  ,        bot_dodgesn7        ]
+{bot_ai_face();
+        bot_attack();
+        bot_run_dodge();
+};
+void()  bot_dodgesn7        =[      $nailatt2  ,        bot_dodgesn8        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgesn8        =[      $nailatt1  ,        bot_dodgesn9        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn9        =[      $nailatt1  ,        bot_dodgesn10       ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn10       =[      $nailatt2  ,        bot_dodgesn11       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgesn11       =[      $nailatt2,       bot_dodgesn12        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgesn12       =[      $nailatt1,       bot_dodgesn13        ] {bot_ai_face();bot_checkrange();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn13       =[      $nailatt1,       bot_dodgesn14       ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn14       =[      $nailatt2,       bot_dodgesn15        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgesn15        =[      $nailatt1,       bot_dodgesn16        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn16        =[      $nailatt1,       bot_dodgesn17        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn17        =[      $nailatt2  ,        bot_dodgesn18        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgesn18        =[      $nailatt1  ,        bot_dodgesn19        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn19        =[      $nailatt1  ,        bot_dodgesn20        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgesn20       =[      $nailatt2  ,        bot_run1        ] {bot_ai_face();bot_run_dodge();bot_end_dodge();};
+
+void()  bot_dodger1        =[      $rockatt1,       bot_dodger2        ] {bot_ai_face();bot_start_dodge();bot_checkrange();bot_attack();bot_run_dodge();};
+void()  bot_dodger2        =[      $rockatt2,       bot_dodger3        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger3        =[      $rockatt3,       bot_dodger4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger4        =[      $rockatt4,       bot_dodger5        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger5        =[      $rockatt5,       bot_dodger6        ] {bot_ai_face();bot_run_dodge();};
+
+void()  bot_dodger6        =[      $rockrun1  ,        bot_dodger7        ]
+{bot_ai_face();
+        bot_run_dodge();
+};
+void()  bot_dodger7        =[      $rockrun2  ,        bot_dodger8        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger8        =[      $rockrun3  ,        bot_dodger9        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger9        =[      $rockrun4  ,        bot_dodger10       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger10       =[      $rockrun5  ,        bot_dodger11       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger11       =[      $rockatt1,       bot_dodger12        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodger12       =[      $rockatt2,       bot_dodger13        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger13       =[      $rockatt3,       bot_dodger14       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger14       =[      $rockatt4,       bot_dodger15        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger15        =[      $rockatt5,       bot_dodger16        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger16        =[      $rockatt6,       bot_dodger17        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger17        =[      $rockrun3  ,        bot_dodger18        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger18        =[      $rockrun4  ,        bot_dodger19        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger19        =[      $rockrun5  ,        bot_dodger20        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodger20       =[      $rockrun6  ,        bot_run1        ] {bot_ai_face();bot_run_dodge();bot_end_dodge();};
+
+void()  bot_dodgel1        =[      $light1,       bot_dodgel2        ] {bot_ai_face();bot_checkrange();bot_attack();bot_start_dodge();bot_run_dodge();};
+void()  bot_dodgel2        =[      $light2,       bot_dodgel3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel3        =[      $light1,       bot_dodgel4        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel4        =[      $light2,       bot_dodgel5        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel5        =[      $light1,       bot_dodgel6        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+
+void()  bot_dodgel6        =[      $light2  ,        bot_dodgel7        ]
+{bot_ai_face();
+        bot_attack();
+        bot_run_dodge();
+};
+void()  bot_dodgel7        =[      $light1  ,        bot_dodgel8        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel8        =[      $light2  ,        bot_dodgel9        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel9        =[      $light1  ,        bot_dodgel10       ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel10       =[      $light2  ,        bot_dodgel11       ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel11       =[      $light1,       bot_dodgel12        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel12       =[      $light2,       bot_dodgel13        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel13       =[      $light1,       bot_dodgel14       ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel14       =[      $light2,       bot_dodgel15        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel15        =[      $light1,       bot_dodgel16        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel16        =[      $light2,       bot_dodgel17        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel17        =[      $light1  ,        bot_dodgel18        ] {bot_ai_face();bot_checkrange();bot_attack();bot_run_dodge();};
+void()  bot_dodgel18        =[      $light2  ,        bot_dodgel19        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel19        =[      $light1  ,        bot_dodgel20        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_dodgel20       =[      $light2  ,        bot_run1        ] {bot_ai_face();bot_attack();bot_run_dodge();bot_end_dodge();};
+
+void()  bot_circle1        =[      $shotatt1,       bot_circle2        ] {bot_ai_face();bot_start_circle();bot_run_circle();};
+void()  bot_circle2        =[      $shotatt2,       bot_circle3        ] {bot_ai_face();bot_attack();bot_run_circle();};
+void()  bot_circle3        =[      $shotatt3,       bot_circle4        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle4        =[      $shotatt4,       bot_circle5        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle5        =[      $shotatt5,       bot_circle6        ] {bot_ai_face();bot_run_circle();};
+
+void()  bot_circle6        =[      $rockrun1  ,        bot_circle7        ]
+{bot_ai_face();
+        bot_run_circle();
+};
+void()  bot_circle7        =[      $rockrun2  ,        bot_circle8        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle8        =[      $rockrun3  ,        bot_circle9        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle9        =[      $rockrun4  ,        bot_circle10       ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle10       =[      $rockrun5  ,        bot_circle11       ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle11       =[      $shotatt1,       bot_circle12        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle12       =[      $shotatt2,       bot_circle13        ] {bot_ai_face();bot_attack();bot_run_circle();};
+void()  bot_circle13       =[      $shotatt3,       bot_circle14       ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle14       =[      $shotatt4,       bot_circle15        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle15        =[      $shotatt5,       bot_circle16        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle16        =[      $shotatt6,       bot_circle17        ] {bot_ai_face();bot_run_circle();};
+
+void()  bot_circle17        =[      $rockrun3  ,        bot_circle18        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle18        =[      $rockrun4  ,        bot_circle19        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle19        =[      $rockrun5  ,        bot_circle20        ] {bot_ai_face();bot_run_circle();};
+void()  bot_circle20       =[      $rockrun6  ,        bot_circle1        ] {bot_ai_face();bot_run_circle();bot_end_circle();};
+
+
+
+void()  bot_atk1        =[      $shotatt1,       bot_atk2        ] {bot_ai_face();};
+void()  bot_atk2        =[      $shotatt2,       bot_atk3        ] {bot_ai_face();bot_checkrange();bot_attack();};
+void()  bot_atk3        =[      $shotatt3,       bot_atk4        ] {bot_ai_face();};
+void()  bot_atk4        =[      $shotatt4,       bot_atk5        ] {bot_ai_face();};
+void()  bot_atk5        =[      $shotatt5,       bot_atk6        ] {bot_ai_face();};
+void()  bot_atk6        =[      $shotatt6,       bot_run1        ] {bot_ai_face();
+        bot_ai_face();
+	BotCheckRefire (bot_atk1);
+};
+void()  bot_atkn1        =[      $nailatt2,       bot_atkn2        ] {bot_ai_face();};
+void()  bot_atkn2        =[      $nailatt1,       bot_atkn3        ] {bot_ai_face();bot_checkrange();bot_attack();};
+void()  bot_atkn3        =[      $nailatt2,       bot_atkn4        ] {bot_ai_face();};
+void()  bot_atkn4        =[      $nailatt1,       bot_atkn5        ] {bot_ai_face();bot_attack();};
+void()  bot_atkn5        =[      $nailatt2,       bot_atkn6        ] {bot_ai_face();};
+void()  bot_atkn6        =[      $nailatt1,       bot_run1        ] {bot_ai_face();bot_checkrange();bot_attack();
+        bot_ai_face();
+        BotCheckRefire (bot_atkn1);
+};
+void()  bot_atksn1        =[      $nailatt2,       bot_atksn2        ] {bot_ai_face();};
+void()  bot_atksn2        =[      $nailatt1,       bot_atksn3        ] {bot_ai_face();bot_checkrange();bot_attack();};
+void()  bot_atksn3        =[      $nailatt1,       bot_atksn4        ] {bot_ai_face();bot_attack();};
+void()  bot_atksn4        =[      $nailatt2,       bot_atksn5        ] {bot_ai_face();};
+void()  bot_atksn5        =[      $nailatt1,       bot_atksn6        ] {bot_ai_face();bot_checkrange();bot_attack();};
+void()  bot_atksn6        =[      $nailatt1,       bot_run1        ] {bot_ai_face();bot_attack();
+        bot_ai_face();
+        BotCheckRefire (bot_atksn1);
+};
+
+void()  bot_atkr1        =[      $rockatt1,       bot_atkr2        ] {bot_ai_face();bot_checkrange();bot_attack();};
+void()  bot_atkr2        =[      $rockatt2,       bot_atkr3        ] {bot_ai_face();};
+void()  bot_atkr3        =[      $rockatt3,       bot_atkr4        ] {bot_ai_face();};
+void()  bot_atkr4        =[      $rockatt4,       bot_atkr5        ] {bot_ai_face();};
+void()  bot_atkr5        =[      $rockatt5,       bot_atkr6        ] {bot_ai_face();};
+void()  bot_atkr6        =[      $rockatt6,       bot_run1        ] {bot_ai_face();
+        bot_ai_face();
+//        BotCheckRefire (bot_atkr1);
+};
+void()  bot_atkl1        =[      $light1,       bot_atkl2        ] {bot_ai_face();bot_checkrange();bot_attack();};
+void()  bot_atkl2        =[      $light2,       bot_atkl3        ] {bot_ai_face();bot_attack();};
+void()  bot_atkl3        =[      $light1,       bot_atkl4        ] {bot_ai_face();bot_attack();};
+void()  bot_atkl4        =[      $light2,       bot_atkl5        ] {bot_ai_face();bot_attack();};
+void()  bot_atkl5        =[      $light1,       bot_atkl6        ] {bot_ai_face();bot_attack();};
+void()  bot_atkl6        =[      $light2,       bot_run1        ] {bot_ai_face();bot_attack();
+        bot_ai_face();
+        BotCheckRefire (bot_atkl1);
+};     
+void()  bot_atka1        =[      $axatt1,       bot_atka2        ] {bot_ai_face();};
+void()  bot_atka2        =[      $axatt2,       bot_atka3        ] {bot_ai_face();};
+void()  bot_atka3        =[      $axatt3,       bot_atka4        ] {bot_ai_face();};
+void()  bot_atka4        =[      $axatt4,       bot_atka5        ] {bot_ai_face();bot_checkrange();bot_FireAxe();};
+void()  bot_atka5        =[      $axatt5,       bot_atka6        ] {bot_ai_face();};
+void()  bot_atka6        =[      $axatt6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+void()  bot_atkab1        =[      $axattb1,       bot_atkab2        ] {bot_ai_face();};
+void()  bot_atkab2        =[      $axattb2,       bot_atkab3        ] {bot_ai_face();};
+void()  bot_atkab3        =[      $axattb3,       bot_atkab4        ] {bot_ai_face();};
+void()  bot_atkab4        =[      $axattb4,       bot_atkab5        ] {bot_ai_face();bot_checkrange();bot_FireAxe();};
+void()  bot_atkab5        =[      $axattb5,       bot_atkab6        ] {bot_ai_face();};
+void()  bot_atkab6        =[      $axattb6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+void()  bot_atkac1        =[      $axattc1,       bot_atkac2        ] {bot_ai_face();};
+void()  bot_atkac2        =[      $axattc2,       bot_atkac3        ] {bot_ai_face();};
+void()  bot_atkac3        =[      $axattc3,       bot_atkac4        ] {bot_ai_face();};
+void()  bot_atkac4        =[      $axattc4,       bot_atkac5        ] {bot_ai_face();bot_checkrange();bot_FireAxe();};
+void()  bot_atkac5        =[      $axattc5,       bot_atkac6        ] {bot_ai_face();};
+void()  bot_atkac6        =[      $axattc6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+void()  bot_atkad1        =[      $axattd1,       bot_atkad2        ] {bot_ai_face();};
+void()  bot_atkad2        =[      $axattd2,       bot_atkad3        ] {bot_ai_face();};
+void()  bot_atkad3        =[      $axattd3,       bot_atkad4        ] {bot_ai_face();};
+void()  bot_atkad4        =[      $axattd4,       bot_atkad5        ] {bot_ai_face();bot_checkrange();bot_FireAxe();};
+void()  bot_atkad5        =[      $axattd5,       bot_atkad6        ] {bot_ai_face();};
+void()  bot_atkad6        =[      $axattd6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+
+void()  bot_stuff1        =[      $rockrun1  ,        bot_stuff2        ]
+{
+        bot_ai_stuff(18);
+};
+void()  bot_stuff2        =[      $rockrun2  ,        bot_stuff3        ] {bot_ai_stuff(14);};
+void()  bot_stuff3        =[      $rockrun3  ,        bot_stuff4        ] {bot_ai_stuff(7);bot_upabit();};
+void()  bot_stuff4        =[      $rockrun4  ,        bot_stuff5        ] {bot_ai_stuff(12);};
+void()  bot_stuff5        =[      $rockrun5  ,        bot_stuff6        ] {bot_ai_stuff(14);};
+void()  bot_stuff6        =[      $rockrun6  ,        bot_walk1        ] {bot_ai_stuff(14);bot_upabit();};
+
+void()  bot_stuffa1        =[      $rockrun1  ,        bot_stuff2        ]
+{
+        bot_ai_stuff(18);
+};
+void()  bot_stuffa2        =[      $axrun2  ,        bot_stuffa3        ] {bot_ai_stuff(14);};
+void()  bot_stuffa3        =[      $axrun3  ,        bot_stuffa4        ] {bot_ai_stuff(7);bot_upabit();};
+void()  bot_stuffa4        =[      $axrun4  ,        bot_stuffa5        ] {bot_ai_stuff(12);};
+void()  bot_stuffa5        =[      $axrun5  ,        bot_stuffa6        ] {bot_ai_stuff(14);};
+void()  bot_stuffa6        =[      $axrun6  ,        bot_walka1        ] {bot_ai_stuff(14);bot_upabit();};
+
+void()  bot_diea1    =       [       $deatha1,       bot_diea2    ] {};
+void()  bot_diea2    =       [       $deatha2,       bot_diea3    ] {};
+void()  bot_diea3    =       [       $deatha3,       bot_diea4    ]
+{
+	self.solid = SOLID_NOT;
+	DropBackpack();
+};
+
+void()  bot_diea4    =       [       $deatha4,       bot_diea5    ] {};
+void()  bot_diea5    =       [       $deatha5,       bot_diea6    ] {};
+void()  bot_diea6    =       [       $deatha6,       bot_diea7    ] {};
+void()  bot_diea7    =       [       $deatha7,       bot_diea8    ] {};
+void()  bot_diea8    =       [       $deatha8,       bot_diea9    ] {};
+void()  bot_diea9    =       [       $deatha9,       bot_diea10   ] {};
+void()  bot_diea10   =       [       $deatha10,      bot_diea11   ] {};
+void()  bot_diea11   =       [       $deatha11,      bot_diea11 ] {BotSelfDeActivate();};
+
+void()  bot_dieb1    =       [       $deathb1,       bot_dieb2    ] {};
+void()  bot_dieb2    =       [       $deathb2,       bot_dieb3    ] {};
+void()  bot_dieb3    =       [       $deathb3,       bot_dieb4    ] 
+{
+	self.solid = SOLID_NOT;
+	DropBackpack();
+};
+
+void()  bot_dieb4    =       [       $deathb4,       bot_dieb5    ] {};
+void()  bot_dieb5    =       [       $deathb5,       bot_dieb6    ] {};
+void()  bot_dieb6    =       [       $deathb6,       bot_dieb7    ] {};
+void()  bot_dieb7    =       [       $deathb7,       bot_dieb8    ] {};
+void()  bot_dieb8    =       [       $deathb8,       bot_dieb9    ] {};
+void()  bot_dieb9    =       [       $deathb9,       bot_dieb9    ] {BotSelfDeActivate();};
+
+void()  bot_diec1    =       [       $deathc1,       bot_diec2    ] {};
+void()  bot_diec2    =       [       $deathc2,       bot_diec3    ] {};
+void()  bot_diec3    =       [       $deathc3,       bot_diec4    ] 
+{
+	self.solid = SOLID_NOT;
+	DropBackpack();
+};
+
+void()  bot_diec4    =       [       $deathc4,       bot_diec5    ] {};
+void()  bot_diec5    =       [       $deathc5,       bot_diec6    ] {};
+void()  bot_diec6    =       [       $deathc6,       bot_diec7    ] {};
+void()  bot_diec7    =       [       $deathc7,       bot_diec8    ] {};
+void()  bot_diec8    =       [       $deathc8,       bot_diec9    ] {};
+void()  bot_diec9    =       [       $deathc9,       bot_diec10   ] {};
+void()  bot_diec10   =       [       $deathc10,      bot_diec11   ] {};
+void()  bot_diec11   =       [       $deathc11,      bot_diec12   ] {};
+void()  bot_diec12   =       [       $deathc12,      bot_diec13   ] {};
+void()  bot_diec13   =       [       $deathc13,      bot_diec14   ] {};
+void()  bot_diec14   =       [       $deathc14,      bot_diec15   ] {};
+void()  bot_diec15   =       [       $deathc15,      bot_diec15 ] {BotSelfDeActivate();};
+
+void()  bot_died1    =       [       $deathd1,       bot_died2    ] {};
+void()  bot_died2    =       [       $deathd2,       bot_died3    ] {};
+void()  bot_died3    =       [       $deathd3,       bot_died4    ] 
+{
+	self.solid = SOLID_NOT;
+	DropBackpack();
+};
+
+void()  bot_died4    =       [       $deathd4,       bot_died5    ] {};
+void()  bot_died5    =       [       $deathd5,       bot_died6    ] {};
+void()  bot_died6    =       [       $deathd6,       bot_died7    ] {};
+void()  bot_died7    =       [       $deathd7,       bot_died8    ] {};
+void()  bot_died8    =       [       $deathd8,       bot_died9    ] {};
+void()  bot_died9    =       [       $deathd9,       bot_died9    ] {BotSelfDeActivate();};
+
+void()  bot_diee1    =       [       $deathe1,       bot_diee2    ] {};
+void()  bot_diee2    =       [       $deathe2,       bot_diee3    ] {};
+void()  bot_diee3    =       [       $deathe3,       bot_diee4    ] 
+{
+	self.solid = SOLID_NOT;
+	DropBackpack();
+};
+
+void()  bot_diee4    =       [       $deathe4,       bot_diee5    ] {};
+void()  bot_diee5    =       [       $deathe5,       bot_diee6    ] {};
+void()  bot_diee6    =       [       $deathe6,       bot_diee7    ] {};
+void()  bot_diee7    =       [       $deathe7,       bot_diee8    ] {};
+void()  bot_diee8    =       [       $deathe8,       bot_diee9    ] {};
+void()  bot_diee9    =       [       $deathe9,       bot_diee9    ] {BotSelfDeActivate();};
+
+void()  bot_dieax1    =       [       $axdeth1,       bot_dieax2    ] {};
+void()  bot_dieax2    =       [       $axdeth2,       bot_dieax3    ] {};
+void()  bot_dieax3    =       [       $axdeth3,       bot_dieax4    ] 
+{
+	self.solid = SOLID_NOT;
+	DropBackpack();
+};
+
+void()  bot_dieax4    =       [       $axdeth4,       bot_dieax5    ] {};
+void()  bot_dieax5    =       [       $axdeth5,       bot_dieax6    ] {};
+void()  bot_dieax6    =       [       $axdeth6,       bot_dieax7    ] {};
+void()  bot_dieax7    =       [       $axdeth7,       bot_dieax8    ] {};
+void()  bot_dieax8    =       [       $axdeth8,       bot_dieax9    ] {};
+void()  bot_dieax9    =       [       $axdeth9,       bot_dieax9    ] {BotSelfDeActivate();};
+                                                        
+void()  bot_qatk1        =[      $shotatt1,       bot_qatk2        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatk2        =[      $shotatt2,       bot_qatk3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatk3        =[      $shotatt3,       bot_qatk4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatk4        =[      $shotatt4,       bot_qatk5        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatk5        =[      $shotatt5,       bot_atk1        ] {bot_ai_face();bot_run_dodge();};
+
+void()  bot_qatkn1        =[      $nailatt2,       bot_qatkn2        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatkn2        =[      $nailatt1,       bot_qatkn3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkn3        =[      $nailatt2,       bot_qatkn4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatkn4        =[      $nailatt1,       bot_qatkn5        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkn5        =[      $nailatt2,       bot_atkn1        ] {bot_ai_face();bot_run_dodge();};
+
+void()  bot_qatksn1        =[      $nailatt2,       bot_qatksn2        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatksn2        =[      $nailatt1,       bot_qatksn3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatksn3        =[      $nailatt1,       bot_qatksn4        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatksn4        =[      $nailatt2,       bot_qatksn5        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatksn5        =[      $nailatt1,       bot_atksn1        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+
+void()  bot_qatkr1        =[      $rockatt1,       bot_qatkr2        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkr2        =[      $rockatt2,       bot_qatkr3        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatkr3        =[      $rockatt3,       bot_qatkr4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatkr4        =[      $rockatt4,       bot_qatkr5        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_qatkr5        =[      $rockatt5,       bot_atkr1        ] {bot_ai_face();bot_run_dodge();};
+
+void()  bot_qatkl1        =[      $light1,       bot_qatkl2        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkl2        =[      $light2,       bot_qatkl3        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkl3        =[      $light1,       bot_qatkl4        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkl4        =[      $light2,       bot_qatkl5        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+void()  bot_qatkl5        =[      $light1,       bot_atkl1        ] {bot_ai_face();bot_attack();bot_run_dodge();};
+                                                                                 
+void()  bot_qatka1        =[      $axatt1,       bot_qatka2        ] {bot_ai_face();};
+void()  bot_qatka2        =[      $axatt2,       bot_qatka3        ] {bot_ai_face();};
+void()  bot_qatka3        =[      $axatt3,       bot_qatka4        ] {bot_ai_face();};
+void()  bot_qatka4        =[      $axatt4,       bot_qatka5        ] {bot_ai_face();bot_FireAxe();};
+void()  bot_qatka5        =[      $axatt5,       bot_qatka6        ] {bot_ai_face();};
+void()  bot_qatka6        =[      $axatt6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+void()  bot_qatkab1        =[      $axattb1,       bot_qatkab2        ] {bot_ai_face();};
+void()  bot_qatkab2        =[      $axattb2,       bot_qatkab3        ] {bot_ai_face();};
+void()  bot_qatkab3        =[      $axattb3,       bot_qatkab4        ] {bot_ai_face();};
+void()  bot_qatkab4        =[      $axattb4,       bot_qatkab5        ] {bot_ai_face();bot_FireAxe();};
+void()  bot_qatkab5        =[      $axattb5,       bot_qatkab6        ] {bot_ai_face();};
+void()  bot_qatkab6        =[      $axattb6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+void()  bot_qatkac1        =[      $axattc1,       bot_qatkac2        ] {bot_ai_face();};
+void()  bot_qatkac2        =[      $axattc2,       bot_qatkac3        ] {bot_ai_face();};
+void()  bot_qatkac3        =[      $axattc3,       bot_qatkac4        ] {bot_ai_face();};
+void()  bot_qatkac4        =[      $axattc4,       bot_qatkac5        ] {bot_ai_face();bot_FireAxe();};
+void()  bot_qatkac5        =[      $axattc5,       bot_qatkac6        ] {bot_ai_face();};
+void()  bot_qatkac6        =[      $axattc6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+void()  bot_qatkad1        =[      $axattd1,       bot_qatkad2        ] {bot_ai_face();};
+void()  bot_qatkad2        =[      $axattd2,       bot_qatkad3        ] {bot_ai_face();};
+void()  bot_qatkad3        =[      $axattd3,       bot_qatkad4        ] {bot_ai_face();};
+void()  bot_qatkad4        =[      $axattd4,       bot_qatkad5        ] {bot_ai_face();bot_FireAxe();};
+void()  bot_qatkad5        =[      $axattd5,       bot_qatkad6        ] {bot_ai_face();};
+void()  bot_qatkad6        =[      $axattd6,       bot_runa1        ] {bot_ai_face();
+        bot_ai_face();
+};
+
+void()  bot_dodgern1        =[      $rockrun1  ,        bot_dodgern2       ]
+{bot_ai_face();
+        bot_start_dodge();
+        bot_run_dodge();
+};
+void()  bot_dodgern2        =[      $rockrun2  ,        bot_dodgern3        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgern3        =[      $rockrun3  ,        bot_dodgern4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgern4        =[      $rockrun4  ,        bot_dodgern5       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgern5       =[      $rockrun5  ,        bot_dodgern6       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgern6        =[      $rockrun6  ,        bot_run1        ] {bot_ai_face();bot_run_dodge();bot_end_dodge();};
+
+void()  bot_dodgea1        =[      $axrun1  ,        bot_dodgea2       ]
+{bot_ai_face();
+        bot_start_dodge();
+        bot_run_dodge();
+};
+void()  bot_dodgea2        =[      $axrun2  ,        bot_dodgea3        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgea3        =[      $axrun3  ,        bot_dodgea4        ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgea4        =[      $axrun4  ,        bot_dodgea5       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgea5       =[      $axrun5  ,        bot_dodgea6       ] {bot_ai_face();bot_run_dodge();};
+void()  bot_dodgea6        =[      $axrun6  ,        bot_runa1        ] {bot_ai_face();bot_run_dodge();bot_end_dodge();};
+
+
+void() BotBegin =
+{
+        self.th_pain = bot_pain;
+        self.takedamage = DAMAGE_YES;
+        bot_SetCurrentAmmo();
+        self.nextthink = time + 0.1;
+        self.think = self.th_stuff;        
+        
+};
+void() BotReBegin =
+{
+        self.th_pain = bot_pain;
+        self.takedamage = DAMAGE_YES;
+        self.nextthink = time + 0.1;
+        self.think = self.th_run;
+};
+        
+//=============================================================
+// BotFindTarget
+// Self is currently not attacking anything, so try to find a target
+// Sets self.enemy and returns TRUE if an enemy was sighted
+// Sets self.enemy to world and returns FALSE if no enemy sighted
+//=============================================================
+float() BotFindTarget =
+{
+	local entity head, selected;
+        local float dist;
+
+	dist = 1500;	// awareness radius of bot, increasing it slows down game
+	selected = world;
+
+	head = findradius(self.origin, 1500);
+	while(head)
+	{
+                if(!(head.flags & FL_NOTARGET))// && (head.flags & FL_MONSTER))
+			if (visible(head))
+				if (trace_plane_dist < dist)
+                                        if ((head.health > 0) && (head !=self))                                        
+                                                if ((head.classname == "player") || (head.classname == "bot"))
+                                                {
+                                                        selected = head;
+                                                        dist = trace_plane_dist;
+                                                }
+		head = head.chain;
+	}
+
+	self.enemy = selected;
+        if ((self.enemy == world) || (self.enemy == self))
+		return FALSE;
+        
+        else 
+	{
+		BotFoundTarget();
+		return TRUE;
+	}
+};
+//=============================================================
+// BotFinditem
+// Self is currently not attacking anything, so try to find an item
+// Sets self.movetarget and returns TRUE if an item was sighted
+// Sets self.movetarget to world and returns FALSE if no enemy sighted
+//=============================================================
+float() BotFindItem =
+{
+	local entity head, selected;
+        local float dist;
+
+	dist = 1500;	// awareness radius of bot, increasing it slows down game
+	selected = world;
+
+	head = findradius(self.origin, 1500);
+	while(head)
+	{
+                if (head.flags == FL_ITEM)
+                        if (visible(head))
+                                if (trace_plane_dist < dist)
+                                {
+                                        selected = head;
+                                        dist = trace_plane_dist;
+                                }
+		head = head.chain;
+	}
+        self.goalentity = selected;
+        self.movetarget = selected;
+		
+        if (self.movetarget == world)
+		return FALSE;
+	else
+	{
+                BotFoundItem();
+		return TRUE;
+	}
+};
+
+float() BotFindRocket =
+{
+	local entity head, selected;
+        local float dist;
+
+	dist = 1500;	// awareness radius of bot, increasing it slows down game
+	selected = world;
+
+	head = findradius(self.origin, 1500);
+	while(head)
+	{
+                if((head.movetype == MOVETYPE_FLYMISSILE) || (head.classname == "grenade"))
+			if (visible(head))
+                                if (infrontr(self,head))
+                                        if (trace_plane_dist < dist)
+                                                if ((head !=self))                                                
+                                        
+                                                {
+                                                        selected = head;
+                                                        dist = trace_plane_dist;
+                                                }
+		head = head.chain;
+	}
+
+        self.rcktdtct = selected;
+		
+        if (self.rcktdtct == world)
+		return FALSE;
+	else
+	{
+                BotFoundRocket();
+		return TRUE;
+	}
+};
+
+
+//=============================================================
+// bot_ai_stand - bot stands in place until target acquired,
+// and starts to walk if pausetime has expired
+//=============================================================
+void() bot_ai_stand =
+{
+//        set_ai_think();
+	if (BotFindTarget ())
+		return;
+	
+        if (BotFindStuff ())
+                return;
+//        if (BotFindTele ())
+ //               return;
+        BotCheckPowerupsb();        
+
+	if (time > self.pausetime)
+	{
+                self.th_walk ();
+		return;
+	}
+};
+
+
+//=============================================================
+// bot_pain
+//=============================================================
+void(entity attacker, float damage)	bot_pain =
+{
+	local float r;
+	local entity oldself;
+        
+	r = random ();
+	if (self.pain_finished > time)
+		return;
+        self.pain_finished = (time + 0.7);
+
+        if ((self.enemy != attacker) && (attacker != self))
+        {
+                if (attacker.health >= 1)
+                self.oldenemy = self.enemy;
+                self.enemy = attacker;
+        }
+        
+        enemy_range = range(self.enemy);
+        if (enemy_range == RANGE_MELEE)
+//                        self.th_qatk ();
+//        else if (enemy_range == RANGE_MELEE) 
+                        self.th_qatk;
+        else self.th_dodge;
+};
+
+//=============================================================
+// bot_die
+//=============================================================
+float() zrandom =
+{
+        return 2*(random());
+};
+
+void() bot_die =
+{
+ 
+	sound (self, CHAN_VOICE, "enforcer/death1.wav", 1, ATTN_NORM);
+
+        if (zrandom() > 1.6)
+                bot_diea1 ();
+        else if (zrandom() > 1.2)
+                bot_dieb1 ();
+        else if (zrandom() > 0.8)
+                bot_diec1 ();
+        else if (zrandom() > 0.4)
+                bot_died1 ();
+        else bot_diee1 ();
+
+
+
+// death frame sequence includes bot deactivation	
+};
+
+//=============================================================
+// BotHuntTarget
+//=============================================================
+void() BotHuntTarget =
+{
+	self.goalentity = self.enemy;
+//        self.think = self.th_run ();
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+//        self.nextthink = time + 0.1;
+	SUB_AttackFinished (0.5);	// wait a while before first attack
+        self.th_run ();
+};
+
+
+//=============================================================
+// BotFoundTarget
+//=============================================================
+void() BotFoundTarget =
+{
+	local float f_dist;
+        local string frgs;
+
+        frgs = ftos (self.frags);
+	self.show_hostile = time + 1;		// wake up other monsters
+	
+//sprints changed to sprint to enemy for purpose of debugging
+        if (self.enemy.classname == "player")
+        {
+                sprint (self.enemy, self.netname);
+                sprint (self.enemy, " targetting: ");
+                sprint (self.enemy, self.enemy.classname);
+                sprint (self.enemy, "\n");
+                sprint (self.enemy, "Frags: ");
+                sprint (self.enemy, frgs);
+                sprint (self.enemy, "\n");
+        }
+	BotHuntTarget ();
+};
+//=============================================================
+// BotFoundItem
+//=============================================================
+void() BotFoundItem =
+{
+	local float f_dist;
+	local string s_dist;
+        f_dist = vlen (self.movetarget.origin - self.origin);
+	s_dist = ftos (f_dist);
+        movetogoal(20);
+};
+
+void() BotFoundRocket =
+{
+	local float f_dist;
+	local string s_dist;
+        f_dist = vlen (self.rcktdtct.origin - self.origin);
+	s_dist = ftos (f_dist);
+
+	self.show_hostile = time + 1;		// wake up other monsters
+        if (self.rcktdtct.owner.classname == "player")
+        {
+                sprint (self.rcktdtct.owner, self.netname);
+                sprint (self.rcktdtct.owner, " evading: ");
+                sprint (self.rcktdtct.owner, self.rcktdtct.classname);
+                sprint (self.rcktdtct.owner, "\n");
+                sprint (self.rcktdtct.owner, "  distance: ");
+                sprint (self.rcktdtct.owner, s_dist);
+                sprint (self.rcktdtct.owner, "\n");
+        }
+        bot_run_dodge ();
+
+
+};
+
+
+//=============================================================
+// bot_ai_walk - bot is walking, looking for enemies
+//=============================================================
+void(float dist) bot_ai_walk =
+{
+//        set_ai_think();
+	if (BotFindTarget ())
+		return;
+        if (BotFindStuff ()) 
+                return;
+        BotCheckPowerupsb();        
+
+        bot_upabit();
+	movetogoal (dist);
+};
+
+void() bot_run_dodge =
+{
+	local float	ofs;
+//        set_ai_think();                 
+        BotCheckPowerupsb();        
+//        if (self.enemy.attack_state == AS_MELEE)
+//                bot_run_mdodge();
+        if (self.enemy.weapon == IT_AXE)
+                bot_run_mdodge();               
+//      if (range(self.enemy) == RANGE_MELEE)
+//              bot_circle1();                
+
+        movedist = 18;
+//        bot_enemy_image();                        
+
+        self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+        if (self.lefty == 1)
+                ofs = 45;
+        else 
+                ofs = -45;
+	
+	if (walkmove (self.ideal_yaw + ofs, movedist))
+		return;
+		
+        self.lefty = 1 - self.lefty;         
+	walkmove (self.ideal_yaw - ofs, movedist);
+        bot_ai_face();
+};
+
+void() bot_run_circle =
+{
+	local float	ofs;
+                 
+//        set_ai_think();
+
+        movedist = 15;
+        self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+        if (self.lefty == 1)
+                ofs = 90;
+        else 
+                ofs = -90;
+	
+	if (walkmove (self.ideal_yaw + ofs, movedist))
+		return;
+		
+        if (infrontr(self.enemy, self))
+                self.lefty = 1 - self.lefty;
+	walkmove (self.ideal_yaw - ofs, movedist);
+        bot_ai_face();
+};
+
+void() bot_run_mdodge =
+{
+	local float	ofs;
+         
+//        set_ai_think();
+
+        movedist = 20;
+        self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+        if (self.lefty == 1)
+                ofs = 135;
+        else 
+                ofs = -135;
+	
+	if (walkmove (self.ideal_yaw + ofs, movedist))
+		return;
+		
+        self.lefty = 1 - self.lefty;         
+	walkmove (self.ideal_yaw - ofs, movedist);
+};
+
+//=============================================================
+// bot_ai_turn - turn towards ideal_yaw if no enemy sighted
+//=============================================================
+void() bot_ai_turn =
+{
+//        set_ai_think();
+
+	if (BotFindTarget ())
+		return;
+	
+        if (BotFindStuff ())
+                return;
+
+	
+	ChangeYaw ();
+};
+
+
+//=============================================================
+// bot_ai_run - still needs a little work
+//=============================================================
+void(float dist) bot_ai_run =
+{
+	local	vector	delta;
+	local	float	axis;
+	local	float	direct, ang_rint, ang_floor, ang_ceil;
+	
+	movedist = dist;
+//        set_ai_think();
+//        bot_enemy_image();                        
+        BotCheckPowerupsb();        
+        if (BotFindRocket())
+        {
+                if (check_dodge() == FALSE)
+                        bot_dodgern1();
+        }
+
+
+	if (self.enemy.health <= 0)
+	{
+		self.enemy = world;
+		if (self.oldenemy.health > 0)
+		{
+			self.enemy = self.oldenemy;
+//                        bot_enemy_image();                        
+			BotHuntTarget ();
+		}
+		else
+		{
+//                        bot_enemy_image();
+
+			if (BotFindTarget())
+                        {
+                                
+                                if ((visible(self.enemy)) == (FALSE))
+                                        movetogoal(dist);
+                                else if ((visible(self.enemy)) == (TRUE))
+//                                        sprint (self.enemy, "tracing: ");
+//                                        bot_enemy_image();
+                
+				return;
+                        }
+			else
+			{
+                                self.movetarget = self.owner;
+                                self.th_walk ();
+				return;
+			}
+		}
+	}
+
+	self.show_hostile = time + 1;		// wake up other monsters
+//        bot_enemy_image();
+	enemy_vis = visible(self.enemy);
+	if (enemy_vis)
+		self.search_time = time + 5;
+
+	enemy_infront = infront(self.enemy);
+        enemy_range = range(self.enemy);
+	enemy_yaw = vectoyaw(self.enemy.origin - self.origin);
+        
+        if (BotFindRocket())
+        {
+                if (check_dodge() == FALSE)
+                        bot_dodgern1();
+        }
+        if (random() <= 0.25)
+                self.th_dodge ();
+
+        if (self.attack_state == AS_MISSILE)
+	{
+		ai_run_missile ();
+		return;
+	}
+	if (self.attack_state == AS_MELEE)
+	{
+		ai_run_melee ();
+		return;
+	}
+
+	if (CheckAnyAttack ())
+		return;					// beginning an attack
+		
+	if (self.attack_state == AS_SLIDING)
+	{
+		ai_run_slide ();
+		return;
+	}
+        bot_upabit(); 
+	movetogoal (dist);		// done in C code...
+};
+
+
+//=============================================================
+// BotCheckRefire
+//=============================================================
+void (void () thinkst) BotCheckRefire =
+{
+	if (!visible (self.enemy) || (self.enemy.health <= 0))
+		return;
+        if (random() >= 0.5)
+                return;
+	self.think = thinkst;
+};
+
+
+//=============================================================
+// BotSelfDeActivate - Bot deactivates itself
+//=============================================================
+void () BotSelfDeActivate =
+{
+        WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+        WriteByte (MSG_BROADCAST, TE_TELEPORT);
+        WriteCoord (MSG_BROADCAST, self.origin_x);
+        WriteCoord (MSG_BROADCAST, self.origin_y);
+        WriteCoord (MSG_BROADCAST, self.origin_z);
+        sound (self, CHAN_BODY, "misc/r_tele1.wav", 1, ATTN_NORM);        
+        remove (self);
+        BotReStartDM(self.frags, self.attackr, self.netname);
+};
+
+//=============================================================
+// bot_fire
+//=============================================================
+void () bot_fire =
+{
+// in future, adjust frame sequence to not show firing if auto_fire off
+
+        if (BotFindRocket())
+        {
+                if (check_dodge() == FALSE)                                
+                        bot_dodgern1();
+        }
+
+	if (self.enemy.health <= 0)
+	{
+		self.enemy = world;
+		if (self.oldenemy.health > 0)
+		{
+			self.enemy = self.oldenemy;
+			BotHuntTarget ();
+		}
+		else
+		{
+			if (BotFindTarget())
+                        {
+                                if ((visible(self.enemy)) == (FALSE))
+                                        movetogoal(30);
+                                else if ((visible(self.enemy)) == (TRUE))
+//                                        sprint (self.enemy, "tracing: ");
+//                                        bot_enemy_image();
+                                return;
+                        }
+                        else
+			{
+				self.movetarget = self.owner;
+                                self.th_walk ();
+				return;
+			}
+		}
+	}
+
+        bot_ai_face();
+        if ((infront(self.enemy)) && (visible(self.enemy)))
+	{
+//                bot_enemy_image();
+                bot_firebullets();
+                sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+	}
+        else if (!(visible(self.enemy)))
+                movetogoal(20);
+                
+		return;
+};
+float(entity targ, entity targ2) infrontr =
+{
+	local vector	vec;
+	local float		dot;
+	
+        makevectors (targ2.angles);
+        vec = normalize (targ.origin - targ2.origin);
+	dot = vec * v_forward;
+	
+	if ( dot > 0.3)
+	{
+		return TRUE;
+	}
+	return FALSE;
+};
+void() bot_ai_face =
+{
+//        bot_enemy_image();
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	ChangeYaw ();
+
+};
+// create ghost image of enemy to move to....
+
+void () bot_enemy_image = 
+{
+               local    entity newbot;
+
+               
+               newbot=spawn();
+
+               newbot.classname = "enemy";
+               newbot.movetype= MOVETYPE_NONE;
+               newbot.solid = SOLID_TRIGGER;
+
+               setsize (newbot, '0 0 1', '0 0 1');        
+//               setmodel (newbot, "progs/laser.mdl"); //for debugging
+               setmodel (newbot, "progs/null.spr");
+               newbot.origin = self.enemy.origin;
+               newbot.owner=self;
+               newbot.touch=bot_remove_enemy_image;
+               newbot.nextthink=time+3;
+               newbot.think=SUB_Remove;
+               self.goalentity = newbot;
+               self.movetarget = newbot;
+};
+
+void () bot_remove_enemy_image =
+       {
+        if (self.owner == other)
+                remove(self);
+        };
+void () bot_start_dodge =
+        {
+                self.dodge_finished = time + 0.7;
+                self.dodge = TRUE;
+                if ((random() * 1) >= 0.5)
+                        self.lefty = 1;
+                else self.lefty = 0;
+                    
+        };
+void () bot_end_dodge =
+        {
+                self.dodge = FALSE;
+              
+        };
+float() check_dodge =
+        {
+                if (time < self.dodge_finished)
+                        return FALSE;
+                if (time > self.dodge_finished)
+                        return TRUE;
+                if (self.dodge == FALSE)
+                       return FALSE;
+                else if (self.dodge == TRUE)
+                        return TRUE;
+        };
+void () bot_start_circle =
+        {
+                self.dodge = TRUE;
+        };
+void () bot_end_circle =
+        {
+                self.dodge = FALSE;
+        };
+void() bot_firebullets =
+{
+	local	vector	dir;
+	local	entity	en;
+	
+        bot_ai_face();
+	
+// fire somewhat behind the player, so a dodging player is harder to hit
+	en = self.enemy;
+	
+	dir = en.origin - en.velocity*0.2;
+	dir = normalize (dir - self.origin);
+	
+        FireBullets (6, dir, '0.1 0.1 0');
+};
+
+void() bot_FireShotgun =
+{
+        local vector dir;
+        local   entity  en;
+
+	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
+	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM);	
+        self.effects = self.effects | EF_MUZZLEFLASH;
+//        self.attack_finished = time + 0.1;
+        en = self.enemy;
+        dir = en.origin - en.velocity*0.2;
+        dir = normalize (dir - self.origin);
+
+        dir = aim (self, 100000);
+        FireBullets (6, dir, '0.1 0.1 0');
+};
+
+void() bot_FireSuperShotgun =
+{
+	local vector dir;
+        local   entity  en;
+        if (self.currentammo == 1)
+	{
+                bot_FireShotgun ();
+		return;
+	}
+	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
+	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM);	
+        self.effects = self.effects | EF_MUZZLEFLASH;
+//        self.attack_finished = time + 0.1;
+	en = self.enemy;
+	dir = en.origin - en.velocity*0.2;
+	dir = normalize (dir - self.origin);
+	FireBullets (14, dir, '0.14 0.08 0');
+};
+
+void() bot_FireRocket =
+{
+	local	entity missile, mpuff;
+        local   vector  dir;
+        local   entity  en;
+        self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+	self.effects = self.effects | EF_MUZZLEFLASH;
+//        self.attack_finished = time + 0.3;
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+        missile.classname = "rocket";         
+	missile.solid = SOLID_BBOX;
+        makevectors (self.angles);
+	en = self.enemy;
+	dir = en.origin - en.velocity*0.2;
+	dir = normalize (dir - self.origin);
+        missile.velocity = dir;
+	missile.velocity = missile.velocity * 1000;
+	missile.angles = vectoangles(missile.velocity);
+	missile.touch = T_MissileTouch;
+	missile.nextthink = time + 5;
+	missile.think = SUB_Remove;
+	setmodel (missile, "progs/missile.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+        setorigin (missile, self.origin + '0 0 16');
+};
+
+void () bot_nail =
+{
+	local vector org;
+        local vector dir;
+        local float ox;
+        
+        ox = 4;
+
+	self.effects = self.effects | EF_MUZZLEFLASH;
+//        self.attack_finished = time + 0.1;
+	makevectors (self.angles);
+	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+	self.currentammo = self.ammo_nails = self.ammo_nails - 1;
+        org = self.origin + v_forward * 30 + v_right*ox + '0 0 16';
+        dir = self.enemy.origin - self.origin;
+        dir = normalize(dir);
+        launch_spike(org, dir);
+};
+
+void () bot_nail2 =
+{
+	local vector	dir;
+        local vector    org;
+	
+        self.oldenemy = self.enemy;
+        if (!visible (self.enemy) || (self.enemy.health <= 0))
+        {
+                if (BotFindTarget ())
+                        return;
+	
+                ChangeYaw ();
+                self.enemy = self.oldenemy;
+        }
+        self.effects = self.effects | EF_MUZZLEFLASH;
+//        self.attack_finished = time + 0.1;
+
+	makevectors (self.angles);
+	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
+	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
+        org = self.origin + '0 0 16';
+        dir = self.enemy.origin - self.origin;
+        dir = normalize(dir);
+        launch_spike (org, dir);
+	newmis.touch = superspike_touch;
+	setmodel (newmis, "progs/s_spike.mdl");
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+};
+
+void(vector offset) benforcer_fire =
+{
+	local vector org;
+        local vector dir;
+        local float ox;
+        
+        ox = 4;
+
+	self.effects = self.effects | EF_MUZZLEFLASH;
+	makevectors (self.angles);
+	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+	
+        org = self.origin + v_forward * 30 + v_right*ox + '0 0 16';
+        dir = self.enemy.origin - self.origin;
+        dir = normalize(dir);
+        launch_spike(org, dir);
+        org = org + offset;
+        launch_spike(org, dir);
+};
+
+void() bot_SetCurrentAmmo =
+{
+	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
+	
+        if (self.weapon == IT_SHOTGUN)
+	{
+		self.currentammo = self.ammo_shells;
+		self.items = self.items | IT_SHELLS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodge1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atk1;
+                self.th_qatk = bot_qatk1;
+	}
+	else if (self.weapon == IT_SUPER_SHOTGUN)
+	{
+		self.currentammo = self.ammo_shells;
+		self.items = self.items | IT_SHELLS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodge1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atk1;
+                self.th_qatk = bot_qatk1;
+
+	}
+	else if (self.weapon == IT_NAILGUN)
+	{
+		self.currentammo = self.ammo_nails;
+		self.items = self.items | IT_NAILS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodgen1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atkn1;
+                self.th_qatk = bot_qatkn1;
+	}
+	else if (self.weapon == IT_SUPER_NAILGUN)
+	{
+		self.currentammo = self.ammo_nails;
+		self.items = self.items | IT_NAILS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodgesn1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atksn1;
+                self.th_qatk = bot_qatksn1;                
+	}
+        else if (self.weapon == IT_GRENADE_LAUNCHER)
+        {
+                self.currentammo = self.ammo_rockets;
+                self.items = self.items | IT_ROCKETS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodger1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atkr1;
+                self.th_qatk = bot_qatkr1;
+
+        }
+	else if (self.weapon == IT_ROCKET_LAUNCHER)
+	{
+		self.currentammo = self.ammo_rockets;
+		self.items = self.items | IT_ROCKETS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodger1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atkr1;
+                self.th_qatk = bot_qatkr1;
+
+	}
+        else if (self.weapon == IT_LIGHTNING)
+	{
+                self.currentammo = self.ammo_cells;
+                self.items = self.items | IT_CELLS;
+                self.th_stand = bot_stand1;
+                self.th_walk = bot_walk1;
+                self.th_run = bot_run1;
+                self.th_stuff = bot_stuff1;
+                self.th_dodge = bot_dodgel1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_die;
+                self.th_missile = bot_atkl1;
+                self.th_qatk = bot_qatkl1;
+
+	}
+
+        else if (self.weapon == IT_AXE)
+	{
+                self.currentammo = 0;
+                self.th_stand = bot_standa1;
+                self.th_walk = bot_walka1;
+                self.th_run = bot_runa1;
+                self.th_stuff = bot_stuffa1;
+                self.th_dodge = bot_dodgea1;
+                self.th_pain = bot_pain;
+                self.th_die = bot_dieax1;
+                self.th_missile = Axe_Attack;
+                self.th_qatk = QAxe_Attack;
+
+
+	}
+
+	else
+	{
+		self.currentammo = 0;
+		self.weaponmodel = "";
+		self.weaponframe = 0;
+	}
+};
+/*
+====================================================
+bot_bestweapon - AI to choose which weapon is best
+====================================================
+*/
+float () bot_bestweapon =
+{
+	local	float	it;
+	
+	it = self.items;
+        if ((self.ammo_cells >= 1) && (it & IT_LIGHTNING) )
+                return IT_LIGHTNING;
+        if ((self.ammo_rockets >= 1) && (it & IT_ROCKET_LAUNCHER) )
+		return IT_ROCKET_LAUNCHER;
+        else if ((self.ammo_nails >= 2) && (it & IT_SUPER_NAILGUN) )
+		return IT_SUPER_NAILGUN;
+        else if ((self.ammo_shells >= 2) && (it & IT_SUPER_SHOTGUN) )
+		return IT_SUPER_SHOTGUN;
+        else if ((self.ammo_nails >= 1) && (it & IT_NAILGUN) )
+		return IT_NAILGUN;
+        else if ((self.ammo_rockets>= 1) && (it & IT_GRENADE_LAUNCHER) )
+                return IT_GRENADE_LAUNCHER;
+        else if ((self.ammo_shells >= 1)) ///&& (it & IT_SHOTGUN) )
+                return IT_SHOTGUN;
+        else return IT_AXE;
+
+};
+/*
+===============================================
+bot_CheckNoAmmo - checks to see if he has ammo 
+===============================================
+*/
+float() bot_CheckNoAmmo =
+{
+	if (self.currentammo > 0)
+		return TRUE;
+
+        self.weapon = bot_bestweapon ();
+
+        bot_SetCurrentAmmo ();
+	
+	return FALSE;
+};
+/*
+==========================
+bot_attack - fires weapon
+==========================
+*/
+void() bot_attack =
+{
+        bot_SetCurrentAmmo (); 
+        if (BotFindRocket())
+        {
+                if (check_dodge() == FALSE)                                
+                        bot_dodgern1();
+        }
+
+	if (self.enemy.health <= 0)
+	{
+		self.enemy = world;
+		if (self.oldenemy.health > 0)
+		{
+			self.enemy = self.oldenemy;
+			BotHuntTarget ();
+		}
+		else
+		{
+			if (BotFindTarget())
+                        {
+                                if (visible(self.enemy) == FALSE)
+                                        movetogoal(30);
+                                else if (visible(self.enemy) == TRUE)
+//                                        sprint (self.enemy, "tracing: ");
+//                                        bot_enemy_image();
+                                return;
+                        }
+                        else
+			{
+				self.movetarget = self.owner;
+				self.th_walk ();
+				return;
+			}
+		}
+	}
+
+        bot_ai_face();
+        if ((infront(self.enemy)) && (visible(self.enemy)))
+	{
+//                bot_enemy_image();                
+                bot_shoot();
+	}
+        else if (!(visible(self.enemy)))
+                movetogoal(20);
+                
+		return;
+};                                                
+void () bot_shoot =
+{
+	local	float	r;
+        
+//        if (time < self.attack_finished)
+//                return;
+
+        if (!visible (self.enemy) || (self.enemy.health <= 0))
+                return;
+
+        if (!bot_CheckNoAmmo ())
+		return;
+
+        makevectors     (self.angles);     
+	self.show_hostile = time + 1;	// wake monsters up
+
+        if (self.weapon == IT_SHOTGUN)
+	{                
+                bot_FireShotgun ();
+                bot_SetCurrentAmmo (); 
+	}
+	else if (self.weapon == IT_SUPER_SHOTGUN)
+	{
+                bot_FireSuperShotgun ();
+                bot_SetCurrentAmmo (); 
+	}
+	else if (self.weapon == IT_NAILGUN)
+	{
+                bot_nail ();
+                bot_nail ();
+                bot_SetCurrentAmmo ();
+	}
+	else if (self.weapon == IT_SUPER_NAILGUN)
+	{
+                bot_nail2 ();
+                bot_nail2 ();
+
+                bot_SetCurrentAmmo (); 
+        }
+        else if (self.weapon == IT_GRENADE_LAUNCHER)
+        {
+                BOTFireGrenade();
+                bot_SetCurrentAmmo (); 
+        }
+        else if (self.weapon == IT_ROCKET_LAUNCHER)
+	{
+                bot_FireRocket();
+                bot_SetCurrentAmmo (); 
+
+        }
+        else if (self.weapon == IT_LIGHTNING)
+	{
+                bot_FireLightning();
+                bot_SetCurrentAmmo (); 
+
+        }
+        else if (self.weapon == IT_AXE)
+        {
+                bot_FireAxe();
+                bot_SetCurrentAmmo();                       
+        }        
+};
+void() BOTGrenadeExplode =
+{
+        T_RadiusDamage (self, self.owner, 120, world);
+	sound (self, CHAN_VOICE, "weapons/r_exp3.wav", 1, ATTN_NORM);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	self.velocity = '0 0 0';
+	self.touch = SUB_Null;
+	setmodel (self, "progs/s_explod.spr");
+	self.solid = SOLID_NOT;
+	s_explode1 ();
+};
+
+void() BOTGrenadeTouch =
+{
+	if (other == self.owner)
+		return;		// don't explode on owner
+        if (other.takedamage == DAMAGE_AIM) 
+	{
+                BOTGrenadeExplode();
+		return;
+	}
+        if (other.classname == "bot") 
+	{
+                BOTGrenadeExplode();
+		return;
+	}
+        
+	sound (self, CHAN_VOICE, "weapons/bounce.wav", 1, ATTN_NORM);	// bounce sound
+	if (self.velocity == '0 0 0')
+		self.avelocity = '0 0 0';
+};
+
+
+/*
+================
+BOTFireGrenade
+================
+*/
+
+void() BOTFireGrenade =
+{
+	local	entity missile, mpuff;
+	local float zchange;
+
+       // knock off a rocket
+       self.ammo_rockets = self.ammo_rockets - 1;
+	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+	self.effects = self.effects | EF_MUZZLEFLASH;
+//        self.attack_finished = time + 0.2;
+ 
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+        missile.classname = "grenade";         
+// set missile speed	
+
+	makevectors (self.angles);
+
+
+	missile.velocity = normalize(self.enemy.origin - self.origin);
+        missile.velocity = missile.velocity * 600;
+	missile.velocity_z = 200;
+	zchange = self.origin_z - self.enemy.origin_z;
+	missile.velocity_z = missile.velocity_z - (zchange+10);
+	missile.avelocity = '300 300 300';
+
+	missile.angles = vectoangles(missile.velocity);
+	
+        missile.touch = BOTGrenadeTouch;
+	
+// set missile duration
+	missile.nextthink = time + 2.5;
+        missile.think = BOTGrenadeExplode;
+
+        setmodel (missile, "progs/grenade.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin);
+};
+
+/*
+================
+BotCheckPowerups
+
+Check for turning off powerups
+================
+*/
+void(entity oldself) BotCheckPowerups =
+{
+//        sprint(self.enemy, "I'm Thinking!!!");
+
+// invisibility
+        if (oldself.invisible_finished)
+	{
+// sound and screen flash when items starts to run out
+
+
+                if (oldself.invisible_finished < time)
+		{	// just stopped
+                        oldself.items = oldself.items - IT_INVISIBILITY;
+                        oldself.invisible_finished = 0;
+                        oldself.invisible_time = 0;
+		}
+		
+	// use the eyes
+                oldself.frame = 0;
+                oldself.modelindex = modelindex_eyes;
+	}
+	else
+                oldself.modelindex = modelindex_bot;    // don't use eyes
+
+// invincibility
+        if (oldself.invincible_finished)
+	{
+                if (oldself.invincible_finished < time)
+		{	// just stopped
+                        oldself.items = oldself.items - IT_INVULNERABILITY;
+                        oldself.invincible_time = 0;
+                        oldself.invincible_finished = 0;
+		}
+                if (oldself.invincible_finished > time)
+                        oldself.effects = oldself.effects & EF_DIMLIGHT;
+		else
+                        oldself.effects = oldself.effects - (oldself.effects & EF_DIMLIGHT);
+	}
+
+// super damage
+        if (oldself.super_damage_finished)
+	{
+
+                if (oldself.super_damage_finished < time)
+		{	// just stopped
+                        oldself.items = oldself.items - IT_QUAD;
+                        oldself.super_damage_finished = 0;
+                        oldself.super_time = 0;
+                        oldself.effects = oldself.effects - (oldself.effects & EF_DIMLIGHT);
+
+		}
+                if (oldself.super_damage_finished > time)
+                        oldself.effects = oldself.effects & EF_DIMLIGHT;
+		else
+                        oldself.effects = oldself.effects - (oldself.effects & EF_DIMLIGHT);
+	}	
+
+// suit	
+        if (oldself.radsuit_finished)
+	{
+                oldself.air_finished = time + 12;          // don't drown
+
+                if (oldself.radsuit_finished < time)
+		{	// just stopped
+                        oldself.items = oldself.items - IT_SUIT;
+                        oldself.rad_time = 0;
+                        oldself.radsuit_finished = 0;
+		}
+	}	
+
+};
+
+
+void () bot_client =
+{
+               local    entity newbot;
+
+               newbot=spawn();
+               newbot.classname = "bot_controller";
+               newbot.movetype= MOVETYPE_NONE;
+               newbot.solid = SOLID_NOT;
+
+               setsize (newbot, '0 0 0', '0 0 0');        
+               setmodel (newbot, "progs/null.spr");
+               newbot.origin = self.origin;
+               newbot.owner=self;
+               self.controller = newbot;
+               newbot.nextthink=time+1;
+               newbot.think=bot_think;
+                
+};
+void () bot_think =
+{
+        local entity oldself;
+        oldself = self.owner;
+
+        if (oldself.health <=0)
+        {
+                remove(self);
+        }
+        else
+        {
+        Bot_PreThink(oldself);
+        self.nextthink = time+1;
+        }
+};
+
+void(entity oldself) Bot_PreThink =
+{
+//        sprint(oldself.enemy, "I'm Thinking!!!");
+        BotCheckPowerups(oldself);
+};
+void(entity oldself) Bot_PostThink =
+{
+        BotCheckPowerups(oldself);
+};
+
+void () bot_thinkb =
+{
+
+        Bot_PreThinkb();
+        self.nextthink = time+0.1;
+};
+
+void() Bot_PreThinkb =
+{
+//        sprint(self.enemy, "I'm Thinking!!!");
+        BotCheckPowerupsb();
+};
+void() Bot_PostThinkb =
+{
+        BotCheckPowerupsb();
+};
+
+
+/*
+================
+BotCheckPowerupsb
+
+Check for turning off powerups
+================
+*/
+void() BotCheckPowerupsb =
+{
+
+// invisibility
+//        if (self.invisible_finished)
+//        {
+// sound and screen flash when items starts to run out
+
+
+                if (self.invisible_finished < time)
+		{	// just stopped
+                        self.items = self.items - IT_INVISIBILITY;
+                        self.invisible_finished = 0;
+                        self.invisible_time = 0;
+                        setmodel (self, "progs/player.mdl");
+
+                }
+		
+	// use the eyes
+//                self.frame = 0;
+//                setmodel (self, "progs/eyes.mdl");
+//        }
+                else
+                  setmodel (self, "progs/eyes.mdl");
+//                setmodel (self, "progs/player.mdl");
+
+// invincibility
+        if (self.invincible_finished)
+	{
+                if (self.invincible_finished < time)
+		{	// just stopped
+                        self.items = self.items - IT_INVULNERABILITY;
+                        self.invincible_time = 0;
+                        self.invincible_finished = 0;
+		}
+                if (self.invincible_finished > time)
+                        self.effects = self.effects & EF_DIMLIGHT;
+		else
+                        self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+	}
+
+// super damage
+        if (self.super_damage_finished)
+	{
+
+                if (self.super_damage_finished < time)
+		{	// just stopped
+                        self.items = self.items - IT_QUAD;
+                        self.super_damage_finished = 0;
+                        self.super_time = 0;
+                        self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+
+		}
+                if (self.super_damage_finished > time)
+                        self.effects = self.effects & EF_DIMLIGHT;
+		else
+                        self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+	}	
+
+// suit	
+        if (self.radsuit_finished)
+	{
+                self.air_finished = time + 12;          // don't drown
+
+                if (self.radsuit_finished < time)
+		{	// just stopped
+                        self.items = self.items - IT_SUIT;
+                        self.rad_time = 0;
+                        self.radsuit_finished = 0;
+		}
+	}	
+
+};
+/*
+void() set_ai_think =
+{
+        self.nextthink = time +0.1;
+        self.think = bot_thinkb;
+
+};
+*/
+// BG Bot - begin hack to check for items
+float() BotFindStuff =
+{
+        local entity head, selected;
+	local float dist;
+        dist = 300; 
+	selected = world;
+
+        head = findradius(self.origin, 300);
+	while(head)
+	{
+                if ((head.classname == "weapon_supernailgun") ||
+                   (head.classname == "weapon_supershotgun") || 
+                   (head.classname == "weapon_rocketlauncher") || 
+                   (head.classname == "weapon_grenadelauncher") || 
+                   (head.classname == "weapon_nailgun") ||
+                   (head.classname == "weapon_lightning") ||
+                   (head.classname == "backpack") ||
+                   ((self.ammo_shells <= 99) && (head.classname == "shells")) ||
+                   ((self.ammo_cells <= 199) && (head.classname == "cells")) ||
+                   ((self.ammo_nails <= 99) && (head.classname == "nails")) ||
+                   ((self.ammo_rockets <= 99) && (head.classname == "rockets")) ||
+                   (head.classname == "item_armor1") ||
+                   (head.classname == "item_armor2") ||
+                   (head.classname == "item_armorInv") ||
+                   (head.classname == "item_artifact_invulnerability") ||
+                   (head.classname == "item_artifact_invisibility") ||
+                   (head.classname == "item_artifact_envirosuit") ||
+                   (head.classname == "item_artifact_super_damage") ||
+                   ((head.healtype == 1) && (self.health <= 99)) ||
+                   ((head.healtype == 2) && (self.health <= 99))) 
+                if (visible(head))                
+                if (trace_plane_dist <= dist)
+
+                   {
+                        selected = head;
+                        dist = trace_plane_dist;
+                   }
+		head = head.chain;
+	}
+        self.stuff = selected;
+                 
+        if (self.stuff == world)
+		return FALSE;
+        else
+        {
+                BotFoundStuff();
+		return TRUE;
+	}
+};
+//=============================================================
+// BotHuntStuff - Look for items
+//=============================================================
+void() BotHuntStuff =
+{
+        self.goalentity = self.stuff;
+        self.movetarget = self.stuff;//attempt
+        self.think = self.th_stuff;
+        self.ideal_yaw = vectoyaw(self.stuff.origin - self.origin);
+	self.nextthink = time + 0.1;
+};
+
+//=============================================================
+// BotFoundStuff - Items
+//=============================================================
+void() BotFoundStuff =
+{
+        local float f_dist;
+        local string s_dist;
+        f_dist = vlen (self.stuff.origin - self.origin);
+        s_dist = ftos (f_dist);
+
+        BotHuntStuff ();
+};
+
+//=============================================================
+// bot_ai_stuff - crappy hack
+//=============================================================
+void(float dist) bot_ai_stuff =
+{
+	local	vector	delta;
+	local	float	axis;
+	local	float	direct, ang_rint, ang_floor, ang_ceil;
+	
+	movedist = dist;
+
+        enemy_vis = visible(self.stuff);
+	if (enemy_vis)
+		self.search_time = time + 5;
+
+        enemy_infront = infront(self.stuff);
+        enemy_range = range(self.stuff);
+        enemy_yaw = vectoyaw(self.stuff.origin - self.origin);
+        BotCheckPowerupsb();        
+                
+	movetogoal (dist);		// done in C code...
+};
+
+void() bot_upabit =
+{
+        self.velocity_z = (self.velocity_z + 35);
+};
+/*
+===============================================================================
+
+Bot LIGHTNING
+
+===============================================================================
+*/
+
+/*
+=================
+BotLightningDamage
+=================
+*/
+void(vector p1, vector p2, entity from, float damage) BotLightningDamage =
+{
+	local entity		e1, e2;
+	local vector		f;
+	
+	f = p2 - p1;
+	normalize (f);
+	f_x = 0 - f_y;
+	f_y = f_x;
+	f_z = 0;
+	f = f*16;
+
+	e1 = e2 = world;
+
+	traceline (p1, p2, FALSE, self);
+	if (trace_ent.takedamage)
+	{
+		particle (trace_endpos, '0 0 100', 225, damage*4);
+		T_Damage (trace_ent, from, from, damage);
+                if ((self.classname == "player") || (self.classname == "bot"))
+                {
+                        if ((other.classname == "player") || (other.classname == "bot"))
+				trace_ent.velocity_z = trace_ent.velocity_z + 400;
+		}
+	}
+	e1 = trace_ent;
+
+	traceline (p1 + f, p2 + f, FALSE, self);
+	if (trace_ent != e1 && trace_ent.takedamage)
+	{
+		particle (trace_endpos, '0 0 100', 225, damage*4);
+		T_Damage (trace_ent, from, from, damage);
+	}
+	e2 = trace_ent;
+
+	traceline (p1 - f, p2 - f, FALSE, self);
+	if (trace_ent != e1 && trace_ent != e2 && trace_ent.takedamage)
+	{
+		particle (trace_endpos, '0 0 100', 225, damage*4);
+		T_Damage (trace_ent, from, from, damage);
+	}
+};
+
+
+void() bot_FireLightning =
+{
+	local	vector		org;
+	local	vector	dir;
+	local	entity	en;
+
+
+	if (self.ammo_cells < 1)
+	{
+                self.weapon = bot_bestweapon ();
+                bot_SetCurrentAmmo ();
+		return;
+	}
+        bot_SetCurrentAmmo ();
+        self.effects = self.effects | EF_MUZZLEFLASH;
+
+// explode if under water
+	if (self.waterlevel > 1)
+	{
+		T_RadiusDamage (self, self, 35*self.ammo_cells, world);
+		self.ammo_cells = 0;
+                bot_SetCurrentAmmo ();
+		return;
+	}
+
+	if (self.t_width < time)
+	{
+		sound (self, CHAN_WEAPON, "weapons/lhit.wav", 1, ATTN_NORM);
+		self.t_width = time + 0.6;
+	}
+	self.punchangle_x = -2;
+
+	self.currentammo = self.ammo_cells = self.ammo_cells - 1;
+
+	en = self.enemy;
+	dir = en.origin - en.velocity*0.2;
+	dir = normalize (dir - self.origin);
+
+	org = self.origin + '0 0 16';
+	
+        traceline (org, dir + v_forward*600, TRUE, self);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LIGHTNING2);
+	WriteEntity (MSG_BROADCAST, self);
+	WriteCoord (MSG_BROADCAST, org_x);
+	WriteCoord (MSG_BROADCAST, org_y);
+	WriteCoord (MSG_BROADCAST, org_z);
+	WriteCoord (MSG_BROADCAST, trace_endpos_x);
+	WriteCoord (MSG_BROADCAST, trace_endpos_y);
+	WriteCoord (MSG_BROADCAST, trace_endpos_z);
+
+        BotLightningDamage (self.origin, trace_endpos + v_forward*4, self, 30);
+};
+
+void() Axe_Attack =
+{
+        if (zrandom() > 1.6)
+                bot_atka1 ();
+        else if (zrandom() > 1.2)
+                bot_atkab1 ();
+        else if (zrandom() > 0.8)
+                bot_atkac1 ();
+        else if (zrandom() > 0.4)
+                bot_atkad1 ();
+
+};
+void() QAxe_Attack =
+{
+        if (zrandom() > 1.6)
+                bot_qatka1 ();
+        else if (zrandom() > 1.2)
+                bot_qatkab1 ();
+        else if (zrandom() > 0.8)
+                bot_qatkac1 ();
+        else if (zrandom() > 0.4)
+                bot_qatkad1 ();
+
+};
+
+/*
+================
+bot_FireAxe
+================
+*/
+void() bot_FireAxe =
+{
+local vector	delta;
+local float 	ldmg;
+
+	if (!self.enemy)
+		return;
+
+	ai_charge(10);
+
+	delta = self.enemy.origin - self.origin;
+
+	if (vlen(delta) > 100)
+		return;
+		
+        T_Damage (self.enemy, self, self, 20);
+        makevectors (self.angles);
+        SpawnMeatSpray (self.origin + v_forward*16, crandom() * 100 * v_right);        
+};
+
+void() bot_checkrange =
+{
+        if ((self.enemy.classname != "bot") && (self.enemy.classname != "player"))
+        {
+                self.th_run ();
+        }
+        if ((self.weapon == IT_ROCKET_LAUNCHER) || (self.weapon == IT_GRENADE_LAUNCHER))
+        {
+                if ((range(self.enemy)) == RANGE_MELEE)
+                        self.th_run ();
+        }
+        if ((self.weapon == IT_AXE) && (range(self.enemy) != RANGE_MELEE))
+        {
+                self.th_run ();
+        }               
+};
diff -ur --new-file d:\quakestu\qcc\send\v101qc/buttons.qc backup5/buttons.qc
--- d:\quakestu\qcc\send\v101qc/buttons.qc	Wed Jul 24 23:51:22 1996
+++ backup5/buttons.qc	Sat Aug 31 23:43:24 1996
@@ -53,7 +53,7 @@
 
 void() button_touch =
 {
-	if (other.classname != "player")
+        if ((other.classname != "player") && (other.classname !="bot"))
 		return;
 	self.enemy = other;
 	button_fire ();
diff -ur --new-file d:\quakestu\qcc\send\v101qc/client.qc backup5/client.qc
--- d:\quakestu\qcc\send\v101qc/client.qc	Wed Jul 24 23:51:22 1996
+++ backup5/client.qc	Mon Sep  9 21:19:00 1996
@@ -1,5 +1,6 @@
 
 // prototypes
+void () BotStartDM;
 void () W_WeaponFrame;
 void() W_SetCurrentAmmo;
 void() player_pain;
@@ -467,6 +468,10 @@
 	self.effects = 0;
 	self.invincible_time = 0;
 
+// TM Bot - begin new start settings
+//        self.bot_flag = FALSE;
+// TM Bot - end new start settings
+
 	DecodeLevelParms ();
 	
 	W_SetCurrentAmmo ();
@@ -495,7 +500,14 @@
 	setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
 	
 	self.view_ofs = '0 0 22';
-
+	if (deathmatch)
+	{
+                if (self.bot_flag == FALSE)
+                {
+                        BotStartDM ();
+                        self.bot_flag == TRUE;
+                }
+        }
 	player_stand1 ();
 	
 	if (deathmatch || coop)
@@ -581,13 +593,15 @@
 
 void() DumpScore =
 {
-	local entity	e, sort, walk;
+        local entity    e, sort, walk, f;
 
 	if (world.chain)
 		error ("DumpScore: world.chain is set");
 
 // build a sorted lis
-	e = find(world, classname, "player");
+//        e = find(world, classname, "player");
+        e = find(world, classname, "bot");
+        
 	sort = world;
 	while (e)
 	{
@@ -597,7 +611,7 @@
 			e.chain = world;
 		}
 		else
-		{
+                {
 			if (e.frags > sort.frags)
 			{
 				e.chain = sort;
@@ -623,9 +637,50 @@
 				} while (walk.chain != e);
 			}
 		}
-		
-		e = find(e, classname, "player");
+       
+                e = find(e, classname, "player");
 	}
+        f = find(world, classname, "bot");
+        
+	sort = world;
+        while (f)
+	{
+		if (!sort)
+		{
+                        sort = f;
+                        f.chain = world;
+		}
+		else
+                {
+                        if (f.frags > sort.frags)
+			{
+                                f.chain = sort;
+                                sort = f;
+			}
+			else
+			{
+				walk = sort;
+				do
+				{
+					if (!walk.chain)
+					{
+                                                f.chain = world;
+                                                walk.chain = f;
+					}
+                                        else if (walk.chain.frags < f.frags)
+					{
+                                                f.chain = walk.chain;
+                                                walk.chain = f;
+					}
+					else
+						walk = walk.chain;
+                                } while (walk.chain != f);
+			}
+		}
+       
+                f = find(f, classname, "bot");
+	}
+
 
 // print the list
 	
@@ -1218,7 +1273,7 @@
 	local	string deathstring, deathstring2;
 	rnum = random();
 
-	if (targ.classname == "player")
+        if ((attacker.classname == "player") || (attacker.classname == "bot"))
 	{
 		if (attacker.classname == "teledeath")
 		{
@@ -1241,7 +1296,7 @@
 			return;
 		}
 
-		if (attacker.classname == "player")
+                if ((attacker.classname == "player") || (attacker.classname == "bot"))
 		{
 			if (targ == attacker)
 			{
@@ -1320,7 +1375,12 @@
 					else
 						deathstring2 = "'s shaft\n";
 				}
-				bprint (targ.netname);
+//                                if (attacker.classname == "bot")
+//                                {                                       
+//                                        deathstring = " eats ";
+//                                        deathstring2 = "'s laser blast\n";
+//                                }
+                                bprint (targ.netname);
 				bprint (deathstring);
 				bprint (attacker.netname);
 				bprint (deathstring2);
@@ -1365,6 +1425,7 @@
 
 			if (attacker.flags & FL_MONSTER)
 			{
+                                
 				if (attacker.classname == "monster_army")
 					bprint (" was shot by a Grunt\n");
 				if (attacker.classname == "monster_demon1")
diff -ur --new-file d:\quakestu\qcc\send\v101qc/combat.qc backup5/combat.qc
--- d:\quakestu\qcc\send\v101qc/combat.qc	Wed Jul 24 23:51:22 1996
+++ backup5/combat.qc	Sat Aug 31 01:45:50 1996
@@ -4,7 +4,6 @@
 void(entity targ, entity attacker) ClientObituary;
 
 void() monster_death_use;
-
 //============================================================================
 
 /*
@@ -83,7 +82,11 @@
 	
 	self.takedamage = DAMAGE_NO;
 	self.touch = SUB_Null;
-
+        if (self.classname == "bot")
+        {
+              //  (attacker.frags = attacker.frags + 1);
+                self.attackr = attacker;
+        }
 	monster_death_use();
 	self.th_die ();
 	
@@ -140,13 +143,12 @@
 	}
 
 // figure momentum add
-	if ( (inflictor != world) && (targ.movetype == MOVETYPE_WALK) )
+        if ((inflictor != world) && ((targ.movetype == MOVETYPE_WALK) || (targ.classname == "bot")))
 	{
 		dir = targ.origin - (inflictor.absmin + inflictor.absmax) * 0.5;
 		dir = normalize(dir);
 		targ.velocity = targ.velocity + dir*damage*8;
 	}
-
 // check for godmode or invincibility
 	if (targ.flags & FL_GODMODE)
 		return;
@@ -177,7 +179,7 @@
 	oldself = self;
 	self = targ;
 
-	if ( (self.flags & FL_MONSTER) && attacker != world)
+        if (( (self.flags & FL_MONSTER) && attacker != world) || (self.classname == "bot") && attacker !=world)
 	{
 	// get mad unless of the same class (except for soldiers)
 		if (self != attacker && attacker != self.enemy)
@@ -191,6 +193,13 @@
 				FoundTarget ();
 			}
 		}
+                if (self.classname == "bot")
+		{
+                         self.oldenemy = self.enemy;
+                         self.enemy = attacker;
+                         BotFoundTarget ();
+		}
+
 	}
 
 	if (self.th_pain)
diff -ur --new-file d:\quakestu\qcc\send\v101qc/defs.qc backup5/defs.qc
--- d:\quakestu\qcc\send\v101qc/defs.qc	Wed Jul 24 23:51:22 1996
+++ backup5/defs.qc	Wed Sep 11 00:17:18 1996
@@ -211,6 +211,27 @@
 void		end_sys_fields;			// flag for structure dumping
 //================================================
 
+
+// TM Bot - begin new entity fields
+.entity		bot;				// pointer to the bot
+.float		bot_flag;			// existence of bot (TRUE or FALSE)
+.float		bot_auto;			// auto mode of bot (TRUE or FALSE)
+.float		move_flag;			// movement of bot (STAND, WALK, or RUN)
+.float		auto_fire;			// status of bot's auto fire (TRUE or FALSE)
+.entity         rcktdtct;                       // detecting rockets(FLY_MISSILE's)
+.entity         attackr;                        // remembering who killed bot
+.entity         bot_enemy_entity;               // remembering where enemy is
+.entity         bot_controller;     // the thinking half of the bot
+.float          dodge;                          // to prevent dodgeing while dodgeing
+.void()         th_dodge;                       // dodge action
+.entity         controller;                     // who the thinker is
+.void()         th_stuff;                       // for searching items
+.entity         stuff;                          // what item to get 
+.void()         th_qatk;                        // quick attack
+.float          dodge_finished;                  // for telling if dodge time up
+.entity         testcase;                       //testcase entity
+// TM Bot - end new entity fields
+
 /*
 ==============================================================================
 
diff -ur --new-file d:\quakestu\qcc\send\v101qc/doors.qc backup5/doors.qc
--- d:\quakestu\qcc\send\v101qc/doors.qc	Wed Jul 24 23:51:22 1996
+++ backup5/doors.qc	Sun Sep  1 00:03:24 1996
@@ -195,19 +195,20 @@
 */
 void() door_touch =
 {
-	if (other.classname != "player")
+        if ((other.classname != "player") && (other.classname !="bot"))
 		return;
 	if (self.owner.attack_finished > time)
 		return;
 
 	self.owner.attack_finished = time + 2;
-
-	if (self.owner.message != "")
-	{
-		centerprint (other, self.owner.message);
-		sound (other, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
-	}
-	
+        if (other.classname == "player")
+        {
+                if (self.owner.message != "")
+                {
+                        centerprint (other, self.owner.message);
+                         sound (other, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);      
+                }
+        }
 // key door stuff
 	if (!self.items)
 		return;
@@ -217,40 +218,48 @@
 	{
 		if (self.owner.items == IT_KEY1)
 		{
-			if (world.worldtype == 2)
-			{
-				centerprint (other, "You need the silver keycard");
-				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
-			}
-			else if (world.worldtype == 1)
-			{
-				centerprint (other, "You need the silver runekey");
-				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
-			}
-			else if (world.worldtype == 0)
-			{
-				centerprint (other, "You need the silver key");
-				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
-			}
-		}
+                        if (other.classname == "player")
+                        {
+
+                                if (world.worldtype == 2)
+                                {
+                                        centerprint (other, "You need the silver keycard");
+                                        sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+                                }
+                                else if (world.worldtype == 1)
+                                {
+                                        centerprint (other, "You need the silver runekey");
+                                        sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+                                }
+                                else if (world.worldtype == 0)
+                                {
+                                        centerprint (other, "You need the silver key");
+                                        sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+                                }
+                        }
+                }
 		else
 		{
-			if (world.worldtype == 2)
-			{
-				centerprint (other, "You need the gold keycard");
-				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
-			}
-			else if (world.worldtype == 1)
-			{
-				centerprint (other, "You need the gold runekey");
-				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);			
-			}
-			else if (world.worldtype == 0)
-			{
-				centerprint (other, "You need the gold key");
-				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
-			}
-		}
+                        if (other.classname == "player")
+                        {
+
+                                if (world.worldtype == 2)
+                                {
+                                        centerprint (other, "You need the gold keycard");
+                                        sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+                                }
+                                else if (world.worldtype == 1)
+                                {
+                                        centerprint (other, "You need the gold runekey");
+                                        sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);             
+                                }
+                                else if (world.worldtype == 0)
+                                {
+                                        centerprint (other, "You need the gold key");
+                                        sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+                                }
+                        }
+                }
 		return;
 	}
 
@@ -687,18 +696,22 @@
 */
 void() secret_touch =
 {
-	if (other.classname != "player")
+        if ((other.classname != "player") && (other.classname != "bot"))
 		return;
 	if (self.attack_finished > time)
 		return;
 
 	self.attack_finished = time + 2;
 	
-	if (self.message)
-	{
-		centerprint (other, self.message);
-		sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
-	}
+        if (other.classname == "player")
+        {
+
+                if (self.message)
+                {
+                        centerprint (other, self.message);
+                        sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
+                }
+        }
 };
 
 
diff -ur --new-file d:\quakestu\qcc\send\v101qc/items.qc backup5/items.qc
--- d:\quakestu\qcc\send\v101qc/items.qc	Wed Jul 24 23:51:24 1996
+++ backup5/items.qc	Mon Sep  9 23:32:00 1996
@@ -1,4 +1,6 @@
 void() W_SetCurrentAmmo;
+void() bot_SetCurrentAmmo;
+float() bot_bestweapon;
 /* ALL LIGHTS SHOULD BE 0 1 0 IN COLOR ALL OTHER ITEMS SHOULD
 BE .8 .3 .4 IN COLOR */
 
@@ -152,7 +154,7 @@
 	local	float amount;
 	local	string	s;
 	
-	if (other.classname != "player")
+        if (other.classname != "player" && other.classname != "bot")
 		return;
 	
 	if (self.healtype == 2) // Megahealth?  Ignore max_health...
@@ -167,17 +169,18 @@
 		if (!T_Heal(other, self.healamount, 0))
 			return;
 	}
-	
-	sprint(other, "You receive ");
-	s = ftos(self.healamount);
-	sprint(other, s);
-	sprint(other, " health\n");
-	
+        if (other.classname == "player")
+        {
+                sprint(other, "You receive ");
+                s = ftos(self.healamount);
+                sprint(other, s);
+                sprint(other, " health\n");
+
 // health touch sound
-	sound(other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
+                sound(other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
 
-	stuffcmd (other, "bf\n");
-	
+                stuffcmd (other, "bf\n");
+        }
 	self.model = string_null;
 	self.solid = SOLID_NOT;
 
@@ -241,7 +244,7 @@
 	
 	if (other.health <= 0)
 		return;
-	if (other.classname != "player")
+        if (other.classname != "player" && other.classname != "bot")
 		return;
 
 	if (self.classname == "item_armor1")
@@ -275,11 +278,13 @@
 		self.nextthink = time + 20;
 	self.think = SUB_regen;
 
-	sprint(other, "You got armor\n");
+        if (other.classname == "player")
+        {
+                sprint(other, "You got armor\n");
 // armor touch sound
 	sound(other, CHAN_ITEM, "items/armor1.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
-	
+        }
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
 };
@@ -391,17 +396,18 @@
 
 void() weapon_touch =
 {
-	local	float	hadammo, best, new, old;
+        local   float   hadammo, best, new, old, bbest;
 	local	entity	stemp;
 	local	float	leave;
 
-	if (!(other.flags & FL_CLIENT))
+        if (!(other.flags & FL_CLIENT) && other.classname != "bot")
 		return;
 
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
+        bbest = bot_bestweapon();
 	self = stemp;
 
 	if (deathmatch == 2 || coop)
@@ -459,14 +465,15 @@
 	}
 	else
 		objerror ("weapon_touch: unknown classname");
-
-	sprint (other, "You got the ");
-	sprint (other, self.netname);
-	sprint (other, "\n");
+        if (other.classname == "player")
+        {
+                sprint (other, "You got the ");
+                sprint (other, self.netname);
+                sprint (other, "\n");
 // weapon touch sound
-	sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
-	stuffcmd (other, "bf\n");
-
+                sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
+                stuffcmd (other, "bf\n");
+        }
 	bound_other_ammo ();
 
 // change to the weapon
@@ -480,10 +487,15 @@
 		self.weapon = new;
 	else
 		Deathmatch_Weapon (old, new);
-
+        if (other.classname == "player")
+        {
 	W_SetCurrentAmmo();
-
-	self = stemp;
+        }
+        if (other.classname == "bot")
+        {
+        bot_SetCurrentAmmo();
+        }
+        self = stemp;
 
 	if (leave)
 		return;
@@ -597,9 +609,9 @@
 void() ammo_touch =
 {
 local entity	stemp;
-local float		best;
+local float             best,bbest;
 
-	if (other.classname != "player")
+        if (other.classname != "player" && other.classname != "bot")
 		return;
 	if (other.health <= 0)
 		return;
@@ -608,6 +620,7 @@
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
+        bbest = bot_bestweapon();
 	self = stemp;
 
 
@@ -644,31 +657,46 @@
 	}
 
 	bound_other_ammo ();
-	
-	sprint (other, "You got the ");
-	sprint (other, self.netname);
-	sprint (other, "\n");
-// ammo touch sound
-	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
-	stuffcmd (other, "bf\n");
-
+        if (other.classname == "player")
+        {
+                sprint (other, "You got the ");
+                sprint (other, self.netname);
+                sprint (other, "\n");
+        // ammo touch sound
+                sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
+                stuffcmd (other, "bf\n");
 // change to a better weapon if appropriate
 
-	if ( other.weapon == best )
-	{
-		stemp = self;
-		self = other;
-		self.weapon = W_BestWeapon();
-		W_SetCurrentAmmo ();
-		self = stemp;
-	}
+                if ( other.weapon == best )
+                {
+                       stemp = self;
+                        self = other;
+                        self.weapon = W_BestWeapon();
+                        W_SetCurrentAmmo ();
+                        self = stemp;
+                }
 
 // if changed current ammo, update it
-	stemp = self;
-	self = other;
-	W_SetCurrentAmmo();
-	self = stemp;
-
+                stemp = self;
+                self = other;
+                W_SetCurrentAmmo();
+                self = stemp;
+        }
+        if (other.classname == "bot")
+        {
+                if (other.weapon == bbest)
+                {
+                        stemp = self;
+                        self = other;
+                        self.weapon = bot_bestweapon();
+                        bot_SetCurrentAmmo();
+                        self = stemp;
+                }
+                stemp = self;
+                self = other;
+                bot_SetCurrentAmmo();
+                self = stemp;
+        }
 // remove it in single player, or setup for respawning in deathmatch
 	self.model = string_null;
 	self.solid = SOLID_NOT;
@@ -706,6 +734,7 @@
 		self.aflag = 20;
 	}
 	self.weapon = 1;
+        self.classname = "shells";
 	self.netname = "shells";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
@@ -731,6 +760,7 @@
 		self.aflag = 25;
 	}
 	self.weapon = 2;
+        self.classname = "nails";
 	self.netname = "nails";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
@@ -756,6 +786,7 @@
 		self.aflag = 5;
 	}
 	self.weapon = 3;
+        self.classname = "rockets";
 	self.netname = "rockets";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
@@ -782,6 +813,7 @@
 		self.aflag = 6;
 	}
 	self.weapon = 4;
+        self.classname = "cells";
 	self.netname = "cells";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
@@ -1081,15 +1113,16 @@
 local entity	stemp;
 local float		best;
 
-	if (other.classname != "player")
+        if (other.classname != "player" && other.classname != "bot")
 		return;
 	if (other.health <= 0)
 		return;
-
-	sprint (other, "You got the ");
-	sprint (other, self.netname);
-	sprint (other,"\n");
-
+        if (other.classname == "player")
+        {
+                sprint (other, "You got the ");
+                sprint (other, self.netname);
+                sprint (other,"\n");
+        }
 	if (deathmatch)
 	{
 		self.mdl = self.model;
@@ -1103,8 +1136,11 @@
 		self.think = SUB_regen;
 	}	
 
-	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
-	stuffcmd (other, "bf\n");
+        if (other.classname == "player")
+        {
+                sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+                stuffcmd (other, "bf\n");
+        }                
 	self.solid = SOLID_NOT;
 	other.items = other.items | self.items;
 	self.model = string_null;
@@ -1120,19 +1156,26 @@
 	{
 		other.invincible_time = 1;
 		other.invincible_finished = time + 30;
+                if (other.classname == "bot")
+                        other.effects = other.effects + EF_DIMLIGHT;
 	}
 	
 	if (self.classname == "item_artifact_invisibility")
 	{
 		other.invisible_time = 1;
 		other.invisible_finished = time + 30;
+                if (other.classname == "bot")
+                        setmodel (other, "progs/eyes.mdl");
 	}
 
 	if (self.classname == "item_artifact_super_damage")
 	{
 		other.super_time = 1;
 		other.super_damage_finished = time + 30;
-	}	
+                if (other.classname == "bot")
+                        other.effects = other.effects + EF_DIMLIGHT;
+
+	}
 
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
@@ -1190,7 +1233,7 @@
 	precache_sound ("items/inv2.wav");
 	precache_sound ("items/inv3.wav");
 	self.noise = "items/inv1.wav";
-	setmodel (self, "progs/invisibl.mdl");
+	setmodel (self, "progs/invisibl.mdl");       
 	self.netname = "Ring of Shadows";
 	self.items = IT_INVISIBILITY;
 	setsize (self, '-16 -16 -24', '16 16 32');
@@ -1230,10 +1273,10 @@
 void() BackpackTouch =
 {
 	local string	s;
-	local	float	best;
+        local   float   best,bbest;
 	local		entity	stemp;
 	
-	if (other.classname != "player")
+        if (other.classname != "player" && other.classname != "bot")
 		return;
 	if (other.health <= 0)
 		return;
@@ -1242,64 +1285,81 @@
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
+        bbest = bot_bestweapon();
 	self = stemp;
 
 // change weapons
 	other.ammo_shells = other.ammo_shells + self.ammo_shells;
 	other.ammo_nails = other.ammo_nails + self.ammo_nails;
-	other.ammo_rockets = other.ammo_rockets + self.ammo_rockets;
+        other.ammo_rockets = other.ammo_rockets + self.ammo_rockets;
 	other.ammo_cells = other.ammo_cells + self.ammo_cells;
 
 	other.items = other.items | self.items;
 	
 	bound_other_ammo ();
-
-	sprint (other, "You get ");
-
-	if (self.ammo_shells)
-	{
-		s = ftos(self.ammo_shells);
-		sprint (other, s);
-		sprint (other, " shells  ");
-	}
-	if (self.ammo_nails)
-	{
-		s = ftos(self.ammo_nails);
-		sprint (other, s);
-		sprint (other, " nails ");
-	}
-	if (self.ammo_rockets)
-	{
-		s = ftos(self.ammo_rockets);
-		sprint (other, s);
-		sprint (other, " rockets  ");
-	}
-	if (self.ammo_cells)
-	{
-		s = ftos(self.ammo_cells);
-		sprint (other, s);
-		sprint (other, " cells  ");
-	}
+        if (other.classname == "player")
+        {
+                sprint (other, "You get ");
+                if (self.ammo_shells)
+                {
+                        s = ftos(self.ammo_shells);
+                        sprint (other, s);
+                        sprint (other, " shells  ");
+                }
+                if (self.ammo_nails)
+                {
+                        s = ftos(self.ammo_nails);
+                        sprint (other, s);
+                        sprint (other, " nails ");
+                }
+                if (self.ammo_rockets)
+                {
+                        s = ftos(self.ammo_rockets);
+                        sprint (other, s);
+                        sprint (other, " rockets  ");
+                }
+                if (self.ammo_cells)
+                {
+                        s = ftos(self.ammo_cells);
+                        sprint (other, s);
+                        sprint (other, " cells  ");
+                }
 	
-	sprint (other, "\n");
+                sprint (other, "\n");
 // backpack touch sound
-	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
-	stuffcmd (other, "bf\n");
+                sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
+                stuffcmd (other, "bf\n");
 
 // change to a better weapon if appropriate
-	if ( other.weapon == best )
-	{
-		stemp = self;
-		self = other;
-		self.weapon = W_BestWeapon();
-		self = stemp;
-	}
-
+                if ( other.weapon == best )
+                {
+                        stemp = self;
+                        self = other;
+                        self.weapon = W_BestWeapon();
+                        W_SetCurrentAmmo ();
+                        self = stemp;
+                }
+
+        }
+        if (other.classname == "bot")
+        {
+                if (other.weapon == bbest)
+                {
+                        stemp = self;
+                        self = other;
+                        self.weapon = bot_bestweapon();
+                        bot_SetCurrentAmmo();
+                        self = stemp;
+                }
+                stemp = self;
+                self = other;
+                bot_SetCurrentAmmo();
+                self = stemp;
+        }
 	
 	remove(self);
 	
 	self = other;
-	W_SetCurrentAmmo ();
 };
 
 /*
@@ -1331,6 +1391,7 @@
 	item.flags = FL_ITEM;
 	item.solid = SOLID_TRIGGER;
 	item.movetype = MOVETYPE_TOSS;
+        item.classname = "backpack";
 	setmodel (item, "progs/backpack.mdl");
 	setsize (item, '-16 -16 0', '16 16 56');
 	item.touch = BackpackTouch;
diff -ur --new-file d:\quakestu\qcc\send\v101qc/plats.qc backup5/plats.qc
--- d:\quakestu\qcc\send\v101qc/plats.qc	Wed Jul 24 23:51:24 1996
+++ backup5/plats.qc	Wed Aug 21 20:56:46 1996
@@ -72,7 +72,8 @@
 
 void() plat_center_touch =
 {
-	if (other.classname != "player")
+// TM Bot - added recognition of "bot" classname
+	if ((other.classname != "player") && (other.classname != "bot"))
 		return;
 		
 	if (other.health <= 0)
@@ -87,7 +88,8 @@
 
 void() plat_outside_touch =
 {
-	if (other.classname != "player")
+// TM Bot - added recognition of "bot" classname
+	if ((other.classname != "player") && (other.classname != "bot"))
 		return;
 
 	if (other.health <= 0)
diff -ur --new-file d:\quakestu\qcc\send\v101qc/player.qc backup5/player.qc
--- d:\quakestu\qcc\send\v101qc/player.qc	Wed Jul 24 23:51:24 1996
+++ backup5/player.qc	Mon Aug 26 00:38:20 1996
@@ -544,6 +544,7 @@
 	if (self.velocity_z < 10)
 		self.velocity_z = self.velocity_z + random()*300;
 
+	
 	if (self.health < -40)
 	{
 		GibPlayer ();
diff -ur --new-file d:\quakestu\qcc\send\v101qc/progs.src backup5/progs.src
--- d:\quakestu\qcc\send\v101qc/progs.src	Wed Jul 24 23:51:28 1996
+++ backup5/progs.src	Tue Sep 10 19:03:32 1996
@@ -1,21 +1,33 @@
 ../progs.dat
 
-defs.qc
-subs.qc
+defs.qc		// Modified - TM Bot
+
+// TM Bot Header File
+bot.h
+
+subs.qc		// Modified - TM Bot
 fight.qc
 ai.qc
 combat.qc
 items.qc
-weapons.qc
-world.qc
-client.qc
-player.qc
+
+// TM Bot source code
+botai.qc
+bot.qc
+
+weapons.qc	// Modified - TM Bot
+world.qc	// Modified - TM Bot
+client.qc	// Modified - TM Bot
+player.qc	// Modified - TM Bot
 monsters.qc
 doors.qc
 buttons.qc
-triggers.qc
-plats.qc
+triggers.qc	// Modified - TM Bot
+plats.qc	// Modified - TM Bot
 misc.qc
+
+// TM Bot extensions
+bot_ext.qc
 
 ogre.qc
 demon.qc
diff -ur --new-file d:\quakestu\qcc\send\v101qc/subs.qc backup5/subs.qc
--- d:\quakestu\qcc\send\v101qc/subs.qc	Wed Jul 24 23:51:24 1996
+++ backup5/subs.qc	Wed Aug 21 20:49:40 1996
@@ -1,5 +1,3 @@
-
-
 void() SUB_Null = {};
 
 void() SUB_Remove = {remove(self);};
@@ -238,6 +236,16 @@
 		if (!self.noise)
 			sound (activator, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
 	}
+
+// TM Bot - begin new code 
+	if (activator.classname == "bot" && self.message != "")
+	{
+		sprint (activator.owner, "Incoming message from bot:\n");
+		centerprint (activator.owner, self.message);
+		if (!self.noise)
+			sound (activator.owner, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
+	}
+// TM Bot - end new code
 
 //
 // kill the killtagets
diff -ur --new-file d:\quakestu\qcc\send\v101qc/triggers.qc backup5/triggers.qc
--- d:\quakestu\qcc\send\v101qc/triggers.qc	Wed Jul 24 23:51:24 1996
+++ backup5/triggers.qc	Sun Sep  1 00:04:02 1996
@@ -36,8 +36,11 @@
 
 	if (self.classname == "trigger_secret")
 	{
-		if (self.enemy.classname != "player")
+// TM Bot - added recognition of "bot" classname
+                if ((self.enemy.classname != "player") && (self.enemy.classname != "bot"))
 			return;
+		if (self.enemy.classname != "bot") // otherwise owner might not know
+			centerprint (self.enemy.owner, "bot found a secret!\n");
 		found_secrets = found_secrets + 1;
 		WriteByte (MSG_ALL, SVC_FOUNDSECRET);
 	}
@@ -80,7 +83,8 @@
 
 void() multi_touch =
 {
-	if (other.classname != "player")
+// TM Bot - added recognition of "bot" classname
+        if ((other.classname != "player") && (other.classname != "bot"))
 		return;
 	
 // if the trigger has an angles field, check player's facing direction
@@ -221,6 +225,13 @@
 
 void() counter_use =
 {
+// TM Bot - uses the bot_ext.qc version of counter_use for bots
+	if (activator.classname == "bot")
+	{
+		bot_counter_use ();
+		return;
+	}
+
 	local string junk;
 
 	self.count = self.count - 1;
@@ -321,11 +332,13 @@
 		return;
 
 // frag anyone who teleports in on top of an invincible player
-	if (other.classname == "player")
+
+// TM Bot - added recognition for classname "bot"
+        if ((other.classname == "player") || (other.classname == "bot"))
 	{
 		if (other.invincible_finished > time)
 			self.classname = "teledeath2";
-		if (self.owner.classname != "player")
+                if ((self.owner.classname != "player") && (self.owner.classname != "bot"))
 		{	// other monsters explode themselves
 			T_Damage (self.owner, self, self, 50000);
 			return;
@@ -337,7 +350,7 @@
 	{
 		T_Damage (other, self, self, 50000);
 	}
-};
+};                                                                                   
 
 
 void(vector org, entity death_owner) spawn_tdeath =
@@ -374,7 +387,8 @@
 
 	if (self.spawnflags & PLAYER_ONLY)
 	{
-		if (other.classname != "player")
+// TM Bot - added recognition for classname "bot"
+                if ((other.classname != "player") && (other.classname != "bot"))
 			return;
 	}
 
@@ -408,7 +422,8 @@
 
 	setorigin (other, t.origin);
 	other.angles = t.mangle;
-	if (other.classname == "player")
+// TM Bot - added recognition of "bot" classname
+        if ((other.classname == "player") || (other.classname == "bot"))
 	{
 		other.fixangle = 1;		// turn this way immediately
 		other.teleport_time = time + 0.7;
@@ -474,7 +489,7 @@
 
 void() trigger_skill_touch =
 {
-	if (other.classname != "player")
+        if ((other.classname != "player") && (other.classname != "bot"))
 		return;
 		
 	cvar_set ("skill", self.message);
@@ -501,6 +516,13 @@
 
 void() trigger_onlyregistered_touch =
 {
+// TM Bot - uses bot_ext.qc version for bots
+	if (other.classname == "bot")
+	{
+		bot_trigger_onlyregistered_touch ();
+		return;
+	}
+
 	if (other.classname != "player")
 		return;
 	if (self.attack_finished > time)
@@ -578,12 +600,18 @@
 	else if (other.health > 0)
 	{
 		other.velocity = self.speed * self.movedir * 10;
-		if (other.classname == "player")
+
+// TM Bot - added recognition of "bot" classname
+                if ((other.classname == "player") || (other.classname == "bot"))
 		{
 			if (other.fly_sound < time)
 			{
 				other.fly_sound = time + 1.5;
 				sound (other, CHAN_AUTO, "ambience/windfly.wav", 1, ATTN_NORM);
+
+// TM Bot - added notification for the bot's owner
+				if (other.classname == "bot")
+					sprint (other.owner, "bot pushed a trigger\n");
 			}
 		}
 	}
diff -ur --new-file d:\quakestu\qcc\send\v101qc/weapons.qc backup5/weapons.qc
--- d:\quakestu\qcc\send\v101qc/weapons.qc	Wed Aug  7 17:10:06 1996
+++ backup5/weapons.qc	Tue Sep 10 17:48:20 1996
@@ -52,7 +52,7 @@
 		SpawnBlood (org, '0 0 0', 20);
 		T_Damage (trace_ent, self, self, 20);
 	}
-	else
+        else
 	{	// hit wall
 		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
 		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -221,7 +221,7 @@
 		WriteCoord (MSG_BROADCAST, org_x);
 		WriteCoord (MSG_BROADCAST, org_y);
 		WriteCoord (MSG_BROADCAST, org_z);
-        }
+	}
 };
 
 /*
@@ -384,6 +384,7 @@
 	missile.owner = self;
 	missile.movetype = MOVETYPE_FLYMISSILE;
 	missile.solid = SOLID_BBOX;
+        missile.classname = "rocket";         
 		
 // set missile speed	
 
@@ -436,8 +437,8 @@
 		particle (trace_endpos, '0 0 100', 225, damage*4);
 		T_Damage (trace_ent, from, from, damage);
 		if (self.classname == "player")
-		{
-			if (other.classname == "player")
+                {
+                        if ((other.classname == "player") || (other.classname == "bot"))
 				trace_ent.velocity_z = trace_ent.velocity_z + 400;
 		}
 	}
@@ -532,6 +533,12 @@
 		GrenadeExplode();
 		return;
 	}
+        if (other.classname == "bot") 
+	{
+                GrenadeExplode();
+		return;
+	}
+
 	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);	// bounce sound
 	if (self.velocity == '0 0 0')
 		self.avelocity = '0 0 0';
@@ -1160,6 +1167,11 @@
 */
 void() ImpulseCommands =
 {
+
+// New code
+        if (self.impulse == 100)
+                BotAdd();
+
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
 
diff -ur --new-file d:\quakestu\qcc\send\v101qc/world.qc backup5/world.qc
--- d:\quakestu\qcc\send\v101qc/world.qc	Wed Jul 24 23:51:24 1996
+++ backup5/world.qc	Wed Aug 21 22:41:56 1996
@@ -287,6 +287,9 @@
 	precache_model ("progs/zom_gib.mdl");
 
 	precache_model ("progs/v_light.mdl");
+
+// TM Bot - precaches for the bot
+	Bot_Precache ();
 	
 
 //
