(**********************8<************************>8**************************)
UNIT KEYBOARD;
INTERFACE

Uses DOS;

CONST
             KEY_ESC         =1;  { ESCAPE }
             KEY_1           =2;
             KEY_2           =3;
             KEY_3           =4;
             KEY_4           =5;
             KEY_5           =6;
             KEY_6           =7;
             KEY_7           =8;
             KEY_8           =9;
             KEY_9           =10;
             KEY_0           =11;
             KEY_MINUS       =12; { + / amerikkalaisen mallin mukaan - }
             KEY_EQUALS      =13; { ' / amerikkalaisen mallin mukaan - }
             KEY_BACKSPACE   =14;
             KEY_TAB         =15; { sarkain / tabulaattori }
             KEY_Q           =16;
             KEY_W           =17;
             KEY_E           =18;
             KEY_R           =19;
             KEY_T           =20;
             KEY_Y           =21;
             KEY_U           =22;
             KEY_I           =23;
             KEY_O           =24;
             KEY_P           =25;
             KEY_OPENBRACE   =26; {  }
             KEY_CLOSEBRACE  =27; {  }
             KEY_ENTER       =28; { ENTER / Return }
             KEY_CONTROL     =29; { CTRL -nppin }
             KEY_A           =30;
             KEY_S           =31;
             KEY_D           =32;
             KEY_F           =33;
             KEY_G           =34;
             KEY_H           =35;
             KEY_J           =36;
             KEY_K           =37;
             KEY_L           =38;
             KEY_COLON       =39; { ; }
             KEY_QUOTE       =40; { ' / * }
             KEY_TILDE       =41; { ~ /  / ^ }
             KEY_LSHIFT      =42; { Vasen shift }
             KEY_Z           =44;
             KEY_X           =45;
             KEY_C           =46;
             KEY_V           =47;
             KEY_B           =48;
             KEY_N           =49;
             KEY_M           =50;
             KEY_COMMA       =51; { , POINT  }
             KEY_STOP        =52; { . PERIOD }
             KEY_SLASH       =53; { - / _ }
             KEY_RSHIFT      =54; { oikea shift }
             KEY_ASTERISK    =55; { numeronppimistn * }
             KEY_ALT         =56; { ALT / ALTGR }
             KEY_SPACE       =57; { vlilynti }
             KEY_CAPSLOCK    =58;
             KEY_F1          =59;
             KEY_F2          =60;
             KEY_F3          =61;
             KEY_F4          =62;
             KEY_F5          =63;
             KEY_F6          =64;
             KEY_F7          =65;
             KEY_F8          =66;
             KEY_F9          =67;
             KEY_F10         =68;
             KEY_NUMLOCK     =69;
             KEY_SCRLOCK     =70;
             KEY_HOME        =71;
             KEY_UP          =72;
             KEY_PGUP        =73;
             KEY_PAD_MINUS   =74; { numeronppimistn - }
             KEY_LEFT        =75; { nuoli vasemmalle }
             KEY_PAD_5       =76; { numeronppimistn 5 }
             KEY_RIGHT       =77; { nuoli oikealle }
             KEY_PAD_PLUS    =78; { numeronppimistn + }
             KEY_END         =79;
             KEY_DOWN        =80;
             KEY_PGDN        =81;
             KEY_INSERT      =82;
             KEY_DEL         =83;
             KEY_F11         =87;
             KEY_F12         =88;


	 Var KEYS : ARRAY [0..127] OF Boolean;
             OldInt09 : POINTER;


     PROCEDURE NewKbdINT09; interrupt;
     PROCEDURE UnHookInt;

     IMPLEMENTATION

         {$F+}  { Laitetaan FAR CALLS valitsin plle }
         PROCEDURE NewKbdINT09;
           VAR  Highbyte, Lowbyte : BYTE;
           BEGIN
             Highbyte := PORT [$60];
             Keys [Highbyte AND $7f] := (Highbyte <= $7f);
             Lowbyte := PORT [$61];
             PORT[$61] := Lowbyte OR $80;
             PORT[$61] := Lowbyte;
             PORT[$20] := $20;
           END;

         PROCEDURE UnHookInt;
           BEGIN
             MEMW [$0000:$041A]:=MEMW [$0000:$041C];
             SetIntVec (9,addr (oldint09));
           END;

         {$F+}
           VAR KeyCount : Byte;
           BEGIN
             For KeyCount:=0 to 127 do Keys[KeyCount]:=False;
             GetIntVec(9, OldInt09);
             SetIntVec(9, Addr( Newkbdint09 ));
           END.
