{ PCXSHOW.PAS -- nytt MCGA-tilan (320x200x256) PCX-kuvan }
{ Jere Kpyaho, MikroBitti 3/95 }
{ Borland Pascal 7.0: knns komennolla 'bpc pcxshow.pas' }

{ kntnyt unitiksi Niko Nyqvist }

UNIT PCXSHOW;

INTERFACE


uses Crt, Dos;

{ Vakiot }
const
  PCX_PALETTE_ID = $0C;                     { paletin tunnus }
  PCX_NUM_COLORS = 256;                     { vrien mr }
  PCX_MAX_DATA_SIZE = 65000;                { kuvan enimmiskoko purettuna }
  PCX_PALETTE_SIZE = 3 * PCX_NUM_COLORS;    { paletin koko }
  VIDEO_INTR = $10;                         { BIOSin nyttkeskeytys }

{ Tietotyypit }
type
  { PCX-tiedoston alkuosa. }
  PCXHeaderType = record
    Manufacturer, Version, Encoding, BitsPerPixel : Byte;
    XMin, YMin, XMax, YMax : Word;
    HRes, VRes : Word;
    ColorMap : array [0..47] of Byte;
    Reserved : Byte;
    NPlanes : Byte;
    BytesPerLine : Word;
    PaletteInfo : Word;
    Filler : array [0..57] of Byte;
  end; { PCXHeaderType }

  { PCX-tiedoston paletti }
  PCXPaletteType = array [0..PCX_PALETTE_SIZE-1] of Byte;

  { PCX:n sisltm kuvatieto ja osoitin siihen }
  PCXDataPtr = ^PCXDataType;
  PCXDataType = array [0..PCX_MAX_DATA_SIZE-1] of Byte;

{ Muuttujat }
var
  VIDEO_MEM_SEG:word;           { nyttmuistin segmentti }
  PCXFileName : string;         { kuvatiedoston nimi }
  Regs : Registers;             { rekisterit keskeytyskutsuja varten }
  VGAPalette : PCXPaletteType;  { PCX-kuvan paletti }
  ch : Char;                    { kytetn odottaessa nppinpainallusta }
  kuvapcx:string;
  mihin:word;
  ok:boolean; { tyhmn funktioratkaisun jljilt 1 bitti turhaa }

procedure Error(msg : string);
function FileExists(Filename: string): Boolean;
function ShowPCXFile(Filename:string;mihin:word) : Boolean;
procedure showpcx(kuvapcx:string;mihin:word);

IMPLEMENTATION

procedure Error(msg : string);
begin
  WriteLn(msg);
  Halt;
end; { Error }

{ FileExists: palauttaa True jos nimetty tiedosto on
  olemassa, muutoin False. }
function FileExists(Filename: string): Boolean;
var F : file;
begin
{$I-}                   { ota I/O-tarkistus pois plt }
  Assign(F, Filename);  { yhdist nimi tiedostoon }
  FileMode := 0;        { tiedoston ksittelytapa: 0 = vain luku }
  Reset(F);             { yrit kytt tiedostoa }
  Close(F);             { sulje saman tien }
{$I+}                   { I/O-tarkistus takaisin plle }
  { Tiedosto on olemassa mikli IOResult ei osoita I/O-virhett
    ja tiedoston nimi ei ole tyhj }
  FileExists := (IOResult = 0) and (Filename <> '');
end; { FileExists }

{ Lue PCX-tiedoston sislt ja nyt se ruudulla }
function ShowPCXFile(Filename:string;mihin:word) : Boolean;
var
  PCXFile : file;            { PCX-kuvatiedosto }
  Header : PCXHeaderType;    { alkuosa }
  Palette : PCXPaletteType;  { paletti }
  PaletteID : Byte;          { paletin tunnus }
  Result : Word;             { apumuuttuja }
  Regs : Registers;          { rekisterit keskeytyskutsuja varten }
  x, y : Word;               { kuvapisteen x- ja y-koordinaatit }
  Data, RunCount, R : Byte;  { kuvatieto, toistolaskuri, apumuuttuja }
  ScreenOffset : Word;       { kuvaruutumuistin osoitin }
  Ok : Boolean;              { apumuuttuja }
  DataPtr : Word;            { kuvatiedon osoitin }
  PCXDataSize : Word;        { kuvatiedon koko }
  PCXData : PCXDataPtr;      { osoitin kuvatiedolle varattuun muistiin }
begin
  VIDEO_MEM_SEG:=mihin;


  { Jos muisti ei riit kuvan lukemiseen, luovuta heti }
  if MemAvail < PCX_MAX_DATA_SIZE then begin
    ShowPCXFile := False;
    Exit;
  end;

  { Lue PCX-tiedoston alkuosa ja tarkista versionumero }
  Assign(PCXFile, Filename);
  Reset(PCXFile, 1);
  BlockRead(PCXFile, Header, SizeOf(PCXHeaderType), Result);

  { Result-muuttujassa on luetun tiedon koko tavuina }
  if Result = SizeOf(PCXHeaderType) then begin
    { Tarkistetaan ett on oikea versio ja mys RLE-koodattu }
    if (Header.Version = 5) and (Header.Encoding = 1) then
      Ok := True
    else
      Ok := False
  end;
  { Mikli ei onnistunut, suljetaan tiedosto ja palataan }
  if not Ok then begin
    Close(PCXFile);
    ShowPCXFile := False;
    Exit
  end;

  { Lue PCX-tiedoston paletti ja tarkista paletin tunnus }
  { Paletin tunnuksen lytmiseksi on mentv tiedoston lopusta }
  { taaksepin 769 tavua. }
  Seek(PCXFile, FileSize(PCXFile) - (SizeOf(PCXPaletteType) + 1));
  BlockRead(PCXFile, PaletteID, 1);
  if PaletteID <> PCX_PALETTE_ID then
    Ok := False
  else begin
    BlockRead(PCXFile, Palette, SizeOf(PCXPaletteType), Result);
    if Result = SizeOf(PCXPaletteType) then
      Ok := True
    else
      Ok := False
  end;
  if not Ok then begin
    Close(PCXFile);
    ShowPCXFile := False;
    Exit
  end;

  { Jaa paletin kaikki arvot neljll }
  for x := 0 to PCX_PALETTE_SIZE-1 do
    Palette[x] := Palette[x] shr 2;

  { Aseta VGA-nytn paletti PCX-kuvan mukaiseksi }

  { Int 10h / Function 10h / Subfunction 12h: Set block of color registers }
  Regs.AH := $10;               { funktion numero }
  Regs.AL := $12;               { alifunktion numero }
  Regs.BX := 0;                 { ensimmisen vrirekisterin numero }
  Regs.CX := PCX_NUM_COLORS;    { vrirekisterien lukumr }
  Regs.ES := Seg(Palette);      { paletin segmenttiosoite }
  Regs.DX := Ofs(Palette);      { paletin siirros }
  Intr(VIDEO_INTR, Regs);

  { Laske kuvatiedon pituus ja varaa sen verran muistia }
  PCXDataSize := FileSize(PCXFile) - SizeOf(PCXHeaderType) -
                 SizeOf(PCXPaletteType) - 1;
  { Varaa muistia kuvatiedolle. Tss ei sen kummemmin tarkistella,
    koska GetMem aiheuttaa ajonaikaisen virheen jos muisti ei riit.
    Sen hoitelemiseksi taas pitisi mritell kokonaan oma ksittelij
    virheelle, ja se saa tll kertaa jd. }
  GetMem(PCXData, PCXDataSize);

  { Lue kaikki tieto muistiin ja sulje PCX-tiedosto }
  Seek(PCXFile, SizeOf(PCXHeaderType));
  BlockRead(PCXFile, PCXData^, PCXDataSize);
  Close(PCXFile);

  { Pura RLE-pakattu kuvatieto suoraan nyttmuistiin }
  { DataPtr osoittaa luetun kuvatiedon ensimmiseen tavuun (alkaen nollasta) }
  { ScreenOffset osoittaa siihen nyttmuistin tavuun johon seuraava }
  { kuvapiste kirjoitetaan. ScreenOffset kasvaa nopeammin kuin DataPtr. }
  DataPtr := 0;                { aloita ensimmisest tavusta }
  ScreenOffset := 0;
  for y := 0 to Header.YMax - Header.YMin + 1 do begin
    x := 0;  { kuvarivi alkaa kohdasta (0,y) }
    while x < Header.BytesPerLine do begin  { rivi kerrallaan }
      Data := PCXData^[DataPtr];  { Data = seuraava kuvatiedon tavu }
      if (Data and $C0) = $C0 then begin { kaksi ylint bitti pll }
        Inc(DataPtr);  { oli laskuritavu, valmistaudu lukemaan varsinainen kuvapiste }
        RunCount := Data and $3F;  { toistolaskuri }
        Data := PCXData^[DataPtr]; { indeksi palettiin }
        for R := 1 to RunCount do begin  { kirjoita kuvaruutumuistiin RunCount kertaa }
          Mem[VIDEO_MEM_SEG:ScreenOffset] := Data;
          Inc(ScreenOffset);
        end;
        Inc(x, RunCount);   { pivit x-koordinaatia }
      end
      else begin
        Mem[VIDEO_MEM_SEG:ScreenOffset] := Data;
        Inc(ScreenOffset);
        Inc(x);             { pivit x-koordinaattia }
      end;
      Inc(DataPtr);         { valmistaudu lukemaan seuraava tavu kuvatiedosta }
    end; { while }
  end; { for y }

  FreeMem(PCXData, PCXDataSize);    { vapauta kuvatiedolle varattu muisti }
end; { ShowPCXFile }


procedure showpcx(kuvapcx:string;mihin:word);
begin
PCXFileName := kuvapcx;

if not FileExists(PCXFileName) then
Error('Tiedostoa ei lydy.');

Regs.AH := $10;               { funktio 10h }
Regs.AL := $17;               { alifunktio 17h }
Regs.BX := 0;                 { ensimminen vrirekisteri }
Regs.CX := PCX_NUM_COLORS;    { vrirekisterien lukumr }
Regs.ES := Seg(VGAPalette);   { paletin segmentti }
Regs.DX := Ofs(VGAPalette);   { paletin siirros }
Intr(VIDEO_INTR, Regs);


ok:=ShowPCXFile(PCXFileName,mihin); { jaa-a, olikohan jrke tehd FUNKTIO }
                              { selvst proceduurista? tulos on tss }
end; {showpcx}


end.