// EF2000 Campaign Status Generator
//
// This program report known status of mobile units in an EF2000 campaign
//
// Version:
// 1.00     By: Ka On Lee (kolee@chat.carleton.ca)
//          1st version.  Only count different units in an EF2000 campaign.
//          Written by simple C++ with C file I/O.



#include <stdio.h>
#include <iostream.h>
#include <string.h>

#define MOB_MAX 50
#define BUFFER_MAX 200


void strcap(char *dest, char *start, char *end)  // Copy characters from start to the character before end.
{
  while(start < end) *(dest++) = *(start++);
  *dest = '\0';                                  // Add end-of-string.
}

struct mobile
{
  char category[10];
  char type_name[20];
  int ok_cnt;
  int dead_cnt;
  int resv_cnt;
};

struct country
{
  char c_name[20];
  mobile *mob_list[MOB_MAX];      // Simple array list.  Good enough for this little program.
  int mob_cnt;
};


int main(int argc, char *argv[])
{
  char in_filename[20];
  FILE *in_file;

  char buffer[BUFFER_MAX];

  char category[10];
  char type_name[20];
  char status[10];
  char c_name[20];

  country *c_list[16];
  int c_total = 0;

  int mob_total = 0;
  int c_found;
  int m_found;
  char *cp1, *cp2;

  int i;

  cout << "\nEF2000 Campaign Status Generator V1.00\n\n";
  cout << "By: Ka On Lee (kolee@chat.carleton.ca) 1996\n\n";
  cout << "== Freeware ==\n\n";

  if(argc>1) strcpy(in_filename,argv[1]);   // Check optional argument
  else strcpy(in_filename,"CAMPAIGN.CG");

  cout << "Opening " <<in_filename<<" ...." << endl;

  if((in_file=fopen(in_filename,"r"))==NULL)
  {
    cout << "Unable to open " << in_filename <<endl;
    return 1;
  }

  cout << "Reading...\n";


  while(!feof(in_file))
  {
    if(fgets(buffer,BUFFER_MAX,in_file)==NULL) break;

    if(buffer[0] == 'M' && buffer[1] == 'O')  // MOB - Mobile unit.
    {
      ++mob_total;


      // Parse different items out of the line buffer.

      cp1 = strchr(buffer,' ')+1;  // Find 1st space, and skip it.
      cp2 = strchr(cp1,' ');

      strcap(category, cp1, cp2);


      cp1 = cp2+1;
      cp2 = strchr(cp1,' ');

      strcap(type_name, cp1, cp2);


      cp1 = cp2+1;
      cp2 = strchr(cp1,' ');

      strcap(status, cp1, cp2);


      cp1 = cp2+1;
      cp2 = strchr(cp1,' ');

      strcap(c_name, cp1, cp2);


//    cout << category <<"/"<< type_name<<"/"<<status<<"/"<<c_name<<endl;

//    if(getch()=='q') break;


      // Search for existing country.
      c_found = -1;
      for(i=0;i<c_total;i++)
	if(strcmp(c_name, c_list[i] -> c_name)==0)
	{
	  c_found = i;
	  break;
	}


      // If country not found in the list, make a new one.
      if(c_found == -1)
      {
	c_found = c_total++;
//	cout << "  Found ["<<c_name<<"]\n";
	c_list[c_found] = new country;
	c_list[c_found]->mob_cnt = 0;
	strcpy(c_list[c_found]->c_name, c_name);
      }


      // Search for existing unit type in this country.
      m_found = -1;
      for(i=0;i<c_list[c_found]->mob_cnt;i++)
	if(strcmp(type_name, c_list[c_found]->mob_list[i]->type_name) == 0)
	{
	  m_found = i;
	  break;
	}

      // If unit type not found in the list, make a new one.
      if(m_found == -1)
      {
//	cout <<"  Found "<< c_name<<" : "<<category <<"/"<<type_name<<"\n";
	m_found = c_list[c_found]->mob_cnt++;
	c_list[c_found]->mob_list[m_found] = new mobile;
	strcpy(c_list[c_found]->mob_list[m_found]->category, category);
	strcpy(c_list[c_found]->mob_list[m_found]->type_name, type_name);
	c_list[c_found]->mob_list[m_found]->ok_cnt=0;
	c_list[c_found]->mob_list[m_found]->resv_cnt=0;
	c_list[c_found]->mob_list[m_found]->dead_cnt=0;
      }

      // Count

      if(strcmp(status,"OK")==0) c_list[c_found]->mob_list[m_found]->ok_cnt++;
      else if(strcmp(status,"DEAD")==0) c_list[c_found]->mob_list[m_found]->dead_cnt++;
      else if(strcmp(status,"RESERVED")==0) c_list[c_found]->mob_list[m_found]->resv_cnt++;
    }
  }


  // Report

  cout << "Total units = "<< mob_total<<endl<<endl;

  for(i=0;i<c_total;i++)
  { cout << c_list[i]->c_name<<endl;

    for(int j=0; j<c_list[i]->mob_cnt; j++)
    {
      cout << "  "<<c_list[i]->mob_list[j]->category<<" / "<<c_list[i]->mob_list[j]->type_name;
      if(strlen(c_list[i]->mob_list[j]->type_name)<16) cout <<"\t";
      if(strlen(c_list[i]->mob_list[j]->type_name)<8) cout <<"\t";
      cout << "\tOK:"<<c_list[i]->mob_list[j]->ok_cnt<<" \tDEAD:"<<c_list[i]->mob_list[j]->dead_cnt;
      cout << "  \tRESERVED:"<<c_list[i]->mob_list[j]->resv_cnt<<endl;
    }
    cout <<endl;
  }

  fclose(in_file);
  return 0;
}
