///TrayHide/////////////////////////////////////////
//                                                //
// Program to show/hide system tray in Windows 95 //
//                                                //
// This program is freeware. You may do           //
// whatever you like with this program and        //
// it's source                                    //
//                                                //
////////////////////////////////////////////////////


////////////////////////////////////////////////////
// Technical Info                                 //
//                                                //
// This program moves the system tray into the    //
// start button, where it cannot be seen          //
// and moves it back again when the program is    //
// run a second time                              //
////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN //make smaller .exe

#include <windows.h>

#define ENUM_FINDTASKBAR  1
#define ENUM_FINDCHILDREN 2

//globals for storage of system window handles
HWND TaskBarHandle = NULL;
HWND TrayHandle = NULL;
HWND StartButtonHandle = NULL;

//main window enumeration function - locates the system windows
BOOL CALLBACK EnumWindowProc(HWND hwnd, LPARAM lParam)
{
    char buffer[20];

    switch(lParam)
    {
        case ENUM_FINDTASKBAR: //find taskbar window
            GetClassName(hwnd, buffer, 16);
            if(stricmp(buffer,"Shell_TrayWnd")==0)
            {
                TaskBarHandle = hwnd; //store taskbar handle

                //call function again with children to get tray and start button
                EnumChildWindows(hwnd, EnumWindowProc, ENUM_FINDCHILDREN);
            }
            break;
        case ENUM_FINDCHILDREN: //find tray and start button
            GetClassName(hwnd, buffer, 16);
            if(stricmp(buffer,"TrayNotifyWnd")==0)
            {
                TrayHandle = hwnd; //store tray handle
            }
            else
                if(stricmp(buffer,"Button")==0)
                {
                    StartButtonHandle = hwnd; //store start button handle
                }
    }
    return TRUE;
}


//Program entry point
int CALLBACK WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    //Find window handles
    EnumWindows(EnumWindowProc, ENUM_FINDTASKBAR);

    if( (!StartButtonHandle)||(!TaskBarHandle)||(!TrayHandle) ) //it didn't work!
    {        
        MessageBox(NULL,"Could not locate system tray\nThis program must be run under Windows 95","Tray Hide",MB_ICONEXCLAMATION);
    }
    else
    {
        if(GetParent(TrayHandle)==TaskBarHandle)
        {   //Window is visible
            SetParent(TrayHandle, StartButtonHandle);
            EnableWindow(TrayHandle, FALSE);
        }
        else
        {   //We've already killed the window, so re show it
            SetParent(TrayHandle, TaskBarHandle);
            EnableWindow(TrayHandle, TRUE);
        }
    }    

    return 0;
}
