#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

void main(int argc, char *argv[])
{
	HKEY	ourKey;
   char	key[256], value[128], data[128];
	DWORD result, whatHappened;
      
   if (argc < 4)
      printf("usage: reguser userKey value data\n");
   else {
		lstrcpy(key,argv[1]);
      lstrcpy(value,argv[2]);
		lstrcpy(data,argv[3]);
		printf("\n");
                  
      result =  RegCreateKeyEx(HKEY_CURRENT_USER,
      							key,
                           0,
                           "REG_SZ",
                           REG_OPTION_NON_VOLATILE,
                           KEY_ALL_ACCESS,
                           NULL,
   								&ourKey,
                           &whatHappened);

		if (result == ERROR_SUCCESS) {
      	printf("%s '%s' key\n   Adding value '%s'='%s'...\n\n",
									(whatHappened == REG_CREATED_NEW_KEY) ? "Created" : "Found",
									key,value,data);
         result = RegSetValueEx(ourKey,
										value,
                     			0,
                     			REG_SZ,
                     			data,
                     			lstrlen(data)+1);
                              
			if (result != ERROR_SUCCESS)
         	printf("Error: Error setting value '%s' to '%s', GetLastError() = %d\n",
            																			value,
                                                                     data,
                                                                     GetLastError());
         else
				printf("In key '%s'\n   I set value '%s' to '%s'...\n\n",key,value,data);
            
       	RegCloseKey(ourKey);
      }
      else
			printf("Error: Could not create/open key, GetLastError() = %d\n",GetLastError());
   }
}

