/****************************************************************************
*                winnt.c
*
*  This module implements WinNT specific routines.
*
*  from Persistence of Vision Raytracer
*  Copyright 1994 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other 
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If 
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by leaving a message in CompuServe's Graphics Developer's
*  Forum.  The latest version of POV-Ray may be found there as well.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/

/****************************************************************************
*  Original WinNT "port" done on 2/25/94 by Dan Goldwater, dgold@brown.edu.
*  Note that no porting was actually needed for a clean WinNT compile under
*  Microsoft Visual C/C++ 32bit Edition v1.1 (henceforth MSVC32 or MSVCNT).
*  All I did was compile the unix version sans the unix makefile as a WinNT
*  console-mode application.  but i spiffed up the config.h and winnt.h anyway,
*  so they are a bit better than my original compile.
*
*  now, why doesnt somebody make the +D option actually show the picture in a nice
*  window, ok?  while you're at it, have the display be a second thread
*  at lower priority so we can be really nifty :)
*****************************************************************************/

/* stuff from unix.c, includes from ibm.c *DG* */

#include <math.h>
#include <stdarg.h>
#include <time.h>
#include <io.h>			 /* needed? */
#include <fcntl.h>		 /* needed? */
#include "config.h"
#include "frame.h"
#include "povproto.h"

void unix_init_POVRAY PARAMS ((void))
   {
   }

#ifdef UNDERFLOW
int matherr (x)
   struct exception *x;
   {
   switch(x->type) 
     {
     case DOMAIN:
     case OVERFLOW:
        x->retval = 1.0e17;
        break;

     case SING:
     case UNDERFLOW:
        x->retval = 0.0;
        break;

     default:
        break;
     }
   return(1);
   }
#endif

void display_finished ()
   {
   }

void display_init ()
   {
   }

void display_close ()
   {
   }

void display_plot (x, y, Red, Green, Blue)
   int x, y;
   char Red, Green, Blue;
   {
   }

/* stuff from ibm.c *DG* */

extern unsigned int Options;
int _cdecl box_fprintf( FILE *stream, char *format,...);

void print_ibm_credits()
  {
  fprintf (stderr," \n");

  fprintf (stderr,"ͻ\n");
  box_fprintf (stderr,"  Persistence of Vision Raytracer Ver %s%s",POV_RAY_VERSION,COMPILER_VER);
  box_fprintf (stderr,"    %s",DISTRIBUTION_MESSAGE_1);
  box_fprintf (stderr,"     %s",DISTRIBUTION_MESSAGE_2);
  box_fprintf (stderr,"     %s",DISTRIBUTION_MESSAGE_3);
  fprintf (stderr,"  Copyright (c) 1993 POV-Team                                           \n");
  fprintf (stderr,"Ķ\n");
  fprintf (stderr,"  POV-Ray is based on DKBTrace 2.12 by David K. Buck & Aaron A. Collins.\n");
  fprintf (stderr,"    Contributing Authors: (Alphabetically)                              \n");
  fprintf (stderr,"      Steve Anger        Steve A. Bennett   David K. Buck               \n");
  fprintf (stderr,"      Aaron A. Collins   Alexander Enzmann  Dan Farmer                  \n");
  fprintf (stderr,"      Douglas Muir       Bill Pulver        Robert Skinner              \n");
  fprintf (stderr,"      Scott Taylor       Drew Wells         Chris Young                 \n");
  fprintf (stderr,"    Other contributors listed in the documentation.-                    \n");
  fprintf (stderr,"ͼ");
  fflush (stderr);
  }

/* Stats kept by the ray tracer: */
extern long Number_Of_Pixels, Number_Of_Rays, Number_Of_Pixels_Supersampled;
extern long Ray_Sphere_Tests, Ray_Sphere_Tests_Succeeded;
extern long Ray_Box_Tests, Ray_Box_Tests_Succeeded;
extern long Ray_Blob_Tests, Ray_Blob_Tests_Succeeded;
extern long Ray_Cone_Tests, Ray_Cone_Tests_Succeeded;
extern long Ray_Disc_Tests, Ray_Disc_Tests_Succeeded;
extern long Ray_Plane_Tests, Ray_Plane_Tests_Succeeded;
extern long Ray_Triangle_Tests, Ray_Triangle_Tests_Succeeded;
extern long Ray_Quadric_Tests, Ray_Quadric_Tests_Succeeded;
extern long Ray_Poly_Tests, Ray_Poly_Tests_Succeeded;
extern long Ray_Bicubic_Tests, Ray_Bicubic_Tests_Succeeded;
extern long Ray_Ht_Field_Tests, Ray_Ht_Field_Tests_Succeeded;
extern long Ray_Ht_Field_Box_Tests, Ray_HField_Box_Tests_Succeeded;
extern long Bounding_Region_Tests, Bounding_Region_Tests_Succeeded;
extern long Clipping_Region_Tests, Clipping_Region_Tests_Succeeded;
extern long Calls_To_Noise, Calls_To_DNoise;
extern long Shadow_Ray_Tests, Shadow_Rays_Succeeded, Shadow_Cache_Hits;
extern long Reflected_Rays_Traced, Refracted_Rays_Traced;
extern long Transmitted_Rays_Traced, Istack_overflows;
extern time_t tstart, tstop;
extern DBL tused;
extern FRAME Frame;

extern char Input_File_Name[FILE_NAME_LENGTH], Output_File_Name[FILE_NAME_LENGTH], Stat_File_Name[FILE_NAME_LENGTH];

void print_ibm_stats()
   {
   long hours,min;
   DBL sec;
   FILE *stat_out;
   long Pixels_In_Image;

   if (Options & VERBOSE_FILE)
      stat_out = fopen(Stat_File_Name,"w+t");
   else
    stat_out = stdout;

   Pixels_In_Image = (long)Frame.Screen_Width * (long)Frame.Screen_Height;

   fprintf (stat_out,"\n");
   fprintf (stat_out,"ͻ\n");
   box_fprintf (stat_out,"  Persistence of Vision Raytracer Ver %s%s",POV_RAY_VERSION, COMPILER_VER);
   fprintf (stat_out,"ĺ\n");
   box_fprintf (stat_out,"  %s statistics",Input_File_Name);
   if(Pixels_In_Image > Number_Of_Pixels)
   box_fprintf (stat_out,"  Partial Image Rendered");
   fprintf (stat_out,"ĺ\n");
   box_fprintf (stat_out," Image Resolution %d pixels wide x %d pixels high",Frame.Screen_Width, Frame.Screen_Height);
   box_fprintf (stat_out," # Rays Calculated     :  %10ld",Number_Of_Rays);
   box_fprintf (stat_out," # Pixels Calculated   :  %10ld", Number_Of_Pixels);
   box_fprintf (stat_out," # Pixels Supersampled :  %10ld",Number_Of_Pixels_Supersampled);
   fprintf (stat_out,"ĺ\n");
   box_fprintf (stat_out,"   Ray - Shape Intersection Tests");
   box_fprintf (stat_out,"   Type             Tests    Succeeded   Percentage");
   fprintf (stat_out,"ĺ\n");
   if(Ray_Sphere_Tests)
   box_fprintf (stat_out,"  Sphere       %10ld  %10ld  %10.2f", Ray_Sphere_Tests, Ray_Sphere_Tests_Succeeded, ( ((DBL)Ray_Sphere_Tests_Succeeded/(DBL)Ray_Sphere_Tests) *100.0 ) );
   if(Ray_Plane_Tests)
   box_fprintf (stat_out,"  Plane        %10ld  %10ld  %10.2f", Ray_Plane_Tests, Ray_Plane_Tests_Succeeded, ( ((DBL)Ray_Plane_Tests_Succeeded/(DBL)Ray_Plane_Tests) *100.0 ));
   if(Ray_Triangle_Tests)
   box_fprintf (stat_out,"  Triangle     %10ld  %10ld  %10.2f", Ray_Triangle_Tests, Ray_Triangle_Tests_Succeeded, ( ((DBL)Ray_Triangle_Tests_Succeeded/(DBL)Ray_Triangle_Tests) *100.0 ));
   if(Ray_Quadric_Tests)
   box_fprintf (stat_out,"  Quadric      %10ld  %10ld  %10.2f", Ray_Quadric_Tests, Ray_Quadric_Tests_Succeeded, ( ((DBL)Ray_Quadric_Tests_Succeeded/(DBL)Ray_Quadric_Tests) *100.0 ));
   if(Ray_Blob_Tests)
   box_fprintf (stat_out,"  Blob         %10ld  %10ld  %10.2f", Ray_Blob_Tests, Ray_Blob_Tests_Succeeded, ( ((DBL)Ray_Blob_Tests_Succeeded/(DBL)Ray_Blob_Tests) *100.0 ));
   if(Ray_Box_Tests)
   box_fprintf (stat_out,"  Box          %10ld  %10ld  %10.2f", Ray_Box_Tests, Ray_Box_Tests_Succeeded, ( ((DBL)Ray_Box_Tests_Succeeded/(DBL)Ray_Box_Tests) *100.0 ));
   if(Ray_Cone_Tests)
   box_fprintf (stat_out,"  Cone\\Cyl.    %10ld  %10ld  %10.2f", Ray_Cone_Tests, Ray_Cone_Tests_Succeeded, ( ((DBL)Ray_Cone_Tests_Succeeded/(DBL)Ray_Cone_Tests) *100.0 ));
   if(Ray_Disc_Tests)
   box_fprintf (stat_out,"  Disc         %10ld  %10ld  %10.2f", Ray_Disc_Tests, Ray_Disc_Tests_Succeeded, ( ((DBL)Ray_Disc_Tests_Succeeded/(DBL)Ray_Disc_Tests) *100.0 ));
   if(Ray_Poly_Tests)
   box_fprintf (stat_out,"  Quartic\\Poly %10ld  %10ld  %10.2f", Ray_Poly_Tests, Ray_Poly_Tests_Succeeded, ( ((DBL)Ray_Poly_Tests_Succeeded/(DBL)Ray_Poly_Tests) *100.0 ));
   if(Ray_Bicubic_Tests)
   box_fprintf (stat_out,"  Bezier Patch %10ld  %10ld  %10.2f", Ray_Bicubic_Tests, Ray_Bicubic_Tests_Succeeded, ( ((DBL)Ray_Bicubic_Tests_Succeeded/(DBL)Ray_Bicubic_Tests) *100.0 ));
   if(Ray_Ht_Field_Tests)
   box_fprintf (stat_out,"  Height Fld   %10ld  %10ld  %10.2f", Ray_Ht_Field_Tests, Ray_Ht_Field_Tests_Succeeded, ( ((DBL)Ray_Ht_Field_Tests_Succeeded/(DBL)Ray_Ht_Field_Tests) *100.0 ));
   if(Ray_Ht_Field_Box_Tests)
   box_fprintf (stat_out,"  Hght Fld Box %10ld  %10ld  %10.2f", Ray_Ht_Field_Box_Tests, Ray_HField_Box_Tests_Succeeded, ( ((DBL)Ray_HField_Box_Tests_Succeeded/(DBL)Ray_Ht_Field_Box_Tests) *100.0 ));
   if(Bounding_Region_Tests)
   box_fprintf (stat_out,"  Bounds       %10ld  %10ld  %10.2f", Bounding_Region_Tests, Bounding_Region_Tests_Succeeded, ( ((DBL)Bounding_Region_Tests_Succeeded/(DBL)Bounding_Region_Tests) *100.0 ));
   if(Clipping_Region_Tests)
   box_fprintf (stat_out,"  Clips        %10ld  %10ld  %10.2f", Clipping_Region_Tests, Clipping_Region_Tests_Succeeded, ( ((DBL)Clipping_Region_Tests_Succeeded/(DBL)Clipping_Region_Tests) *100.0 ));
   fprintf (stat_out,"ĺ\n");
   if(Calls_To_Noise)
   box_fprintf (stat_out,  "  Calls to Noise Routine  :  %10ld", Calls_To_Noise);
   if(Calls_To_DNoise)
   box_fprintf (stat_out,  "  Calls to DNoise Routine :  %10ld", Calls_To_DNoise);
   fprintf (stat_out,"ĺ\n");
   if(Shadow_Ray_Tests){
     box_fprintf (stat_out,"  Shadow Ray Tests        :  %10ld",Shadow_Ray_Tests);
/* SJA */
     box_fprintf (stat_out,"  Shadow Cache Hits       :  %10ld",Shadow_Cache_Hits);
/* SJA */
     box_fprintf (stat_out,"  Blocking Objects Found  :  %10ld",Shadow_Rays_Succeeded);
     }
   if(Reflected_Rays_Traced)
   box_fprintf (stat_out,  "  Reflected Rays          :  %10ld", Reflected_Rays_Traced);
   if(Refracted_Rays_Traced)
   box_fprintf (stat_out,  "  Refracted Rays          :  %10ld", Refracted_Rays_Traced);
   if(Transmitted_Rays_Traced)
   box_fprintf (stat_out,  "  Transmitted Rays        :  %10ld", Transmitted_Rays_Traced);
   if(Istack_overflows)
   box_fprintf (stat_out,  "  I-Stack overflows       :  %10ld", Istack_overflows);

   if(tused==0) {
    STOP_TIME                 /* Get trace done time. */
    tused = TIME_ELAPSED      /* Calc. elapsed time. Define TIME_ELAPSED as */
                              /* 0 in your specific CONFIG.H if unsupported */
    }
   if (tused != 0){
     /* Convert seconds to hours, min & sec. CdW */
     hours = (long) tused/3600;
     min = (long) (tused - hours*3600)/60;
     sec = tused - (DBL) (hours*3600 + min*60);
     fprintf (stat_out,"ĺ\n");
     box_fprintf (stat_out,"  Rendering Time          :   %5ld hours %2d minutes %4.2f seconds", hours,min,sec);
     }
     fprintf (stat_out,"ͼ\n");

    if (Options & VERBOSE_FILE)
      fclose(stat_out);

}


/* Output a string to stream with vfprintf formatted for ibm stat screen. */
/* String should be <80 chars                 */
int _cdecl box_fprintf( FILE *stream, char *fmt , ... )
{
    va_list marker;
    char buffer[160];
    int len,i;

    buffer[0] = '';
    va_start( marker, fmt );
    vsprintf( buffer+1, fmt, marker );
    va_end( marker );
    len = strlen (buffer);
    for(i=len;i<73;i++)
       buffer[i] = ' ';
    strcpy (buffer+73,"\n");
    return( fputs(buffer,stream) );
}

