unit Tray;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, TrayIcon;

type
  THiddenForm = class(TForm)
    TrayIcon1: TTrayIcon;
    PopupMenu1: TPopupMenu;
    AboutUptime1: TMenuItem;
    N1: TMenuItem;
    Close1: TMenuItem;
    procedure AboutUptime1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TrayIcon1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure WMEndSession(var Msg: TWMEndSession); message WM_ENDSESSION;
  end;

var
  HiddenForm: THiddenForm;

implementation

uses
  Upt, About;

{$R *.DFM}

procedure THiddenForm.AboutUptime1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure THiddenForm.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure THiddenForm.FormCreate(Sender: TObject);
begin
  WriteLogEntry(True);

  Left := -9999;  // move the form off-screen to avoid flashing

  ShowWindowAsync( Handle, SW_HIDE );  // hide the form

  // This is for Delphi 3 or later: hide the form's taskbar button.
  SetWindowLong(Application.Handle, GWL_EXSTYLE, WS_EX_TOOLWINDOW);
end;

procedure THiddenForm.TrayIcon1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  Uptime: TUptime;
  UptimeStr: string;
begin
  Uptime := TUptime.Create;
  try
    Uptime.Format(UptimeStr, True);  // use the verbose format
    TrayIcon1.Tooltip := 'Up ' + UptimeStr;
  finally
    Uptime.Destroy;
  end;
end;

procedure THiddenForm.WMEndSession(var Msg: TWMEndSession);
begin
  if Msg.EndSession then
    WriteLogEntry(False);  // going down
end;


end.

