unit AboutBox;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, StdCtrls, Buttons, ExtCtrls;

type
  TAboutForm = class(TForm)
    lblVersion    : TLabel;
    lblCopyright  : TLabel;
    btnAboutOK    : TBitBtn;
    Panel1        : TPanel;
      Image1      : TImage;
      Image2      : TImage;
    Timer1        : TTimer;
    lblWinVer     : TLabel;
    lblVxdVersion : TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    Opt      : String;
    eyebmp   : Integer;
    FrontImg : TImage;
  public
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

function GetFileVersion : String;

implementation
USES IniFiles, In4Share, CtrlTrap;
{$R *.DFM}

function GetFileVersion : String;
const
  cFV = '\StringFileInfo\040904E4\FileVersion';
VAR
  viSize      : Integer;
  Len         : UInt;
  Dummy       : DWORD;
  viBuff, viP : Pointer;
  viS         : PChar;
begin
  viSize := GetFileVersionInfoSize(PChar(Application.ExeName),Dummy);
  GetMem(viBuff, viSize);
  try
    GetFileVersionInfo(PChar(Application.ExeName),0,viSize,viBuff);
    IF (NOT VerQueryValue(viBuff, cFV, viP, Len)) OR (Len<8) THEN
      Result := ''
    else
      begin
        viS := StrNew(PChar(viP));
        try
          Result := StrPas(viS);
        finally
          StrDispose(viS);
        end;
      end;
  finally
    FreeMem(viBuff);
  end;
end;

function GetFileCopyright : String;
const
  cFC = '\StringFileInfo\040904E4\LegalCopyright';
VAR
  viSize      : Integer;
  Len         : UInt;
  Dummy       : DWORD;
  viBuff, viP : Pointer;
  viS         : PChar;
begin
  viSize := GetFileVersionInfoSize(PChar(Application.ExeName),Dummy);
  GetMem(viBuff, viSize);
  try
    GetFileVersionInfo(PChar(Application.ExeName),0,viSize,viBuff);
    IF (NOT VerQueryValue(viBuff, cFC, viP, Len)) OR (Len<10) THEN
      Result := 'Copyright  1999 Ziff-Davis, InC.'
    else
      begin
        viS := StrNew(PChar(viP));
        try
          Result := StrPas(viS);
        finally
          StrDispose(viS);
        end;
      end;
  finally
    FreeMem(viBuff);
  end;
end;

procedure TAboutForm.FormCreate(Sender: TObject);
VAR VxdVersion : Integer;
begin
  IF PlatVer IN [WV_95, WV_98] THEN
    VxdVersion := GetVxdVersion
  ELSE VxdVersion := -1;
  IF VxdVersion <> -1 THEN
    begin
      lblVxdVersion.Caption := Format('CTRLTRAP.VXD version %d.%.2d',
        [Hi(LoWord(VxdVersion)), Lo(LoWord(VxdVersion))]);
    end;

  Opt := Name+ ' Settings';
  WITH TIniFile.Create(iniName) DO
  try
    Left := ReadInteger(Opt, 'Left', (Screen.Width - Width) DIV 2);
    IF Left + Width > Screen.Width THEN
      Left := Screen.Width - Width;
    Top := ReadInteger(Opt, 'Top', (Screen.Height - Height) DIV 2);
    IF Top + Height > Screen.Height THEN
      Top := Screen.Height - Height;
  finally
    Free;
  end;
  lblWinVer.Caption    := PlatVerStr;
  lblVersion.Caption   := 'InCtrl4 - version ' + GetFileVersion;
  lblCopyright.Caption := GetFileCopyright;
  eyebmp   := 101;
  FrontImg := Image1;
  FrontImg.Picture.Bitmap.Handle := LoadImage(hInstance,
    MAKEINTRESOURCE(eyebmp), IMAGE_BITMAP, 48, 48,  LR_DEFAULTCOLOR);
end;

function NextEye(first, current : Integer) : Integer;
VAR N : Integer;
begin
  N := Random(24);
  CASE N OF
    // 6 times in 24, just pick one at random
    0..5  : Result := First+1+N;
    // 8 times in 24, if NOT on the first image,
    //   take the next in sequence
    6..13 : IF current = first THEN
      result := First+1+Random(6)
    ELSE
      begin
        Result := succ(current);
        IF Result > first + 6 THEN
          Result := First + 1;
      end;
    // for the remainder, reset to first image
    ELSE Result := first;
  END;
end;

procedure TAboutForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(iniName) DO
  try
    WriteInteger(Opt, 'Left', Left);
    WriteInteger(Opt, 'Top', Top);
  finally
    Free;
  end;
end;

procedure TAboutForm.Timer1Timer(Sender: TObject);
begin
  eyebmp := NextEye(101, eyebmp);
  IF FrontImg = Image1 THEN
    FrontImg := Image2
  ELSE FrontImg := Image1;
  FrontImg.Picture.Bitmap.Handle := LoadImage(hInstance,
    MAKEINTRESOURCE(eyebmp), IMAGE_BITMAP, 48, 48,  LR_DEFAULTCOLOR);
  FrontImg.BringToFront;
  Timer1.Interval := 250 + Random(750);
end;

end.



