unit regoptu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  optbaseu, Dialogs, StdCtrls, ExtCtrls;

type
  TTrackRegForm = class(TOptForm)
    procedure btnAddClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TrackRegForm: TTrackRegForm;

implementation
USES in4share, pikigkey;

{$R *.DFM}

procedure TTrackRegForm.btnAddClick(Sender: TObject);
begin
  inherited;
  WITH TRegIgForm.Create(Self) DO
  try
    IF ShowModal = mrOK THEN
      CASE AddToHierList(lbMain.Items, Key) OF
        ADL_OK    :;
        ADL_BELOW : begin
          MessageBeep(MB_ICONSTOP);
          MessageDlg(Format('The key "%s" was not '+
            'added, because it is a subkey of another key '+
            'that is already present in the list.', [Key]),
            mtInformation, [mbok], 0);
        end;
        ADL_ABOVE : begin
          MessageBeep(MB_ICONSTOP);
          MessageDlg(Format('The key "%s" was added, replacing '+
            'one or more of its own subkeys in the list.',
            [key]), mtInformation, [mbok], 0);
        end;
        ADL_DUPE  : begin
          MessageBeep(MB_ICONSTOP);
          MessageDlg(Format('The key "%s" is '+
            'already present in the list.', [key]),
            mtInformation, [mbok], 0);
        end;
      END;
  finally
    free;
  end;
end;

end.
   