unit pathsu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, StdCtrls, ExtCtrls;

type
  TPathsForm = class(TForm)
    Label1       : TLabel;
    btnReports   : TButton;
    ebReportPath : TEdit;
    btnTemp      : TButton;
    ebTempPath   : TEdit;
    btnHelp      : TButton;
    btnCancel    : TButton;
    btnOK        : TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GetFolder(eb : TEdit; const S : String);
    procedure btnReportsClick(Sender: TObject);
    procedure btnTempClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
    Opt : String;
  public
    { Public declarations }
  end;

var
  PathsForm: TPathsForm;

implementation
uses IniFiles, in4Share, shlobj, activeX;

{$R *.DFM}

procedure TPathsForm.FormCreate(Sender: TObject);
begin
  Opt := Name+ ' Settings';
  WITH TIniFile.Create(iniName) DO
  try
    Width := ReadInteger(Opt, 'Width', Constraints.MinWidth);
    Height := ReadInteger(Opt, 'Height', Constraints.MinHeight);
    Left := ReadInteger(Opt, 'Left', (Screen.Width - Width) DIV 2);
    IF Left + Width > Screen.Width THEN
      Left := Screen.Width - Width;
    Top := ReadInteger(Opt, 'Top', (Screen.Height - Height) DIV 2);
    IF Top + Height > Screen.Height THEN
      Top := Screen.Height - Height;
  finally
    Free;
  end;
end;

procedure TPathsForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(iniName) DO
  try
    WriteInteger(Opt, 'Width', Width);
    WriteInteger(Opt, 'Height', Height);
    WriteInteger(Opt, 'Left', Left);
    WriteInteger(Opt, 'Top', Top);
  finally
    Free;
  end;
end;

procedure TPathsForm.FormResize(Sender: TObject);
begin
  ebReportPath.Width := Width - ebReportPath.Left - 11;
  ebTempPath.Width   := Width - ebTempPath.Left - 11;
  btnOK.Left         := Width - btnOK.Width - 11;
  btnCancel.Left     := btnOK.Left - btnCancel.Width - 6;
end;

procedure BrowseCallBackProc(hWindow : HWND; uMsg : Integer;
  lParam : LPARAM; lpData : Integer); stdCall;
VAR buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  IF uMsg = BFFM_INITIALIZED THEN
    begin
      StrCopy(Buffer, PChar(lpData));
      StrPCopy(Buffer, NoFinSlash(StrPas(Buffer)));
      // Set the starting directory
      SendMessage(hWindow, BFFM_SETSELECTION, 1, Integer(@buffer))
    end
  ELSE IF uMsg = BFFM_SELCHANGED THEN
    begin
      SHGetPathFromIDList(PItemIDList(lParam), buffer);
      // Display the current selection
      SendMessage(hWindow, BFFM_SETSTATUSTEXT, 0, Integer(@buffer));
    end;
end;

procedure TPathsForm.GetFolder(eb : TEdit; const S : String);
VAR
  TB     : TBrowseInfo;
  IDL    : PItemIdList;
  buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  FillChar(TB, SizeOf(TB), 0);
  WITH TB DO
    begin
      SHGetSpecialFolderLocation(Handle, CSIDL_DRIVES, pIdlRoot);
      lpszTitle := PChar('InCtrl4 - Select default folder for '+ S);
      ulFlags := BIF_RETURNONLYFSDIRS OR BIF_DONTGOBELOWDOMAIN OR
        BIF_STATUSTEXT;
      lpfn := @BrowseCallBackProc;
      StrPCopy(Buffer, eb.Text);
      lparam := Integer(@Buffer);
    end;
  IDL := SHBrowseForFolder(TB);
  try
    IF IDL <> nil THEN
      begin
        SHGetPathFromIDList(IDL, Buffer);
        eb.Text := StrPas(Buffer);
        CoTaskMemFree(IDL);
      end;
  finally
    CoTaskMemFree(TB.pIdlRoot);
  end;
end;

procedure TPathsForm.btnReportsClick(Sender: TObject);
begin
  GetFolder(ebReportPath, 'reports');
end;

procedure TPathsForm.btnTempClick(Sender: TObject);
begin
  GetFolder(ebTempPath, 'temp files');
end;

procedure TPathsForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext(70);
end;

end.

